/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Motion Graphics Configuration
 */
@Generated("software.amazon.awssdk:codegen")
public final class MotionGraphicsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MotionGraphicsConfiguration.Builder, MotionGraphicsConfiguration> {
    private static final SdkField<String> MOTION_GRAPHICS_INSERTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MotionGraphicsInsertion").getter(getter(MotionGraphicsConfiguration::motionGraphicsInsertionAsString))
            .setter(setter(Builder::motionGraphicsInsertion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("motionGraphicsInsertion").build())
            .build();

    private static final SdkField<MotionGraphicsSettings> MOTION_GRAPHICS_SETTINGS_FIELD = SdkField
            .<MotionGraphicsSettings> builder(MarshallingType.SDK_POJO).memberName("MotionGraphicsSettings")
            .getter(getter(MotionGraphicsConfiguration::motionGraphicsSettings)).setter(setter(Builder::motionGraphicsSettings))
            .constructor(MotionGraphicsSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("motionGraphicsSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MOTION_GRAPHICS_INSERTION_FIELD, MOTION_GRAPHICS_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String motionGraphicsInsertion;

    private final MotionGraphicsSettings motionGraphicsSettings;

    private MotionGraphicsConfiguration(BuilderImpl builder) {
        this.motionGraphicsInsertion = builder.motionGraphicsInsertion;
        this.motionGraphicsSettings = builder.motionGraphicsSettings;
    }

    /**
     * Returns the value of the MotionGraphicsInsertion property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #motionGraphicsInsertion} will return {@link MotionGraphicsInsertion#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #motionGraphicsInsertionAsString}.
     * </p>
     * 
     * @return The value of the MotionGraphicsInsertion property for this object.
     * @see MotionGraphicsInsertion
     */
    public final MotionGraphicsInsertion motionGraphicsInsertion() {
        return MotionGraphicsInsertion.fromValue(motionGraphicsInsertion);
    }

    /**
     * Returns the value of the MotionGraphicsInsertion property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #motionGraphicsInsertion} will return {@link MotionGraphicsInsertion#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #motionGraphicsInsertionAsString}.
     * </p>
     * 
     * @return The value of the MotionGraphicsInsertion property for this object.
     * @see MotionGraphicsInsertion
     */
    public final String motionGraphicsInsertionAsString() {
        return motionGraphicsInsertion;
    }

    /**
     * Motion Graphics Settings
     * 
     * @return Motion Graphics Settings
     */
    public final MotionGraphicsSettings motionGraphicsSettings() {
        return motionGraphicsSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(motionGraphicsInsertionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(motionGraphicsSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MotionGraphicsConfiguration)) {
            return false;
        }
        MotionGraphicsConfiguration other = (MotionGraphicsConfiguration) obj;
        return Objects.equals(motionGraphicsInsertionAsString(), other.motionGraphicsInsertionAsString())
                && Objects.equals(motionGraphicsSettings(), other.motionGraphicsSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MotionGraphicsConfiguration").add("MotionGraphicsInsertion", motionGraphicsInsertionAsString())
                .add("MotionGraphicsSettings", motionGraphicsSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MotionGraphicsInsertion":
            return Optional.ofNullable(clazz.cast(motionGraphicsInsertionAsString()));
        case "MotionGraphicsSettings":
            return Optional.ofNullable(clazz.cast(motionGraphicsSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MotionGraphicsConfiguration, T> g) {
        return obj -> g.apply((MotionGraphicsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MotionGraphicsConfiguration> {
        /**
         * Sets the value of the MotionGraphicsInsertion property for this object.
         *
         * @param motionGraphicsInsertion
         *        The new value for the MotionGraphicsInsertion property for this object.
         * @see MotionGraphicsInsertion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MotionGraphicsInsertion
         */
        Builder motionGraphicsInsertion(String motionGraphicsInsertion);

        /**
         * Sets the value of the MotionGraphicsInsertion property for this object.
         *
         * @param motionGraphicsInsertion
         *        The new value for the MotionGraphicsInsertion property for this object.
         * @see MotionGraphicsInsertion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MotionGraphicsInsertion
         */
        Builder motionGraphicsInsertion(MotionGraphicsInsertion motionGraphicsInsertion);

        /**
         * Motion Graphics Settings
         * 
         * @param motionGraphicsSettings
         *        Motion Graphics Settings
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder motionGraphicsSettings(MotionGraphicsSettings motionGraphicsSettings);

        /**
         * Motion Graphics Settings This is a convenience method that creates an instance of the
         * {@link MotionGraphicsSettings.Builder} avoiding the need to create one manually via
         * {@link MotionGraphicsSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link MotionGraphicsSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #motionGraphicsSettings(MotionGraphicsSettings)}.
         * 
         * @param motionGraphicsSettings
         *        a consumer that will call methods on {@link MotionGraphicsSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #motionGraphicsSettings(MotionGraphicsSettings)
         */
        default Builder motionGraphicsSettings(Consumer<MotionGraphicsSettings.Builder> motionGraphicsSettings) {
            return motionGraphicsSettings(MotionGraphicsSettings.builder().applyMutation(motionGraphicsSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String motionGraphicsInsertion;

        private MotionGraphicsSettings motionGraphicsSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(MotionGraphicsConfiguration model) {
            motionGraphicsInsertion(model.motionGraphicsInsertion);
            motionGraphicsSettings(model.motionGraphicsSettings);
        }

        public final String getMotionGraphicsInsertion() {
            return motionGraphicsInsertion;
        }

        public final void setMotionGraphicsInsertion(String motionGraphicsInsertion) {
            this.motionGraphicsInsertion = motionGraphicsInsertion;
        }

        @Override
        public final Builder motionGraphicsInsertion(String motionGraphicsInsertion) {
            this.motionGraphicsInsertion = motionGraphicsInsertion;
            return this;
        }

        @Override
        public final Builder motionGraphicsInsertion(MotionGraphicsInsertion motionGraphicsInsertion) {
            this.motionGraphicsInsertion(motionGraphicsInsertion == null ? null : motionGraphicsInsertion.toString());
            return this;
        }

        public final MotionGraphicsSettings.Builder getMotionGraphicsSettings() {
            return motionGraphicsSettings != null ? motionGraphicsSettings.toBuilder() : null;
        }

        public final void setMotionGraphicsSettings(MotionGraphicsSettings.BuilderImpl motionGraphicsSettings) {
            this.motionGraphicsSettings = motionGraphicsSettings != null ? motionGraphicsSettings.build() : null;
        }

        @Override
        public final Builder motionGraphicsSettings(MotionGraphicsSettings motionGraphicsSettings) {
            this.motionGraphicsSettings = motionGraphicsSettings;
            return this;
        }

        @Override
        public MotionGraphicsConfiguration build() {
            return new MotionGraphicsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
