/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Motion Graphics Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class MotionGraphicsSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<MotionGraphicsSettings.Builder, MotionGraphicsSettings> {
    private static final SdkField<HtmlMotionGraphicsSettings> HTML_MOTION_GRAPHICS_SETTINGS_FIELD = SdkField
            .<HtmlMotionGraphicsSettings> builder(MarshallingType.SDK_POJO)
            .memberName("HtmlMotionGraphicsSettings")
            .getter(getter(MotionGraphicsSettings::htmlMotionGraphicsSettings))
            .setter(setter(Builder::htmlMotionGraphicsSettings))
            .constructor(HtmlMotionGraphicsSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("htmlMotionGraphicsSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(HTML_MOTION_GRAPHICS_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final HtmlMotionGraphicsSettings htmlMotionGraphicsSettings;

    private MotionGraphicsSettings(BuilderImpl builder) {
        this.htmlMotionGraphicsSettings = builder.htmlMotionGraphicsSettings;
    }

    /**
     * Returns the value of the HtmlMotionGraphicsSettings property for this object.
     * 
     * @return The value of the HtmlMotionGraphicsSettings property for this object.
     */
    public final HtmlMotionGraphicsSettings htmlMotionGraphicsSettings() {
        return htmlMotionGraphicsSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(htmlMotionGraphicsSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MotionGraphicsSettings)) {
            return false;
        }
        MotionGraphicsSettings other = (MotionGraphicsSettings) obj;
        return Objects.equals(htmlMotionGraphicsSettings(), other.htmlMotionGraphicsSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MotionGraphicsSettings").add("HtmlMotionGraphicsSettings", htmlMotionGraphicsSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HtmlMotionGraphicsSettings":
            return Optional.ofNullable(clazz.cast(htmlMotionGraphicsSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MotionGraphicsSettings, T> g) {
        return obj -> g.apply((MotionGraphicsSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MotionGraphicsSettings> {
        /**
         * Sets the value of the HtmlMotionGraphicsSettings property for this object.
         *
         * @param htmlMotionGraphicsSettings
         *        The new value for the HtmlMotionGraphicsSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder htmlMotionGraphicsSettings(HtmlMotionGraphicsSettings htmlMotionGraphicsSettings);

        /**
         * Sets the value of the HtmlMotionGraphicsSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link HtmlMotionGraphicsSettings.Builder}
         * avoiding the need to create one manually via {@link HtmlMotionGraphicsSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link HtmlMotionGraphicsSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #htmlMotionGraphicsSettings(HtmlMotionGraphicsSettings)}.
         * 
         * @param htmlMotionGraphicsSettings
         *        a consumer that will call methods on {@link HtmlMotionGraphicsSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #htmlMotionGraphicsSettings(HtmlMotionGraphicsSettings)
         */
        default Builder htmlMotionGraphicsSettings(Consumer<HtmlMotionGraphicsSettings.Builder> htmlMotionGraphicsSettings) {
            return htmlMotionGraphicsSettings(HtmlMotionGraphicsSettings.builder().applyMutation(htmlMotionGraphicsSettings)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private HtmlMotionGraphicsSettings htmlMotionGraphicsSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(MotionGraphicsSettings model) {
            htmlMotionGraphicsSettings(model.htmlMotionGraphicsSettings);
        }

        public final HtmlMotionGraphicsSettings.Builder getHtmlMotionGraphicsSettings() {
            return htmlMotionGraphicsSettings != null ? htmlMotionGraphicsSettings.toBuilder() : null;
        }

        public final void setHtmlMotionGraphicsSettings(HtmlMotionGraphicsSettings.BuilderImpl htmlMotionGraphicsSettings) {
            this.htmlMotionGraphicsSettings = htmlMotionGraphicsSettings != null ? htmlMotionGraphicsSettings.build() : null;
        }

        @Override
        public final Builder htmlMotionGraphicsSettings(HtmlMotionGraphicsSettings htmlMotionGraphicsSettings) {
            this.htmlMotionGraphicsSettings = htmlMotionGraphicsSettings;
            return this;
        }

        @Override
        public MotionGraphicsSettings build() {
            return new MotionGraphicsSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
