/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Output settings. There can be multiple outputs within a group.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Output implements SdkPojo, Serializable, ToCopyableBuilder<Output.Builder, Output> {
    private static final SdkField<List<String>> AUDIO_DESCRIPTION_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AudioDescriptionNames")
            .getter(getter(Output::audioDescriptionNames))
            .setter(setter(Builder::audioDescriptionNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioDescriptionNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CAPTION_DESCRIPTION_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CaptionDescriptionNames")
            .getter(getter(Output::captionDescriptionNames))
            .setter(setter(Builder::captionDescriptionNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionDescriptionNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OUTPUT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputName").getter(getter(Output::outputName)).setter(setter(Builder::outputName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputName").build()).build();

    private static final SdkField<OutputSettings> OUTPUT_SETTINGS_FIELD = SdkField
            .<OutputSettings> builder(MarshallingType.SDK_POJO).memberName("OutputSettings")
            .getter(getter(Output::outputSettings)).setter(setter(Builder::outputSettings)).constructor(OutputSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputSettings").build()).build();

    private static final SdkField<String> VIDEO_DESCRIPTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VideoDescriptionName").getter(getter(Output::videoDescriptionName))
            .setter(setter(Builder::videoDescriptionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoDescriptionName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_DESCRIPTION_NAMES_FIELD,
            CAPTION_DESCRIPTION_NAMES_FIELD, OUTPUT_NAME_FIELD, OUTPUT_SETTINGS_FIELD, VIDEO_DESCRIPTION_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> audioDescriptionNames;

    private final List<String> captionDescriptionNames;

    private final String outputName;

    private final OutputSettings outputSettings;

    private final String videoDescriptionName;

    private Output(BuilderImpl builder) {
        this.audioDescriptionNames = builder.audioDescriptionNames;
        this.captionDescriptionNames = builder.captionDescriptionNames;
        this.outputName = builder.outputName;
        this.outputSettings = builder.outputSettings;
        this.videoDescriptionName = builder.videoDescriptionName;
    }

    /**
     * For responses, this returns true if the service returned a value for the AudioDescriptionNames property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAudioDescriptionNames() {
        return audioDescriptionNames != null && !(audioDescriptionNames instanceof SdkAutoConstructList);
    }

    /**
     * The names of the AudioDescriptions used as audio sources for this output.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAudioDescriptionNames} method.
     * </p>
     * 
     * @return The names of the AudioDescriptions used as audio sources for this output.
     */
    public final List<String> audioDescriptionNames() {
        return audioDescriptionNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the CaptionDescriptionNames property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCaptionDescriptionNames() {
        return captionDescriptionNames != null && !(captionDescriptionNames instanceof SdkAutoConstructList);
    }

    /**
     * The names of the CaptionDescriptions used as caption sources for this output.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCaptionDescriptionNames} method.
     * </p>
     * 
     * @return The names of the CaptionDescriptions used as caption sources for this output.
     */
    public final List<String> captionDescriptionNames() {
        return captionDescriptionNames;
    }

    /**
     * The name used to identify an output.
     * 
     * @return The name used to identify an output.
     */
    public final String outputName() {
        return outputName;
    }

    /**
     * Output type-specific settings.
     * 
     * @return Output type-specific settings.
     */
    public final OutputSettings outputSettings() {
        return outputSettings;
    }

    /**
     * The name of the VideoDescription used as the source for this output.
     * 
     * @return The name of the VideoDescription used as the source for this output.
     */
    public final String videoDescriptionName() {
        return videoDescriptionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAudioDescriptionNames() ? audioDescriptionNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCaptionDescriptionNames() ? captionDescriptionNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(outputName());
        hashCode = 31 * hashCode + Objects.hashCode(outputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(videoDescriptionName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Output)) {
            return false;
        }
        Output other = (Output) obj;
        return hasAudioDescriptionNames() == other.hasAudioDescriptionNames()
                && Objects.equals(audioDescriptionNames(), other.audioDescriptionNames())
                && hasCaptionDescriptionNames() == other.hasCaptionDescriptionNames()
                && Objects.equals(captionDescriptionNames(), other.captionDescriptionNames())
                && Objects.equals(outputName(), other.outputName()) && Objects.equals(outputSettings(), other.outputSettings())
                && Objects.equals(videoDescriptionName(), other.videoDescriptionName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Output")
                .add("AudioDescriptionNames", hasAudioDescriptionNames() ? audioDescriptionNames() : null)
                .add("CaptionDescriptionNames", hasCaptionDescriptionNames() ? captionDescriptionNames() : null)
                .add("OutputName", outputName()).add("OutputSettings", outputSettings())
                .add("VideoDescriptionName", videoDescriptionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AudioDescriptionNames":
            return Optional.ofNullable(clazz.cast(audioDescriptionNames()));
        case "CaptionDescriptionNames":
            return Optional.ofNullable(clazz.cast(captionDescriptionNames()));
        case "OutputName":
            return Optional.ofNullable(clazz.cast(outputName()));
        case "OutputSettings":
            return Optional.ofNullable(clazz.cast(outputSettings()));
        case "VideoDescriptionName":
            return Optional.ofNullable(clazz.cast(videoDescriptionName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Output, T> g) {
        return obj -> g.apply((Output) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Output> {
        /**
         * The names of the AudioDescriptions used as audio sources for this output.
         * 
         * @param audioDescriptionNames
         *        The names of the AudioDescriptions used as audio sources for this output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioDescriptionNames(Collection<String> audioDescriptionNames);

        /**
         * The names of the AudioDescriptions used as audio sources for this output.
         * 
         * @param audioDescriptionNames
         *        The names of the AudioDescriptions used as audio sources for this output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioDescriptionNames(String... audioDescriptionNames);

        /**
         * The names of the CaptionDescriptions used as caption sources for this output.
         * 
         * @param captionDescriptionNames
         *        The names of the CaptionDescriptions used as caption sources for this output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captionDescriptionNames(Collection<String> captionDescriptionNames);

        /**
         * The names of the CaptionDescriptions used as caption sources for this output.
         * 
         * @param captionDescriptionNames
         *        The names of the CaptionDescriptions used as caption sources for this output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captionDescriptionNames(String... captionDescriptionNames);

        /**
         * The name used to identify an output.
         * 
         * @param outputName
         *        The name used to identify an output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputName(String outputName);

        /**
         * Output type-specific settings.
         * 
         * @param outputSettings
         *        Output type-specific settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputSettings(OutputSettings outputSettings);

        /**
         * Output type-specific settings. This is a convenience method that creates an instance of the
         * {@link OutputSettings.Builder} avoiding the need to create one manually via {@link OutputSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link OutputSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #outputSettings(OutputSettings)}.
         * 
         * @param outputSettings
         *        a consumer that will call methods on {@link OutputSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputSettings(OutputSettings)
         */
        default Builder outputSettings(Consumer<OutputSettings.Builder> outputSettings) {
            return outputSettings(OutputSettings.builder().applyMutation(outputSettings).build());
        }

        /**
         * The name of the VideoDescription used as the source for this output.
         * 
         * @param videoDescriptionName
         *        The name of the VideoDescription used as the source for this output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoDescriptionName(String videoDescriptionName);
    }

    static final class BuilderImpl implements Builder {
        private List<String> audioDescriptionNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> captionDescriptionNames = DefaultSdkAutoConstructList.getInstance();

        private String outputName;

        private OutputSettings outputSettings;

        private String videoDescriptionName;

        private BuilderImpl() {
        }

        private BuilderImpl(Output model) {
            audioDescriptionNames(model.audioDescriptionNames);
            captionDescriptionNames(model.captionDescriptionNames);
            outputName(model.outputName);
            outputSettings(model.outputSettings);
            videoDescriptionName(model.videoDescriptionName);
        }

        public final Collection<String> getAudioDescriptionNames() {
            if (audioDescriptionNames instanceof SdkAutoConstructList) {
                return null;
            }
            return audioDescriptionNames;
        }

        public final void setAudioDescriptionNames(Collection<String> audioDescriptionNames) {
            this.audioDescriptionNames = ___listOf__stringCopier.copy(audioDescriptionNames);
        }

        @Override
        public final Builder audioDescriptionNames(Collection<String> audioDescriptionNames) {
            this.audioDescriptionNames = ___listOf__stringCopier.copy(audioDescriptionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioDescriptionNames(String... audioDescriptionNames) {
            audioDescriptionNames(Arrays.asList(audioDescriptionNames));
            return this;
        }

        public final Collection<String> getCaptionDescriptionNames() {
            if (captionDescriptionNames instanceof SdkAutoConstructList) {
                return null;
            }
            return captionDescriptionNames;
        }

        public final void setCaptionDescriptionNames(Collection<String> captionDescriptionNames) {
            this.captionDescriptionNames = ___listOf__stringCopier.copy(captionDescriptionNames);
        }

        @Override
        public final Builder captionDescriptionNames(Collection<String> captionDescriptionNames) {
            this.captionDescriptionNames = ___listOf__stringCopier.copy(captionDescriptionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionDescriptionNames(String... captionDescriptionNames) {
            captionDescriptionNames(Arrays.asList(captionDescriptionNames));
            return this;
        }

        public final String getOutputName() {
            return outputName;
        }

        public final void setOutputName(String outputName) {
            this.outputName = outputName;
        }

        @Override
        public final Builder outputName(String outputName) {
            this.outputName = outputName;
            return this;
        }

        public final OutputSettings.Builder getOutputSettings() {
            return outputSettings != null ? outputSettings.toBuilder() : null;
        }

        public final void setOutputSettings(OutputSettings.BuilderImpl outputSettings) {
            this.outputSettings = outputSettings != null ? outputSettings.build() : null;
        }

        @Override
        public final Builder outputSettings(OutputSettings outputSettings) {
            this.outputSettings = outputSettings;
            return this;
        }

        public final String getVideoDescriptionName() {
            return videoDescriptionName;
        }

        public final void setVideoDescriptionName(String videoDescriptionName) {
            this.videoDescriptionName = videoDescriptionName;
        }

        @Override
        public final Builder videoDescriptionName(String videoDescriptionName) {
            this.videoDescriptionName = videoDescriptionName;
            return this;
        }

        @Override
        public Output build() {
            return new Output(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
