/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for StartMultiplexResponse
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartMultiplexResponse extends MediaLiveResponse implements
        ToCopyableBuilder<StartMultiplexResponse.Builder, StartMultiplexResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(StartMultiplexResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZones")
            .getter(getter(StartMultiplexResponse::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MultiplexOutputDestination>> DESTINATIONS_FIELD = SdkField
            .<List<MultiplexOutputDestination>> builder(MarshallingType.LIST)
            .memberName("Destinations")
            .getter(getter(StartMultiplexResponse::destinations))
            .setter(setter(Builder::destinations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MultiplexOutputDestination> builder(MarshallingType.SDK_POJO)
                                            .constructor(MultiplexOutputDestination::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(StartMultiplexResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<MultiplexSettings> MULTIPLEX_SETTINGS_FIELD = SdkField
            .<MultiplexSettings> builder(MarshallingType.SDK_POJO).memberName("MultiplexSettings")
            .getter(getter(StartMultiplexResponse::multiplexSettings)).setter(setter(Builder::multiplexSettings))
            .constructor(MultiplexSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiplexSettings").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(StartMultiplexResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> PIPELINES_RUNNING_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PipelinesRunningCount").getter(getter(StartMultiplexResponse::pipelinesRunningCount))
            .setter(setter(Builder::pipelinesRunningCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelinesRunningCount").build())
            .build();

    private static final SdkField<Integer> PROGRAM_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ProgramCount").getter(getter(StartMultiplexResponse::programCount))
            .setter(setter(Builder::programCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programCount").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(StartMultiplexResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(StartMultiplexResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            AVAILABILITY_ZONES_FIELD, DESTINATIONS_FIELD, ID_FIELD, MULTIPLEX_SETTINGS_FIELD, NAME_FIELD,
            PIPELINES_RUNNING_COUNT_FIELD, PROGRAM_COUNT_FIELD, STATE_FIELD, TAGS_FIELD));

    private final String arn;

    private final List<String> availabilityZones;

    private final List<MultiplexOutputDestination> destinations;

    private final String id;

    private final MultiplexSettings multiplexSettings;

    private final String name;

    private final Integer pipelinesRunningCount;

    private final Integer programCount;

    private final String state;

    private final Map<String, String> tags;

    private StartMultiplexResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.availabilityZones = builder.availabilityZones;
        this.destinations = builder.destinations;
        this.id = builder.id;
        this.multiplexSettings = builder.multiplexSettings;
        this.name = builder.name;
        this.pipelinesRunningCount = builder.pipelinesRunningCount;
        this.programCount = builder.programCount;
        this.state = builder.state;
        this.tags = builder.tags;
    }

    /**
     * The unique arn of the multiplex.
     * 
     * @return The unique arn of the multiplex.
     */
    public final String arn() {
        return arn;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailabilityZones property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * A list of availability zones for the multiplex.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailabilityZones} method.
     * </p>
     * 
     * @return A list of availability zones for the multiplex.
     */
    public final List<String> availabilityZones() {
        return availabilityZones;
    }

    /**
     * For responses, this returns true if the service returned a value for the Destinations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDestinations() {
        return destinations != null && !(destinations instanceof SdkAutoConstructList);
    }

    /**
     * A list of the multiplex output destinations.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinations} method.
     * </p>
     * 
     * @return A list of the multiplex output destinations.
     */
    public final List<MultiplexOutputDestination> destinations() {
        return destinations;
    }

    /**
     * The unique id of the multiplex.
     * 
     * @return The unique id of the multiplex.
     */
    public final String id() {
        return id;
    }

    /**
     * Configuration for a multiplex event.
     * 
     * @return Configuration for a multiplex event.
     */
    public final MultiplexSettings multiplexSettings() {
        return multiplexSettings;
    }

    /**
     * The name of the multiplex.
     * 
     * @return The name of the multiplex.
     */
    public final String name() {
        return name;
    }

    /**
     * The number of currently healthy pipelines.
     * 
     * @return The number of currently healthy pipelines.
     */
    public final Integer pipelinesRunningCount() {
        return pipelinesRunningCount;
    }

    /**
     * The number of programs in the multiplex.
     * 
     * @return The number of programs in the multiplex.
     */
    public final Integer programCount() {
        return programCount;
    }

    /**
     * The current state of the multiplex.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link MultiplexState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the multiplex.
     * @see MultiplexState
     */
    public final MultiplexState state() {
        return MultiplexState.fromValue(state);
    }

    /**
     * The current state of the multiplex.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link MultiplexState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the multiplex.
     * @see MultiplexState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * A collection of key-value pairs.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A collection of key-value pairs.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZones() ? availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinations() ? destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(multiplexSettings());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(pipelinesRunningCount());
        hashCode = 31 * hashCode + Objects.hashCode(programCount());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMultiplexResponse)) {
            return false;
        }
        StartMultiplexResponse other = (StartMultiplexResponse) obj;
        return Objects.equals(arn(), other.arn()) && hasAvailabilityZones() == other.hasAvailabilityZones()
                && Objects.equals(availabilityZones(), other.availabilityZones()) && hasDestinations() == other.hasDestinations()
                && Objects.equals(destinations(), other.destinations()) && Objects.equals(id(), other.id())
                && Objects.equals(multiplexSettings(), other.multiplexSettings()) && Objects.equals(name(), other.name())
                && Objects.equals(pipelinesRunningCount(), other.pipelinesRunningCount())
                && Objects.equals(programCount(), other.programCount()) && Objects.equals(stateAsString(), other.stateAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartMultiplexResponse").add("Arn", arn())
                .add("AvailabilityZones", hasAvailabilityZones() ? availabilityZones() : null)
                .add("Destinations", hasDestinations() ? destinations() : null).add("Id", id())
                .add("MultiplexSettings", multiplexSettings()).add("Name", name())
                .add("PipelinesRunningCount", pipelinesRunningCount()).add("ProgramCount", programCount())
                .add("State", stateAsString()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "AvailabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "Destinations":
            return Optional.ofNullable(clazz.cast(destinations()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "MultiplexSettings":
            return Optional.ofNullable(clazz.cast(multiplexSettings()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "PipelinesRunningCount":
            return Optional.ofNullable(clazz.cast(pipelinesRunningCount()));
        case "ProgramCount":
            return Optional.ofNullable(clazz.cast(programCount()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartMultiplexResponse, T> g) {
        return obj -> g.apply((StartMultiplexResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartMultiplexResponse> {
        /**
         * The unique arn of the multiplex.
         * 
         * @param arn
         *        The unique arn of the multiplex.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * A list of availability zones for the multiplex.
         * 
         * @param availabilityZones
         *        A list of availability zones for the multiplex.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * A list of availability zones for the multiplex.
         * 
         * @param availabilityZones
         *        A list of availability zones for the multiplex.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);

        /**
         * A list of the multiplex output destinations.
         * 
         * @param destinations
         *        A list of the multiplex output destinations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(Collection<MultiplexOutputDestination> destinations);

        /**
         * A list of the multiplex output destinations.
         * 
         * @param destinations
         *        A list of the multiplex output destinations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(MultiplexOutputDestination... destinations);

        /**
         * A list of the multiplex output destinations. This is a convenience method that creates an instance of the
         * {@link List<MultiplexOutputDestination>.Builder} avoiding the need to create one manually via {@link List
         * <MultiplexOutputDestination>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MultiplexOutputDestination>.Builder#build()} is called
         * immediately and its result is passed to {@link #destinations(List<MultiplexOutputDestination>)}.
         * 
         * @param destinations
         *        a consumer that will call methods on {@link List<MultiplexOutputDestination>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinations(List<MultiplexOutputDestination>)
         */
        Builder destinations(Consumer<MultiplexOutputDestination.Builder>... destinations);

        /**
         * The unique id of the multiplex.
         * 
         * @param id
         *        The unique id of the multiplex.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Configuration for a multiplex event.
         * 
         * @param multiplexSettings
         *        Configuration for a multiplex event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiplexSettings(MultiplexSettings multiplexSettings);

        /**
         * Configuration for a multiplex event. This is a convenience method that creates an instance of the
         * {@link MultiplexSettings.Builder} avoiding the need to create one manually via
         * {@link MultiplexSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link MultiplexSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #multiplexSettings(MultiplexSettings)}.
         * 
         * @param multiplexSettings
         *        a consumer that will call methods on {@link MultiplexSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multiplexSettings(MultiplexSettings)
         */
        default Builder multiplexSettings(Consumer<MultiplexSettings.Builder> multiplexSettings) {
            return multiplexSettings(MultiplexSettings.builder().applyMutation(multiplexSettings).build());
        }

        /**
         * The name of the multiplex.
         * 
         * @param name
         *        The name of the multiplex.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * The number of currently healthy pipelines.
         * 
         * @param pipelinesRunningCount
         *        The number of currently healthy pipelines.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelinesRunningCount(Integer pipelinesRunningCount);

        /**
         * The number of programs in the multiplex.
         * 
         * @param programCount
         *        The number of programs in the multiplex.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programCount(Integer programCount);

        /**
         * The current state of the multiplex.
         * 
         * @param state
         *        The current state of the multiplex.
         * @see MultiplexState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MultiplexState
         */
        Builder state(String state);

        /**
         * The current state of the multiplex.
         * 
         * @param state
         *        The current state of the multiplex.
         * @see MultiplexState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MultiplexState
         */
        Builder state(MultiplexState state);

        /**
         * A collection of key-value pairs.
         * 
         * @param tags
         *        A collection of key-value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends MediaLiveResponse.BuilderImpl implements Builder {
        private String arn;

        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private List<MultiplexOutputDestination> destinations = DefaultSdkAutoConstructList.getInstance();

        private String id;

        private MultiplexSettings multiplexSettings;

        private String name;

        private Integer pipelinesRunningCount;

        private Integer programCount;

        private String state;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartMultiplexResponse model) {
            super(model);
            arn(model.arn);
            availabilityZones(model.availabilityZones);
            destinations(model.destinations);
            id(model.id);
            multiplexSettings(model.multiplexSettings);
            name(model.name);
            pipelinesRunningCount(model.pipelinesRunningCount);
            programCount(model.programCount);
            state(model.state);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Collection<String> getAvailabilityZones() {
            if (availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = ___listOf__stringCopier.copy(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = ___listOf__stringCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final List<MultiplexOutputDestination.Builder> getDestinations() {
            List<MultiplexOutputDestination.Builder> result = ___listOfMultiplexOutputDestinationCopier
                    .copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<MultiplexOutputDestination.BuilderImpl> destinations) {
            this.destinations = ___listOfMultiplexOutputDestinationCopier.copyFromBuilder(destinations);
        }

        @Override
        public final Builder destinations(Collection<MultiplexOutputDestination> destinations) {
            this.destinations = ___listOfMultiplexOutputDestinationCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(MultiplexOutputDestination... destinations) {
            destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<MultiplexOutputDestination.Builder>... destinations) {
            destinations(Stream.of(destinations).map(c -> MultiplexOutputDestination.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final MultiplexSettings.Builder getMultiplexSettings() {
            return multiplexSettings != null ? multiplexSettings.toBuilder() : null;
        }

        public final void setMultiplexSettings(MultiplexSettings.BuilderImpl multiplexSettings) {
            this.multiplexSettings = multiplexSettings != null ? multiplexSettings.build() : null;
        }

        @Override
        public final Builder multiplexSettings(MultiplexSettings multiplexSettings) {
            this.multiplexSettings = multiplexSettings;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getPipelinesRunningCount() {
            return pipelinesRunningCount;
        }

        public final void setPipelinesRunningCount(Integer pipelinesRunningCount) {
            this.pipelinesRunningCount = pipelinesRunningCount;
        }

        @Override
        public final Builder pipelinesRunningCount(Integer pipelinesRunningCount) {
            this.pipelinesRunningCount = pipelinesRunningCount;
            return this;
        }

        public final Integer getProgramCount() {
            return programCount;
        }

        public final void setProgramCount(Integer programCount) {
            this.programCount = programCount;
        }

        @Override
        public final Builder programCount(Integer programCount) {
            this.programCount = programCount;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(MultiplexState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public StartMultiplexResponse build() {
            return new StartMultiplexResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
