/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Static Key Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class StaticKeySettings implements SdkPojo, Serializable,
        ToCopyableBuilder<StaticKeySettings.Builder, StaticKeySettings> {
    private static final SdkField<InputLocation> KEY_PROVIDER_SERVER_FIELD = SdkField
            .<InputLocation> builder(MarshallingType.SDK_POJO).memberName("KeyProviderServer")
            .getter(getter(StaticKeySettings::keyProviderServer)).setter(setter(Builder::keyProviderServer))
            .constructor(InputLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyProviderServer").build()).build();

    private static final SdkField<String> STATIC_KEY_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StaticKeyValue").getter(getter(StaticKeySettings::staticKeyValue))
            .setter(setter(Builder::staticKeyValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("staticKeyValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_PROVIDER_SERVER_FIELD,
            STATIC_KEY_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final InputLocation keyProviderServer;

    private final String staticKeyValue;

    private StaticKeySettings(BuilderImpl builder) {
        this.keyProviderServer = builder.keyProviderServer;
        this.staticKeyValue = builder.staticKeyValue;
    }

    /**
     * The URL of the license server used for protecting content.
     * 
     * @return The URL of the license server used for protecting content.
     */
    public final InputLocation keyProviderServer() {
        return keyProviderServer;
    }

    /**
     * Static key value as a 32 character hexadecimal string.
     * 
     * @return Static key value as a 32 character hexadecimal string.
     */
    public final String staticKeyValue() {
        return staticKeyValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyProviderServer());
        hashCode = 31 * hashCode + Objects.hashCode(staticKeyValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StaticKeySettings)) {
            return false;
        }
        StaticKeySettings other = (StaticKeySettings) obj;
        return Objects.equals(keyProviderServer(), other.keyProviderServer())
                && Objects.equals(staticKeyValue(), other.staticKeyValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StaticKeySettings").add("KeyProviderServer", keyProviderServer())
                .add("StaticKeyValue", staticKeyValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyProviderServer":
            return Optional.ofNullable(clazz.cast(keyProviderServer()));
        case "StaticKeyValue":
            return Optional.ofNullable(clazz.cast(staticKeyValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StaticKeySettings, T> g) {
        return obj -> g.apply((StaticKeySettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StaticKeySettings> {
        /**
         * The URL of the license server used for protecting content.
         * 
         * @param keyProviderServer
         *        The URL of the license server used for protecting content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyProviderServer(InputLocation keyProviderServer);

        /**
         * The URL of the license server used for protecting content. This is a convenience method that creates an
         * instance of the {@link InputLocation.Builder} avoiding the need to create one manually via
         * {@link InputLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #keyProviderServer(InputLocation)}.
         * 
         * @param keyProviderServer
         *        a consumer that will call methods on {@link InputLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyProviderServer(InputLocation)
         */
        default Builder keyProviderServer(Consumer<InputLocation.Builder> keyProviderServer) {
            return keyProviderServer(InputLocation.builder().applyMutation(keyProviderServer).build());
        }

        /**
         * Static key value as a 32 character hexadecimal string.
         * 
         * @param staticKeyValue
         *        Static key value as a 32 character hexadecimal string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticKeyValue(String staticKeyValue);
    }

    static final class BuilderImpl implements Builder {
        private InputLocation keyProviderServer;

        private String staticKeyValue;

        private BuilderImpl() {
        }

        private BuilderImpl(StaticKeySettings model) {
            keyProviderServer(model.keyProviderServer);
            staticKeyValue(model.staticKeyValue);
        }

        public final InputLocation.Builder getKeyProviderServer() {
            return keyProviderServer != null ? keyProviderServer.toBuilder() : null;
        }

        public final void setKeyProviderServer(InputLocation.BuilderImpl keyProviderServer) {
            this.keyProviderServer = keyProviderServer != null ? keyProviderServer.build() : null;
        }

        @Override
        public final Builder keyProviderServer(InputLocation keyProviderServer) {
            this.keyProviderServer = keyProviderServer;
            return this;
        }

        public final String getStaticKeyValue() {
            return staticKeyValue;
        }

        public final void setStaticKeyValue(String staticKeyValue) {
            this.staticKeyValue = staticKeyValue;
        }

        @Override
        public final Builder staticKeyValue(String staticKeyValue) {
            this.staticKeyValue = staticKeyValue;
            return this;
        }

        @Override
        public StaticKeySettings build() {
            return new StaticKeySettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
