/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A request to update a multiplex.
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMultiplexRequest extends MediaLiveRequest implements
        ToCopyableBuilder<UpdateMultiplexRequest.Builder, UpdateMultiplexRequest> {
    private static final SdkField<String> MULTIPLEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MultiplexId").getter(getter(UpdateMultiplexRequest::multiplexId)).setter(setter(Builder::multiplexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("multiplexId").build()).build();

    private static final SdkField<MultiplexSettings> MULTIPLEX_SETTINGS_FIELD = SdkField
            .<MultiplexSettings> builder(MarshallingType.SDK_POJO).memberName("MultiplexSettings")
            .getter(getter(UpdateMultiplexRequest::multiplexSettings)).setter(setter(Builder::multiplexSettings))
            .constructor(MultiplexSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiplexSettings").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateMultiplexRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MULTIPLEX_ID_FIELD,
            MULTIPLEX_SETTINGS_FIELD, NAME_FIELD));

    private final String multiplexId;

    private final MultiplexSettings multiplexSettings;

    private final String name;

    private UpdateMultiplexRequest(BuilderImpl builder) {
        super(builder);
        this.multiplexId = builder.multiplexId;
        this.multiplexSettings = builder.multiplexSettings;
        this.name = builder.name;
    }

    /**
     * ID of the multiplex to update.
     * 
     * @return ID of the multiplex to update.
     */
    public final String multiplexId() {
        return multiplexId;
    }

    /**
     * The new settings for a multiplex.
     * 
     * @return The new settings for a multiplex.
     */
    public final MultiplexSettings multiplexSettings() {
        return multiplexSettings;
    }

    /**
     * Name of the multiplex.
     * 
     * @return Name of the multiplex.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(multiplexId());
        hashCode = 31 * hashCode + Objects.hashCode(multiplexSettings());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMultiplexRequest)) {
            return false;
        }
        UpdateMultiplexRequest other = (UpdateMultiplexRequest) obj;
        return Objects.equals(multiplexId(), other.multiplexId())
                && Objects.equals(multiplexSettings(), other.multiplexSettings()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateMultiplexRequest").add("MultiplexId", multiplexId())
                .add("MultiplexSettings", multiplexSettings()).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MultiplexId":
            return Optional.ofNullable(clazz.cast(multiplexId()));
        case "MultiplexSettings":
            return Optional.ofNullable(clazz.cast(multiplexSettings()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMultiplexRequest, T> g) {
        return obj -> g.apply((UpdateMultiplexRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateMultiplexRequest> {
        /**
         * ID of the multiplex to update.
         * 
         * @param multiplexId
         *        ID of the multiplex to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiplexId(String multiplexId);

        /**
         * The new settings for a multiplex.
         * 
         * @param multiplexSettings
         *        The new settings for a multiplex.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiplexSettings(MultiplexSettings multiplexSettings);

        /**
         * The new settings for a multiplex. This is a convenience method that creates an instance of the
         * {@link MultiplexSettings.Builder} avoiding the need to create one manually via
         * {@link MultiplexSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link MultiplexSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #multiplexSettings(MultiplexSettings)}.
         * 
         * @param multiplexSettings
         *        a consumer that will call methods on {@link MultiplexSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multiplexSettings(MultiplexSettings)
         */
        default Builder multiplexSettings(Consumer<MultiplexSettings.Builder> multiplexSettings) {
            return multiplexSettings(MultiplexSettings.builder().applyMutation(multiplexSettings).build());
        }

        /**
         * Name of the multiplex.
         * 
         * @param name
         *        Name of the multiplex.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaLiveRequest.BuilderImpl implements Builder {
        private String multiplexId;

        private MultiplexSettings multiplexSettings;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMultiplexRequest model) {
            super(model);
            multiplexId(model.multiplexId);
            multiplexSettings(model.multiplexSettings);
            name(model.name);
        }

        public final String getMultiplexId() {
            return multiplexId;
        }

        public final void setMultiplexId(String multiplexId) {
            this.multiplexId = multiplexId;
        }

        @Override
        public final Builder multiplexId(String multiplexId) {
            this.multiplexId = multiplexId;
            return this;
        }

        public final MultiplexSettings.Builder getMultiplexSettings() {
            return multiplexSettings != null ? multiplexSettings.toBuilder() : null;
        }

        public final void setMultiplexSettings(MultiplexSettings.BuilderImpl multiplexSettings) {
            this.multiplexSettings = multiplexSettings != null ? multiplexSettings.build() : null;
        }

        @Override
        public final Builder multiplexSettings(MultiplexSettings multiplexSettings) {
            this.multiplexSettings = multiplexSettings;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMultiplexRequest build() {
            return new UpdateMultiplexRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
