/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Hls Input Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class HlsInputSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<HlsInputSettings.Builder, HlsInputSettings> {
    private static final SdkField<Integer> BANDWIDTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Bandwidth").getter(getter(HlsInputSettings::bandwidth)).setter(setter(Builder::bandwidth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bandwidth").build()).build();

    private static final SdkField<Integer> BUFFER_SEGMENTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BufferSegments").getter(getter(HlsInputSettings::bufferSegments))
            .setter(setter(Builder::bufferSegments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bufferSegments").build()).build();

    private static final SdkField<Integer> RETRIES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Retries").getter(getter(HlsInputSettings::retries)).setter(setter(Builder::retries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retries").build()).build();

    private static final SdkField<Integer> RETRY_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RetryInterval").getter(getter(HlsInputSettings::retryInterval)).setter(setter(Builder::retryInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryInterval").build()).build();

    private static final SdkField<String> SCTE35_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Scte35Source").getter(getter(HlsInputSettings::scte35SourceAsString))
            .setter(setter(Builder::scte35Source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35Source").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BANDWIDTH_FIELD,
            BUFFER_SEGMENTS_FIELD, RETRIES_FIELD, RETRY_INTERVAL_FIELD, SCTE35_SOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer bandwidth;

    private final Integer bufferSegments;

    private final Integer retries;

    private final Integer retryInterval;

    private final String scte35Source;

    private HlsInputSettings(BuilderImpl builder) {
        this.bandwidth = builder.bandwidth;
        this.bufferSegments = builder.bufferSegments;
        this.retries = builder.retries;
        this.retryInterval = builder.retryInterval;
        this.scte35Source = builder.scte35Source;
    }

    /**
     * When specified the HLS stream with the m3u8 BANDWIDTH that most closely matches this value will be chosen,
     * otherwise the highest bandwidth stream in the m3u8 will be chosen. The bitrate is specified in bits per second,
     * as in an HLS manifest.
     * 
     * @return When specified the HLS stream with the m3u8 BANDWIDTH that most closely matches this value will be
     *         chosen, otherwise the highest bandwidth stream in the m3u8 will be chosen. The bitrate is specified in
     *         bits per second, as in an HLS manifest.
     */
    public final Integer bandwidth() {
        return bandwidth;
    }

    /**
     * When specified, reading of the HLS input will begin this many buffer segments from the end (most recently written
     * segment). When not specified, the HLS input will begin with the first segment specified in the m3u8.
     * 
     * @return When specified, reading of the HLS input will begin this many buffer segments from the end (most recently
     *         written segment). When not specified, the HLS input will begin with the first segment specified in the
     *         m3u8.
     */
    public final Integer bufferSegments() {
        return bufferSegments;
    }

    /**
     * The number of consecutive times that attempts to read a manifest or segment must fail before the input is
     * considered unavailable.
     * 
     * @return The number of consecutive times that attempts to read a manifest or segment must fail before the input is
     *         considered unavailable.
     */
    public final Integer retries() {
        return retries;
    }

    /**
     * The number of seconds between retries when an attempt to read a manifest or segment fails.
     * 
     * @return The number of seconds between retries when an attempt to read a manifest or segment fails.
     */
    public final Integer retryInterval() {
        return retryInterval;
    }

    /**
     * Identifies the source for the SCTE-35 messages that MediaLive will ingest. Messages can be ingested from the
     * content segments (in the stream) or from tags in the playlist (the HLS manifest). MediaLive ignores SCTE-35
     * information in the source that is not selected.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scte35Source} will
     * return {@link HlsScte35SourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scte35SourceAsString}.
     * </p>
     * 
     * @return Identifies the source for the SCTE-35 messages that MediaLive will ingest. Messages can be ingested from
     *         the content segments (in the stream) or from tags in the playlist (the HLS manifest). MediaLive ignores
     *         SCTE-35 information in the source that is not selected.
     * @see HlsScte35SourceType
     */
    public final HlsScte35SourceType scte35Source() {
        return HlsScte35SourceType.fromValue(scte35Source);
    }

    /**
     * Identifies the source for the SCTE-35 messages that MediaLive will ingest. Messages can be ingested from the
     * content segments (in the stream) or from tags in the playlist (the HLS manifest). MediaLive ignores SCTE-35
     * information in the source that is not selected.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scte35Source} will
     * return {@link HlsScte35SourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scte35SourceAsString}.
     * </p>
     * 
     * @return Identifies the source for the SCTE-35 messages that MediaLive will ingest. Messages can be ingested from
     *         the content segments (in the stream) or from tags in the playlist (the HLS manifest). MediaLive ignores
     *         SCTE-35 information in the source that is not selected.
     * @see HlsScte35SourceType
     */
    public final String scte35SourceAsString() {
        return scte35Source;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bandwidth());
        hashCode = 31 * hashCode + Objects.hashCode(bufferSegments());
        hashCode = 31 * hashCode + Objects.hashCode(retries());
        hashCode = 31 * hashCode + Objects.hashCode(retryInterval());
        hashCode = 31 * hashCode + Objects.hashCode(scte35SourceAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsInputSettings)) {
            return false;
        }
        HlsInputSettings other = (HlsInputSettings) obj;
        return Objects.equals(bandwidth(), other.bandwidth()) && Objects.equals(bufferSegments(), other.bufferSegments())
                && Objects.equals(retries(), other.retries()) && Objects.equals(retryInterval(), other.retryInterval())
                && Objects.equals(scte35SourceAsString(), other.scte35SourceAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HlsInputSettings").add("Bandwidth", bandwidth()).add("BufferSegments", bufferSegments())
                .add("Retries", retries()).add("RetryInterval", retryInterval()).add("Scte35Source", scte35SourceAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bandwidth":
            return Optional.ofNullable(clazz.cast(bandwidth()));
        case "BufferSegments":
            return Optional.ofNullable(clazz.cast(bufferSegments()));
        case "Retries":
            return Optional.ofNullable(clazz.cast(retries()));
        case "RetryInterval":
            return Optional.ofNullable(clazz.cast(retryInterval()));
        case "Scte35Source":
            return Optional.ofNullable(clazz.cast(scte35SourceAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsInputSettings, T> g) {
        return obj -> g.apply((HlsInputSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HlsInputSettings> {
        /**
         * When specified the HLS stream with the m3u8 BANDWIDTH that most closely matches this value will be chosen,
         * otherwise the highest bandwidth stream in the m3u8 will be chosen. The bitrate is specified in bits per
         * second, as in an HLS manifest.
         * 
         * @param bandwidth
         *        When specified the HLS stream with the m3u8 BANDWIDTH that most closely matches this value will be
         *        chosen, otherwise the highest bandwidth stream in the m3u8 will be chosen. The bitrate is specified in
         *        bits per second, as in an HLS manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bandwidth(Integer bandwidth);

        /**
         * When specified, reading of the HLS input will begin this many buffer segments from the end (most recently
         * written segment). When not specified, the HLS input will begin with the first segment specified in the m3u8.
         * 
         * @param bufferSegments
         *        When specified, reading of the HLS input will begin this many buffer segments from the end (most
         *        recently written segment). When not specified, the HLS input will begin with the first segment
         *        specified in the m3u8.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bufferSegments(Integer bufferSegments);

        /**
         * The number of consecutive times that attempts to read a manifest or segment must fail before the input is
         * considered unavailable.
         * 
         * @param retries
         *        The number of consecutive times that attempts to read a manifest or segment must fail before the input
         *        is considered unavailable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retries(Integer retries);

        /**
         * The number of seconds between retries when an attempt to read a manifest or segment fails.
         * 
         * @param retryInterval
         *        The number of seconds between retries when an attempt to read a manifest or segment fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryInterval(Integer retryInterval);

        /**
         * Identifies the source for the SCTE-35 messages that MediaLive will ingest. Messages can be ingested from the
         * content segments (in the stream) or from tags in the playlist (the HLS manifest). MediaLive ignores SCTE-35
         * information in the source that is not selected.
         * 
         * @param scte35Source
         *        Identifies the source for the SCTE-35 messages that MediaLive will ingest. Messages can be ingested
         *        from the content segments (in the stream) or from tags in the playlist (the HLS manifest). MediaLive
         *        ignores SCTE-35 information in the source that is not selected.
         * @see HlsScte35SourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsScte35SourceType
         */
        Builder scte35Source(String scte35Source);

        /**
         * Identifies the source for the SCTE-35 messages that MediaLive will ingest. Messages can be ingested from the
         * content segments (in the stream) or from tags in the playlist (the HLS manifest). MediaLive ignores SCTE-35
         * information in the source that is not selected.
         * 
         * @param scte35Source
         *        Identifies the source for the SCTE-35 messages that MediaLive will ingest. Messages can be ingested
         *        from the content segments (in the stream) or from tags in the playlist (the HLS manifest). MediaLive
         *        ignores SCTE-35 information in the source that is not selected.
         * @see HlsScte35SourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsScte35SourceType
         */
        Builder scte35Source(HlsScte35SourceType scte35Source);
    }

    static final class BuilderImpl implements Builder {
        private Integer bandwidth;

        private Integer bufferSegments;

        private Integer retries;

        private Integer retryInterval;

        private String scte35Source;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsInputSettings model) {
            bandwidth(model.bandwidth);
            bufferSegments(model.bufferSegments);
            retries(model.retries);
            retryInterval(model.retryInterval);
            scte35Source(model.scte35Source);
        }

        public final Integer getBandwidth() {
            return bandwidth;
        }

        public final void setBandwidth(Integer bandwidth) {
            this.bandwidth = bandwidth;
        }

        @Override
        public final Builder bandwidth(Integer bandwidth) {
            this.bandwidth = bandwidth;
            return this;
        }

        public final Integer getBufferSegments() {
            return bufferSegments;
        }

        public final void setBufferSegments(Integer bufferSegments) {
            this.bufferSegments = bufferSegments;
        }

        @Override
        public final Builder bufferSegments(Integer bufferSegments) {
            this.bufferSegments = bufferSegments;
            return this;
        }

        public final Integer getRetries() {
            return retries;
        }

        public final void setRetries(Integer retries) {
            this.retries = retries;
        }

        @Override
        public final Builder retries(Integer retries) {
            this.retries = retries;
            return this;
        }

        public final Integer getRetryInterval() {
            return retryInterval;
        }

        public final void setRetryInterval(Integer retryInterval) {
            this.retryInterval = retryInterval;
        }

        @Override
        public final Builder retryInterval(Integer retryInterval) {
            this.retryInterval = retryInterval;
            return this;
        }

        public final String getScte35Source() {
            return scte35Source;
        }

        public final void setScte35Source(String scte35Source) {
            this.scte35Source = scte35Source;
        }

        @Override
        public final Builder scte35Source(String scte35Source) {
            this.scte35Source = scte35Source;
            return this;
        }

        @Override
        public final Builder scte35Source(HlsScte35SourceType scte35Source) {
            this.scte35Source(scte35Source == null ? null : scte35Source.toString());
            return this;
        }

        @Override
        public HlsInputSettings build() {
            return new HlsInputSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
