/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for ChannelEgressEndpoint
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChannelEgressEndpoint implements SdkPojo, Serializable,
        ToCopyableBuilder<ChannelEgressEndpoint.Builder, ChannelEgressEndpoint> {
    private static final SdkField<String> SOURCE_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceIp").getter(getter(ChannelEgressEndpoint::sourceIp)).setter(setter(Builder::sourceIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceIp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_IP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sourceIp;

    private ChannelEgressEndpoint(BuilderImpl builder) {
        this.sourceIp = builder.sourceIp;
    }

    /**
     * Public IP of where a channel's output comes from
     * 
     * @return Public IP of where a channel's output comes from
     */
    public final String sourceIp() {
        return sourceIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceIp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelEgressEndpoint)) {
            return false;
        }
        ChannelEgressEndpoint other = (ChannelEgressEndpoint) obj;
        return Objects.equals(sourceIp(), other.sourceIp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChannelEgressEndpoint").add("SourceIp", sourceIp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceIp":
            return Optional.ofNullable(clazz.cast(sourceIp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChannelEgressEndpoint, T> g) {
        return obj -> g.apply((ChannelEgressEndpoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChannelEgressEndpoint> {
        /**
         * Public IP of where a channel's output comes from
         * 
         * @param sourceIp
         *        Public IP of where a channel's output comes from
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceIp(String sourceIp);
    }

    static final class BuilderImpl implements Builder {
        private String sourceIp;

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelEgressEndpoint model) {
            sourceIp(model.sourceIp);
        }

        public final String getSourceIp() {
            return sourceIp;
        }

        public final void setSourceIp(String sourceIp) {
            this.sourceIp = sourceIp;
        }

        @Override
        public final Builder sourceIp(String sourceIp) {
            this.sourceIp = sourceIp;
            return this;
        }

        @Override
        public ChannelEgressEndpoint build() {
            return new ChannelEgressEndpoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
