/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings for the action to insert a user-defined ID3 tag in each HLS segment
 */
@Generated("software.amazon.awssdk:codegen")
public final class HlsId3SegmentTaggingScheduleActionSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<HlsId3SegmentTaggingScheduleActionSettings.Builder, HlsId3SegmentTaggingScheduleActionSettings> {
    private static final SdkField<String> TAG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Tag")
            .getter(getter(HlsId3SegmentTaggingScheduleActionSettings::tag)).setter(setter(Builder::tag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tag").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String tag;

    private HlsId3SegmentTaggingScheduleActionSettings(BuilderImpl builder) {
        this.tag = builder.tag;
    }

    /**
     * ID3 tag to insert into each segment. Supports special keyword identifiers to substitute in segment-related
     * values.\nSupported keyword identifiers:
     * https://docs.aws.amazon.com/medialive/latest/ug/variable-data-identifiers.html
     * 
     * @return ID3 tag to insert into each segment. Supports special keyword identifiers to substitute in
     *         segment-related values.\nSupported keyword identifiers:
     *         https://docs.aws.amazon.com/medialive/latest/ug/variable-data-identifiers.html
     */
    public final String tag() {
        return tag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tag());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsId3SegmentTaggingScheduleActionSettings)) {
            return false;
        }
        HlsId3SegmentTaggingScheduleActionSettings other = (HlsId3SegmentTaggingScheduleActionSettings) obj;
        return Objects.equals(tag(), other.tag());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HlsId3SegmentTaggingScheduleActionSettings").add("Tag", tag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Tag":
            return Optional.ofNullable(clazz.cast(tag()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsId3SegmentTaggingScheduleActionSettings, T> g) {
        return obj -> g.apply((HlsId3SegmentTaggingScheduleActionSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HlsId3SegmentTaggingScheduleActionSettings> {
        /**
         * ID3 tag to insert into each segment. Supports special keyword identifiers to substitute in segment-related
         * values.\nSupported keyword identifiers:
         * https://docs.aws.amazon.com/medialive/latest/ug/variable-data-identifiers.html
         * 
         * @param tag
         *        ID3 tag to insert into each segment. Supports special keyword identifiers to substitute in
         *        segment-related values.\nSupported keyword identifiers:
         *        https://docs.aws.amazon.com/medialive/latest/ug/variable-data-identifiers.html
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tag(String tag);
    }

    static final class BuilderImpl implements Builder {
        private String tag;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsId3SegmentTaggingScheduleActionSettings model) {
            tag(model.tag);
        }

        public final String getTag() {
            return tag;
        }

        public final void setTag(String tag) {
            this.tag = tag;
        }

        @Override
        public final Builder tag(String tag) {
            this.tag = tag;
            return this;
        }

        @Override
        public HlsId3SegmentTaggingScheduleActionSettings build() {
            return new HlsId3SegmentTaggingScheduleActionSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
