/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings for the "scte35 input" action
 */
@Generated("software.amazon.awssdk:codegen")
public final class Scte35InputScheduleActionSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<Scte35InputScheduleActionSettings.Builder, Scte35InputScheduleActionSettings> {
    private static final SdkField<String> INPUT_ATTACHMENT_NAME_REFERENCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InputAttachmentNameReference")
            .getter(getter(Scte35InputScheduleActionSettings::inputAttachmentNameReference))
            .setter(setter(Builder::inputAttachmentNameReference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputAttachmentNameReference")
                    .build()).build();

    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Mode")
            .getter(getter(Scte35InputScheduleActionSettings::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INPUT_ATTACHMENT_NAME_REFERENCE_FIELD, MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String inputAttachmentNameReference;

    private final String mode;

    private Scte35InputScheduleActionSettings(BuilderImpl builder) {
        this.inputAttachmentNameReference = builder.inputAttachmentNameReference;
        this.mode = builder.mode;
    }

    /**
     * In fixed mode, enter the name of the input attachment that you want to use as a SCTE-35 input. (Don't enter the
     * ID of the input.)"
     * 
     * @return In fixed mode, enter the name of the input attachment that you want to use as a SCTE-35 input. (Don't
     *         enter the ID of the input.)"
     */
    public final String inputAttachmentNameReference() {
        return inputAttachmentNameReference;
    }

    /**
     * Whether the SCTE-35 input should be the active input or a fixed input.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link Scte35InputMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return Whether the SCTE-35 input should be the active input or a fixed input.
     * @see Scte35InputMode
     */
    public final Scte35InputMode mode() {
        return Scte35InputMode.fromValue(mode);
    }

    /**
     * Whether the SCTE-35 input should be the active input or a fixed input.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link Scte35InputMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return Whether the SCTE-35 input should be the active input or a fixed input.
     * @see Scte35InputMode
     */
    public final String modeAsString() {
        return mode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputAttachmentNameReference());
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Scte35InputScheduleActionSettings)) {
            return false;
        }
        Scte35InputScheduleActionSettings other = (Scte35InputScheduleActionSettings) obj;
        return Objects.equals(inputAttachmentNameReference(), other.inputAttachmentNameReference())
                && Objects.equals(modeAsString(), other.modeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Scte35InputScheduleActionSettings")
                .add("InputAttachmentNameReference", inputAttachmentNameReference()).add("Mode", modeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputAttachmentNameReference":
            return Optional.ofNullable(clazz.cast(inputAttachmentNameReference()));
        case "Mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Scte35InputScheduleActionSettings, T> g) {
        return obj -> g.apply((Scte35InputScheduleActionSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Scte35InputScheduleActionSettings> {
        /**
         * In fixed mode, enter the name of the input attachment that you want to use as a SCTE-35 input. (Don't enter
         * the ID of the input.)"
         * 
         * @param inputAttachmentNameReference
         *        In fixed mode, enter the name of the input attachment that you want to use as a SCTE-35 input. (Don't
         *        enter the ID of the input.)"
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputAttachmentNameReference(String inputAttachmentNameReference);

        /**
         * Whether the SCTE-35 input should be the active input or a fixed input.
         * 
         * @param mode
         *        Whether the SCTE-35 input should be the active input or a fixed input.
         * @see Scte35InputMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scte35InputMode
         */
        Builder mode(String mode);

        /**
         * Whether the SCTE-35 input should be the active input or a fixed input.
         * 
         * @param mode
         *        Whether the SCTE-35 input should be the active input or a fixed input.
         * @see Scte35InputMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scte35InputMode
         */
        Builder mode(Scte35InputMode mode);
    }

    static final class BuilderImpl implements Builder {
        private String inputAttachmentNameReference;

        private String mode;

        private BuilderImpl() {
        }

        private BuilderImpl(Scte35InputScheduleActionSettings model) {
            inputAttachmentNameReference(model.inputAttachmentNameReference);
            mode(model.mode);
        }

        public final String getInputAttachmentNameReference() {
            return inputAttachmentNameReference;
        }

        public final void setInputAttachmentNameReference(String inputAttachmentNameReference) {
            this.inputAttachmentNameReference = inputAttachmentNameReference;
        }

        @Override
        public final Builder inputAttachmentNameReference(String inputAttachmentNameReference) {
            this.inputAttachmentNameReference = inputAttachmentNameReference;
            return this;
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(Scte35InputMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        @Override
        public Scte35InputScheduleActionSettings build() {
            return new Scte35InputScheduleActionSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
