/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for UnprocessableEntityException
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnprocessableEntityException extends MediaLiveException implements
        ToCopyableBuilder<UnprocessableEntityException.Builder, UnprocessableEntityException> {
    private static final SdkField<List<ValidationError>> VALIDATION_ERRORS_FIELD = SdkField
            .<List<ValidationError>> builder(MarshallingType.LIST)
            .memberName("ValidationErrors")
            .getter(getter(UnprocessableEntityException::validationErrors))
            .setter(setter(Builder::validationErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationErrors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ValidationError> builder(MarshallingType.SDK_POJO)
                                            .constructor(ValidationError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALIDATION_ERRORS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ValidationError> validationErrors;

    private UnprocessableEntityException(BuilderImpl builder) {
        super(builder);
        this.validationErrors = builder.validationErrors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * For responses, this returns true if the service returned a value for the ValidationErrors property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public boolean hasValidationErrors() {
        return validationErrors != null && !(validationErrors instanceof SdkAutoConstructList);
    }

    /**
     * A collection of validation error responses.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValidationErrors} method.
     * </p>
     * 
     * @return A collection of validation error responses.
     */
    public List<ValidationError> validationErrors() {
        return validationErrors;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UnprocessableEntityException, T> g) {
        return obj -> g.apply((UnprocessableEntityException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UnprocessableEntityException>, MediaLiveException.Builder {
        /**
         * A collection of validation error responses.
         * 
         * @param validationErrors
         *        A collection of validation error responses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationErrors(Collection<ValidationError> validationErrors);

        /**
         * A collection of validation error responses.
         * 
         * @param validationErrors
         *        A collection of validation error responses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationErrors(ValidationError... validationErrors);

        /**
         * A collection of validation error responses. This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.medialive.model.ValidationError.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.medialive.model.ValidationError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.ValidationError.Builder#build()} is called immediately
         * and its result is passed to {@link #validationErrors(List<ValidationError>)}.
         * 
         * @param validationErrors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.ValidationError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validationErrors(java.util.Collection<ValidationError>)
         */
        Builder validationErrors(Consumer<ValidationError.Builder>... validationErrors);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends MediaLiveException.BuilderImpl implements Builder {
        private List<ValidationError> validationErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UnprocessableEntityException model) {
            super(model);
            validationErrors(model.validationErrors);
        }

        public final List<ValidationError.Builder> getValidationErrors() {
            List<ValidationError.Builder> result = ___listOfValidationErrorCopier.copyToBuilder(this.validationErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValidationErrors(Collection<ValidationError.BuilderImpl> validationErrors) {
            this.validationErrors = ___listOfValidationErrorCopier.copyFromBuilder(validationErrors);
        }

        @Override
        public final Builder validationErrors(Collection<ValidationError> validationErrors) {
            this.validationErrors = ___listOfValidationErrorCopier.copy(validationErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationErrors(ValidationError... validationErrors) {
            validationErrors(Arrays.asList(validationErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationErrors(Consumer<ValidationError.Builder>... validationErrors) {
            validationErrors(Stream.of(validationErrors).map(c -> ValidationError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public UnprocessableEntityException build() {
            return new UnprocessableEntityException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
