/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Smooth Group Sparse Track Type
 */
@Generated("software.amazon.awssdk:codegen")
public enum SmoothGroupSparseTrackType {
    NONE("NONE"),

    SCTE_35("SCTE_35"),

    SCTE_35_WITHOUT_SEGMENTATION("SCTE_35_WITHOUT_SEGMENTATION"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SmoothGroupSparseTrackType> VALUE_MAP = EnumUtils.uniqueIndex(
            SmoothGroupSparseTrackType.class, SmoothGroupSparseTrackType::toString);

    private final String value;

    private SmoothGroupSparseTrackType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return SmoothGroupSparseTrackType corresponding to the value
     */
    public static SmoothGroupSparseTrackType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link SmoothGroupSparseTrackType}s
     */
    public static Set<SmoothGroupSparseTrackType> knownValues() {
        Set<SmoothGroupSparseTrackType> knownValues = EnumSet.allOf(SmoothGroupSparseTrackType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
