/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveAsyncClient;
import software.amazon.awssdk.services.medialive.model.DescribeScheduleRequest;
import software.amazon.awssdk.services.medialive.model.DescribeScheduleResponse;
import software.amazon.awssdk.services.medialive.model.ScheduleAction;

public class DescribeSchedulePublisher
implements SdkPublisher<DescribeScheduleResponse> {
    private final MediaLiveAsyncClient client;
    private final DescribeScheduleRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeSchedulePublisher(MediaLiveAsyncClient client, DescribeScheduleRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeSchedulePublisher(MediaLiveAsyncClient client, DescribeScheduleRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeScheduleResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeScheduleResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ScheduleAction> scheduleActions() {
        Function<DescribeScheduleResponse, Iterator> getIterator = response -> {
            if (response != null && response.scheduleActions() != null) {
                return response.scheduleActions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeScheduleResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeScheduleResponseFetcher
    implements AsyncPageFetcher<DescribeScheduleResponse> {
        private DescribeScheduleResponseFetcher() {
        }

        public boolean hasNextPage(DescribeScheduleResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeScheduleResponse> nextPage(DescribeScheduleResponse previousPage) {
            if (previousPage == null) {
                return DescribeSchedulePublisher.this.client.describeSchedule(DescribeSchedulePublisher.this.firstRequest);
            }
            return DescribeSchedulePublisher.this.client.describeSchedule((DescribeScheduleRequest)((Object)DescribeSchedulePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

