/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings to let you create a clip of the file input, in order to set up the input to ingest only a portion of the
 * file.
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputClippingSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<InputClippingSettings.Builder, InputClippingSettings> {
    private static final SdkField<String> INPUT_TIMECODE_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputTimecodeSource").getter(getter(InputClippingSettings::inputTimecodeSourceAsString))
            .setter(setter(Builder::inputTimecodeSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputTimecodeSource").build())
            .build();

    private static final SdkField<StartTimecode> START_TIMECODE_FIELD = SdkField
            .<StartTimecode> builder(MarshallingType.SDK_POJO).memberName("StartTimecode")
            .getter(getter(InputClippingSettings::startTimecode)).setter(setter(Builder::startTimecode))
            .constructor(StartTimecode::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimecode").build()).build();

    private static final SdkField<StopTimecode> STOP_TIMECODE_FIELD = SdkField.<StopTimecode> builder(MarshallingType.SDK_POJO)
            .memberName("StopTimecode").getter(getter(InputClippingSettings::stopTimecode)).setter(setter(Builder::stopTimecode))
            .constructor(StopTimecode::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopTimecode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_TIMECODE_SOURCE_FIELD,
            START_TIMECODE_FIELD, STOP_TIMECODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String inputTimecodeSource;

    private final StartTimecode startTimecode;

    private final StopTimecode stopTimecode;

    private InputClippingSettings(BuilderImpl builder) {
        this.inputTimecodeSource = builder.inputTimecodeSource;
        this.startTimecode = builder.startTimecode;
        this.stopTimecode = builder.stopTimecode;
    }

    /**
     * The source of the timecodes in the source being clipped.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #inputTimecodeSource} will return {@link InputTimecodeSource#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #inputTimecodeSourceAsString}.
     * </p>
     * 
     * @return The source of the timecodes in the source being clipped.
     * @see InputTimecodeSource
     */
    public final InputTimecodeSource inputTimecodeSource() {
        return InputTimecodeSource.fromValue(inputTimecodeSource);
    }

    /**
     * The source of the timecodes in the source being clipped.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #inputTimecodeSource} will return {@link InputTimecodeSource#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #inputTimecodeSourceAsString}.
     * </p>
     * 
     * @return The source of the timecodes in the source being clipped.
     * @see InputTimecodeSource
     */
    public final String inputTimecodeSourceAsString() {
        return inputTimecodeSource;
    }

    /**
     * Settings to identify the start of the clip.
     * 
     * @return Settings to identify the start of the clip.
     */
    public final StartTimecode startTimecode() {
        return startTimecode;
    }

    /**
     * Settings to identify the end of the clip.
     * 
     * @return Settings to identify the end of the clip.
     */
    public final StopTimecode stopTimecode() {
        return stopTimecode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputTimecodeSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTimecode());
        hashCode = 31 * hashCode + Objects.hashCode(stopTimecode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputClippingSettings)) {
            return false;
        }
        InputClippingSettings other = (InputClippingSettings) obj;
        return Objects.equals(inputTimecodeSourceAsString(), other.inputTimecodeSourceAsString())
                && Objects.equals(startTimecode(), other.startTimecode()) && Objects.equals(stopTimecode(), other.stopTimecode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputClippingSettings").add("InputTimecodeSource", inputTimecodeSourceAsString())
                .add("StartTimecode", startTimecode()).add("StopTimecode", stopTimecode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputTimecodeSource":
            return Optional.ofNullable(clazz.cast(inputTimecodeSourceAsString()));
        case "StartTimecode":
            return Optional.ofNullable(clazz.cast(startTimecode()));
        case "StopTimecode":
            return Optional.ofNullable(clazz.cast(stopTimecode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputClippingSettings, T> g) {
        return obj -> g.apply((InputClippingSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputClippingSettings> {
        /**
         * The source of the timecodes in the source being clipped.
         * 
         * @param inputTimecodeSource
         *        The source of the timecodes in the source being clipped.
         * @see InputTimecodeSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputTimecodeSource
         */
        Builder inputTimecodeSource(String inputTimecodeSource);

        /**
         * The source of the timecodes in the source being clipped.
         * 
         * @param inputTimecodeSource
         *        The source of the timecodes in the source being clipped.
         * @see InputTimecodeSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputTimecodeSource
         */
        Builder inputTimecodeSource(InputTimecodeSource inputTimecodeSource);

        /**
         * Settings to identify the start of the clip.
         * 
         * @param startTimecode
         *        Settings to identify the start of the clip.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimecode(StartTimecode startTimecode);

        /**
         * Settings to identify the start of the clip. This is a convenience method that creates an instance of the
         * {@link StartTimecode.Builder} avoiding the need to create one manually via {@link StartTimecode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StartTimecode.Builder#build()} is called immediately and its
         * result is passed to {@link #startTimecode(StartTimecode)}.
         * 
         * @param startTimecode
         *        a consumer that will call methods on {@link StartTimecode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startTimecode(StartTimecode)
         */
        default Builder startTimecode(Consumer<StartTimecode.Builder> startTimecode) {
            return startTimecode(StartTimecode.builder().applyMutation(startTimecode).build());
        }

        /**
         * Settings to identify the end of the clip.
         * 
         * @param stopTimecode
         *        Settings to identify the end of the clip.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopTimecode(StopTimecode stopTimecode);

        /**
         * Settings to identify the end of the clip. This is a convenience method that creates an instance of the
         * {@link StopTimecode.Builder} avoiding the need to create one manually via {@link StopTimecode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StopTimecode.Builder#build()} is called immediately and its
         * result is passed to {@link #stopTimecode(StopTimecode)}.
         * 
         * @param stopTimecode
         *        a consumer that will call methods on {@link StopTimecode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stopTimecode(StopTimecode)
         */
        default Builder stopTimecode(Consumer<StopTimecode.Builder> stopTimecode) {
            return stopTimecode(StopTimecode.builder().applyMutation(stopTimecode).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String inputTimecodeSource;

        private StartTimecode startTimecode;

        private StopTimecode stopTimecode;

        private BuilderImpl() {
        }

        private BuilderImpl(InputClippingSettings model) {
            inputTimecodeSource(model.inputTimecodeSource);
            startTimecode(model.startTimecode);
            stopTimecode(model.stopTimecode);
        }

        public final String getInputTimecodeSource() {
            return inputTimecodeSource;
        }

        public final void setInputTimecodeSource(String inputTimecodeSource) {
            this.inputTimecodeSource = inputTimecodeSource;
        }

        @Override
        public final Builder inputTimecodeSource(String inputTimecodeSource) {
            this.inputTimecodeSource = inputTimecodeSource;
            return this;
        }

        @Override
        public final Builder inputTimecodeSource(InputTimecodeSource inputTimecodeSource) {
            this.inputTimecodeSource(inputTimecodeSource == null ? null : inputTimecodeSource.toString());
            return this;
        }

        public final StartTimecode.Builder getStartTimecode() {
            return startTimecode != null ? startTimecode.toBuilder() : null;
        }

        public final void setStartTimecode(StartTimecode.BuilderImpl startTimecode) {
            this.startTimecode = startTimecode != null ? startTimecode.build() : null;
        }

        @Override
        public final Builder startTimecode(StartTimecode startTimecode) {
            this.startTimecode = startTimecode;
            return this;
        }

        public final StopTimecode.Builder getStopTimecode() {
            return stopTimecode != null ? stopTimecode.toBuilder() : null;
        }

        public final void setStopTimecode(StopTimecode.BuilderImpl stopTimecode) {
            this.stopTimecode = stopTimecode != null ? stopTimecode.build() : null;
        }

        @Override
        public final Builder stopTimecode(StopTimecode stopTimecode) {
            this.stopTimecode = stopTimecode;
            return this;
        }

        @Override
        public InputClippingSettings build() {
            return new InputClippingSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
