/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Timecode Burnin Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimecodeBurninSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<TimecodeBurninSettings.Builder, TimecodeBurninSettings> {
    private static final SdkField<String> FONT_SIZE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FontSize").getter(getter(TimecodeBurninSettings::fontSizeAsString)).setter(setter(Builder::fontSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fontSize").build()).build();

    private static final SdkField<String> POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Position").getter(getter(TimecodeBurninSettings::positionAsString)).setter(setter(Builder::position))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("position").build()).build();

    private static final SdkField<String> PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Prefix")
            .getter(getter(TimecodeBurninSettings::prefix)).setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FONT_SIZE_FIELD,
            POSITION_FIELD, PREFIX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fontSize;

    private final String position;

    private final String prefix;

    private TimecodeBurninSettings(BuilderImpl builder) {
        this.fontSize = builder.fontSize;
        this.position = builder.position;
        this.prefix = builder.prefix;
    }

    /**
     * Choose a timecode burn-in font size
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fontSize} will
     * return {@link TimecodeBurninFontSize#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fontSizeAsString}.
     * </p>
     * 
     * @return Choose a timecode burn-in font size
     * @see TimecodeBurninFontSize
     */
    public final TimecodeBurninFontSize fontSize() {
        return TimecodeBurninFontSize.fromValue(fontSize);
    }

    /**
     * Choose a timecode burn-in font size
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fontSize} will
     * return {@link TimecodeBurninFontSize#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fontSizeAsString}.
     * </p>
     * 
     * @return Choose a timecode burn-in font size
     * @see TimecodeBurninFontSize
     */
    public final String fontSizeAsString() {
        return fontSize;
    }

    /**
     * Choose a timecode burn-in output position
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #position} will
     * return {@link TimecodeBurninPosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #positionAsString}.
     * </p>
     * 
     * @return Choose a timecode burn-in output position
     * @see TimecodeBurninPosition
     */
    public final TimecodeBurninPosition position() {
        return TimecodeBurninPosition.fromValue(position);
    }

    /**
     * Choose a timecode burn-in output position
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #position} will
     * return {@link TimecodeBurninPosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #positionAsString}.
     * </p>
     * 
     * @return Choose a timecode burn-in output position
     * @see TimecodeBurninPosition
     */
    public final String positionAsString() {
        return position;
    }

    /**
     * Create a timecode burn-in prefix (optional)
     * 
     * @return Create a timecode burn-in prefix (optional)
     */
    public final String prefix() {
        return prefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fontSizeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(positionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimecodeBurninSettings)) {
            return false;
        }
        TimecodeBurninSettings other = (TimecodeBurninSettings) obj;
        return Objects.equals(fontSizeAsString(), other.fontSizeAsString())
                && Objects.equals(positionAsString(), other.positionAsString()) && Objects.equals(prefix(), other.prefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimecodeBurninSettings").add("FontSize", fontSizeAsString()).add("Position", positionAsString())
                .add("Prefix", prefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FontSize":
            return Optional.ofNullable(clazz.cast(fontSizeAsString()));
        case "Position":
            return Optional.ofNullable(clazz.cast(positionAsString()));
        case "Prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimecodeBurninSettings, T> g) {
        return obj -> g.apply((TimecodeBurninSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimecodeBurninSettings> {
        /**
         * Choose a timecode burn-in font size
         * 
         * @param fontSize
         *        Choose a timecode burn-in font size
         * @see TimecodeBurninFontSize
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimecodeBurninFontSize
         */
        Builder fontSize(String fontSize);

        /**
         * Choose a timecode burn-in font size
         * 
         * @param fontSize
         *        Choose a timecode burn-in font size
         * @see TimecodeBurninFontSize
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimecodeBurninFontSize
         */
        Builder fontSize(TimecodeBurninFontSize fontSize);

        /**
         * Choose a timecode burn-in output position
         * 
         * @param position
         *        Choose a timecode burn-in output position
         * @see TimecodeBurninPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimecodeBurninPosition
         */
        Builder position(String position);

        /**
         * Choose a timecode burn-in output position
         * 
         * @param position
         *        Choose a timecode burn-in output position
         * @see TimecodeBurninPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimecodeBurninPosition
         */
        Builder position(TimecodeBurninPosition position);

        /**
         * Create a timecode burn-in prefix (optional)
         * 
         * @param prefix
         *        Create a timecode burn-in prefix (optional)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);
    }

    static final class BuilderImpl implements Builder {
        private String fontSize;

        private String position;

        private String prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(TimecodeBurninSettings model) {
            fontSize(model.fontSize);
            position(model.position);
            prefix(model.prefix);
        }

        public final String getFontSize() {
            return fontSize;
        }

        public final void setFontSize(String fontSize) {
            this.fontSize = fontSize;
        }

        @Override
        public final Builder fontSize(String fontSize) {
            this.fontSize = fontSize;
            return this;
        }

        @Override
        public final Builder fontSize(TimecodeBurninFontSize fontSize) {
            this.fontSize(fontSize == null ? null : fontSize.toString());
            return this;
        }

        public final String getPosition() {
            return position;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        @Override
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        @Override
        public final Builder position(TimecodeBurninPosition position) {
            this.position(position == null ? null : position.toString());
            return this;
        }

        public final String getPrefix() {
            return prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        @Override
        public TimecodeBurninSettings build() {
            return new TimecodeBurninSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
