/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Information about the MediaConnect flow attached to the device.
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputDeviceMediaConnectSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<InputDeviceMediaConnectSettings.Builder, InputDeviceMediaConnectSettings> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowArn").getter(getter(InputDeviceMediaConnectSettings::flowArn)).setter(setter(Builder::flowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(InputDeviceMediaConnectSettings::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretArn").getter(getter(InputDeviceMediaConnectSettings::secretArn))
            .setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretArn").build()).build();

    private static final SdkField<String> SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceName").getter(getter(InputDeviceMediaConnectSettings::sourceName))
            .setter(setter(Builder::sourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ARN_FIELD,
            ROLE_ARN_FIELD, SECRET_ARN_FIELD, SOURCE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String flowArn;

    private final String roleArn;

    private final String secretArn;

    private final String sourceName;

    private InputDeviceMediaConnectSettings(BuilderImpl builder) {
        this.flowArn = builder.flowArn;
        this.roleArn = builder.roleArn;
        this.secretArn = builder.secretArn;
        this.sourceName = builder.sourceName;
    }

    /**
     * The ARN of the MediaConnect flow.
     * 
     * @return The ARN of the MediaConnect flow.
     */
    public final String flowArn() {
        return flowArn;
    }

    /**
     * The ARN for the role that MediaLive assumes to access the attached flow and secret.
     * 
     * @return The ARN for the role that MediaLive assumes to access the attached flow and secret.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * The ARN of the secret used to encrypt the stream.
     * 
     * @return The ARN of the secret used to encrypt the stream.
     */
    public final String secretArn() {
        return secretArn;
    }

    /**
     * The name of the MediaConnect flow source.
     * 
     * @return The name of the MediaConnect flow source.
     */
    public final String sourceName() {
        return sourceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDeviceMediaConnectSettings)) {
            return false;
        }
        InputDeviceMediaConnectSettings other = (InputDeviceMediaConnectSettings) obj;
        return Objects.equals(flowArn(), other.flowArn()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(secretArn(), other.secretArn()) && Objects.equals(sourceName(), other.sourceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputDeviceMediaConnectSettings").add("FlowArn", flowArn()).add("RoleArn", roleArn())
                .add("SecretArn", secretArn()).add("SourceName", sourceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlowArn":
            return Optional.ofNullable(clazz.cast(flowArn()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "SecretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        case "SourceName":
            return Optional.ofNullable(clazz.cast(sourceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputDeviceMediaConnectSettings, T> g) {
        return obj -> g.apply((InputDeviceMediaConnectSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputDeviceMediaConnectSettings> {
        /**
         * The ARN of the MediaConnect flow.
         * 
         * @param flowArn
         *        The ARN of the MediaConnect flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowArn(String flowArn);

        /**
         * The ARN for the role that MediaLive assumes to access the attached flow and secret.
         * 
         * @param roleArn
         *        The ARN for the role that MediaLive assumes to access the attached flow and secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * The ARN of the secret used to encrypt the stream.
         * 
         * @param secretArn
         *        The ARN of the secret used to encrypt the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);

        /**
         * The name of the MediaConnect flow source.
         * 
         * @param sourceName
         *        The name of the MediaConnect flow source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceName(String sourceName);
    }

    static final class BuilderImpl implements Builder {
        private String flowArn;

        private String roleArn;

        private String secretArn;

        private String sourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(InputDeviceMediaConnectSettings model) {
            flowArn(model.flowArn);
            roleArn(model.roleArn);
            secretArn(model.secretArn);
            sourceName(model.sourceName);
        }

        public final String getFlowArn() {
            return flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getSecretArn() {
            return secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final String getSourceName() {
            return sourceName;
        }

        public final void setSourceName(String sourceName) {
            this.sourceName = sourceName;
        }

        @Override
        public final Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        @Override
        public InputDeviceMediaConnectSettings build() {
            return new InputDeviceMediaConnectSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
