/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HlsCodecSpecification {
    RFC_4281("RFC_4281"),
    RFC_6381("RFC_6381"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HlsCodecSpecification> VALUE_MAP;
    private final String value;

    private HlsCodecSpecification(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HlsCodecSpecification fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HlsCodecSpecification> knownValues() {
        EnumSet<HlsCodecSpecification> knownValues = EnumSet.allOf(HlsCodecSpecification.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HlsCodecSpecification.class, HlsCodecSpecification::toString);
    }
}

