/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * One audio configuration that specifies the format for one audio pair that the device produces as output.
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputDeviceConfigurableAudioChannelPairConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<InputDeviceConfigurableAudioChannelPairConfig.Builder, InputDeviceConfigurableAudioChannelPairConfig> {
    private static final SdkField<Integer> ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Id")
            .getter(getter(InputDeviceConfigurableAudioChannelPairConfig::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> PROFILE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Profile")
            .getter(getter(InputDeviceConfigurableAudioChannelPairConfig::profileAsString)).setter(setter(Builder::profile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profile").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, PROFILE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer id;

    private final String profile;

    private InputDeviceConfigurableAudioChannelPairConfig(BuilderImpl builder) {
        this.id = builder.id;
        this.profile = builder.profile;
    }

    /**
     * The ID for one audio pair configuration, a value from 1 to 8.
     * 
     * @return The ID for one audio pair configuration, a value from 1 to 8.
     */
    public final Integer id() {
        return id;
    }

    /**
     * The profile to set for one audio pair configuration. Choose an enumeration value. Each value describes one audio
     * configuration using the format (rate control algorithm)-(codec)_(quality)-(bitrate in bytes). For example,
     * CBR-AAC_HQ-192000. Or choose DISABLED, in which case the device won't produce audio for this pair.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #profile} will
     * return {@link InputDeviceConfigurableAudioChannelPairProfile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #profileAsString}.
     * </p>
     * 
     * @return The profile to set for one audio pair configuration. Choose an enumeration value. Each value describes
     *         one audio configuration using the format (rate control algorithm)-(codec)_(quality)-(bitrate in bytes).
     *         For example, CBR-AAC_HQ-192000. Or choose DISABLED, in which case the device won't produce audio for this
     *         pair.
     * @see InputDeviceConfigurableAudioChannelPairProfile
     */
    public final InputDeviceConfigurableAudioChannelPairProfile profile() {
        return InputDeviceConfigurableAudioChannelPairProfile.fromValue(profile);
    }

    /**
     * The profile to set for one audio pair configuration. Choose an enumeration value. Each value describes one audio
     * configuration using the format (rate control algorithm)-(codec)_(quality)-(bitrate in bytes). For example,
     * CBR-AAC_HQ-192000. Or choose DISABLED, in which case the device won't produce audio for this pair.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #profile} will
     * return {@link InputDeviceConfigurableAudioChannelPairProfile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #profileAsString}.
     * </p>
     * 
     * @return The profile to set for one audio pair configuration. Choose an enumeration value. Each value describes
     *         one audio configuration using the format (rate control algorithm)-(codec)_(quality)-(bitrate in bytes).
     *         For example, CBR-AAC_HQ-192000. Or choose DISABLED, in which case the device won't produce audio for this
     *         pair.
     * @see InputDeviceConfigurableAudioChannelPairProfile
     */
    public final String profileAsString() {
        return profile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(profileAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDeviceConfigurableAudioChannelPairConfig)) {
            return false;
        }
        InputDeviceConfigurableAudioChannelPairConfig other = (InputDeviceConfigurableAudioChannelPairConfig) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(profileAsString(), other.profileAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputDeviceConfigurableAudioChannelPairConfig").add("Id", id())
                .add("Profile", profileAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Profile":
            return Optional.ofNullable(clazz.cast(profileAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputDeviceConfigurableAudioChannelPairConfig, T> g) {
        return obj -> g.apply((InputDeviceConfigurableAudioChannelPairConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputDeviceConfigurableAudioChannelPairConfig> {
        /**
         * The ID for one audio pair configuration, a value from 1 to 8.
         * 
         * @param id
         *        The ID for one audio pair configuration, a value from 1 to 8.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(Integer id);

        /**
         * The profile to set for one audio pair configuration. Choose an enumeration value. Each value describes one
         * audio configuration using the format (rate control algorithm)-(codec)_(quality)-(bitrate in bytes). For
         * example, CBR-AAC_HQ-192000. Or choose DISABLED, in which case the device won't produce audio for this pair.
         * 
         * @param profile
         *        The profile to set for one audio pair configuration. Choose an enumeration value. Each value describes
         *        one audio configuration using the format (rate control algorithm)-(codec)_(quality)-(bitrate in
         *        bytes). For example, CBR-AAC_HQ-192000. Or choose DISABLED, in which case the device won't produce
         *        audio for this pair.
         * @see InputDeviceConfigurableAudioChannelPairProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceConfigurableAudioChannelPairProfile
         */
        Builder profile(String profile);

        /**
         * The profile to set for one audio pair configuration. Choose an enumeration value. Each value describes one
         * audio configuration using the format (rate control algorithm)-(codec)_(quality)-(bitrate in bytes). For
         * example, CBR-AAC_HQ-192000. Or choose DISABLED, in which case the device won't produce audio for this pair.
         * 
         * @param profile
         *        The profile to set for one audio pair configuration. Choose an enumeration value. Each value describes
         *        one audio configuration using the format (rate control algorithm)-(codec)_(quality)-(bitrate in
         *        bytes). For example, CBR-AAC_HQ-192000. Or choose DISABLED, in which case the device won't produce
         *        audio for this pair.
         * @see InputDeviceConfigurableAudioChannelPairProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceConfigurableAudioChannelPairProfile
         */
        Builder profile(InputDeviceConfigurableAudioChannelPairProfile profile);
    }

    static final class BuilderImpl implements Builder {
        private Integer id;

        private String profile;

        private BuilderImpl() {
        }

        private BuilderImpl(InputDeviceConfigurableAudioChannelPairConfig model) {
            id(model.id);
            profile(model.profile);
        }

        public final Integer getId() {
            return id;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        @Override
        public final Builder id(Integer id) {
            this.id = id;
            return this;
        }

        public final String getProfile() {
            return profile;
        }

        public final void setProfile(String profile) {
            this.profile = profile;
        }

        @Override
        public final Builder profile(String profile) {
            this.profile = profile;
            return this;
        }

        @Override
        public final Builder profile(InputDeviceConfigurableAudioChannelPairProfile profile) {
            this.profile(profile == null ? null : profile.toString());
            return this;
        }

        @Override
        public InputDeviceConfigurableAudioChannelPairConfig build() {
            return new InputDeviceConfigurableAudioChannelPairConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
