/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A request to create a multiplex.
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMultiplexRequest extends MediaLiveRequest implements
        ToCopyableBuilder<CreateMultiplexRequest.Builder, CreateMultiplexRequest> {
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZones")
            .getter(getter(CreateMultiplexRequest::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<MultiplexSettings> MULTIPLEX_SETTINGS_FIELD = SdkField
            .<MultiplexSettings> builder(MarshallingType.SDK_POJO).memberName("MultiplexSettings")
            .getter(getter(CreateMultiplexRequest::multiplexSettings)).setter(setter(Builder::multiplexSettings))
            .constructor(MultiplexSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiplexSettings").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateMultiplexRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RequestId")
            .getter(getter(CreateMultiplexRequest::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateMultiplexRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONES_FIELD,
            MULTIPLEX_SETTINGS_FIELD, NAME_FIELD, REQUEST_ID_FIELD, TAGS_FIELD));

    private final List<String> availabilityZones;

    private final MultiplexSettings multiplexSettings;

    private final String name;

    private final String requestId;

    private final Map<String, String> tags;

    private CreateMultiplexRequest(BuilderImpl builder) {
        super(builder);
        this.availabilityZones = builder.availabilityZones;
        this.multiplexSettings = builder.multiplexSettings;
        this.name = builder.name;
        this.requestId = builder.requestId;
        this.tags = builder.tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailabilityZones property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * A list of availability zones for the multiplex. You must specify exactly two.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailabilityZones} method.
     * </p>
     * 
     * @return A list of availability zones for the multiplex. You must specify exactly two.
     */
    public final List<String> availabilityZones() {
        return availabilityZones;
    }

    /**
     * Configuration for a multiplex event.
     * 
     * @return Configuration for a multiplex event.
     */
    public final MultiplexSettings multiplexSettings() {
        return multiplexSettings;
    }

    /**
     * Name of multiplex.
     * 
     * @return Name of multiplex.
     */
    public final String name() {
        return name;
    }

    /**
     * Unique request ID. This prevents retries from creating multiple resources.
     * 
     * @return Unique request ID. This prevents retries from creating multiple resources.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * A collection of key-value pairs.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A collection of key-value pairs.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZones() ? availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(multiplexSettings());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMultiplexRequest)) {
            return false;
        }
        CreateMultiplexRequest other = (CreateMultiplexRequest) obj;
        return hasAvailabilityZones() == other.hasAvailabilityZones()
                && Objects.equals(availabilityZones(), other.availabilityZones())
                && Objects.equals(multiplexSettings(), other.multiplexSettings()) && Objects.equals(name(), other.name())
                && Objects.equals(requestId(), other.requestId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMultiplexRequest")
                .add("AvailabilityZones", hasAvailabilityZones() ? availabilityZones() : null)
                .add("MultiplexSettings", multiplexSettings()).add("Name", name()).add("RequestId", requestId())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "MultiplexSettings":
            return Optional.ofNullable(clazz.cast(multiplexSettings()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMultiplexRequest, T> g) {
        return obj -> g.apply((CreateMultiplexRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateMultiplexRequest> {
        /**
         * A list of availability zones for the multiplex. You must specify exactly two.
         * 
         * @param availabilityZones
         *        A list of availability zones for the multiplex. You must specify exactly two.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * A list of availability zones for the multiplex. You must specify exactly two.
         * 
         * @param availabilityZones
         *        A list of availability zones for the multiplex. You must specify exactly two.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);

        /**
         * Configuration for a multiplex event.
         * 
         * @param multiplexSettings
         *        Configuration for a multiplex event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiplexSettings(MultiplexSettings multiplexSettings);

        /**
         * Configuration for a multiplex event. This is a convenience method that creates an instance of the
         * {@link MultiplexSettings.Builder} avoiding the need to create one manually via
         * {@link MultiplexSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MultiplexSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #multiplexSettings(MultiplexSettings)}.
         * 
         * @param multiplexSettings
         *        a consumer that will call methods on {@link MultiplexSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multiplexSettings(MultiplexSettings)
         */
        default Builder multiplexSettings(Consumer<MultiplexSettings.Builder> multiplexSettings) {
            return multiplexSettings(MultiplexSettings.builder().applyMutation(multiplexSettings).build());
        }

        /**
         * Name of multiplex.
         * 
         * @param name
         *        Name of multiplex.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Unique request ID. This prevents retries from creating multiple resources.
         * 
         * @param requestId
         *        Unique request ID. This prevents retries from creating multiple resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * A collection of key-value pairs.
         * 
         * @param tags
         *        A collection of key-value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaLiveRequest.BuilderImpl implements Builder {
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private MultiplexSettings multiplexSettings;

        private String name;

        private String requestId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMultiplexRequest model) {
            super(model);
            availabilityZones(model.availabilityZones);
            multiplexSettings(model.multiplexSettings);
            name(model.name);
            requestId(model.requestId);
            tags(model.tags);
        }

        public final Collection<String> getAvailabilityZones() {
            if (availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = ___listOf__stringCopier.copy(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = ___listOf__stringCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final MultiplexSettings.Builder getMultiplexSettings() {
            return multiplexSettings != null ? multiplexSettings.toBuilder() : null;
        }

        public final void setMultiplexSettings(MultiplexSettings.BuilderImpl multiplexSettings) {
            this.multiplexSettings = multiplexSettings != null ? multiplexSettings.build() : null;
        }

        @Override
        public final Builder multiplexSettings(MultiplexSettings multiplexSettings) {
            this.multiplexSettings = multiplexSettings;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMultiplexRequest build() {
            return new CreateMultiplexRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
