/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for DescribeThumbnailsRequest
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeThumbnailsRequest extends MediaLiveRequest implements
        ToCopyableBuilder<DescribeThumbnailsRequest.Builder, DescribeThumbnailsRequest> {
    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelId").getter(getter(DescribeThumbnailsRequest::channelId)).setter(setter(Builder::channelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelId").build()).build();

    private static final SdkField<String> PIPELINE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineId").getter(getter(DescribeThumbnailsRequest::pipelineId)).setter(setter(Builder::pipelineId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("pipelineId").build()).build();

    private static final SdkField<String> THUMBNAIL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ThumbnailType").getter(getter(DescribeThumbnailsRequest::thumbnailType))
            .setter(setter(Builder::thumbnailType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("thumbnailType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ID_FIELD,
            PIPELINE_ID_FIELD, THUMBNAIL_TYPE_FIELD));

    private final String channelId;

    private final String pipelineId;

    private final String thumbnailType;

    private DescribeThumbnailsRequest(BuilderImpl builder) {
        super(builder);
        this.channelId = builder.channelId;
        this.pipelineId = builder.pipelineId;
        this.thumbnailType = builder.thumbnailType;
    }

    /**
     * Unique ID of the channel
     * 
     * @return Unique ID of the channel
     */
    public final String channelId() {
        return channelId;
    }

    /**
     * Pipeline ID ("0" or "1")
     * 
     * @return Pipeline ID ("0" or "1")
     */
    public final String pipelineId() {
        return pipelineId;
    }

    /**
     * thumbnail type
     * 
     * @return thumbnail type
     */
    public final String thumbnailType() {
        return thumbnailType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelId());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineId());
        hashCode = 31 * hashCode + Objects.hashCode(thumbnailType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeThumbnailsRequest)) {
            return false;
        }
        DescribeThumbnailsRequest other = (DescribeThumbnailsRequest) obj;
        return Objects.equals(channelId(), other.channelId()) && Objects.equals(pipelineId(), other.pipelineId())
                && Objects.equals(thumbnailType(), other.thumbnailType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeThumbnailsRequest").add("ChannelId", channelId()).add("PipelineId", pipelineId())
                .add("ThumbnailType", thumbnailType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelId":
            return Optional.ofNullable(clazz.cast(channelId()));
        case "PipelineId":
            return Optional.ofNullable(clazz.cast(pipelineId()));
        case "ThumbnailType":
            return Optional.ofNullable(clazz.cast(thumbnailType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeThumbnailsRequest, T> g) {
        return obj -> g.apply((DescribeThumbnailsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeThumbnailsRequest> {
        /**
         * Unique ID of the channel
         * 
         * @param channelId
         *        Unique ID of the channel
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelId(String channelId);

        /**
         * Pipeline ID ("0" or "1")
         * 
         * @param pipelineId
         *        Pipeline ID ("0" or "1")
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineId(String pipelineId);

        /**
         * thumbnail type
         * 
         * @param thumbnailType
         *        thumbnail type
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thumbnailType(String thumbnailType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaLiveRequest.BuilderImpl implements Builder {
        private String channelId;

        private String pipelineId;

        private String thumbnailType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeThumbnailsRequest model) {
            super(model);
            channelId(model.channelId);
            pipelineId(model.pipelineId);
            thumbnailType(model.thumbnailType);
        }

        public final String getChannelId() {
            return channelId;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final String getPipelineId() {
            return pipelineId;
        }

        public final void setPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        @Override
        public final Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public final String getThumbnailType() {
            return thumbnailType;
        }

        public final void setThumbnailType(String thumbnailType) {
            this.thumbnailType = thumbnailType;
        }

        @Override
        public final Builder thumbnailType(String thumbnailType) {
            this.thumbnailType = thumbnailType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeThumbnailsRequest build() {
            return new DescribeThumbnailsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
