/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.core.waiters.WaiterState;
import software.amazon.awssdk.services.medialive.MediaLiveClient;
import software.amazon.awssdk.services.medialive.model.DescribeChannelRequest;
import software.amazon.awssdk.services.medialive.model.DescribeChannelResponse;
import software.amazon.awssdk.services.medialive.model.DescribeInputRequest;
import software.amazon.awssdk.services.medialive.model.DescribeInputResponse;
import software.amazon.awssdk.services.medialive.model.DescribeMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.DescribeMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.services.medialive.waiters.MediaLiveWaiter;
import software.amazon.awssdk.services.medialive.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultMediaLiveWaiter
implements MediaLiveWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final MediaLiveClient client;
    private final AttributeMap managedResources;
    private final Waiter<DescribeChannelResponse> channelCreatedWaiter;
    private final Waiter<DescribeChannelResponse> channelRunningWaiter;
    private final Waiter<DescribeChannelResponse> channelStoppedWaiter;
    private final Waiter<DescribeChannelResponse> channelDeletedWaiter;
    private final Waiter<DescribeInputResponse> inputAttachedWaiter;
    private final Waiter<DescribeInputResponse> inputDetachedWaiter;
    private final Waiter<DescribeInputResponse> inputDeletedWaiter;
    private final Waiter<DescribeMultiplexResponse> multiplexCreatedWaiter;
    private final Waiter<DescribeMultiplexResponse> multiplexRunningWaiter;
    private final Waiter<DescribeMultiplexResponse> multiplexStoppedWaiter;
    private final Waiter<DescribeMultiplexResponse> multiplexDeletedWaiter;

    private DefaultMediaLiveWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (MediaLiveClient)MediaLiveClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.channelCreatedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeChannelResponse.class).acceptors(DefaultMediaLiveWaiter.channelCreatedWaiterAcceptors())).overrideConfiguration(DefaultMediaLiveWaiter.channelCreatedWaiterConfig(builder.overrideConfiguration))).build();
        this.channelRunningWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeChannelResponse.class).acceptors(DefaultMediaLiveWaiter.channelRunningWaiterAcceptors())).overrideConfiguration(DefaultMediaLiveWaiter.channelRunningWaiterConfig(builder.overrideConfiguration))).build();
        this.channelStoppedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeChannelResponse.class).acceptors(DefaultMediaLiveWaiter.channelStoppedWaiterAcceptors())).overrideConfiguration(DefaultMediaLiveWaiter.channelStoppedWaiterConfig(builder.overrideConfiguration))).build();
        this.channelDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeChannelResponse.class).acceptors(DefaultMediaLiveWaiter.channelDeletedWaiterAcceptors())).overrideConfiguration(DefaultMediaLiveWaiter.channelDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.inputAttachedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeInputResponse.class).acceptors(DefaultMediaLiveWaiter.inputAttachedWaiterAcceptors())).overrideConfiguration(DefaultMediaLiveWaiter.inputAttachedWaiterConfig(builder.overrideConfiguration))).build();
        this.inputDetachedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeInputResponse.class).acceptors(DefaultMediaLiveWaiter.inputDetachedWaiterAcceptors())).overrideConfiguration(DefaultMediaLiveWaiter.inputDetachedWaiterConfig(builder.overrideConfiguration))).build();
        this.inputDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeInputResponse.class).acceptors(DefaultMediaLiveWaiter.inputDeletedWaiterAcceptors())).overrideConfiguration(DefaultMediaLiveWaiter.inputDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.multiplexCreatedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeMultiplexResponse.class).acceptors(DefaultMediaLiveWaiter.multiplexCreatedWaiterAcceptors())).overrideConfiguration(DefaultMediaLiveWaiter.multiplexCreatedWaiterConfig(builder.overrideConfiguration))).build();
        this.multiplexRunningWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeMultiplexResponse.class).acceptors(DefaultMediaLiveWaiter.multiplexRunningWaiterAcceptors())).overrideConfiguration(DefaultMediaLiveWaiter.multiplexRunningWaiterConfig(builder.overrideConfiguration))).build();
        this.multiplexStoppedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeMultiplexResponse.class).acceptors(DefaultMediaLiveWaiter.multiplexStoppedWaiterAcceptors())).overrideConfiguration(DefaultMediaLiveWaiter.multiplexStoppedWaiterConfig(builder.overrideConfiguration))).build();
        this.multiplexDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeMultiplexResponse.class).acceptors(DefaultMediaLiveWaiter.multiplexDeletedWaiterAcceptors())).overrideConfiguration(DefaultMediaLiveWaiter.multiplexDeletedWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<DescribeChannelResponse> waitUntilChannelCreated(DescribeChannelRequest describeChannelRequest) {
        return this.channelCreatedWaiter.run(() -> this.client.describeChannel(this.applyWaitersUserAgent(describeChannelRequest)));
    }

    @Override
    public WaiterResponse<DescribeChannelResponse> waitUntilChannelCreated(DescribeChannelRequest describeChannelRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.channelCreatedWaiter.run(() -> this.client.describeChannel(this.applyWaitersUserAgent(describeChannelRequest)), DefaultMediaLiveWaiter.channelCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeChannelResponse> waitUntilChannelDeleted(DescribeChannelRequest describeChannelRequest) {
        return this.channelDeletedWaiter.run(() -> this.client.describeChannel(this.applyWaitersUserAgent(describeChannelRequest)));
    }

    @Override
    public WaiterResponse<DescribeChannelResponse> waitUntilChannelDeleted(DescribeChannelRequest describeChannelRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.channelDeletedWaiter.run(() -> this.client.describeChannel(this.applyWaitersUserAgent(describeChannelRequest)), DefaultMediaLiveWaiter.channelDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeChannelResponse> waitUntilChannelRunning(DescribeChannelRequest describeChannelRequest) {
        return this.channelRunningWaiter.run(() -> this.client.describeChannel(this.applyWaitersUserAgent(describeChannelRequest)));
    }

    @Override
    public WaiterResponse<DescribeChannelResponse> waitUntilChannelRunning(DescribeChannelRequest describeChannelRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.channelRunningWaiter.run(() -> this.client.describeChannel(this.applyWaitersUserAgent(describeChannelRequest)), DefaultMediaLiveWaiter.channelRunningWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeChannelResponse> waitUntilChannelStopped(DescribeChannelRequest describeChannelRequest) {
        return this.channelStoppedWaiter.run(() -> this.client.describeChannel(this.applyWaitersUserAgent(describeChannelRequest)));
    }

    @Override
    public WaiterResponse<DescribeChannelResponse> waitUntilChannelStopped(DescribeChannelRequest describeChannelRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.channelStoppedWaiter.run(() -> this.client.describeChannel(this.applyWaitersUserAgent(describeChannelRequest)), DefaultMediaLiveWaiter.channelStoppedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeInputResponse> waitUntilInputAttached(DescribeInputRequest describeInputRequest) {
        return this.inputAttachedWaiter.run(() -> this.client.describeInput(this.applyWaitersUserAgent(describeInputRequest)));
    }

    @Override
    public WaiterResponse<DescribeInputResponse> waitUntilInputAttached(DescribeInputRequest describeInputRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.inputAttachedWaiter.run(() -> this.client.describeInput(this.applyWaitersUserAgent(describeInputRequest)), DefaultMediaLiveWaiter.inputAttachedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeInputResponse> waitUntilInputDeleted(DescribeInputRequest describeInputRequest) {
        return this.inputDeletedWaiter.run(() -> this.client.describeInput(this.applyWaitersUserAgent(describeInputRequest)));
    }

    @Override
    public WaiterResponse<DescribeInputResponse> waitUntilInputDeleted(DescribeInputRequest describeInputRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.inputDeletedWaiter.run(() -> this.client.describeInput(this.applyWaitersUserAgent(describeInputRequest)), DefaultMediaLiveWaiter.inputDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeInputResponse> waitUntilInputDetached(DescribeInputRequest describeInputRequest) {
        return this.inputDetachedWaiter.run(() -> this.client.describeInput(this.applyWaitersUserAgent(describeInputRequest)));
    }

    @Override
    public WaiterResponse<DescribeInputResponse> waitUntilInputDetached(DescribeInputRequest describeInputRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.inputDetachedWaiter.run(() -> this.client.describeInput(this.applyWaitersUserAgent(describeInputRequest)), DefaultMediaLiveWaiter.inputDetachedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeMultiplexResponse> waitUntilMultiplexCreated(DescribeMultiplexRequest describeMultiplexRequest) {
        return this.multiplexCreatedWaiter.run(() -> this.client.describeMultiplex(this.applyWaitersUserAgent(describeMultiplexRequest)));
    }

    @Override
    public WaiterResponse<DescribeMultiplexResponse> waitUntilMultiplexCreated(DescribeMultiplexRequest describeMultiplexRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.multiplexCreatedWaiter.run(() -> this.client.describeMultiplex(this.applyWaitersUserAgent(describeMultiplexRequest)), DefaultMediaLiveWaiter.multiplexCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeMultiplexResponse> waitUntilMultiplexDeleted(DescribeMultiplexRequest describeMultiplexRequest) {
        return this.multiplexDeletedWaiter.run(() -> this.client.describeMultiplex(this.applyWaitersUserAgent(describeMultiplexRequest)));
    }

    @Override
    public WaiterResponse<DescribeMultiplexResponse> waitUntilMultiplexDeleted(DescribeMultiplexRequest describeMultiplexRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.multiplexDeletedWaiter.run(() -> this.client.describeMultiplex(this.applyWaitersUserAgent(describeMultiplexRequest)), DefaultMediaLiveWaiter.multiplexDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeMultiplexResponse> waitUntilMultiplexRunning(DescribeMultiplexRequest describeMultiplexRequest) {
        return this.multiplexRunningWaiter.run(() -> this.client.describeMultiplex(this.applyWaitersUserAgent(describeMultiplexRequest)));
    }

    @Override
    public WaiterResponse<DescribeMultiplexResponse> waitUntilMultiplexRunning(DescribeMultiplexRequest describeMultiplexRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.multiplexRunningWaiter.run(() -> this.client.describeMultiplex(this.applyWaitersUserAgent(describeMultiplexRequest)), DefaultMediaLiveWaiter.multiplexRunningWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeMultiplexResponse> waitUntilMultiplexStopped(DescribeMultiplexRequest describeMultiplexRequest) {
        return this.multiplexStoppedWaiter.run(() -> this.client.describeMultiplex(this.applyWaitersUserAgent(describeMultiplexRequest)));
    }

    @Override
    public WaiterResponse<DescribeMultiplexResponse> waitUntilMultiplexStopped(DescribeMultiplexRequest describeMultiplexRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.multiplexStoppedWaiter.run(() -> this.client.describeMultiplex(this.applyWaitersUserAgent(describeMultiplexRequest)), DefaultMediaLiveWaiter.multiplexStoppedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeChannelResponse>> channelCreatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeChannelResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeChannelResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "IDLE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "CREATING");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "CREATE_FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeChannelResponse>> channelRunningWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeChannelResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeChannelResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "RUNNING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "STARTING");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeChannelResponse>> channelStoppedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeChannelResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeChannelResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "IDLE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "STOPPING");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeChannelResponse>> channelDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeChannelResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeChannelResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "DELETED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "DELETING");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeInputResponse>> inputAttachedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeInputResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeInputResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "ATTACHED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "DETACHED");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeInputResponse>> inputDetachedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeInputResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeInputResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "DETACHED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "CREATING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "ATTACHED");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeInputResponse>> inputDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeInputResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeInputResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "DELETED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "DELETING");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeMultiplexResponse>> multiplexCreatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeMultiplexResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeMultiplexResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "IDLE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "CREATING");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "CREATE_FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeMultiplexResponse>> multiplexRunningWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeMultiplexResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeMultiplexResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "RUNNING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "STARTING");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeMultiplexResponse>> multiplexStoppedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeMultiplexResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeMultiplexResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "IDLE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "STOPPING");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeMultiplexResponse>> multiplexDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeMultiplexResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeMultiplexResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "DELETED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "DELETING");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration channelCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration channelRunningWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(120);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration channelStoppedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration channelDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(84);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration inputAttachedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration inputDetachedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(84);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration inputDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration multiplexCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration multiplexRunningWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(120);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration multiplexStoppedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(28);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration multiplexDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static MediaLiveWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends MediaLiveRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((MediaLiveRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements MediaLiveWaiter.Builder {
        private MediaLiveClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public MediaLiveWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public MediaLiveWaiter.Builder client(MediaLiveClient client) {
            this.client = client;
            return this;
        }

        @Override
        public MediaLiveWaiter build() {
            return new DefaultMediaLiveWaiter(this);
        }
    }
}

