/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.medialive.model.AcceptInputDeviceTransferRequest;
import software.amazon.awssdk.services.medialive.model.AcceptInputDeviceTransferResponse;
import software.amazon.awssdk.services.medialive.model.BatchDeleteRequest;
import software.amazon.awssdk.services.medialive.model.BatchDeleteResponse;
import software.amazon.awssdk.services.medialive.model.BatchStartRequest;
import software.amazon.awssdk.services.medialive.model.BatchStartResponse;
import software.amazon.awssdk.services.medialive.model.BatchStopRequest;
import software.amazon.awssdk.services.medialive.model.BatchStopResponse;
import software.amazon.awssdk.services.medialive.model.BatchUpdateScheduleRequest;
import software.amazon.awssdk.services.medialive.model.BatchUpdateScheduleResponse;
import software.amazon.awssdk.services.medialive.model.CancelInputDeviceTransferRequest;
import software.amazon.awssdk.services.medialive.model.CancelInputDeviceTransferResponse;
import software.amazon.awssdk.services.medialive.model.ClaimDeviceRequest;
import software.amazon.awssdk.services.medialive.model.ClaimDeviceResponse;
import software.amazon.awssdk.services.medialive.model.CreateChannelRequest;
import software.amazon.awssdk.services.medialive.model.CreateChannelResponse;
import software.amazon.awssdk.services.medialive.model.CreateCloudWatchAlarmTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.CreateCloudWatchAlarmTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.CreateCloudWatchAlarmTemplateRequest;
import software.amazon.awssdk.services.medialive.model.CreateCloudWatchAlarmTemplateResponse;
import software.amazon.awssdk.services.medialive.model.CreateEventBridgeRuleTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.CreateEventBridgeRuleTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.CreateEventBridgeRuleTemplateRequest;
import software.amazon.awssdk.services.medialive.model.CreateEventBridgeRuleTemplateResponse;
import software.amazon.awssdk.services.medialive.model.CreateInputRequest;
import software.amazon.awssdk.services.medialive.model.CreateInputResponse;
import software.amazon.awssdk.services.medialive.model.CreateInputSecurityGroupRequest;
import software.amazon.awssdk.services.medialive.model.CreateInputSecurityGroupResponse;
import software.amazon.awssdk.services.medialive.model.CreateMultiplexProgramRequest;
import software.amazon.awssdk.services.medialive.model.CreateMultiplexProgramResponse;
import software.amazon.awssdk.services.medialive.model.CreateMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.CreateMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.CreatePartnerInputRequest;
import software.amazon.awssdk.services.medialive.model.CreatePartnerInputResponse;
import software.amazon.awssdk.services.medialive.model.CreateSignalMapRequest;
import software.amazon.awssdk.services.medialive.model.CreateSignalMapResponse;
import software.amazon.awssdk.services.medialive.model.CreateTagsRequest;
import software.amazon.awssdk.services.medialive.model.CreateTagsResponse;
import software.amazon.awssdk.services.medialive.model.DeleteChannelRequest;
import software.amazon.awssdk.services.medialive.model.DeleteChannelResponse;
import software.amazon.awssdk.services.medialive.model.DeleteCloudWatchAlarmTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.DeleteCloudWatchAlarmTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.DeleteCloudWatchAlarmTemplateRequest;
import software.amazon.awssdk.services.medialive.model.DeleteCloudWatchAlarmTemplateResponse;
import software.amazon.awssdk.services.medialive.model.DeleteEventBridgeRuleTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.DeleteEventBridgeRuleTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.DeleteEventBridgeRuleTemplateRequest;
import software.amazon.awssdk.services.medialive.model.DeleteEventBridgeRuleTemplateResponse;
import software.amazon.awssdk.services.medialive.model.DeleteInputRequest;
import software.amazon.awssdk.services.medialive.model.DeleteInputResponse;
import software.amazon.awssdk.services.medialive.model.DeleteInputSecurityGroupRequest;
import software.amazon.awssdk.services.medialive.model.DeleteInputSecurityGroupResponse;
import software.amazon.awssdk.services.medialive.model.DeleteMultiplexProgramRequest;
import software.amazon.awssdk.services.medialive.model.DeleteMultiplexProgramResponse;
import software.amazon.awssdk.services.medialive.model.DeleteMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.DeleteMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.DeleteReservationRequest;
import software.amazon.awssdk.services.medialive.model.DeleteReservationResponse;
import software.amazon.awssdk.services.medialive.model.DeleteScheduleRequest;
import software.amazon.awssdk.services.medialive.model.DeleteScheduleResponse;
import software.amazon.awssdk.services.medialive.model.DeleteSignalMapRequest;
import software.amazon.awssdk.services.medialive.model.DeleteSignalMapResponse;
import software.amazon.awssdk.services.medialive.model.DeleteTagsRequest;
import software.amazon.awssdk.services.medialive.model.DeleteTagsResponse;
import software.amazon.awssdk.services.medialive.model.DescribeAccountConfigurationRequest;
import software.amazon.awssdk.services.medialive.model.DescribeAccountConfigurationResponse;
import software.amazon.awssdk.services.medialive.model.DescribeChannelRequest;
import software.amazon.awssdk.services.medialive.model.DescribeChannelResponse;
import software.amazon.awssdk.services.medialive.model.DescribeInputDeviceRequest;
import software.amazon.awssdk.services.medialive.model.DescribeInputDeviceResponse;
import software.amazon.awssdk.services.medialive.model.DescribeInputDeviceThumbnailRequest;
import software.amazon.awssdk.services.medialive.model.DescribeInputDeviceThumbnailResponse;
import software.amazon.awssdk.services.medialive.model.DescribeInputRequest;
import software.amazon.awssdk.services.medialive.model.DescribeInputResponse;
import software.amazon.awssdk.services.medialive.model.DescribeInputSecurityGroupRequest;
import software.amazon.awssdk.services.medialive.model.DescribeInputSecurityGroupResponse;
import software.amazon.awssdk.services.medialive.model.DescribeMultiplexProgramRequest;
import software.amazon.awssdk.services.medialive.model.DescribeMultiplexProgramResponse;
import software.amazon.awssdk.services.medialive.model.DescribeMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.DescribeMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.DescribeOfferingRequest;
import software.amazon.awssdk.services.medialive.model.DescribeOfferingResponse;
import software.amazon.awssdk.services.medialive.model.DescribeReservationRequest;
import software.amazon.awssdk.services.medialive.model.DescribeReservationResponse;
import software.amazon.awssdk.services.medialive.model.DescribeScheduleRequest;
import software.amazon.awssdk.services.medialive.model.DescribeScheduleResponse;
import software.amazon.awssdk.services.medialive.model.DescribeThumbnailsRequest;
import software.amazon.awssdk.services.medialive.model.DescribeThumbnailsResponse;
import software.amazon.awssdk.services.medialive.model.GetCloudWatchAlarmTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.GetCloudWatchAlarmTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.GetCloudWatchAlarmTemplateRequest;
import software.amazon.awssdk.services.medialive.model.GetCloudWatchAlarmTemplateResponse;
import software.amazon.awssdk.services.medialive.model.GetEventBridgeRuleTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.GetEventBridgeRuleTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.GetEventBridgeRuleTemplateRequest;
import software.amazon.awssdk.services.medialive.model.GetEventBridgeRuleTemplateResponse;
import software.amazon.awssdk.services.medialive.model.GetSignalMapRequest;
import software.amazon.awssdk.services.medialive.model.GetSignalMapResponse;
import software.amazon.awssdk.services.medialive.model.ListChannelsRequest;
import software.amazon.awssdk.services.medialive.model.ListChannelsResponse;
import software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplateGroupsRequest;
import software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplateGroupsResponse;
import software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplatesRequest;
import software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplatesResponse;
import software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplateGroupsRequest;
import software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplateGroupsResponse;
import software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplatesRequest;
import software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplatesResponse;
import software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersRequest;
import software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersResponse;
import software.amazon.awssdk.services.medialive.model.ListInputDevicesRequest;
import software.amazon.awssdk.services.medialive.model.ListInputDevicesResponse;
import software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest;
import software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsResponse;
import software.amazon.awssdk.services.medialive.model.ListInputsRequest;
import software.amazon.awssdk.services.medialive.model.ListInputsResponse;
import software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsRequest;
import software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsResponse;
import software.amazon.awssdk.services.medialive.model.ListMultiplexesRequest;
import software.amazon.awssdk.services.medialive.model.ListMultiplexesResponse;
import software.amazon.awssdk.services.medialive.model.ListOfferingsRequest;
import software.amazon.awssdk.services.medialive.model.ListOfferingsResponse;
import software.amazon.awssdk.services.medialive.model.ListReservationsRequest;
import software.amazon.awssdk.services.medialive.model.ListReservationsResponse;
import software.amazon.awssdk.services.medialive.model.ListSignalMapsRequest;
import software.amazon.awssdk.services.medialive.model.ListSignalMapsResponse;
import software.amazon.awssdk.services.medialive.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.medialive.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.medialive.model.PurchaseOfferingRequest;
import software.amazon.awssdk.services.medialive.model.PurchaseOfferingResponse;
import software.amazon.awssdk.services.medialive.model.RebootInputDeviceRequest;
import software.amazon.awssdk.services.medialive.model.RebootInputDeviceResponse;
import software.amazon.awssdk.services.medialive.model.RejectInputDeviceTransferRequest;
import software.amazon.awssdk.services.medialive.model.RejectInputDeviceTransferResponse;
import software.amazon.awssdk.services.medialive.model.RestartChannelPipelinesRequest;
import software.amazon.awssdk.services.medialive.model.RestartChannelPipelinesResponse;
import software.amazon.awssdk.services.medialive.model.StartChannelRequest;
import software.amazon.awssdk.services.medialive.model.StartChannelResponse;
import software.amazon.awssdk.services.medialive.model.StartDeleteMonitorDeploymentRequest;
import software.amazon.awssdk.services.medialive.model.StartDeleteMonitorDeploymentResponse;
import software.amazon.awssdk.services.medialive.model.StartInputDeviceMaintenanceWindowRequest;
import software.amazon.awssdk.services.medialive.model.StartInputDeviceMaintenanceWindowResponse;
import software.amazon.awssdk.services.medialive.model.StartInputDeviceRequest;
import software.amazon.awssdk.services.medialive.model.StartInputDeviceResponse;
import software.amazon.awssdk.services.medialive.model.StartMonitorDeploymentRequest;
import software.amazon.awssdk.services.medialive.model.StartMonitorDeploymentResponse;
import software.amazon.awssdk.services.medialive.model.StartMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.StartMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.StartUpdateSignalMapRequest;
import software.amazon.awssdk.services.medialive.model.StartUpdateSignalMapResponse;
import software.amazon.awssdk.services.medialive.model.StopChannelRequest;
import software.amazon.awssdk.services.medialive.model.StopChannelResponse;
import software.amazon.awssdk.services.medialive.model.StopInputDeviceRequest;
import software.amazon.awssdk.services.medialive.model.StopInputDeviceResponse;
import software.amazon.awssdk.services.medialive.model.StopMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.StopMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.TransferInputDeviceRequest;
import software.amazon.awssdk.services.medialive.model.TransferInputDeviceResponse;
import software.amazon.awssdk.services.medialive.model.UpdateAccountConfigurationRequest;
import software.amazon.awssdk.services.medialive.model.UpdateAccountConfigurationResponse;
import software.amazon.awssdk.services.medialive.model.UpdateChannelClassRequest;
import software.amazon.awssdk.services.medialive.model.UpdateChannelClassResponse;
import software.amazon.awssdk.services.medialive.model.UpdateChannelRequest;
import software.amazon.awssdk.services.medialive.model.UpdateChannelResponse;
import software.amazon.awssdk.services.medialive.model.UpdateCloudWatchAlarmTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.UpdateCloudWatchAlarmTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.UpdateCloudWatchAlarmTemplateRequest;
import software.amazon.awssdk.services.medialive.model.UpdateCloudWatchAlarmTemplateResponse;
import software.amazon.awssdk.services.medialive.model.UpdateEventBridgeRuleTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.UpdateEventBridgeRuleTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.UpdateEventBridgeRuleTemplateRequest;
import software.amazon.awssdk.services.medialive.model.UpdateEventBridgeRuleTemplateResponse;
import software.amazon.awssdk.services.medialive.model.UpdateInputDeviceRequest;
import software.amazon.awssdk.services.medialive.model.UpdateInputDeviceResponse;
import software.amazon.awssdk.services.medialive.model.UpdateInputRequest;
import software.amazon.awssdk.services.medialive.model.UpdateInputResponse;
import software.amazon.awssdk.services.medialive.model.UpdateInputSecurityGroupRequest;
import software.amazon.awssdk.services.medialive.model.UpdateInputSecurityGroupResponse;
import software.amazon.awssdk.services.medialive.model.UpdateMultiplexProgramRequest;
import software.amazon.awssdk.services.medialive.model.UpdateMultiplexProgramResponse;
import software.amazon.awssdk.services.medialive.model.UpdateMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.UpdateMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.UpdateReservationRequest;
import software.amazon.awssdk.services.medialive.model.UpdateReservationResponse;
import software.amazon.awssdk.services.medialive.paginators.DescribeSchedulePublisher;
import software.amazon.awssdk.services.medialive.paginators.ListChannelsPublisher;
import software.amazon.awssdk.services.medialive.paginators.ListCloudWatchAlarmTemplateGroupsPublisher;
import software.amazon.awssdk.services.medialive.paginators.ListCloudWatchAlarmTemplatesPublisher;
import software.amazon.awssdk.services.medialive.paginators.ListEventBridgeRuleTemplateGroupsPublisher;
import software.amazon.awssdk.services.medialive.paginators.ListEventBridgeRuleTemplatesPublisher;
import software.amazon.awssdk.services.medialive.paginators.ListInputDeviceTransfersPublisher;
import software.amazon.awssdk.services.medialive.paginators.ListInputDevicesPublisher;
import software.amazon.awssdk.services.medialive.paginators.ListInputSecurityGroupsPublisher;
import software.amazon.awssdk.services.medialive.paginators.ListInputsPublisher;
import software.amazon.awssdk.services.medialive.paginators.ListMultiplexProgramsPublisher;
import software.amazon.awssdk.services.medialive.paginators.ListMultiplexesPublisher;
import software.amazon.awssdk.services.medialive.paginators.ListOfferingsPublisher;
import software.amazon.awssdk.services.medialive.paginators.ListReservationsPublisher;
import software.amazon.awssdk.services.medialive.paginators.ListSignalMapsPublisher;
import software.amazon.awssdk.services.medialive.waiters.MediaLiveAsyncWaiter;

/**
 * Service client for accessing MediaLive asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * API for AWS Elemental MediaLive
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface MediaLiveAsyncClient extends AwsClient {
    String SERVICE_NAME = "medialive";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "medialive";

    /**
     * Accept an incoming input device transfer. The ownership of the device will transfer to your AWS account.
     *
     * @param acceptInputDeviceTransferRequest
     *        Placeholder documentation for AcceptInputDeviceTransferRequest
     * @return A Java Future containing the result of the AcceptInputDeviceTransfer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException Transfer operation failed, input could not be validated.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to accept input device transfers.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException Input device not found.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on transfer device calls to the input device service.
     *         </li>
     *         <li>ConflictException Input device transfer could not be accepted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.AcceptInputDeviceTransfer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/AcceptInputDeviceTransfer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptInputDeviceTransferResponse> acceptInputDeviceTransfer(
            AcceptInputDeviceTransferRequest acceptInputDeviceTransferRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Accept an incoming input device transfer. The ownership of the device will transfer to your AWS account.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptInputDeviceTransferRequest.Builder} avoiding
     * the need to create one manually via {@link AcceptInputDeviceTransferRequest#builder()}
     * </p>
     *
     * @param acceptInputDeviceTransferRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.AcceptInputDeviceTransferRequest.Builder} to create
     *        a request. Placeholder documentation for AcceptInputDeviceTransferRequest
     * @return A Java Future containing the result of the AcceptInputDeviceTransfer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException Transfer operation failed, input could not be validated.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to accept input device transfers.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException Input device not found.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on transfer device calls to the input device service.
     *         </li>
     *         <li>ConflictException Input device transfer could not be accepted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.AcceptInputDeviceTransfer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/AcceptInputDeviceTransfer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptInputDeviceTransferResponse> acceptInputDeviceTransfer(
            Consumer<AcceptInputDeviceTransferRequest.Builder> acceptInputDeviceTransferRequest) {
        return acceptInputDeviceTransfer(AcceptInputDeviceTransferRequest.builder()
                .applyMutation(acceptInputDeviceTransferRequest).build());
    }

    /**
     * Starts delete of resources.
     *
     * @param batchDeleteRequest
     *        A request to delete resources
     * @return A Java Future containing the result of the BatchDelete operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to delete the resources.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The resources you're requesting to delete do not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Request limit exceeded on delete resources calls.</li>
     *         <li>ConflictException The resources are unable to delete.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.BatchDelete
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchDelete" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchDeleteResponse> batchDelete(BatchDeleteRequest batchDeleteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Starts delete of resources.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteRequest.Builder} avoiding the need to
     * create one manually via {@link BatchDeleteRequest#builder()}
     * </p>
     *
     * @param batchDeleteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.BatchDeleteRequest.Builder} to create a request. A
     *        request to delete resources
     * @return A Java Future containing the result of the BatchDelete operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to delete the resources.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The resources you're requesting to delete do not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Request limit exceeded on delete resources calls.</li>
     *         <li>ConflictException The resources are unable to delete.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.BatchDelete
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchDelete" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchDeleteResponse> batchDelete(Consumer<BatchDeleteRequest.Builder> batchDeleteRequest) {
        return batchDelete(BatchDeleteRequest.builder().applyMutation(batchDeleteRequest).build());
    }

    /**
     * Starts existing resources
     *
     * @param batchStartRequest
     *        A request to start resources
     * @return A Java Future containing the result of the BatchStart operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to start the resources.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The resources you're requesting to start do not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Request limit exceeded on start resources calls to resource service.</li>
     *         <li>ConflictException The resources are unable to start.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.BatchStart
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchStart" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchStartResponse> batchStart(BatchStartRequest batchStartRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Starts existing resources<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchStartRequest.Builder} avoiding the need to
     * create one manually via {@link BatchStartRequest#builder()}
     * </p>
     *
     * @param batchStartRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.BatchStartRequest.Builder} to create a request. A
     *        request to start resources
     * @return A Java Future containing the result of the BatchStart operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to start the resources.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The resources you're requesting to start do not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Request limit exceeded on start resources calls to resource service.</li>
     *         <li>ConflictException The resources are unable to start.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.BatchStart
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchStart" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchStartResponse> batchStart(Consumer<BatchStartRequest.Builder> batchStartRequest) {
        return batchStart(BatchStartRequest.builder().applyMutation(batchStartRequest).build());
    }

    /**
     * Stops running resources
     *
     * @param batchStopRequest
     *        A request to stop resources
     * @return A Java Future containing the result of the BatchStop operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to stop the resources.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The resources you're requesting to stop do not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Request limit exceeded on stop resources.</li>
     *         <li>ConflictException The resources are unable to stop.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.BatchStop
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchStop" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchStopResponse> batchStop(BatchStopRequest batchStopRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Stops running resources<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchStopRequest.Builder} avoiding the need to
     * create one manually via {@link BatchStopRequest#builder()}
     * </p>
     *
     * @param batchStopRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.BatchStopRequest.Builder} to create a request. A
     *        request to stop resources
     * @return A Java Future containing the result of the BatchStop operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to stop the resources.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The resources you're requesting to stop do not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Request limit exceeded on stop resources.</li>
     *         <li>ConflictException The resources are unable to stop.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.BatchStop
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchStop" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchStopResponse> batchStop(Consumer<BatchStopRequest.Builder> batchStopRequest) {
        return batchStop(BatchStopRequest.builder().applyMutation(batchStopRequest).build());
    }

    /**
     * Update a channel schedule
     *
     * @param batchUpdateScheduleRequest
     *        List of actions to create and list of actions to delete.
     * @return A Java Future containing the result of the BatchUpdateSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException The update schedule request failed validation.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to update the channel schedule.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The specified channel id does not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on update schedule calls.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.BatchUpdateSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchUpdateSchedule" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchUpdateScheduleResponse> batchUpdateSchedule(
            BatchUpdateScheduleRequest batchUpdateScheduleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Update a channel schedule<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUpdateScheduleRequest.Builder} avoiding the
     * need to create one manually via {@link BatchUpdateScheduleRequest#builder()}
     * </p>
     *
     * @param batchUpdateScheduleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.BatchUpdateScheduleRequest.Builder} to create a
     *        request. List of actions to create and list of actions to delete.
     * @return A Java Future containing the result of the BatchUpdateSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException The update schedule request failed validation.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to update the channel schedule.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The specified channel id does not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on update schedule calls.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.BatchUpdateSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchUpdateSchedule" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchUpdateScheduleResponse> batchUpdateSchedule(
            Consumer<BatchUpdateScheduleRequest.Builder> batchUpdateScheduleRequest) {
        return batchUpdateSchedule(BatchUpdateScheduleRequest.builder().applyMutation(batchUpdateScheduleRequest).build());
    }

    /**
     * Cancel an input device transfer that you have requested.
     *
     * @param cancelInputDeviceTransferRequest
     *        Placeholder documentation for CancelInputDeviceTransferRequest
     * @return A Java Future containing the result of the CancelInputDeviceTransfer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException Transfer operation failed, input could not be validated.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to cancel input device transfers.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException Input device not found.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on transfer device calls to the input device service.
     *         </li>
     *         <li>ConflictException Input device transfer could not be canceled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CancelInputDeviceTransfer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CancelInputDeviceTransfer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelInputDeviceTransferResponse> cancelInputDeviceTransfer(
            CancelInputDeviceTransferRequest cancelInputDeviceTransferRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Cancel an input device transfer that you have requested.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelInputDeviceTransferRequest.Builder} avoiding
     * the need to create one manually via {@link CancelInputDeviceTransferRequest#builder()}
     * </p>
     *
     * @param cancelInputDeviceTransferRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.CancelInputDeviceTransferRequest.Builder} to create
     *        a request. Placeholder documentation for CancelInputDeviceTransferRequest
     * @return A Java Future containing the result of the CancelInputDeviceTransfer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException Transfer operation failed, input could not be validated.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to cancel input device transfers.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException Input device not found.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on transfer device calls to the input device service.
     *         </li>
     *         <li>ConflictException Input device transfer could not be canceled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CancelInputDeviceTransfer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CancelInputDeviceTransfer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelInputDeviceTransferResponse> cancelInputDeviceTransfer(
            Consumer<CancelInputDeviceTransferRequest.Builder> cancelInputDeviceTransferRequest) {
        return cancelInputDeviceTransfer(CancelInputDeviceTransferRequest.builder()
                .applyMutation(cancelInputDeviceTransferRequest).build());
    }

    /**
     * Send a request to claim an AWS Elemental device that you have purchased from a third-party vendor. After the
     * request succeeds, you will own the device.
     *
     * @param claimDeviceRequest
     *        A request to claim an AWS Elemental device that you have purchased from a third-party vendor.
     * @return A Java Future containing the result of the ClaimDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException Claim operation failed, device id could not be validated.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You don't have the IAM access permissions to claim this device. You must have
     *         permission for the WriteClaim operation.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException Device not found or you called an unsupported region.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded. Your have sent this request too many times. There
     *         might be a bug in your API client.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ClaimDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ClaimDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ClaimDeviceResponse> claimDevice(ClaimDeviceRequest claimDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Send a request to claim an AWS Elemental device that you have purchased from a third-party vendor. After the
     * request succeeds, you will own the device.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ClaimDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link ClaimDeviceRequest#builder()}
     * </p>
     *
     * @param claimDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ClaimDeviceRequest.Builder} to create a request. A
     *        request to claim an AWS Elemental device that you have purchased from a third-party vendor.
     * @return A Java Future containing the result of the ClaimDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException Claim operation failed, device id could not be validated.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You don't have the IAM access permissions to claim this device. You must have
     *         permission for the WriteClaim operation.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException Device not found or you called an unsupported region.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded. Your have sent this request too many times. There
     *         might be a bug in your API client.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ClaimDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ClaimDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ClaimDeviceResponse> claimDevice(Consumer<ClaimDeviceRequest.Builder> claimDeviceRequest) {
        return claimDevice(ClaimDeviceRequest.builder().applyMutation(claimDeviceRequest).build());
    }

    /**
     * Creates a new channel
     *
     * @param createChannelRequest
     *        A request to create a channel
     * @return A Java Future containing the result of the CreateChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException The Channel failed validation and could not be created.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to create the channel.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on create channel calls to channel service.</li>
     *         <li>ConflictException The channel is unable to create due to an issue with channel resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateChannelResponse> createChannel(CreateChannelRequest createChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a new channel<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateChannelRequest.Builder} avoiding the need to
     * create one manually via {@link CreateChannelRequest#builder()}
     * </p>
     *
     * @param createChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.CreateChannelRequest.Builder} to create a request.
     *        A request to create a channel
     * @return A Java Future containing the result of the CreateChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException The Channel failed validation and could not be created.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to create the channel.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on create channel calls to channel service.</li>
     *         <li>ConflictException The channel is unable to create due to an issue with channel resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateChannelResponse> createChannel(Consumer<CreateChannelRequest.Builder> createChannelRequest) {
        return createChannel(CreateChannelRequest.builder().applyMutation(createChannelRequest).build());
    }

    /**
     * Creates a cloudwatch alarm template to dynamically generate cloudwatch metric alarms on targeted resource types.
     *
     * @param createCloudWatchAlarmTemplateRequest
     *        Placeholder documentation for CreateCloudWatchAlarmTemplateRequest
     * @return A Java Future containing the result of the CreateCloudWatchAlarmTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateCloudWatchAlarmTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateCloudWatchAlarmTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCloudWatchAlarmTemplateResponse> createCloudWatchAlarmTemplate(
            CreateCloudWatchAlarmTemplateRequest createCloudWatchAlarmTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a cloudwatch alarm template to dynamically generate cloudwatch metric alarms on targeted resource types.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCloudWatchAlarmTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link CreateCloudWatchAlarmTemplateRequest#builder()}
     * </p>
     *
     * @param createCloudWatchAlarmTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.CreateCloudWatchAlarmTemplateRequest.Builder} to
     *        create a request. Placeholder documentation for CreateCloudWatchAlarmTemplateRequest
     * @return A Java Future containing the result of the CreateCloudWatchAlarmTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateCloudWatchAlarmTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateCloudWatchAlarmTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCloudWatchAlarmTemplateResponse> createCloudWatchAlarmTemplate(
            Consumer<CreateCloudWatchAlarmTemplateRequest.Builder> createCloudWatchAlarmTemplateRequest) {
        return createCloudWatchAlarmTemplate(CreateCloudWatchAlarmTemplateRequest.builder()
                .applyMutation(createCloudWatchAlarmTemplateRequest).build());
    }

    /**
     * Creates a cloudwatch alarm template group to group your cloudwatch alarm templates and to attach to signal maps
     * for dynamically creating alarms.
     *
     * @param createCloudWatchAlarmTemplateGroupRequest
     *        Placeholder documentation for CreateCloudWatchAlarmTemplateGroupRequest
     * @return A Java Future containing the result of the CreateCloudWatchAlarmTemplateGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateCloudWatchAlarmTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateCloudWatchAlarmTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCloudWatchAlarmTemplateGroupResponse> createCloudWatchAlarmTemplateGroup(
            CreateCloudWatchAlarmTemplateGroupRequest createCloudWatchAlarmTemplateGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a cloudwatch alarm template group to group your cloudwatch alarm templates and to attach to signal maps
     * for dynamically creating alarms.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCloudWatchAlarmTemplateGroupRequest.Builder}
     * avoiding the need to create one manually via {@link CreateCloudWatchAlarmTemplateGroupRequest#builder()}
     * </p>
     *
     * @param createCloudWatchAlarmTemplateGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.CreateCloudWatchAlarmTemplateGroupRequest.Builder}
     *        to create a request. Placeholder documentation for CreateCloudWatchAlarmTemplateGroupRequest
     * @return A Java Future containing the result of the CreateCloudWatchAlarmTemplateGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateCloudWatchAlarmTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateCloudWatchAlarmTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCloudWatchAlarmTemplateGroupResponse> createCloudWatchAlarmTemplateGroup(
            Consumer<CreateCloudWatchAlarmTemplateGroupRequest.Builder> createCloudWatchAlarmTemplateGroupRequest) {
        return createCloudWatchAlarmTemplateGroup(CreateCloudWatchAlarmTemplateGroupRequest.builder()
                .applyMutation(createCloudWatchAlarmTemplateGroupRequest).build());
    }

    /**
     * Creates an eventbridge rule template to monitor events and send notifications to your targeted resources.
     *
     * @param createEventBridgeRuleTemplateRequest
     *        Placeholder documentation for CreateEventBridgeRuleTemplateRequest
     * @return A Java Future containing the result of the CreateEventBridgeRuleTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateEventBridgeRuleTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateEventBridgeRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEventBridgeRuleTemplateResponse> createEventBridgeRuleTemplate(
            CreateEventBridgeRuleTemplateRequest createEventBridgeRuleTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates an eventbridge rule template to monitor events and send notifications to your targeted resources.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEventBridgeRuleTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link CreateEventBridgeRuleTemplateRequest#builder()}
     * </p>
     *
     * @param createEventBridgeRuleTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.CreateEventBridgeRuleTemplateRequest.Builder} to
     *        create a request. Placeholder documentation for CreateEventBridgeRuleTemplateRequest
     * @return A Java Future containing the result of the CreateEventBridgeRuleTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateEventBridgeRuleTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateEventBridgeRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEventBridgeRuleTemplateResponse> createEventBridgeRuleTemplate(
            Consumer<CreateEventBridgeRuleTemplateRequest.Builder> createEventBridgeRuleTemplateRequest) {
        return createEventBridgeRuleTemplate(CreateEventBridgeRuleTemplateRequest.builder()
                .applyMutation(createEventBridgeRuleTemplateRequest).build());
    }

    /**
     * Creates an eventbridge rule template group to group your eventbridge rule templates and to attach to signal maps
     * for dynamically creating notification rules.
     *
     * @param createEventBridgeRuleTemplateGroupRequest
     *        Placeholder documentation for CreateEventBridgeRuleTemplateGroupRequest
     * @return A Java Future containing the result of the CreateEventBridgeRuleTemplateGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateEventBridgeRuleTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateEventBridgeRuleTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEventBridgeRuleTemplateGroupResponse> createEventBridgeRuleTemplateGroup(
            CreateEventBridgeRuleTemplateGroupRequest createEventBridgeRuleTemplateGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates an eventbridge rule template group to group your eventbridge rule templates and to attach to signal maps
     * for dynamically creating notification rules.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEventBridgeRuleTemplateGroupRequest.Builder}
     * avoiding the need to create one manually via {@link CreateEventBridgeRuleTemplateGroupRequest#builder()}
     * </p>
     *
     * @param createEventBridgeRuleTemplateGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.CreateEventBridgeRuleTemplateGroupRequest.Builder}
     *        to create a request. Placeholder documentation for CreateEventBridgeRuleTemplateGroupRequest
     * @return A Java Future containing the result of the CreateEventBridgeRuleTemplateGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateEventBridgeRuleTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateEventBridgeRuleTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEventBridgeRuleTemplateGroupResponse> createEventBridgeRuleTemplateGroup(
            Consumer<CreateEventBridgeRuleTemplateGroupRequest.Builder> createEventBridgeRuleTemplateGroupRequest) {
        return createEventBridgeRuleTemplateGroup(CreateEventBridgeRuleTemplateGroupRequest.builder()
                .applyMutation(createEventBridgeRuleTemplateGroupRequest).build());
    }

    /**
     * Create an input
     *
     * @param createInputRequest
     *        The name of the input
     * @return A Java Future containing the result of the CreateInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateInput" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateInputResponse> createInput(CreateInputRequest createInputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Create an input<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInputRequest.Builder} avoiding the need to
     * create one manually via {@link CreateInputRequest#builder()}
     * </p>
     *
     * @param createInputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.CreateInputRequest.Builder} to create a request.
     *        The name of the input
     * @return A Java Future containing the result of the CreateInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateInput" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateInputResponse> createInput(Consumer<CreateInputRequest.Builder> createInputRequest) {
        return createInput(CreateInputRequest.builder().applyMutation(createInputRequest).build());
    }

    /**
     * Creates a Input Security Group
     *
     * @param createInputSecurityGroupRequest
     *        The IPv4 CIDRs to whitelist for this Input Security Group
     * @return A Java Future containing the result of the CreateInputSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request to create an Input Security Group was Invalid</li>
     *         <li>InternalServerErrorException Internal Server Error</li>
     *         <li>ForbiddenException The requester does not have permission to create an Input Security Group</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Limit Exceeded Error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateInputSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateInputSecurityGroupResponse> createInputSecurityGroup(
            CreateInputSecurityGroupRequest createInputSecurityGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a Input Security Group<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInputSecurityGroupRequest.Builder} avoiding
     * the need to create one manually via {@link CreateInputSecurityGroupRequest#builder()}
     * </p>
     *
     * @param createInputSecurityGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.CreateInputSecurityGroupRequest.Builder} to create
     *        a request. The IPv4 CIDRs to whitelist for this Input Security Group
     * @return A Java Future containing the result of the CreateInputSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request to create an Input Security Group was Invalid</li>
     *         <li>InternalServerErrorException Internal Server Error</li>
     *         <li>ForbiddenException The requester does not have permission to create an Input Security Group</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Limit Exceeded Error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateInputSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateInputSecurityGroupResponse> createInputSecurityGroup(
            Consumer<CreateInputSecurityGroupRequest.Builder> createInputSecurityGroupRequest) {
        return createInputSecurityGroup(CreateInputSecurityGroupRequest.builder().applyMutation(createInputSecurityGroupRequest)
                .build());
    }

    /**
     * Create a new multiplex.
     *
     * @param createMultiplexRequest
     *        A request to create a multiplex.
     * @return A Java Future containing the result of the CreateMultiplex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>UnprocessableEntityException The Multiplex failed validation and could not be created.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You don't have permission to create the multiplex.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on create multiplex calls to multiplex service.</li>
     *         <li>ConflictException The multiplex is unable to create due to an issue with multiplex resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateMultiplex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateMultiplexResponse> createMultiplex(CreateMultiplexRequest createMultiplexRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a new multiplex.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMultiplexRequest.Builder} avoiding the need
     * to create one manually via {@link CreateMultiplexRequest#builder()}
     * </p>
     *
     * @param createMultiplexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.CreateMultiplexRequest.Builder} to create a
     *        request. A request to create a multiplex.
     * @return A Java Future containing the result of the CreateMultiplex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>UnprocessableEntityException The Multiplex failed validation and could not be created.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You don't have permission to create the multiplex.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on create multiplex calls to multiplex service.</li>
     *         <li>ConflictException The multiplex is unable to create due to an issue with multiplex resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateMultiplex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateMultiplexResponse> createMultiplex(
            Consumer<CreateMultiplexRequest.Builder> createMultiplexRequest) {
        return createMultiplex(CreateMultiplexRequest.builder().applyMutation(createMultiplexRequest).build());
    }

    /**
     * Create a new program in the multiplex.
     *
     * @param createMultiplexProgramRequest
     *        A request to create a program in a multiplex.
     * @return A Java Future containing the result of the CreateMultiplexProgram operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>UnprocessableEntityException The Multiplex program failed validation and could not be created.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to create a program.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on create multiplex program calls to multiplex
     *         service.</li>
     *         <li>ConflictException The multiplex program is unable to create due to an issue with multiplex resources.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateMultiplexProgram
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMultiplexProgramResponse> createMultiplexProgram(
            CreateMultiplexProgramRequest createMultiplexProgramRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a new program in the multiplex.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMultiplexProgramRequest.Builder} avoiding the
     * need to create one manually via {@link CreateMultiplexProgramRequest#builder()}
     * </p>
     *
     * @param createMultiplexProgramRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.CreateMultiplexProgramRequest.Builder} to create a
     *        request. A request to create a program in a multiplex.
     * @return A Java Future containing the result of the CreateMultiplexProgram operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>UnprocessableEntityException The Multiplex program failed validation and could not be created.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to create a program.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on create multiplex program calls to multiplex
     *         service.</li>
     *         <li>ConflictException The multiplex program is unable to create due to an issue with multiplex resources.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateMultiplexProgram
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMultiplexProgramResponse> createMultiplexProgram(
            Consumer<CreateMultiplexProgramRequest.Builder> createMultiplexProgramRequest) {
        return createMultiplexProgram(CreateMultiplexProgramRequest.builder().applyMutation(createMultiplexProgramRequest)
                .build());
    }

    /**
     * Create a partner input
     *
     * @param createPartnerInputRequest
     *        A request to create a partner input
     * @return A Java Future containing the result of the CreatePartnerInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreatePartnerInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreatePartnerInput" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreatePartnerInputResponse> createPartnerInput(CreatePartnerInputRequest createPartnerInputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a partner input<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePartnerInputRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePartnerInputRequest#builder()}
     * </p>
     *
     * @param createPartnerInputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.CreatePartnerInputRequest.Builder} to create a
     *        request. A request to create a partner input
     * @return A Java Future containing the result of the CreatePartnerInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreatePartnerInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreatePartnerInput" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreatePartnerInputResponse> createPartnerInput(
            Consumer<CreatePartnerInputRequest.Builder> createPartnerInputRequest) {
        return createPartnerInput(CreatePartnerInputRequest.builder().applyMutation(createPartnerInputRequest).build());
    }

    /**
     * Initiates the creation of a new signal map. Will discover a new mediaResourceMap based on the provided
     * discoveryEntryPointArn.
     *
     * @param createSignalMapRequest
     *        Placeholder documentation for CreateSignalMapRequest
     * @return A Java Future containing the result of the CreateSignalMap operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateSignalMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateSignalMap" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSignalMapResponse> createSignalMap(CreateSignalMapRequest createSignalMapRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Initiates the creation of a new signal map. Will discover a new mediaResourceMap based on the provided
     * discoveryEntryPointArn.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSignalMapRequest.Builder} avoiding the need
     * to create one manually via {@link CreateSignalMapRequest#builder()}
     * </p>
     *
     * @param createSignalMapRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.CreateSignalMapRequest.Builder} to create a
     *        request. Placeholder documentation for CreateSignalMapRequest
     * @return A Java Future containing the result of the CreateSignalMap operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateSignalMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateSignalMap" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSignalMapResponse> createSignalMap(
            Consumer<CreateSignalMapRequest.Builder> createSignalMapRequest) {
        return createSignalMap(CreateSignalMapRequest.builder().applyMutation(createSignalMapRequest).build());
    }

    /**
     * Create tags for a resource
     *
     * @param createTagsRequest
     *        Placeholder documentation for CreateTagsRequest
     * @return A Java Future containing the result of the CreateTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The arn was not found.</li>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTagsResponse> createTags(CreateTagsRequest createTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Create tags for a resource<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTagsRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTagsRequest#builder()}
     * </p>
     *
     * @param createTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.CreateTagsRequest.Builder} to create a request.
     *        Placeholder documentation for CreateTagsRequest
     * @return A Java Future containing the result of the CreateTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The arn was not found.</li>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTagsResponse> createTags(Consumer<CreateTagsRequest.Builder> createTagsRequest) {
        return createTags(CreateTagsRequest.builder().applyMutation(createTagsRequest).build());
    }

    /**
     * Starts deletion of channel. The associated outputs are also deleted.
     *
     * @param deleteChannelRequest
     *        Placeholder documentation for DeleteChannelRequest
     * @return A Java Future containing the result of the DeleteChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to delete the channel.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The channel you're requesting to delete does not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on delete channel calls to channel service.</li>
     *         <li>ConflictException The channel is unable to delete due to an issue with channel resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteChannelResponse> deleteChannel(DeleteChannelRequest deleteChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Starts deletion of channel. The associated outputs are also deleted.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteChannelRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteChannelRequest#builder()}
     * </p>
     *
     * @param deleteChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DeleteChannelRequest.Builder} to create a request.
     *        Placeholder documentation for DeleteChannelRequest
     * @return A Java Future containing the result of the DeleteChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to delete the channel.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The channel you're requesting to delete does not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on delete channel calls to channel service.</li>
     *         <li>ConflictException The channel is unable to delete due to an issue with channel resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteChannelResponse> deleteChannel(Consumer<DeleteChannelRequest.Builder> deleteChannelRequest) {
        return deleteChannel(DeleteChannelRequest.builder().applyMutation(deleteChannelRequest).build());
    }

    /**
     * Deletes a cloudwatch alarm template.
     *
     * @param deleteCloudWatchAlarmTemplateRequest
     *        Placeholder documentation for DeleteCloudWatchAlarmTemplateRequest
     * @return A Java Future containing the result of the DeleteCloudWatchAlarmTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteCloudWatchAlarmTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteCloudWatchAlarmTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCloudWatchAlarmTemplateResponse> deleteCloudWatchAlarmTemplate(
            DeleteCloudWatchAlarmTemplateRequest deleteCloudWatchAlarmTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes a cloudwatch alarm template.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCloudWatchAlarmTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteCloudWatchAlarmTemplateRequest#builder()}
     * </p>
     *
     * @param deleteCloudWatchAlarmTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DeleteCloudWatchAlarmTemplateRequest.Builder} to
     *        create a request. Placeholder documentation for DeleteCloudWatchAlarmTemplateRequest
     * @return A Java Future containing the result of the DeleteCloudWatchAlarmTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteCloudWatchAlarmTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteCloudWatchAlarmTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCloudWatchAlarmTemplateResponse> deleteCloudWatchAlarmTemplate(
            Consumer<DeleteCloudWatchAlarmTemplateRequest.Builder> deleteCloudWatchAlarmTemplateRequest) {
        return deleteCloudWatchAlarmTemplate(DeleteCloudWatchAlarmTemplateRequest.builder()
                .applyMutation(deleteCloudWatchAlarmTemplateRequest).build());
    }

    /**
     * Deletes a cloudwatch alarm template group. You must detach this group from all signal maps and ensure its
     * existing templates are moved to another group or deleted.
     *
     * @param deleteCloudWatchAlarmTemplateGroupRequest
     *        Placeholder documentation for DeleteCloudWatchAlarmTemplateGroupRequest
     * @return A Java Future containing the result of the DeleteCloudWatchAlarmTemplateGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteCloudWatchAlarmTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteCloudWatchAlarmTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCloudWatchAlarmTemplateGroupResponse> deleteCloudWatchAlarmTemplateGroup(
            DeleteCloudWatchAlarmTemplateGroupRequest deleteCloudWatchAlarmTemplateGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes a cloudwatch alarm template group. You must detach this group from all signal maps and ensure its
     * existing templates are moved to another group or deleted.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCloudWatchAlarmTemplateGroupRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteCloudWatchAlarmTemplateGroupRequest#builder()}
     * </p>
     *
     * @param deleteCloudWatchAlarmTemplateGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DeleteCloudWatchAlarmTemplateGroupRequest.Builder}
     *        to create a request. Placeholder documentation for DeleteCloudWatchAlarmTemplateGroupRequest
     * @return A Java Future containing the result of the DeleteCloudWatchAlarmTemplateGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteCloudWatchAlarmTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteCloudWatchAlarmTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCloudWatchAlarmTemplateGroupResponse> deleteCloudWatchAlarmTemplateGroup(
            Consumer<DeleteCloudWatchAlarmTemplateGroupRequest.Builder> deleteCloudWatchAlarmTemplateGroupRequest) {
        return deleteCloudWatchAlarmTemplateGroup(DeleteCloudWatchAlarmTemplateGroupRequest.builder()
                .applyMutation(deleteCloudWatchAlarmTemplateGroupRequest).build());
    }

    /**
     * Deletes an eventbridge rule template.
     *
     * @param deleteEventBridgeRuleTemplateRequest
     *        Placeholder documentation for DeleteEventBridgeRuleTemplateRequest
     * @return A Java Future containing the result of the DeleteEventBridgeRuleTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteEventBridgeRuleTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteEventBridgeRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEventBridgeRuleTemplateResponse> deleteEventBridgeRuleTemplate(
            DeleteEventBridgeRuleTemplateRequest deleteEventBridgeRuleTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes an eventbridge rule template.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventBridgeRuleTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteEventBridgeRuleTemplateRequest#builder()}
     * </p>
     *
     * @param deleteEventBridgeRuleTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DeleteEventBridgeRuleTemplateRequest.Builder} to
     *        create a request. Placeholder documentation for DeleteEventBridgeRuleTemplateRequest
     * @return A Java Future containing the result of the DeleteEventBridgeRuleTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteEventBridgeRuleTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteEventBridgeRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEventBridgeRuleTemplateResponse> deleteEventBridgeRuleTemplate(
            Consumer<DeleteEventBridgeRuleTemplateRequest.Builder> deleteEventBridgeRuleTemplateRequest) {
        return deleteEventBridgeRuleTemplate(DeleteEventBridgeRuleTemplateRequest.builder()
                .applyMutation(deleteEventBridgeRuleTemplateRequest).build());
    }

    /**
     * Deletes an eventbridge rule template group. You must detach this group from all signal maps and ensure its
     * existing templates are moved to another group or deleted.
     *
     * @param deleteEventBridgeRuleTemplateGroupRequest
     *        Placeholder documentation for DeleteEventBridgeRuleTemplateGroupRequest
     * @return A Java Future containing the result of the DeleteEventBridgeRuleTemplateGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteEventBridgeRuleTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteEventBridgeRuleTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEventBridgeRuleTemplateGroupResponse> deleteEventBridgeRuleTemplateGroup(
            DeleteEventBridgeRuleTemplateGroupRequest deleteEventBridgeRuleTemplateGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes an eventbridge rule template group. You must detach this group from all signal maps and ensure its
     * existing templates are moved to another group or deleted.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventBridgeRuleTemplateGroupRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteEventBridgeRuleTemplateGroupRequest#builder()}
     * </p>
     *
     * @param deleteEventBridgeRuleTemplateGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DeleteEventBridgeRuleTemplateGroupRequest.Builder}
     *        to create a request. Placeholder documentation for DeleteEventBridgeRuleTemplateGroupRequest
     * @return A Java Future containing the result of the DeleteEventBridgeRuleTemplateGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteEventBridgeRuleTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteEventBridgeRuleTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEventBridgeRuleTemplateGroupResponse> deleteEventBridgeRuleTemplateGroup(
            Consumer<DeleteEventBridgeRuleTemplateGroupRequest.Builder> deleteEventBridgeRuleTemplateGroupRequest) {
        return deleteEventBridgeRuleTemplateGroup(DeleteEventBridgeRuleTemplateGroupRequest.builder()
                .applyMutation(deleteEventBridgeRuleTemplateGroupRequest).build());
    }

    /**
     * Deletes the input end point
     *
     * @param deleteInputRequest
     *        Placeholder documentation for DeleteInputRequest
     * @return A Java Future containing the result of the DeleteInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException Input not found</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Limit exceeded</li>
     *         <li>ConflictException Resource conflict</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteInput" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteInputResponse> deleteInput(DeleteInputRequest deleteInputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes the input end point<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInputRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteInputRequest#builder()}
     * </p>
     *
     * @param deleteInputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DeleteInputRequest.Builder} to create a request.
     *        Placeholder documentation for DeleteInputRequest
     * @return A Java Future containing the result of the DeleteInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException Input not found</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Limit exceeded</li>
     *         <li>ConflictException Resource conflict</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteInput" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteInputResponse> deleteInput(Consumer<DeleteInputRequest.Builder> deleteInputRequest) {
        return deleteInput(DeleteInputRequest.builder().applyMutation(deleteInputRequest).build());
    }

    /**
     * Deletes an Input Security Group
     *
     * @param deleteInputSecurityGroupRequest
     *        Placeholder documentation for DeleteInputSecurityGroupRequest
     * @return A Java Future containing the result of the DeleteInputSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request to delete the Input Security Group was Invalid</li>
     *         <li>InternalServerErrorException Internal Server Error</li>
     *         <li>ForbiddenException The requester does not have permission to delete this Input Security Group</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException Input Security Group not found</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Limit Exceeded Error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteInputSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteInputSecurityGroupResponse> deleteInputSecurityGroup(
            DeleteInputSecurityGroupRequest deleteInputSecurityGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes an Input Security Group<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInputSecurityGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteInputSecurityGroupRequest#builder()}
     * </p>
     *
     * @param deleteInputSecurityGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DeleteInputSecurityGroupRequest.Builder} to create
     *        a request. Placeholder documentation for DeleteInputSecurityGroupRequest
     * @return A Java Future containing the result of the DeleteInputSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request to delete the Input Security Group was Invalid</li>
     *         <li>InternalServerErrorException Internal Server Error</li>
     *         <li>ForbiddenException The requester does not have permission to delete this Input Security Group</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException Input Security Group not found</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Limit Exceeded Error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteInputSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteInputSecurityGroupResponse> deleteInputSecurityGroup(
            Consumer<DeleteInputSecurityGroupRequest.Builder> deleteInputSecurityGroupRequest) {
        return deleteInputSecurityGroup(DeleteInputSecurityGroupRequest.builder().applyMutation(deleteInputSecurityGroupRequest)
                .build());
    }

    /**
     * Delete a multiplex. The multiplex must be idle.
     *
     * @param deleteMultiplexRequest
     *        Placeholder documentation for DeleteMultiplexRequest
     * @return A Java Future containing the result of the DeleteMultiplex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You don't have permission to delete the multiplex.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The multiplex that you are trying to delete doesn’t exist. Check the ID and try
     *         again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on delete multiplex calls to multiplex service.</li>
     *         <li>ConflictException The multiplex is unable to delete due to an issue with multiplex resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteMultiplex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteMultiplexResponse> deleteMultiplex(DeleteMultiplexRequest deleteMultiplexRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Delete a multiplex. The multiplex must be idle.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMultiplexRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteMultiplexRequest#builder()}
     * </p>
     *
     * @param deleteMultiplexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DeleteMultiplexRequest.Builder} to create a
     *        request. Placeholder documentation for DeleteMultiplexRequest
     * @return A Java Future containing the result of the DeleteMultiplex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You don't have permission to delete the multiplex.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The multiplex that you are trying to delete doesn’t exist. Check the ID and try
     *         again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on delete multiplex calls to multiplex service.</li>
     *         <li>ConflictException The multiplex is unable to delete due to an issue with multiplex resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteMultiplex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteMultiplexResponse> deleteMultiplex(
            Consumer<DeleteMultiplexRequest.Builder> deleteMultiplexRequest) {
        return deleteMultiplex(DeleteMultiplexRequest.builder().applyMutation(deleteMultiplexRequest).build());
    }

    /**
     * Delete a program from a multiplex.
     *
     * @param deleteMultiplexProgramRequest
     *        Placeholder documentation for DeleteMultiplexProgramRequest
     * @return A Java Future containing the result of the DeleteMultiplexProgram operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You don't have permission to delete the multiplex program.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The program that you are trying to delete doesn’t exist. Check the ID and try
     *         again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on delete multiplex program calls to multiplex
     *         service.</li>
     *         <li>ConflictException The multiplex program is unable to delete due to an issue with multiplex resources.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteMultiplexProgram
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMultiplexProgramResponse> deleteMultiplexProgram(
            DeleteMultiplexProgramRequest deleteMultiplexProgramRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Delete a program from a multiplex.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMultiplexProgramRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteMultiplexProgramRequest#builder()}
     * </p>
     *
     * @param deleteMultiplexProgramRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DeleteMultiplexProgramRequest.Builder} to create a
     *        request. Placeholder documentation for DeleteMultiplexProgramRequest
     * @return A Java Future containing the result of the DeleteMultiplexProgram operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You don't have permission to delete the multiplex program.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The program that you are trying to delete doesn’t exist. Check the ID and try
     *         again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on delete multiplex program calls to multiplex
     *         service.</li>
     *         <li>ConflictException The multiplex program is unable to delete due to an issue with multiplex resources.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteMultiplexProgram
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMultiplexProgramResponse> deleteMultiplexProgram(
            Consumer<DeleteMultiplexProgramRequest.Builder> deleteMultiplexProgramRequest) {
        return deleteMultiplexProgram(DeleteMultiplexProgramRequest.builder().applyMutation(deleteMultiplexProgramRequest)
                .build());
    }

    /**
     * Delete an expired reservation.
     *
     * @param deleteReservationRequest
     *        Placeholder documentation for DeleteReservationRequest
     * @return A Java Future containing the result of the DeleteReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to delete reservation</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>NotFoundException Reservation you're attempting to delete does not exist</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on delete reservation request</li>
     *         <li>ConflictException The reservation could not be deleted because it is currently active.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteReservation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteReservationResponse> deleteReservation(DeleteReservationRequest deleteReservationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Delete an expired reservation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReservationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteReservationRequest#builder()}
     * </p>
     *
     * @param deleteReservationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DeleteReservationRequest.Builder} to create a
     *        request. Placeholder documentation for DeleteReservationRequest
     * @return A Java Future containing the result of the DeleteReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to delete reservation</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>NotFoundException Reservation you're attempting to delete does not exist</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on delete reservation request</li>
     *         <li>ConflictException The reservation could not be deleted because it is currently active.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteReservation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteReservationResponse> deleteReservation(
            Consumer<DeleteReservationRequest.Builder> deleteReservationRequest) {
        return deleteReservation(DeleteReservationRequest.builder().applyMutation(deleteReservationRequest).build());
    }

    /**
     * Delete all schedule actions on a channel.
     *
     * @param deleteScheduleRequest
     *        Placeholder documentation for DeleteScheduleRequest
     * @return A Java Future containing the result of the DeleteSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request to delete the schedule on this channel was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to delete the channel schedule.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The specified channel does not exist to have its schedule deleted.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on delete schedule calls.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteScheduleResponse> deleteSchedule(DeleteScheduleRequest deleteScheduleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Delete all schedule actions on a channel.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteScheduleRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteScheduleRequest#builder()}
     * </p>
     *
     * @param deleteScheduleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DeleteScheduleRequest.Builder} to create a request.
     *        Placeholder documentation for DeleteScheduleRequest
     * @return A Java Future containing the result of the DeleteSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request to delete the schedule on this channel was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to delete the channel schedule.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The specified channel does not exist to have its schedule deleted.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on delete schedule calls.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteScheduleResponse> deleteSchedule(Consumer<DeleteScheduleRequest.Builder> deleteScheduleRequest) {
        return deleteSchedule(DeleteScheduleRequest.builder().applyMutation(deleteScheduleRequest).build());
    }

    /**
     * Deletes the specified signal map.
     *
     * @param deleteSignalMapRequest
     *        Placeholder documentation for DeleteSignalMapRequest
     * @return A Java Future containing the result of the DeleteSignalMap operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteSignalMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteSignalMap" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSignalMapResponse> deleteSignalMap(DeleteSignalMapRequest deleteSignalMapRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes the specified signal map.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSignalMapRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteSignalMapRequest#builder()}
     * </p>
     *
     * @param deleteSignalMapRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DeleteSignalMapRequest.Builder} to create a
     *        request. Placeholder documentation for DeleteSignalMapRequest
     * @return A Java Future containing the result of the DeleteSignalMap operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteSignalMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteSignalMap" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSignalMapResponse> deleteSignalMap(
            Consumer<DeleteSignalMapRequest.Builder> deleteSignalMapRequest) {
        return deleteSignalMap(DeleteSignalMapRequest.builder().applyMutation(deleteSignalMapRequest).build());
    }

    /**
     * Removes tags for a resource
     *
     * @param deleteTagsRequest
     *        Placeholder documentation for DeleteTagsRequest
     * @return A Java Future containing the result of the DeleteTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The arn was not found.</li>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTagsResponse> deleteTags(DeleteTagsRequest deleteTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Removes tags for a resource<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTagsRequest#builder()}
     * </p>
     *
     * @param deleteTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DeleteTagsRequest.Builder} to create a request.
     *        Placeholder documentation for DeleteTagsRequest
     * @return A Java Future containing the result of the DeleteTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The arn was not found.</li>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTagsResponse> deleteTags(Consumer<DeleteTagsRequest.Builder> deleteTagsRequest) {
        return deleteTags(DeleteTagsRequest.builder().applyMutation(deleteTagsRequest).build());
    }

    /**
     * Describe account configuration
     *
     * @param describeAccountConfigurationRequest
     *        Placeholder documentation for DescribeAccountConfigurationRequest
     * @return A Java Future containing the result of the DescribeAccountConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to describe the account configuration.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe account configuration calls.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeAccountConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeAccountConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountConfigurationResponse> describeAccountConfiguration(
            DescribeAccountConfigurationRequest describeAccountConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Describe account configuration<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAccountConfigurationRequest#builder()}
     * </p>
     *
     * @param describeAccountConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DescribeAccountConfigurationRequest.Builder} to
     *        create a request. Placeholder documentation for DescribeAccountConfigurationRequest
     * @return A Java Future containing the result of the DescribeAccountConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to describe the account configuration.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe account configuration calls.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeAccountConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeAccountConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountConfigurationResponse> describeAccountConfiguration(
            Consumer<DescribeAccountConfigurationRequest.Builder> describeAccountConfigurationRequest) {
        return describeAccountConfiguration(DescribeAccountConfigurationRequest.builder()
                .applyMutation(describeAccountConfigurationRequest).build());
    }

    /**
     * Gets details about a channel
     *
     * @param describeChannelRequest
     *        Placeholder documentation for DescribeChannelRequest
     * @return A Java Future containing the result of the DescribeChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to describe the channel.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The channel you're requesting to describe does not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe channel calls to channel service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeChannelResponse> describeChannel(DescribeChannelRequest describeChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Gets details about a channel<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeChannelRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeChannelRequest#builder()}
     * </p>
     *
     * @param describeChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DescribeChannelRequest.Builder} to create a
     *        request. Placeholder documentation for DescribeChannelRequest
     * @return A Java Future containing the result of the DescribeChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to describe the channel.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The channel you're requesting to describe does not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe channel calls to channel service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeChannelResponse> describeChannel(
            Consumer<DescribeChannelRequest.Builder> describeChannelRequest) {
        return describeChannel(DescribeChannelRequest.builder().applyMutation(describeChannelRequest).build());
    }

    /**
     * Produces details about an input
     *
     * @param describeInputRequest
     *        Placeholder documentation for DescribeInputRequest
     * @return A Java Future containing the result of the DescribeInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException Input not found</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInput" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeInputResponse> describeInput(DescribeInputRequest describeInputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Produces details about an input<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInputRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeInputRequest#builder()}
     * </p>
     *
     * @param describeInputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DescribeInputRequest.Builder} to create a request.
     *        Placeholder documentation for DescribeInputRequest
     * @return A Java Future containing the result of the DescribeInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException Input not found</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInput" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeInputResponse> describeInput(Consumer<DescribeInputRequest.Builder> describeInputRequest) {
        return describeInput(DescribeInputRequest.builder().applyMutation(describeInputRequest).build());
    }

    /**
     * Gets the details for the input device
     *
     * @param describeInputDeviceRequest
     *        Placeholder documentation for DescribeInputDeviceRequest
     * @return A Java Future containing the result of the DescribeInputDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to describe the input device.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException The input device you're requesting to describe does not exist. Check the ID.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe calls to the input device service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeInputDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeInputDeviceResponse> describeInputDevice(
            DescribeInputDeviceRequest describeInputDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Gets the details for the input device<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInputDeviceRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeInputDeviceRequest#builder()}
     * </p>
     *
     * @param describeInputDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DescribeInputDeviceRequest.Builder} to create a
     *        request. Placeholder documentation for DescribeInputDeviceRequest
     * @return A Java Future containing the result of the DescribeInputDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to describe the input device.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException The input device you're requesting to describe does not exist. Check the ID.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe calls to the input device service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeInputDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeInputDeviceResponse> describeInputDevice(
            Consumer<DescribeInputDeviceRequest.Builder> describeInputDeviceRequest) {
        return describeInputDevice(DescribeInputDeviceRequest.builder().applyMutation(describeInputDeviceRequest).build());
    }

    /**
     * Get the latest thumbnail data for the input device.
     *
     * @param describeInputDeviceThumbnailRequest
     *        Placeholder documentation for DescribeInputDeviceThumbnailRequest
     * @param asyncResponseTransformer
     *        The response transformer for processing the streaming response in a non-blocking manner. See
     *        {@link AsyncResponseTransformer} for details on how this callback should be implemented and for links to
     *        precanned implementations for common scenarios like downloading to a file. The service documentation for
     *        the response content is as follows 'The binary data for the thumbnail that the Link device has most
     *        recently sent to MediaLive.'.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to describe input device thumbnail.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException Input device not found.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on get thumbnail calls to the input device service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeInputDeviceThumbnail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputDeviceThumbnail"
     *      target="_top">AWS API Documentation</a>
     */
    default <ReturnT> CompletableFuture<ReturnT> describeInputDeviceThumbnail(
            DescribeInputDeviceThumbnailRequest describeInputDeviceThumbnailRequest,
            AsyncResponseTransformer<DescribeInputDeviceThumbnailResponse, ReturnT> asyncResponseTransformer) {
        throw new UnsupportedOperationException();
    }

    /**
     * Get the latest thumbnail data for the input device.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInputDeviceThumbnailRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeInputDeviceThumbnailRequest#builder()}
     * </p>
     *
     * @param describeInputDeviceThumbnailRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DescribeInputDeviceThumbnailRequest.Builder} to
     *        create a request. Placeholder documentation for DescribeInputDeviceThumbnailRequest
     * @param asyncResponseTransformer
     *        The response transformer for processing the streaming response in a non-blocking manner. See
     *        {@link AsyncResponseTransformer} for details on how this callback should be implemented and for links to
     *        precanned implementations for common scenarios like downloading to a file. The service documentation for
     *        the response content is as follows 'The binary data for the thumbnail that the Link device has most
     *        recently sent to MediaLive.'.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to describe input device thumbnail.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException Input device not found.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on get thumbnail calls to the input device service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeInputDeviceThumbnail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputDeviceThumbnail"
     *      target="_top">AWS API Documentation</a>
     */
    default <ReturnT> CompletableFuture<ReturnT> describeInputDeviceThumbnail(
            Consumer<DescribeInputDeviceThumbnailRequest.Builder> describeInputDeviceThumbnailRequest,
            AsyncResponseTransformer<DescribeInputDeviceThumbnailResponse, ReturnT> asyncResponseTransformer) {
        return describeInputDeviceThumbnail(
                DescribeInputDeviceThumbnailRequest.builder().applyMutation(describeInputDeviceThumbnailRequest).build(),
                asyncResponseTransformer);
    }

    /**
     * Get the latest thumbnail data for the input device.
     *
     * @param describeInputDeviceThumbnailRequest
     *        Placeholder documentation for DescribeInputDeviceThumbnailRequest
     * @param destinationPath
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows 'The binary data for the thumbnail that
     *        the Link device has most recently sent to MediaLive.'.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to describe input device thumbnail.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException Input device not found.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on get thumbnail calls to the input device service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeInputDeviceThumbnail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputDeviceThumbnail"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInputDeviceThumbnailResponse> describeInputDeviceThumbnail(
            DescribeInputDeviceThumbnailRequest describeInputDeviceThumbnailRequest, Path destinationPath) {
        return describeInputDeviceThumbnail(describeInputDeviceThumbnailRequest, AsyncResponseTransformer.toFile(destinationPath));
    }

    /**
     * Get the latest thumbnail data for the input device.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInputDeviceThumbnailRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeInputDeviceThumbnailRequest#builder()}
     * </p>
     *
     * @param describeInputDeviceThumbnailRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DescribeInputDeviceThumbnailRequest.Builder} to
     *        create a request. Placeholder documentation for DescribeInputDeviceThumbnailRequest
     * @param destinationPath
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows 'The binary data for the thumbnail that
     *        the Link device has most recently sent to MediaLive.'.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to describe input device thumbnail.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException Input device not found.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on get thumbnail calls to the input device service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeInputDeviceThumbnail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputDeviceThumbnail"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInputDeviceThumbnailResponse> describeInputDeviceThumbnail(
            Consumer<DescribeInputDeviceThumbnailRequest.Builder> describeInputDeviceThumbnailRequest, Path destinationPath) {
        return describeInputDeviceThumbnail(
                DescribeInputDeviceThumbnailRequest.builder().applyMutation(describeInputDeviceThumbnailRequest).build(),
                destinationPath);
    }

    /**
     * Produces a summary of an Input Security Group
     *
     * @param describeInputSecurityGroupRequest
     *        Placeholder documentation for DescribeInputSecurityGroupRequest
     * @return A Java Future containing the result of the DescribeInputSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request to describe an Input Security Group was Invalid</li>
     *         <li>InternalServerErrorException Internal Server Error</li>
     *         <li>ForbiddenException The requester does not have permission to describe this Input Security Group</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException Input Security Group not found</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Limit Exceeded Error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeInputSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInputSecurityGroupResponse> describeInputSecurityGroup(
            DescribeInputSecurityGroupRequest describeInputSecurityGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Produces a summary of an Input Security Group<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInputSecurityGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeInputSecurityGroupRequest#builder()}
     * </p>
     *
     * @param describeInputSecurityGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DescribeInputSecurityGroupRequest.Builder} to
     *        create a request. Placeholder documentation for DescribeInputSecurityGroupRequest
     * @return A Java Future containing the result of the DescribeInputSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request to describe an Input Security Group was Invalid</li>
     *         <li>InternalServerErrorException Internal Server Error</li>
     *         <li>ForbiddenException The requester does not have permission to describe this Input Security Group</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException Input Security Group not found</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Limit Exceeded Error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeInputSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInputSecurityGroupResponse> describeInputSecurityGroup(
            Consumer<DescribeInputSecurityGroupRequest.Builder> describeInputSecurityGroupRequest) {
        return describeInputSecurityGroup(DescribeInputSecurityGroupRequest.builder()
                .applyMutation(describeInputSecurityGroupRequest).build());
    }

    /**
     * Gets details about a multiplex.
     *
     * @param describeMultiplexRequest
     *        Placeholder documentation for DescribeMultiplexRequest
     * @return A Java Future containing the result of the DescribeMultiplex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You don't have permission to describe the multiplex.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The multiplex that you are trying to describe doesn’t exist. Check the ID and try
     *         again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe multiplex calls to multiplex service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeMultiplex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeMultiplex" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeMultiplexResponse> describeMultiplex(DescribeMultiplexRequest describeMultiplexRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Gets details about a multiplex.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMultiplexRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeMultiplexRequest#builder()}
     * </p>
     *
     * @param describeMultiplexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DescribeMultiplexRequest.Builder} to create a
     *        request. Placeholder documentation for DescribeMultiplexRequest
     * @return A Java Future containing the result of the DescribeMultiplex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You don't have permission to describe the multiplex.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The multiplex that you are trying to describe doesn’t exist. Check the ID and try
     *         again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe multiplex calls to multiplex service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeMultiplex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeMultiplex" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeMultiplexResponse> describeMultiplex(
            Consumer<DescribeMultiplexRequest.Builder> describeMultiplexRequest) {
        return describeMultiplex(DescribeMultiplexRequest.builder().applyMutation(describeMultiplexRequest).build());
    }

    /**
     * Get the details for a program in a multiplex.
     *
     * @param describeMultiplexProgramRequest
     *        Placeholder documentation for DescribeMultiplexProgramRequest
     * @return A Java Future containing the result of the DescribeMultiplexProgram operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You don't have permission to describe the multiplex program.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException MediaLive can't describe the program. The multiplex or the program that you
     *         specified doesn’t exist. Check the IDs and try again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe multiplex program calls to multiplex
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeMultiplexProgram
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMultiplexProgramResponse> describeMultiplexProgram(
            DescribeMultiplexProgramRequest describeMultiplexProgramRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Get the details for a program in a multiplex.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMultiplexProgramRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeMultiplexProgramRequest#builder()}
     * </p>
     *
     * @param describeMultiplexProgramRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DescribeMultiplexProgramRequest.Builder} to create
     *        a request. Placeholder documentation for DescribeMultiplexProgramRequest
     * @return A Java Future containing the result of the DescribeMultiplexProgram operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You don't have permission to describe the multiplex program.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException MediaLive can't describe the program. The multiplex or the program that you
     *         specified doesn’t exist. Check the IDs and try again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe multiplex program calls to multiplex
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeMultiplexProgram
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMultiplexProgramResponse> describeMultiplexProgram(
            Consumer<DescribeMultiplexProgramRequest.Builder> describeMultiplexProgramRequest) {
        return describeMultiplexProgram(DescribeMultiplexProgramRequest.builder().applyMutation(describeMultiplexProgramRequest)
                .build());
    }

    /**
     * Get details for an offering.
     *
     * @param describeOfferingRequest
     *        Placeholder documentation for DescribeOfferingRequest
     * @return A Java Future containing the result of the DescribeOffering operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to describe offering</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>NotFoundException Offering you're attempting to describe does not exist</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe offering request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeOffering" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeOfferingResponse> describeOffering(DescribeOfferingRequest describeOfferingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Get details for an offering.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOfferingRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeOfferingRequest#builder()}
     * </p>
     *
     * @param describeOfferingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DescribeOfferingRequest.Builder} to create a
     *        request. Placeholder documentation for DescribeOfferingRequest
     * @return A Java Future containing the result of the DescribeOffering operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to describe offering</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>NotFoundException Offering you're attempting to describe does not exist</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe offering request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeOffering" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeOfferingResponse> describeOffering(
            Consumer<DescribeOfferingRequest.Builder> describeOfferingRequest) {
        return describeOffering(DescribeOfferingRequest.builder().applyMutation(describeOfferingRequest).build());
    }

    /**
     * Get details for a reservation.
     *
     * @param describeReservationRequest
     *        Placeholder documentation for DescribeReservationRequest
     * @return A Java Future containing the result of the DescribeReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to describe reservation</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>NotFoundException Reservation you're attempting to describe does not exist</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe reservation request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeReservation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeReservationResponse> describeReservation(
            DescribeReservationRequest describeReservationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Get details for a reservation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReservationRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeReservationRequest#builder()}
     * </p>
     *
     * @param describeReservationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DescribeReservationRequest.Builder} to create a
     *        request. Placeholder documentation for DescribeReservationRequest
     * @return A Java Future containing the result of the DescribeReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to describe reservation</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>NotFoundException Reservation you're attempting to describe does not exist</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe reservation request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeReservation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeReservationResponse> describeReservation(
            Consumer<DescribeReservationRequest.Builder> describeReservationRequest) {
        return describeReservation(DescribeReservationRequest.builder().applyMutation(describeReservationRequest).build());
    }

    /**
     * Get a channel schedule
     *
     * @param describeScheduleRequest
     *        Placeholder documentation for DescribeScheduleRequest
     * @return A Java Future containing the result of the DescribeSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to describe the channel schedule.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The channel you're requesting a schedule describe for does not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe schedule calls.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeSchedule" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeScheduleResponse> describeSchedule(DescribeScheduleRequest describeScheduleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Get a channel schedule<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScheduleRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeScheduleRequest#builder()}
     * </p>
     *
     * @param describeScheduleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DescribeScheduleRequest.Builder} to create a
     *        request. Placeholder documentation for DescribeScheduleRequest
     * @return A Java Future containing the result of the DescribeSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to describe the channel schedule.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The channel you're requesting a schedule describe for does not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe schedule calls.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeSchedule" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeScheduleResponse> describeSchedule(
            Consumer<DescribeScheduleRequest.Builder> describeScheduleRequest) {
        return describeSchedule(DescribeScheduleRequest.builder().applyMutation(describeScheduleRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeSchedule(software.amazon.awssdk.services.medialive.model.DescribeScheduleRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.DescribeSchedulePublisher publisher = client.describeSchedulePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.DescribeSchedulePublisher publisher = client.describeSchedulePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.DescribeScheduleResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.DescribeScheduleResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSchedule(software.amazon.awssdk.services.medialive.model.DescribeScheduleRequest)} operation.</b>
     * </p>
     *
     * @param describeScheduleRequest
     *        Placeholder documentation for DescribeScheduleRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to describe the channel schedule.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The channel you're requesting a schedule describe for does not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe schedule calls.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeSchedule" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeSchedulePublisher describeSchedulePaginator(DescribeScheduleRequest describeScheduleRequest) {
        return new DescribeSchedulePublisher(this, describeScheduleRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeSchedule(software.amazon.awssdk.services.medialive.model.DescribeScheduleRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.DescribeSchedulePublisher publisher = client.describeSchedulePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.DescribeSchedulePublisher publisher = client.describeSchedulePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.DescribeScheduleResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.DescribeScheduleResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSchedule(software.amazon.awssdk.services.medialive.model.DescribeScheduleRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScheduleRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeScheduleRequest#builder()}
     * </p>
     *
     * @param describeScheduleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DescribeScheduleRequest.Builder} to create a
     *        request. Placeholder documentation for DescribeScheduleRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to describe the channel schedule.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The channel you're requesting a schedule describe for does not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe schedule calls.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeSchedule" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeSchedulePublisher describeSchedulePaginator(Consumer<DescribeScheduleRequest.Builder> describeScheduleRequest) {
        return describeSchedulePaginator(DescribeScheduleRequest.builder().applyMutation(describeScheduleRequest).build());
    }

    /**
     * Describe the latest thumbnails data.
     *
     * @param describeThumbnailsRequest
     *        Placeholder documentation for DescribeThumbnailsRequest
     * @return A Java Future containing the result of the DescribeThumbnails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal service error.</li>
     *         <li>ForbiddenException You do not have permission to describe thumbnails.</li>
     *         <li>BadGatewayException Bad Gateway error.</li>
     *         <li>NotFoundException There are no thumbnails for this channel.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe thumbnails calls to channel service.</li>
     *         <li>ConflictException Service do not have permission to customer's KMS key.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeThumbnails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeThumbnails" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeThumbnailsResponse> describeThumbnails(DescribeThumbnailsRequest describeThumbnailsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Describe the latest thumbnails data.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeThumbnailsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeThumbnailsRequest#builder()}
     * </p>
     *
     * @param describeThumbnailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DescribeThumbnailsRequest.Builder} to create a
     *        request. Placeholder documentation for DescribeThumbnailsRequest
     * @return A Java Future containing the result of the DescribeThumbnails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal service error.</li>
     *         <li>ForbiddenException You do not have permission to describe thumbnails.</li>
     *         <li>BadGatewayException Bad Gateway error.</li>
     *         <li>NotFoundException There are no thumbnails for this channel.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe thumbnails calls to channel service.</li>
     *         <li>ConflictException Service do not have permission to customer's KMS key.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeThumbnails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeThumbnails" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeThumbnailsResponse> describeThumbnails(
            Consumer<DescribeThumbnailsRequest.Builder> describeThumbnailsRequest) {
        return describeThumbnails(DescribeThumbnailsRequest.builder().applyMutation(describeThumbnailsRequest).build());
    }

    /**
     * Retrieves the specified cloudwatch alarm template.
     *
     * @param getCloudWatchAlarmTemplateRequest
     *        Placeholder documentation for GetCloudWatchAlarmTemplateRequest
     * @return A Java Future containing the result of the GetCloudWatchAlarmTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.GetCloudWatchAlarmTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetCloudWatchAlarmTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCloudWatchAlarmTemplateResponse> getCloudWatchAlarmTemplate(
            GetCloudWatchAlarmTemplateRequest getCloudWatchAlarmTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves the specified cloudwatch alarm template.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCloudWatchAlarmTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link GetCloudWatchAlarmTemplateRequest#builder()}
     * </p>
     *
     * @param getCloudWatchAlarmTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.GetCloudWatchAlarmTemplateRequest.Builder} to
     *        create a request. Placeholder documentation for GetCloudWatchAlarmTemplateRequest
     * @return A Java Future containing the result of the GetCloudWatchAlarmTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.GetCloudWatchAlarmTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetCloudWatchAlarmTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCloudWatchAlarmTemplateResponse> getCloudWatchAlarmTemplate(
            Consumer<GetCloudWatchAlarmTemplateRequest.Builder> getCloudWatchAlarmTemplateRequest) {
        return getCloudWatchAlarmTemplate(GetCloudWatchAlarmTemplateRequest.builder()
                .applyMutation(getCloudWatchAlarmTemplateRequest).build());
    }

    /**
     * Retrieves the specified cloudwatch alarm template group.
     *
     * @param getCloudWatchAlarmTemplateGroupRequest
     *        Placeholder documentation for GetCloudWatchAlarmTemplateGroupRequest
     * @return A Java Future containing the result of the GetCloudWatchAlarmTemplateGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.GetCloudWatchAlarmTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetCloudWatchAlarmTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCloudWatchAlarmTemplateGroupResponse> getCloudWatchAlarmTemplateGroup(
            GetCloudWatchAlarmTemplateGroupRequest getCloudWatchAlarmTemplateGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves the specified cloudwatch alarm template group.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCloudWatchAlarmTemplateGroupRequest.Builder}
     * avoiding the need to create one manually via {@link GetCloudWatchAlarmTemplateGroupRequest#builder()}
     * </p>
     *
     * @param getCloudWatchAlarmTemplateGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.GetCloudWatchAlarmTemplateGroupRequest.Builder} to
     *        create a request. Placeholder documentation for GetCloudWatchAlarmTemplateGroupRequest
     * @return A Java Future containing the result of the GetCloudWatchAlarmTemplateGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.GetCloudWatchAlarmTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetCloudWatchAlarmTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCloudWatchAlarmTemplateGroupResponse> getCloudWatchAlarmTemplateGroup(
            Consumer<GetCloudWatchAlarmTemplateGroupRequest.Builder> getCloudWatchAlarmTemplateGroupRequest) {
        return getCloudWatchAlarmTemplateGroup(GetCloudWatchAlarmTemplateGroupRequest.builder()
                .applyMutation(getCloudWatchAlarmTemplateGroupRequest).build());
    }

    /**
     * Retrieves the specified eventbridge rule template.
     *
     * @param getEventBridgeRuleTemplateRequest
     *        Placeholder documentation for GetEventBridgeRuleTemplateRequest
     * @return A Java Future containing the result of the GetEventBridgeRuleTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.GetEventBridgeRuleTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetEventBridgeRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEventBridgeRuleTemplateResponse> getEventBridgeRuleTemplate(
            GetEventBridgeRuleTemplateRequest getEventBridgeRuleTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves the specified eventbridge rule template.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEventBridgeRuleTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link GetEventBridgeRuleTemplateRequest#builder()}
     * </p>
     *
     * @param getEventBridgeRuleTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.GetEventBridgeRuleTemplateRequest.Builder} to
     *        create a request. Placeholder documentation for GetEventBridgeRuleTemplateRequest
     * @return A Java Future containing the result of the GetEventBridgeRuleTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.GetEventBridgeRuleTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetEventBridgeRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEventBridgeRuleTemplateResponse> getEventBridgeRuleTemplate(
            Consumer<GetEventBridgeRuleTemplateRequest.Builder> getEventBridgeRuleTemplateRequest) {
        return getEventBridgeRuleTemplate(GetEventBridgeRuleTemplateRequest.builder()
                .applyMutation(getEventBridgeRuleTemplateRequest).build());
    }

    /**
     * Retrieves the specified eventbridge rule template group.
     *
     * @param getEventBridgeRuleTemplateGroupRequest
     *        Placeholder documentation for GetEventBridgeRuleTemplateGroupRequest
     * @return A Java Future containing the result of the GetEventBridgeRuleTemplateGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.GetEventBridgeRuleTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetEventBridgeRuleTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEventBridgeRuleTemplateGroupResponse> getEventBridgeRuleTemplateGroup(
            GetEventBridgeRuleTemplateGroupRequest getEventBridgeRuleTemplateGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves the specified eventbridge rule template group.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEventBridgeRuleTemplateGroupRequest.Builder}
     * avoiding the need to create one manually via {@link GetEventBridgeRuleTemplateGroupRequest#builder()}
     * </p>
     *
     * @param getEventBridgeRuleTemplateGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.GetEventBridgeRuleTemplateGroupRequest.Builder} to
     *        create a request. Placeholder documentation for GetEventBridgeRuleTemplateGroupRequest
     * @return A Java Future containing the result of the GetEventBridgeRuleTemplateGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.GetEventBridgeRuleTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetEventBridgeRuleTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEventBridgeRuleTemplateGroupResponse> getEventBridgeRuleTemplateGroup(
            Consumer<GetEventBridgeRuleTemplateGroupRequest.Builder> getEventBridgeRuleTemplateGroupRequest) {
        return getEventBridgeRuleTemplateGroup(GetEventBridgeRuleTemplateGroupRequest.builder()
                .applyMutation(getEventBridgeRuleTemplateGroupRequest).build());
    }

    /**
     * Retrieves the specified signal map.
     *
     * @param getSignalMapRequest
     *        Placeholder documentation for GetSignalMapRequest
     * @return A Java Future containing the result of the GetSignalMap operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.GetSignalMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetSignalMap" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSignalMapResponse> getSignalMap(GetSignalMapRequest getSignalMapRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves the specified signal map.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSignalMapRequest.Builder} avoiding the need to
     * create one manually via {@link GetSignalMapRequest#builder()}
     * </p>
     *
     * @param getSignalMapRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.GetSignalMapRequest.Builder} to create a request.
     *        Placeholder documentation for GetSignalMapRequest
     * @return A Java Future containing the result of the GetSignalMap operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.GetSignalMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetSignalMap" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSignalMapResponse> getSignalMap(Consumer<GetSignalMapRequest.Builder> getSignalMapRequest) {
        return getSignalMap(GetSignalMapRequest.builder().applyMutation(getSignalMapRequest).build());
    }

    /**
     * Produces list of channels that have been created
     *
     * @param listChannelsRequest
     *        Placeholder documentation for ListChannelsRequest
     * @return A Java Future containing the result of the ListChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to list channels.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list channel calls to channel service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListChannelsResponse> listChannels(ListChannelsRequest listChannelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Produces list of channels that have been created<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChannelsRequest#builder()}
     * </p>
     *
     * @param listChannelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListChannelsRequest.Builder} to create a request.
     *        Placeholder documentation for ListChannelsRequest
     * @return A Java Future containing the result of the ListChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to list channels.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list channel calls to channel service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListChannelsResponse> listChannels(Consumer<ListChannelsRequest.Builder> listChannelsRequest) {
        return listChannels(ListChannelsRequest.builder().applyMutation(listChannelsRequest).build());
    }

    /**
     * Produces list of channels that have been created
     *
     * @return A Java Future containing the result of the ListChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to list channels.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list channel calls to channel service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListChannelsResponse> listChannels() {
        return listChannels(ListChannelsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listChannels(software.amazon.awssdk.services.medialive.model.ListChannelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListChannelsPublisher publisher = client.listChannelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListChannelsPublisher publisher = client.listChannelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListChannelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListChannelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannels(software.amazon.awssdk.services.medialive.model.ListChannelsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to list channels.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list channel calls to channel service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChannelsPublisher listChannelsPaginator() {
        return listChannelsPaginator(ListChannelsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listChannels(software.amazon.awssdk.services.medialive.model.ListChannelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListChannelsPublisher publisher = client.listChannelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListChannelsPublisher publisher = client.listChannelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListChannelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListChannelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannels(software.amazon.awssdk.services.medialive.model.ListChannelsRequest)} operation.</b>
     * </p>
     *
     * @param listChannelsRequest
     *        Placeholder documentation for ListChannelsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to list channels.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list channel calls to channel service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChannelsPublisher listChannelsPaginator(ListChannelsRequest listChannelsRequest) {
        return new ListChannelsPublisher(this, listChannelsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listChannels(software.amazon.awssdk.services.medialive.model.ListChannelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListChannelsPublisher publisher = client.listChannelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListChannelsPublisher publisher = client.listChannelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListChannelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListChannelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannels(software.amazon.awssdk.services.medialive.model.ListChannelsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChannelsRequest#builder()}
     * </p>
     *
     * @param listChannelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListChannelsRequest.Builder} to create a request.
     *        Placeholder documentation for ListChannelsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to list channels.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list channel calls to channel service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChannelsPublisher listChannelsPaginator(Consumer<ListChannelsRequest.Builder> listChannelsRequest) {
        return listChannelsPaginator(ListChannelsRequest.builder().applyMutation(listChannelsRequest).build());
    }

    /**
     * Lists cloudwatch alarm template groups.
     *
     * @param listCloudWatchAlarmTemplateGroupsRequest
     *        Placeholder documentation for ListCloudWatchAlarmTemplateGroupsRequest
     * @return A Java Future containing the result of the ListCloudWatchAlarmTemplateGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListCloudWatchAlarmTemplateGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListCloudWatchAlarmTemplateGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCloudWatchAlarmTemplateGroupsResponse> listCloudWatchAlarmTemplateGroups(
            ListCloudWatchAlarmTemplateGroupsRequest listCloudWatchAlarmTemplateGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists cloudwatch alarm template groups.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCloudWatchAlarmTemplateGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCloudWatchAlarmTemplateGroupsRequest#builder()}
     * </p>
     *
     * @param listCloudWatchAlarmTemplateGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplateGroupsRequest.Builder}
     *        to create a request. Placeholder documentation for ListCloudWatchAlarmTemplateGroupsRequest
     * @return A Java Future containing the result of the ListCloudWatchAlarmTemplateGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListCloudWatchAlarmTemplateGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListCloudWatchAlarmTemplateGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCloudWatchAlarmTemplateGroupsResponse> listCloudWatchAlarmTemplateGroups(
            Consumer<ListCloudWatchAlarmTemplateGroupsRequest.Builder> listCloudWatchAlarmTemplateGroupsRequest) {
        return listCloudWatchAlarmTemplateGroups(ListCloudWatchAlarmTemplateGroupsRequest.builder()
                .applyMutation(listCloudWatchAlarmTemplateGroupsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCloudWatchAlarmTemplateGroups(software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplateGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListCloudWatchAlarmTemplateGroupsPublisher publisher = client.listCloudWatchAlarmTemplateGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListCloudWatchAlarmTemplateGroupsPublisher publisher = client.listCloudWatchAlarmTemplateGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplateGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplateGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCloudWatchAlarmTemplateGroups(software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplateGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCloudWatchAlarmTemplateGroupsRequest
     *        Placeholder documentation for ListCloudWatchAlarmTemplateGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListCloudWatchAlarmTemplateGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListCloudWatchAlarmTemplateGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCloudWatchAlarmTemplateGroupsPublisher listCloudWatchAlarmTemplateGroupsPaginator(
            ListCloudWatchAlarmTemplateGroupsRequest listCloudWatchAlarmTemplateGroupsRequest) {
        return new ListCloudWatchAlarmTemplateGroupsPublisher(this, listCloudWatchAlarmTemplateGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCloudWatchAlarmTemplateGroups(software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplateGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListCloudWatchAlarmTemplateGroupsPublisher publisher = client.listCloudWatchAlarmTemplateGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListCloudWatchAlarmTemplateGroupsPublisher publisher = client.listCloudWatchAlarmTemplateGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplateGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplateGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCloudWatchAlarmTemplateGroups(software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplateGroupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCloudWatchAlarmTemplateGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCloudWatchAlarmTemplateGroupsRequest#builder()}
     * </p>
     *
     * @param listCloudWatchAlarmTemplateGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplateGroupsRequest.Builder}
     *        to create a request. Placeholder documentation for ListCloudWatchAlarmTemplateGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListCloudWatchAlarmTemplateGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListCloudWatchAlarmTemplateGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCloudWatchAlarmTemplateGroupsPublisher listCloudWatchAlarmTemplateGroupsPaginator(
            Consumer<ListCloudWatchAlarmTemplateGroupsRequest.Builder> listCloudWatchAlarmTemplateGroupsRequest) {
        return listCloudWatchAlarmTemplateGroupsPaginator(ListCloudWatchAlarmTemplateGroupsRequest.builder()
                .applyMutation(listCloudWatchAlarmTemplateGroupsRequest).build());
    }

    /**
     * Lists cloudwatch alarm templates.
     *
     * @param listCloudWatchAlarmTemplatesRequest
     *        Placeholder documentation for ListCloudWatchAlarmTemplatesRequest
     * @return A Java Future containing the result of the ListCloudWatchAlarmTemplates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListCloudWatchAlarmTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListCloudWatchAlarmTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCloudWatchAlarmTemplatesResponse> listCloudWatchAlarmTemplates(
            ListCloudWatchAlarmTemplatesRequest listCloudWatchAlarmTemplatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists cloudwatch alarm templates.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCloudWatchAlarmTemplatesRequest.Builder}
     * avoiding the need to create one manually via {@link ListCloudWatchAlarmTemplatesRequest#builder()}
     * </p>
     *
     * @param listCloudWatchAlarmTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplatesRequest.Builder} to
     *        create a request. Placeholder documentation for ListCloudWatchAlarmTemplatesRequest
     * @return A Java Future containing the result of the ListCloudWatchAlarmTemplates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListCloudWatchAlarmTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListCloudWatchAlarmTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCloudWatchAlarmTemplatesResponse> listCloudWatchAlarmTemplates(
            Consumer<ListCloudWatchAlarmTemplatesRequest.Builder> listCloudWatchAlarmTemplatesRequest) {
        return listCloudWatchAlarmTemplates(ListCloudWatchAlarmTemplatesRequest.builder()
                .applyMutation(listCloudWatchAlarmTemplatesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCloudWatchAlarmTemplates(software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListCloudWatchAlarmTemplatesPublisher publisher = client.listCloudWatchAlarmTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListCloudWatchAlarmTemplatesPublisher publisher = client.listCloudWatchAlarmTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCloudWatchAlarmTemplates(software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCloudWatchAlarmTemplatesRequest
     *        Placeholder documentation for ListCloudWatchAlarmTemplatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListCloudWatchAlarmTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListCloudWatchAlarmTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCloudWatchAlarmTemplatesPublisher listCloudWatchAlarmTemplatesPaginator(
            ListCloudWatchAlarmTemplatesRequest listCloudWatchAlarmTemplatesRequest) {
        return new ListCloudWatchAlarmTemplatesPublisher(this, listCloudWatchAlarmTemplatesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCloudWatchAlarmTemplates(software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListCloudWatchAlarmTemplatesPublisher publisher = client.listCloudWatchAlarmTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListCloudWatchAlarmTemplatesPublisher publisher = client.listCloudWatchAlarmTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCloudWatchAlarmTemplates(software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplatesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCloudWatchAlarmTemplatesRequest.Builder}
     * avoiding the need to create one manually via {@link ListCloudWatchAlarmTemplatesRequest#builder()}
     * </p>
     *
     * @param listCloudWatchAlarmTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplatesRequest.Builder} to
     *        create a request. Placeholder documentation for ListCloudWatchAlarmTemplatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListCloudWatchAlarmTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListCloudWatchAlarmTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCloudWatchAlarmTemplatesPublisher listCloudWatchAlarmTemplatesPaginator(
            Consumer<ListCloudWatchAlarmTemplatesRequest.Builder> listCloudWatchAlarmTemplatesRequest) {
        return listCloudWatchAlarmTemplatesPaginator(ListCloudWatchAlarmTemplatesRequest.builder()
                .applyMutation(listCloudWatchAlarmTemplatesRequest).build());
    }

    /**
     * Lists eventbridge rule template groups.
     *
     * @param listEventBridgeRuleTemplateGroupsRequest
     *        Placeholder documentation for ListEventBridgeRuleTemplateGroupsRequest
     * @return A Java Future containing the result of the ListEventBridgeRuleTemplateGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListEventBridgeRuleTemplateGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListEventBridgeRuleTemplateGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEventBridgeRuleTemplateGroupsResponse> listEventBridgeRuleTemplateGroups(
            ListEventBridgeRuleTemplateGroupsRequest listEventBridgeRuleTemplateGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists eventbridge rule template groups.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventBridgeRuleTemplateGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link ListEventBridgeRuleTemplateGroupsRequest#builder()}
     * </p>
     *
     * @param listEventBridgeRuleTemplateGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplateGroupsRequest.Builder}
     *        to create a request. Placeholder documentation for ListEventBridgeRuleTemplateGroupsRequest
     * @return A Java Future containing the result of the ListEventBridgeRuleTemplateGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListEventBridgeRuleTemplateGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListEventBridgeRuleTemplateGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEventBridgeRuleTemplateGroupsResponse> listEventBridgeRuleTemplateGroups(
            Consumer<ListEventBridgeRuleTemplateGroupsRequest.Builder> listEventBridgeRuleTemplateGroupsRequest) {
        return listEventBridgeRuleTemplateGroups(ListEventBridgeRuleTemplateGroupsRequest.builder()
                .applyMutation(listEventBridgeRuleTemplateGroupsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEventBridgeRuleTemplateGroups(software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplateGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListEventBridgeRuleTemplateGroupsPublisher publisher = client.listEventBridgeRuleTemplateGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListEventBridgeRuleTemplateGroupsPublisher publisher = client.listEventBridgeRuleTemplateGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplateGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplateGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventBridgeRuleTemplateGroups(software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplateGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEventBridgeRuleTemplateGroupsRequest
     *        Placeholder documentation for ListEventBridgeRuleTemplateGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListEventBridgeRuleTemplateGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListEventBridgeRuleTemplateGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventBridgeRuleTemplateGroupsPublisher listEventBridgeRuleTemplateGroupsPaginator(
            ListEventBridgeRuleTemplateGroupsRequest listEventBridgeRuleTemplateGroupsRequest) {
        return new ListEventBridgeRuleTemplateGroupsPublisher(this, listEventBridgeRuleTemplateGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEventBridgeRuleTemplateGroups(software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplateGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListEventBridgeRuleTemplateGroupsPublisher publisher = client.listEventBridgeRuleTemplateGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListEventBridgeRuleTemplateGroupsPublisher publisher = client.listEventBridgeRuleTemplateGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplateGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplateGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventBridgeRuleTemplateGroups(software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplateGroupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventBridgeRuleTemplateGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link ListEventBridgeRuleTemplateGroupsRequest#builder()}
     * </p>
     *
     * @param listEventBridgeRuleTemplateGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplateGroupsRequest.Builder}
     *        to create a request. Placeholder documentation for ListEventBridgeRuleTemplateGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListEventBridgeRuleTemplateGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListEventBridgeRuleTemplateGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventBridgeRuleTemplateGroupsPublisher listEventBridgeRuleTemplateGroupsPaginator(
            Consumer<ListEventBridgeRuleTemplateGroupsRequest.Builder> listEventBridgeRuleTemplateGroupsRequest) {
        return listEventBridgeRuleTemplateGroupsPaginator(ListEventBridgeRuleTemplateGroupsRequest.builder()
                .applyMutation(listEventBridgeRuleTemplateGroupsRequest).build());
    }

    /**
     * Lists eventbridge rule templates.
     *
     * @param listEventBridgeRuleTemplatesRequest
     *        Placeholder documentation for ListEventBridgeRuleTemplatesRequest
     * @return A Java Future containing the result of the ListEventBridgeRuleTemplates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListEventBridgeRuleTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListEventBridgeRuleTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEventBridgeRuleTemplatesResponse> listEventBridgeRuleTemplates(
            ListEventBridgeRuleTemplatesRequest listEventBridgeRuleTemplatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists eventbridge rule templates.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventBridgeRuleTemplatesRequest.Builder}
     * avoiding the need to create one manually via {@link ListEventBridgeRuleTemplatesRequest#builder()}
     * </p>
     *
     * @param listEventBridgeRuleTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplatesRequest.Builder} to
     *        create a request. Placeholder documentation for ListEventBridgeRuleTemplatesRequest
     * @return A Java Future containing the result of the ListEventBridgeRuleTemplates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListEventBridgeRuleTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListEventBridgeRuleTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEventBridgeRuleTemplatesResponse> listEventBridgeRuleTemplates(
            Consumer<ListEventBridgeRuleTemplatesRequest.Builder> listEventBridgeRuleTemplatesRequest) {
        return listEventBridgeRuleTemplates(ListEventBridgeRuleTemplatesRequest.builder()
                .applyMutation(listEventBridgeRuleTemplatesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEventBridgeRuleTemplates(software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListEventBridgeRuleTemplatesPublisher publisher = client.listEventBridgeRuleTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListEventBridgeRuleTemplatesPublisher publisher = client.listEventBridgeRuleTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventBridgeRuleTemplates(software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEventBridgeRuleTemplatesRequest
     *        Placeholder documentation for ListEventBridgeRuleTemplatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListEventBridgeRuleTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListEventBridgeRuleTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventBridgeRuleTemplatesPublisher listEventBridgeRuleTemplatesPaginator(
            ListEventBridgeRuleTemplatesRequest listEventBridgeRuleTemplatesRequest) {
        return new ListEventBridgeRuleTemplatesPublisher(this, listEventBridgeRuleTemplatesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEventBridgeRuleTemplates(software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListEventBridgeRuleTemplatesPublisher publisher = client.listEventBridgeRuleTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListEventBridgeRuleTemplatesPublisher publisher = client.listEventBridgeRuleTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventBridgeRuleTemplates(software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplatesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventBridgeRuleTemplatesRequest.Builder}
     * avoiding the need to create one manually via {@link ListEventBridgeRuleTemplatesRequest#builder()}
     * </p>
     *
     * @param listEventBridgeRuleTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplatesRequest.Builder} to
     *        create a request. Placeholder documentation for ListEventBridgeRuleTemplatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListEventBridgeRuleTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListEventBridgeRuleTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventBridgeRuleTemplatesPublisher listEventBridgeRuleTemplatesPaginator(
            Consumer<ListEventBridgeRuleTemplatesRequest.Builder> listEventBridgeRuleTemplatesRequest) {
        return listEventBridgeRuleTemplatesPaginator(ListEventBridgeRuleTemplatesRequest.builder()
                .applyMutation(listEventBridgeRuleTemplatesRequest).build());
    }

    /**
     * List input devices that are currently being transferred. List input devices that you are transferring from your
     * AWS account or input devices that another AWS account is transferring to you.
     *
     * @param listInputDeviceTransfersRequest
     *        Placeholder documentation for ListInputDeviceTransfersRequest
     * @return A Java Future containing the result of the ListInputDeviceTransfers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException Transfer operation failed, input could not be validated.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to list transferring devices.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list devices calls to the input device service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputDeviceTransfers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputDeviceTransfers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInputDeviceTransfersResponse> listInputDeviceTransfers(
            ListInputDeviceTransfersRequest listInputDeviceTransfersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * List input devices that are currently being transferred. List input devices that you are transferring from your
     * AWS account or input devices that another AWS account is transferring to you.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInputDeviceTransfersRequest.Builder} avoiding
     * the need to create one manually via {@link ListInputDeviceTransfersRequest#builder()}
     * </p>
     *
     * @param listInputDeviceTransfersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersRequest.Builder} to create
     *        a request. Placeholder documentation for ListInputDeviceTransfersRequest
     * @return A Java Future containing the result of the ListInputDeviceTransfers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException Transfer operation failed, input could not be validated.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to list transferring devices.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list devices calls to the input device service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputDeviceTransfers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputDeviceTransfers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInputDeviceTransfersResponse> listInputDeviceTransfers(
            Consumer<ListInputDeviceTransfersRequest.Builder> listInputDeviceTransfersRequest) {
        return listInputDeviceTransfers(ListInputDeviceTransfersRequest.builder().applyMutation(listInputDeviceTransfersRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInputDeviceTransfers(software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputDeviceTransfersPublisher publisher = client.listInputDeviceTransfersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputDeviceTransfersPublisher publisher = client.listInputDeviceTransfersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInputDeviceTransfers(software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInputDeviceTransfersRequest
     *        Placeholder documentation for ListInputDeviceTransfersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException Transfer operation failed, input could not be validated.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to list transferring devices.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list devices calls to the input device service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputDeviceTransfers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputDeviceTransfers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInputDeviceTransfersPublisher listInputDeviceTransfersPaginator(
            ListInputDeviceTransfersRequest listInputDeviceTransfersRequest) {
        return new ListInputDeviceTransfersPublisher(this, listInputDeviceTransfersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInputDeviceTransfers(software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputDeviceTransfersPublisher publisher = client.listInputDeviceTransfersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputDeviceTransfersPublisher publisher = client.listInputDeviceTransfersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInputDeviceTransfers(software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInputDeviceTransfersRequest.Builder} avoiding
     * the need to create one manually via {@link ListInputDeviceTransfersRequest#builder()}
     * </p>
     *
     * @param listInputDeviceTransfersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersRequest.Builder} to create
     *        a request. Placeholder documentation for ListInputDeviceTransfersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException Transfer operation failed, input could not be validated.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to list transferring devices.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list devices calls to the input device service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputDeviceTransfers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputDeviceTransfers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInputDeviceTransfersPublisher listInputDeviceTransfersPaginator(
            Consumer<ListInputDeviceTransfersRequest.Builder> listInputDeviceTransfersRequest) {
        return listInputDeviceTransfersPaginator(ListInputDeviceTransfersRequest.builder()
                .applyMutation(listInputDeviceTransfersRequest).build());
    }

    /**
     * List input devices
     *
     * @param listInputDevicesRequest
     *        Placeholder documentation for ListInputDevicesRequest
     * @return A Java Future containing the result of the ListInputDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to list input devices.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list devices calls to the input device service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputDevices" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListInputDevicesResponse> listInputDevices(ListInputDevicesRequest listInputDevicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * List input devices<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInputDevicesRequest.Builder} avoiding the need
     * to create one manually via {@link ListInputDevicesRequest#builder()}
     * </p>
     *
     * @param listInputDevicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListInputDevicesRequest.Builder} to create a
     *        request. Placeholder documentation for ListInputDevicesRequest
     * @return A Java Future containing the result of the ListInputDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to list input devices.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list devices calls to the input device service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputDevices" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListInputDevicesResponse> listInputDevices(
            Consumer<ListInputDevicesRequest.Builder> listInputDevicesRequest) {
        return listInputDevices(ListInputDevicesRequest.builder().applyMutation(listInputDevicesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInputDevices(software.amazon.awssdk.services.medialive.model.ListInputDevicesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputDevicesPublisher publisher = client.listInputDevicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputDevicesPublisher publisher = client.listInputDevicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListInputDevicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListInputDevicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInputDevices(software.amazon.awssdk.services.medialive.model.ListInputDevicesRequest)} operation.</b>
     * </p>
     *
     * @param listInputDevicesRequest
     *        Placeholder documentation for ListInputDevicesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to list input devices.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list devices calls to the input device service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputDevices" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInputDevicesPublisher listInputDevicesPaginator(ListInputDevicesRequest listInputDevicesRequest) {
        return new ListInputDevicesPublisher(this, listInputDevicesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInputDevices(software.amazon.awssdk.services.medialive.model.ListInputDevicesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputDevicesPublisher publisher = client.listInputDevicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputDevicesPublisher publisher = client.listInputDevicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListInputDevicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListInputDevicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInputDevices(software.amazon.awssdk.services.medialive.model.ListInputDevicesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInputDevicesRequest.Builder} avoiding the need
     * to create one manually via {@link ListInputDevicesRequest#builder()}
     * </p>
     *
     * @param listInputDevicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListInputDevicesRequest.Builder} to create a
     *        request. Placeholder documentation for ListInputDevicesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to list input devices.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list devices calls to the input device service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputDevices" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInputDevicesPublisher listInputDevicesPaginator(Consumer<ListInputDevicesRequest.Builder> listInputDevicesRequest) {
        return listInputDevicesPaginator(ListInputDevicesRequest.builder().applyMutation(listInputDevicesRequest).build());
    }

    /**
     * Produces a list of Input Security Groups for an account
     *
     * @param listInputSecurityGroupsRequest
     *        Placeholder documentation for ListInputSecurityGroupsRequest
     * @return A Java Future containing the result of the ListInputSecurityGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request to list Input Security Groups was invalid</li>
     *         <li>InternalServerErrorException Internal Server Error</li>
     *         <li>ForbiddenException The requester does not have permission to call ListInputSecurityGroups</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Limit Exceeded Error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInputSecurityGroupsResponse> listInputSecurityGroups(
            ListInputSecurityGroupsRequest listInputSecurityGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Produces a list of Input Security Groups for an account<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInputSecurityGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link ListInputSecurityGroupsRequest#builder()}
     * </p>
     *
     * @param listInputSecurityGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest.Builder} to create a
     *        request. Placeholder documentation for ListInputSecurityGroupsRequest
     * @return A Java Future containing the result of the ListInputSecurityGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request to list Input Security Groups was invalid</li>
     *         <li>InternalServerErrorException Internal Server Error</li>
     *         <li>ForbiddenException The requester does not have permission to call ListInputSecurityGroups</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Limit Exceeded Error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInputSecurityGroupsResponse> listInputSecurityGroups(
            Consumer<ListInputSecurityGroupsRequest.Builder> listInputSecurityGroupsRequest) {
        return listInputSecurityGroups(ListInputSecurityGroupsRequest.builder().applyMutation(listInputSecurityGroupsRequest)
                .build());
    }

    /**
     * Produces a list of Input Security Groups for an account
     *
     * @return A Java Future containing the result of the ListInputSecurityGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request to list Input Security Groups was invalid</li>
     *         <li>InternalServerErrorException Internal Server Error</li>
     *         <li>ForbiddenException The requester does not have permission to call ListInputSecurityGroups</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Limit Exceeded Error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInputSecurityGroupsResponse> listInputSecurityGroups() {
        return listInputSecurityGroups(ListInputSecurityGroupsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInputSecurityGroups(software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputSecurityGroupsPublisher publisher = client.listInputSecurityGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputSecurityGroupsPublisher publisher = client.listInputSecurityGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInputSecurityGroups(software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request to list Input Security Groups was invalid</li>
     *         <li>InternalServerErrorException Internal Server Error</li>
     *         <li>ForbiddenException The requester does not have permission to call ListInputSecurityGroups</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Limit Exceeded Error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInputSecurityGroupsPublisher listInputSecurityGroupsPaginator() {
        return listInputSecurityGroupsPaginator(ListInputSecurityGroupsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInputSecurityGroups(software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputSecurityGroupsPublisher publisher = client.listInputSecurityGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputSecurityGroupsPublisher publisher = client.listInputSecurityGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInputSecurityGroups(software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInputSecurityGroupsRequest
     *        Placeholder documentation for ListInputSecurityGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request to list Input Security Groups was invalid</li>
     *         <li>InternalServerErrorException Internal Server Error</li>
     *         <li>ForbiddenException The requester does not have permission to call ListInputSecurityGroups</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Limit Exceeded Error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInputSecurityGroupsPublisher listInputSecurityGroupsPaginator(
            ListInputSecurityGroupsRequest listInputSecurityGroupsRequest) {
        return new ListInputSecurityGroupsPublisher(this, listInputSecurityGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInputSecurityGroups(software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputSecurityGroupsPublisher publisher = client.listInputSecurityGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputSecurityGroupsPublisher publisher = client.listInputSecurityGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInputSecurityGroups(software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInputSecurityGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link ListInputSecurityGroupsRequest#builder()}
     * </p>
     *
     * @param listInputSecurityGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest.Builder} to create a
     *        request. Placeholder documentation for ListInputSecurityGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request to list Input Security Groups was invalid</li>
     *         <li>InternalServerErrorException Internal Server Error</li>
     *         <li>ForbiddenException The requester does not have permission to call ListInputSecurityGroups</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Limit Exceeded Error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInputSecurityGroupsPublisher listInputSecurityGroupsPaginator(
            Consumer<ListInputSecurityGroupsRequest.Builder> listInputSecurityGroupsRequest) {
        return listInputSecurityGroupsPaginator(ListInputSecurityGroupsRequest.builder()
                .applyMutation(listInputSecurityGroupsRequest).build());
    }

    /**
     * Produces list of inputs that have been created
     *
     * @param listInputsRequest
     *        Placeholder documentation for ListInputsRequest
     * @return A Java Future containing the result of the ListInputs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListInputsResponse> listInputs(ListInputsRequest listInputsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Produces list of inputs that have been created<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInputsRequest.Builder} avoiding the need to
     * create one manually via {@link ListInputsRequest#builder()}
     * </p>
     *
     * @param listInputsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListInputsRequest.Builder} to create a request.
     *        Placeholder documentation for ListInputsRequest
     * @return A Java Future containing the result of the ListInputs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListInputsResponse> listInputs(Consumer<ListInputsRequest.Builder> listInputsRequest) {
        return listInputs(ListInputsRequest.builder().applyMutation(listInputsRequest).build());
    }

    /**
     * Produces list of inputs that have been created
     *
     * @return A Java Future containing the result of the ListInputs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListInputsResponse> listInputs() {
        return listInputs(ListInputsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listInputs(software.amazon.awssdk.services.medialive.model.ListInputsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputsPublisher publisher = client.listInputsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputsPublisher publisher = client.listInputsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListInputsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListInputsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInputs(software.amazon.awssdk.services.medialive.model.ListInputsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInputsPublisher listInputsPaginator() {
        return listInputsPaginator(ListInputsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listInputs(software.amazon.awssdk.services.medialive.model.ListInputsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputsPublisher publisher = client.listInputsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputsPublisher publisher = client.listInputsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListInputsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListInputsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInputs(software.amazon.awssdk.services.medialive.model.ListInputsRequest)} operation.</b>
     * </p>
     *
     * @param listInputsRequest
     *        Placeholder documentation for ListInputsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInputsPublisher listInputsPaginator(ListInputsRequest listInputsRequest) {
        return new ListInputsPublisher(this, listInputsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listInputs(software.amazon.awssdk.services.medialive.model.ListInputsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputsPublisher publisher = client.listInputsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputsPublisher publisher = client.listInputsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListInputsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListInputsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInputs(software.amazon.awssdk.services.medialive.model.ListInputsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInputsRequest.Builder} avoiding the need to
     * create one manually via {@link ListInputsRequest#builder()}
     * </p>
     *
     * @param listInputsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListInputsRequest.Builder} to create a request.
     *        Placeholder documentation for ListInputsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInputsPublisher listInputsPaginator(Consumer<ListInputsRequest.Builder> listInputsRequest) {
        return listInputsPaginator(ListInputsRequest.builder().applyMutation(listInputsRequest).build());
    }

    /**
     * List the programs that currently exist for a specific multiplex.
     *
     * @param listMultiplexProgramsRequest
     *        Placeholder documentation for ListMultiplexProgramsRequest
     * @return A Java Future containing the result of the ListMultiplexPrograms operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to list multiplex programs.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException MediaLive can't provide the list of programs. The multiplex that you specified
     *         doesn’t exist. Check the ID and try again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list multiplex calls to multiplex service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListMultiplexPrograms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexPrograms"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMultiplexProgramsResponse> listMultiplexPrograms(
            ListMultiplexProgramsRequest listMultiplexProgramsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * List the programs that currently exist for a specific multiplex.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMultiplexProgramsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMultiplexProgramsRequest#builder()}
     * </p>
     *
     * @param listMultiplexProgramsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsRequest.Builder} to create a
     *        request. Placeholder documentation for ListMultiplexProgramsRequest
     * @return A Java Future containing the result of the ListMultiplexPrograms operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to list multiplex programs.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException MediaLive can't provide the list of programs. The multiplex that you specified
     *         doesn’t exist. Check the ID and try again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list multiplex calls to multiplex service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListMultiplexPrograms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexPrograms"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMultiplexProgramsResponse> listMultiplexPrograms(
            Consumer<ListMultiplexProgramsRequest.Builder> listMultiplexProgramsRequest) {
        return listMultiplexPrograms(ListMultiplexProgramsRequest.builder().applyMutation(listMultiplexProgramsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMultiplexPrograms(software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListMultiplexProgramsPublisher publisher = client.listMultiplexProgramsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListMultiplexProgramsPublisher publisher = client.listMultiplexProgramsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMultiplexPrograms(software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMultiplexProgramsRequest
     *        Placeholder documentation for ListMultiplexProgramsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to list multiplex programs.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException MediaLive can't provide the list of programs. The multiplex that you specified
     *         doesn’t exist. Check the ID and try again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list multiplex calls to multiplex service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListMultiplexPrograms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexPrograms"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMultiplexProgramsPublisher listMultiplexProgramsPaginator(
            ListMultiplexProgramsRequest listMultiplexProgramsRequest) {
        return new ListMultiplexProgramsPublisher(this, listMultiplexProgramsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMultiplexPrograms(software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListMultiplexProgramsPublisher publisher = client.listMultiplexProgramsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListMultiplexProgramsPublisher publisher = client.listMultiplexProgramsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMultiplexPrograms(software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMultiplexProgramsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMultiplexProgramsRequest#builder()}
     * </p>
     *
     * @param listMultiplexProgramsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsRequest.Builder} to create a
     *        request. Placeholder documentation for ListMultiplexProgramsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to list multiplex programs.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException MediaLive can't provide the list of programs. The multiplex that you specified
     *         doesn’t exist. Check the ID and try again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list multiplex calls to multiplex service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListMultiplexPrograms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexPrograms"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMultiplexProgramsPublisher listMultiplexProgramsPaginator(
            Consumer<ListMultiplexProgramsRequest.Builder> listMultiplexProgramsRequest) {
        return listMultiplexProgramsPaginator(ListMultiplexProgramsRequest.builder().applyMutation(listMultiplexProgramsRequest)
                .build());
    }

    /**
     * Retrieve a list of the existing multiplexes.
     *
     * @param listMultiplexesRequest
     *        Placeholder documentation for ListMultiplexesRequest
     * @return A Java Future containing the result of the ListMultiplexes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You don't have permission to list multiplexes.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list multiplex calls to multiplex service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListMultiplexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMultiplexesResponse> listMultiplexes(ListMultiplexesRequest listMultiplexesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieve a list of the existing multiplexes.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMultiplexesRequest.Builder} avoiding the need
     * to create one manually via {@link ListMultiplexesRequest#builder()}
     * </p>
     *
     * @param listMultiplexesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListMultiplexesRequest.Builder} to create a
     *        request. Placeholder documentation for ListMultiplexesRequest
     * @return A Java Future containing the result of the ListMultiplexes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You don't have permission to list multiplexes.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list multiplex calls to multiplex service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListMultiplexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMultiplexesResponse> listMultiplexes(
            Consumer<ListMultiplexesRequest.Builder> listMultiplexesRequest) {
        return listMultiplexes(ListMultiplexesRequest.builder().applyMutation(listMultiplexesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMultiplexes(software.amazon.awssdk.services.medialive.model.ListMultiplexesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListMultiplexesPublisher publisher = client.listMultiplexesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListMultiplexesPublisher publisher = client.listMultiplexesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListMultiplexesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListMultiplexesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMultiplexes(software.amazon.awssdk.services.medialive.model.ListMultiplexesRequest)} operation.</b>
     * </p>
     *
     * @param listMultiplexesRequest
     *        Placeholder documentation for ListMultiplexesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You don't have permission to list multiplexes.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list multiplex calls to multiplex service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListMultiplexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMultiplexesPublisher listMultiplexesPaginator(ListMultiplexesRequest listMultiplexesRequest) {
        return new ListMultiplexesPublisher(this, listMultiplexesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMultiplexes(software.amazon.awssdk.services.medialive.model.ListMultiplexesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListMultiplexesPublisher publisher = client.listMultiplexesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListMultiplexesPublisher publisher = client.listMultiplexesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListMultiplexesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListMultiplexesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMultiplexes(software.amazon.awssdk.services.medialive.model.ListMultiplexesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMultiplexesRequest.Builder} avoiding the need
     * to create one manually via {@link ListMultiplexesRequest#builder()}
     * </p>
     *
     * @param listMultiplexesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListMultiplexesRequest.Builder} to create a
     *        request. Placeholder documentation for ListMultiplexesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You don't have permission to list multiplexes.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list multiplex calls to multiplex service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListMultiplexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMultiplexesPublisher listMultiplexesPaginator(Consumer<ListMultiplexesRequest.Builder> listMultiplexesRequest) {
        return listMultiplexesPaginator(ListMultiplexesRequest.builder().applyMutation(listMultiplexesRequest).build());
    }

    /**
     * List offerings available for purchase.
     *
     * @param listOfferingsRequest
     *        Placeholder documentation for ListOfferingsRequest
     * @return A Java Future containing the result of the ListOfferings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to list offerings</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list offerings request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListOfferingsResponse> listOfferings(ListOfferingsRequest listOfferingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * List offerings available for purchase.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOfferingsRequest.Builder} avoiding the need to
     * create one manually via {@link ListOfferingsRequest#builder()}
     * </p>
     *
     * @param listOfferingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListOfferingsRequest.Builder} to create a request.
     *        Placeholder documentation for ListOfferingsRequest
     * @return A Java Future containing the result of the ListOfferings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to list offerings</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list offerings request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListOfferingsResponse> listOfferings(Consumer<ListOfferingsRequest.Builder> listOfferingsRequest) {
        return listOfferings(ListOfferingsRequest.builder().applyMutation(listOfferingsRequest).build());
    }

    /**
     * List offerings available for purchase.
     *
     * @return A Java Future containing the result of the ListOfferings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to list offerings</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list offerings request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListOfferingsResponse> listOfferings() {
        return listOfferings(ListOfferingsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listOfferings(software.amazon.awssdk.services.medialive.model.ListOfferingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListOfferingsPublisher publisher = client.listOfferingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListOfferingsPublisher publisher = client.listOfferingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListOfferingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListOfferingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOfferings(software.amazon.awssdk.services.medialive.model.ListOfferingsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to list offerings</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list offerings request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOfferingsPublisher listOfferingsPaginator() {
        return listOfferingsPaginator(ListOfferingsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listOfferings(software.amazon.awssdk.services.medialive.model.ListOfferingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListOfferingsPublisher publisher = client.listOfferingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListOfferingsPublisher publisher = client.listOfferingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListOfferingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListOfferingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOfferings(software.amazon.awssdk.services.medialive.model.ListOfferingsRequest)} operation.</b>
     * </p>
     *
     * @param listOfferingsRequest
     *        Placeholder documentation for ListOfferingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to list offerings</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list offerings request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOfferingsPublisher listOfferingsPaginator(ListOfferingsRequest listOfferingsRequest) {
        return new ListOfferingsPublisher(this, listOfferingsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listOfferings(software.amazon.awssdk.services.medialive.model.ListOfferingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListOfferingsPublisher publisher = client.listOfferingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListOfferingsPublisher publisher = client.listOfferingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListOfferingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListOfferingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOfferings(software.amazon.awssdk.services.medialive.model.ListOfferingsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOfferingsRequest.Builder} avoiding the need to
     * create one manually via {@link ListOfferingsRequest#builder()}
     * </p>
     *
     * @param listOfferingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListOfferingsRequest.Builder} to create a request.
     *        Placeholder documentation for ListOfferingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to list offerings</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list offerings request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOfferingsPublisher listOfferingsPaginator(Consumer<ListOfferingsRequest.Builder> listOfferingsRequest) {
        return listOfferingsPaginator(ListOfferingsRequest.builder().applyMutation(listOfferingsRequest).build());
    }

    /**
     * List purchased reservations.
     *
     * @param listReservationsRequest
     *        Placeholder documentation for ListReservationsRequest
     * @return A Java Future containing the result of the ListReservations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to list reservations</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list reservations request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListReservations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListReservations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListReservationsResponse> listReservations(ListReservationsRequest listReservationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * List purchased reservations.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReservationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListReservationsRequest#builder()}
     * </p>
     *
     * @param listReservationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListReservationsRequest.Builder} to create a
     *        request. Placeholder documentation for ListReservationsRequest
     * @return A Java Future containing the result of the ListReservations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to list reservations</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list reservations request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListReservations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListReservations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListReservationsResponse> listReservations(
            Consumer<ListReservationsRequest.Builder> listReservationsRequest) {
        return listReservations(ListReservationsRequest.builder().applyMutation(listReservationsRequest).build());
    }

    /**
     * List purchased reservations.
     *
     * @return A Java Future containing the result of the ListReservations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to list reservations</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list reservations request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListReservations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListReservations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListReservationsResponse> listReservations() {
        return listReservations(ListReservationsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listReservations(software.amazon.awssdk.services.medialive.model.ListReservationsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListReservationsPublisher publisher = client.listReservationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListReservationsPublisher publisher = client.listReservationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListReservationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListReservationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReservations(software.amazon.awssdk.services.medialive.model.ListReservationsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to list reservations</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list reservations request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListReservations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListReservations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListReservationsPublisher listReservationsPaginator() {
        return listReservationsPaginator(ListReservationsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listReservations(software.amazon.awssdk.services.medialive.model.ListReservationsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListReservationsPublisher publisher = client.listReservationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListReservationsPublisher publisher = client.listReservationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListReservationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListReservationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReservations(software.amazon.awssdk.services.medialive.model.ListReservationsRequest)} operation.</b>
     * </p>
     *
     * @param listReservationsRequest
     *        Placeholder documentation for ListReservationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to list reservations</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list reservations request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListReservations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListReservations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListReservationsPublisher listReservationsPaginator(ListReservationsRequest listReservationsRequest) {
        return new ListReservationsPublisher(this, listReservationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listReservations(software.amazon.awssdk.services.medialive.model.ListReservationsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListReservationsPublisher publisher = client.listReservationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListReservationsPublisher publisher = client.listReservationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListReservationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListReservationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReservations(software.amazon.awssdk.services.medialive.model.ListReservationsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReservationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListReservationsRequest#builder()}
     * </p>
     *
     * @param listReservationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListReservationsRequest.Builder} to create a
     *        request. Placeholder documentation for ListReservationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to list reservations</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list reservations request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListReservations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListReservations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListReservationsPublisher listReservationsPaginator(Consumer<ListReservationsRequest.Builder> listReservationsRequest) {
        return listReservationsPaginator(ListReservationsRequest.builder().applyMutation(listReservationsRequest).build());
    }

    /**
     * Lists signal maps.
     *
     * @param listSignalMapsRequest
     *        Placeholder documentation for ListSignalMapsRequest
     * @return A Java Future containing the result of the ListSignalMaps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListSignalMaps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListSignalMaps" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSignalMapsResponse> listSignalMaps(ListSignalMapsRequest listSignalMapsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists signal maps.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSignalMapsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSignalMapsRequest#builder()}
     * </p>
     *
     * @param listSignalMapsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListSignalMapsRequest.Builder} to create a request.
     *        Placeholder documentation for ListSignalMapsRequest
     * @return A Java Future containing the result of the ListSignalMaps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListSignalMaps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListSignalMaps" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSignalMapsResponse> listSignalMaps(Consumer<ListSignalMapsRequest.Builder> listSignalMapsRequest) {
        return listSignalMaps(ListSignalMapsRequest.builder().applyMutation(listSignalMapsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSignalMaps(software.amazon.awssdk.services.medialive.model.ListSignalMapsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListSignalMapsPublisher publisher = client.listSignalMapsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListSignalMapsPublisher publisher = client.listSignalMapsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListSignalMapsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListSignalMapsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSignalMaps(software.amazon.awssdk.services.medialive.model.ListSignalMapsRequest)} operation.</b>
     * </p>
     *
     * @param listSignalMapsRequest
     *        Placeholder documentation for ListSignalMapsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListSignalMaps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListSignalMaps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSignalMapsPublisher listSignalMapsPaginator(ListSignalMapsRequest listSignalMapsRequest) {
        return new ListSignalMapsPublisher(this, listSignalMapsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSignalMaps(software.amazon.awssdk.services.medialive.model.ListSignalMapsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListSignalMapsPublisher publisher = client.listSignalMapsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListSignalMapsPublisher publisher = client.listSignalMapsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListSignalMapsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListSignalMapsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSignalMaps(software.amazon.awssdk.services.medialive.model.ListSignalMapsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSignalMapsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSignalMapsRequest#builder()}
     * </p>
     *
     * @param listSignalMapsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListSignalMapsRequest.Builder} to create a request.
     *        Placeholder documentation for ListSignalMapsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListSignalMaps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListSignalMaps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSignalMapsPublisher listSignalMapsPaginator(Consumer<ListSignalMapsRequest.Builder> listSignalMapsRequest) {
        return listSignalMapsPaginator(ListSignalMapsRequest.builder().applyMutation(listSignalMapsRequest).build());
    }

    /**
     * Produces list of tags that have been created for a resource
     *
     * @param listTagsForResourceRequest
     *        Placeholder documentation for ListTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The arn was not found</li>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Produces list of tags that have been created for a resource<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListTagsForResourceRequest.Builder} to create a
     *        request. Placeholder documentation for ListTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The arn was not found</li>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * Purchase an offering and create a reservation.
     *
     * @param purchaseOfferingRequest
     *        Placeholder documentation for PurchaseOfferingRequest
     * @return A Java Future containing the result of the PurchaseOffering operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to purchase the offering</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>NotFoundException Offering you're attempting to purchase does not exist</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on purchase offering request</li>
     *         <li>ConflictException Offering purchase prevented by service resource issue</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.PurchaseOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/PurchaseOffering" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PurchaseOfferingResponse> purchaseOffering(PurchaseOfferingRequest purchaseOfferingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Purchase an offering and create a reservation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PurchaseOfferingRequest.Builder} avoiding the need
     * to create one manually via {@link PurchaseOfferingRequest#builder()}
     * </p>
     *
     * @param purchaseOfferingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.PurchaseOfferingRequest.Builder} to create a
     *        request. Placeholder documentation for PurchaseOfferingRequest
     * @return A Java Future containing the result of the PurchaseOffering operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to purchase the offering</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>NotFoundException Offering you're attempting to purchase does not exist</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on purchase offering request</li>
     *         <li>ConflictException Offering purchase prevented by service resource issue</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.PurchaseOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/PurchaseOffering" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PurchaseOfferingResponse> purchaseOffering(
            Consumer<PurchaseOfferingRequest.Builder> purchaseOfferingRequest) {
        return purchaseOffering(PurchaseOfferingRequest.builder().applyMutation(purchaseOfferingRequest).build());
    }

    /**
     * Send a reboot command to the specified input device. The device will begin rebooting within a few seconds of
     * sending the command. When the reboot is complete, the device’s connection status will change to connected.
     *
     * @param rebootInputDeviceRequest
     *        A request to reboot an AWS Elemental device.
     * @return A Java Future containing the result of the RebootInputDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException Reboot operation failed, input could not be validated.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to reboot input device.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException Input device not found.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on reboot device calls to the input device service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.RebootInputDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/RebootInputDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RebootInputDeviceResponse> rebootInputDevice(RebootInputDeviceRequest rebootInputDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Send a reboot command to the specified input device. The device will begin rebooting within a few seconds of
     * sending the command. When the reboot is complete, the device’s connection status will change to connected.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RebootInputDeviceRequest.Builder} avoiding the need
     * to create one manually via {@link RebootInputDeviceRequest#builder()}
     * </p>
     *
     * @param rebootInputDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.RebootInputDeviceRequest.Builder} to create a
     *        request. A request to reboot an AWS Elemental device.
     * @return A Java Future containing the result of the RebootInputDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException Reboot operation failed, input could not be validated.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to reboot input device.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException Input device not found.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on reboot device calls to the input device service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.RebootInputDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/RebootInputDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RebootInputDeviceResponse> rebootInputDevice(
            Consumer<RebootInputDeviceRequest.Builder> rebootInputDeviceRequest) {
        return rebootInputDevice(RebootInputDeviceRequest.builder().applyMutation(rebootInputDeviceRequest).build());
    }

    /**
     * Reject the transfer of the specified input device to your AWS account.
     *
     * @param rejectInputDeviceTransferRequest
     *        Placeholder documentation for RejectInputDeviceTransferRequest
     * @return A Java Future containing the result of the RejectInputDeviceTransfer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException Transfer operation failed, input could not be validated.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to reject input device transfers.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException Input device not found.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on transfer device calls to the input device service.
     *         </li>
     *         <li>ConflictException Input device transfer could not be rejected.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.RejectInputDeviceTransfer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/RejectInputDeviceTransfer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RejectInputDeviceTransferResponse> rejectInputDeviceTransfer(
            RejectInputDeviceTransferRequest rejectInputDeviceTransferRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Reject the transfer of the specified input device to your AWS account.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RejectInputDeviceTransferRequest.Builder} avoiding
     * the need to create one manually via {@link RejectInputDeviceTransferRequest#builder()}
     * </p>
     *
     * @param rejectInputDeviceTransferRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.RejectInputDeviceTransferRequest.Builder} to create
     *        a request. Placeholder documentation for RejectInputDeviceTransferRequest
     * @return A Java Future containing the result of the RejectInputDeviceTransfer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException Transfer operation failed, input could not be validated.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to reject input device transfers.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException Input device not found.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on transfer device calls to the input device service.
     *         </li>
     *         <li>ConflictException Input device transfer could not be rejected.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.RejectInputDeviceTransfer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/RejectInputDeviceTransfer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RejectInputDeviceTransferResponse> rejectInputDeviceTransfer(
            Consumer<RejectInputDeviceTransferRequest.Builder> rejectInputDeviceTransferRequest) {
        return rejectInputDeviceTransfer(RejectInputDeviceTransferRequest.builder()
                .applyMutation(rejectInputDeviceTransferRequest).build());
    }

    /**
     * Restart pipelines in one channel that is currently running.
     *
     * @param restartChannelPipelinesRequest
     *        Pipelines to restart.
     * @return A Java Future containing the result of the RestartChannelPipelines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Verify that the syntax is correct.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials that you sent.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The channel or pipeline you specified doesn't exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service could not complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.RestartChannelPipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/RestartChannelPipelines"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestartChannelPipelinesResponse> restartChannelPipelines(
            RestartChannelPipelinesRequest restartChannelPipelinesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Restart pipelines in one channel that is currently running.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestartChannelPipelinesRequest.Builder} avoiding
     * the need to create one manually via {@link RestartChannelPipelinesRequest#builder()}
     * </p>
     *
     * @param restartChannelPipelinesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.RestartChannelPipelinesRequest.Builder} to create a
     *        request. Pipelines to restart.
     * @return A Java Future containing the result of the RestartChannelPipelines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Verify that the syntax is correct.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials that you sent.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The channel or pipeline you specified doesn't exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service could not complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.RestartChannelPipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/RestartChannelPipelines"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestartChannelPipelinesResponse> restartChannelPipelines(
            Consumer<RestartChannelPipelinesRequest.Builder> restartChannelPipelinesRequest) {
        return restartChannelPipelines(RestartChannelPipelinesRequest.builder().applyMutation(restartChannelPipelinesRequest)
                .build());
    }

    /**
     * Starts an existing channel
     *
     * @param startChannelRequest
     *        Placeholder documentation for StartChannelRequest
     * @return A Java Future containing the result of the StartChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to start the channel.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The channel you're requesting to start does not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on start channel calls to channel service.</li>
     *         <li>ConflictException The channel is unable to start due to an issue with channel resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.StartChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartChannelResponse> startChannel(StartChannelRequest startChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Starts an existing channel<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartChannelRequest.Builder} avoiding the need to
     * create one manually via {@link StartChannelRequest#builder()}
     * </p>
     *
     * @param startChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.StartChannelRequest.Builder} to create a request.
     *        Placeholder documentation for StartChannelRequest
     * @return A Java Future containing the result of the StartChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to start the channel.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The channel you're requesting to start does not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on start channel calls to channel service.</li>
     *         <li>ConflictException The channel is unable to start due to an issue with channel resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.StartChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartChannelResponse> startChannel(Consumer<StartChannelRequest.Builder> startChannelRequest) {
        return startChannel(StartChannelRequest.builder().applyMutation(startChannelRequest).build());
    }

    /**
     * Initiates a deployment to delete the monitor of the specified signal map.
     *
     * @param startDeleteMonitorDeploymentRequest
     *        Placeholder documentation for StartDeleteMonitorDeploymentRequest
     * @return A Java Future containing the result of the StartDeleteMonitorDeployment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.StartDeleteMonitorDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartDeleteMonitorDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartDeleteMonitorDeploymentResponse> startDeleteMonitorDeployment(
            StartDeleteMonitorDeploymentRequest startDeleteMonitorDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Initiates a deployment to delete the monitor of the specified signal map.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDeleteMonitorDeploymentRequest.Builder}
     * avoiding the need to create one manually via {@link StartDeleteMonitorDeploymentRequest#builder()}
     * </p>
     *
     * @param startDeleteMonitorDeploymentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.StartDeleteMonitorDeploymentRequest.Builder} to
     *        create a request. Placeholder documentation for StartDeleteMonitorDeploymentRequest
     * @return A Java Future containing the result of the StartDeleteMonitorDeployment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.StartDeleteMonitorDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartDeleteMonitorDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartDeleteMonitorDeploymentResponse> startDeleteMonitorDeployment(
            Consumer<StartDeleteMonitorDeploymentRequest.Builder> startDeleteMonitorDeploymentRequest) {
        return startDeleteMonitorDeployment(StartDeleteMonitorDeploymentRequest.builder()
                .applyMutation(startDeleteMonitorDeploymentRequest).build());
    }

    /**
     * Start an input device that is attached to a MediaConnect flow. (There is no need to start a device that is
     * attached to a MediaLive input; MediaLive starts the device when the channel starts.)
     *
     * @param startInputDeviceRequest
     *        Placeholder documentation for StartInputDeviceRequest
     * @return A Java Future containing the result of the StartInputDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException Start operation failed, input could not be validated.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to start the input device.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException Input device not found.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on start device calls to the input device service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.StartInputDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartInputDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartInputDeviceResponse> startInputDevice(StartInputDeviceRequest startInputDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Start an input device that is attached to a MediaConnect flow. (There is no need to start a device that is
     * attached to a MediaLive input; MediaLive starts the device when the channel starts.)<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartInputDeviceRequest.Builder} avoiding the need
     * to create one manually via {@link StartInputDeviceRequest#builder()}
     * </p>
     *
     * @param startInputDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.StartInputDeviceRequest.Builder} to create a
     *        request. Placeholder documentation for StartInputDeviceRequest
     * @return A Java Future containing the result of the StartInputDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException Start operation failed, input could not be validated.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to start the input device.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException Input device not found.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on start device calls to the input device service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.StartInputDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartInputDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartInputDeviceResponse> startInputDevice(
            Consumer<StartInputDeviceRequest.Builder> startInputDeviceRequest) {
        return startInputDevice(StartInputDeviceRequest.builder().applyMutation(startInputDeviceRequest).build());
    }

    /**
     * Start a maintenance window for the specified input device. Starting a maintenance window will give the device up
     * to two hours to install software. If the device was streaming prior to the maintenance, it will resume streaming
     * when the software is fully installed. Devices automatically install updates while they are powered on and their
     * MediaLive channels are stopped. A maintenance window allows you to update a device without having to stop
     * MediaLive channels that use the device. The device must remain powered on and connected to the internet for the
     * duration of the maintenance.
     *
     * @param startInputDeviceMaintenanceWindowRequest
     *        Placeholder documentation for StartInputDeviceMaintenanceWindowRequest
     * @return A Java Future containing the result of the StartInputDeviceMaintenanceWindow operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException Start maintenance window operation failed, input could not be validated.
     *         </li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to start a maintenance window for this input device.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException Input device not found.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on start maintenance window calls to the input device
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.StartInputDeviceMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartInputDeviceMaintenanceWindow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartInputDeviceMaintenanceWindowResponse> startInputDeviceMaintenanceWindow(
            StartInputDeviceMaintenanceWindowRequest startInputDeviceMaintenanceWindowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Start a maintenance window for the specified input device. Starting a maintenance window will give the device up
     * to two hours to install software. If the device was streaming prior to the maintenance, it will resume streaming
     * when the software is fully installed. Devices automatically install updates while they are powered on and their
     * MediaLive channels are stopped. A maintenance window allows you to update a device without having to stop
     * MediaLive channels that use the device. The device must remain powered on and connected to the internet for the
     * duration of the maintenance.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartInputDeviceMaintenanceWindowRequest.Builder}
     * avoiding the need to create one manually via {@link StartInputDeviceMaintenanceWindowRequest#builder()}
     * </p>
     *
     * @param startInputDeviceMaintenanceWindowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.StartInputDeviceMaintenanceWindowRequest.Builder}
     *        to create a request. Placeholder documentation for StartInputDeviceMaintenanceWindowRequest
     * @return A Java Future containing the result of the StartInputDeviceMaintenanceWindow operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException Start maintenance window operation failed, input could not be validated.
     *         </li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to start a maintenance window for this input device.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException Input device not found.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on start maintenance window calls to the input device
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.StartInputDeviceMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartInputDeviceMaintenanceWindow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartInputDeviceMaintenanceWindowResponse> startInputDeviceMaintenanceWindow(
            Consumer<StartInputDeviceMaintenanceWindowRequest.Builder> startInputDeviceMaintenanceWindowRequest) {
        return startInputDeviceMaintenanceWindow(StartInputDeviceMaintenanceWindowRequest.builder()
                .applyMutation(startInputDeviceMaintenanceWindowRequest).build());
    }

    /**
     * Initiates a deployment to deploy the latest monitor of the specified signal map.
     *
     * @param startMonitorDeploymentRequest
     *        Placeholder documentation for StartMonitorDeploymentRequest
     * @return A Java Future containing the result of the StartMonitorDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.StartMonitorDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartMonitorDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartMonitorDeploymentResponse> startMonitorDeployment(
            StartMonitorDeploymentRequest startMonitorDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Initiates a deployment to deploy the latest monitor of the specified signal map.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMonitorDeploymentRequest.Builder} avoiding the
     * need to create one manually via {@link StartMonitorDeploymentRequest#builder()}
     * </p>
     *
     * @param startMonitorDeploymentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.StartMonitorDeploymentRequest.Builder} to create a
     *        request. Placeholder documentation for StartMonitorDeploymentRequest
     * @return A Java Future containing the result of the StartMonitorDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.StartMonitorDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartMonitorDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartMonitorDeploymentResponse> startMonitorDeployment(
            Consumer<StartMonitorDeploymentRequest.Builder> startMonitorDeploymentRequest) {
        return startMonitorDeployment(StartMonitorDeploymentRequest.builder().applyMutation(startMonitorDeploymentRequest)
                .build());
    }

    /**
     * Start (run) the multiplex. Starting the multiplex does not start the channels. You must explicitly start each
     * channel.
     *
     * @param startMultiplexRequest
     *        Placeholder documentation for StartMultiplexRequest
     * @return A Java Future containing the result of the StartMultiplex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You don't have permission to start the multiplex.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The multiplex that you are trying to start doesn’t exist. Check the ID and try
     *         again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on start multiplex calls to multiplex service.</li>
     *         <li>ConflictException The multiplex is unable to start due to an issue with multiplex resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.StartMultiplex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartMultiplexResponse> startMultiplex(StartMultiplexRequest startMultiplexRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Start (run) the multiplex. Starting the multiplex does not start the channels. You must explicitly start each
     * channel.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMultiplexRequest.Builder} avoiding the need to
     * create one manually via {@link StartMultiplexRequest#builder()}
     * </p>
     *
     * @param startMultiplexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.StartMultiplexRequest.Builder} to create a request.
     *        Placeholder documentation for StartMultiplexRequest
     * @return A Java Future containing the result of the StartMultiplex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You don't have permission to start the multiplex.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The multiplex that you are trying to start doesn’t exist. Check the ID and try
     *         again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on start multiplex calls to multiplex service.</li>
     *         <li>ConflictException The multiplex is unable to start due to an issue with multiplex resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.StartMultiplex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartMultiplexResponse> startMultiplex(Consumer<StartMultiplexRequest.Builder> startMultiplexRequest) {
        return startMultiplex(StartMultiplexRequest.builder().applyMutation(startMultiplexRequest).build());
    }

    /**
     * Initiates an update for the specified signal map. Will discover a new signal map if a changed
     * discoveryEntryPointArn is provided.
     *
     * @param startUpdateSignalMapRequest
     *        Placeholder documentation for StartUpdateSignalMapRequest
     * @return A Java Future containing the result of the StartUpdateSignalMap operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.StartUpdateSignalMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartUpdateSignalMap"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartUpdateSignalMapResponse> startUpdateSignalMap(
            StartUpdateSignalMapRequest startUpdateSignalMapRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Initiates an update for the specified signal map. Will discover a new signal map if a changed
     * discoveryEntryPointArn is provided.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartUpdateSignalMapRequest.Builder} avoiding the
     * need to create one manually via {@link StartUpdateSignalMapRequest#builder()}
     * </p>
     *
     * @param startUpdateSignalMapRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.StartUpdateSignalMapRequest.Builder} to create a
     *        request. Placeholder documentation for StartUpdateSignalMapRequest
     * @return A Java Future containing the result of the StartUpdateSignalMap operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.StartUpdateSignalMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartUpdateSignalMap"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartUpdateSignalMapResponse> startUpdateSignalMap(
            Consumer<StartUpdateSignalMapRequest.Builder> startUpdateSignalMapRequest) {
        return startUpdateSignalMap(StartUpdateSignalMapRequest.builder().applyMutation(startUpdateSignalMapRequest).build());
    }

    /**
     * Stops a running channel
     *
     * @param stopChannelRequest
     *        Placeholder documentation for StopChannelRequest
     * @return A Java Future containing the result of the StopChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to stop the channel.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The channel you're requesting to stop does not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on stop channel calls to channel service.</li>
     *         <li>ConflictException The channel is unable to stop due to an issue with channel resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.StopChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StopChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopChannelResponse> stopChannel(StopChannelRequest stopChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Stops a running channel<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopChannelRequest.Builder} avoiding the need to
     * create one manually via {@link StopChannelRequest#builder()}
     * </p>
     *
     * @param stopChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.StopChannelRequest.Builder} to create a request.
     *        Placeholder documentation for StopChannelRequest
     * @return A Java Future containing the result of the StopChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to stop the channel.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The channel you're requesting to stop does not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on stop channel calls to channel service.</li>
     *         <li>ConflictException The channel is unable to stop due to an issue with channel resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.StopChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StopChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopChannelResponse> stopChannel(Consumer<StopChannelRequest.Builder> stopChannelRequest) {
        return stopChannel(StopChannelRequest.builder().applyMutation(stopChannelRequest).build());
    }

    /**
     * Stop an input device that is attached to a MediaConnect flow. (There is no need to stop a device that is attached
     * to a MediaLive input; MediaLive automatically stops the device when the channel stops.)
     *
     * @param stopInputDeviceRequest
     *        Placeholder documentation for StopInputDeviceRequest
     * @return A Java Future containing the result of the StopInputDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException Start operation failed, input could not be validated.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to stop the input device.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException Input device not found.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on stop device calls to the input device service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.StopInputDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StopInputDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopInputDeviceResponse> stopInputDevice(StopInputDeviceRequest stopInputDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Stop an input device that is attached to a MediaConnect flow. (There is no need to stop a device that is attached
     * to a MediaLive input; MediaLive automatically stops the device when the channel stops.)<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopInputDeviceRequest.Builder} avoiding the need
     * to create one manually via {@link StopInputDeviceRequest#builder()}
     * </p>
     *
     * @param stopInputDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.StopInputDeviceRequest.Builder} to create a
     *        request. Placeholder documentation for StopInputDeviceRequest
     * @return A Java Future containing the result of the StopInputDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException Start operation failed, input could not be validated.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to stop the input device.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException Input device not found.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on stop device calls to the input device service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.StopInputDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StopInputDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopInputDeviceResponse> stopInputDevice(
            Consumer<StopInputDeviceRequest.Builder> stopInputDeviceRequest) {
        return stopInputDevice(StopInputDeviceRequest.builder().applyMutation(stopInputDeviceRequest).build());
    }

    /**
     * Stops a running multiplex. If the multiplex isn't running, this action has no effect.
     *
     * @param stopMultiplexRequest
     *        Placeholder documentation for StopMultiplexRequest
     * @return A Java Future containing the result of the StopMultiplex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You don't have permission to stop the multiplex.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The multiplex that you are trying to stop doesn’t exist. Check the ID and try
     *         again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on stop multiplex calls to multiplex service.</li>
     *         <li>ConflictException The multiplex is unable to stop due to an issue with multiplex resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.StopMultiplex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StopMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopMultiplexResponse> stopMultiplex(StopMultiplexRequest stopMultiplexRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Stops a running multiplex. If the multiplex isn't running, this action has no effect.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopMultiplexRequest.Builder} avoiding the need to
     * create one manually via {@link StopMultiplexRequest#builder()}
     * </p>
     *
     * @param stopMultiplexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.StopMultiplexRequest.Builder} to create a request.
     *        Placeholder documentation for StopMultiplexRequest
     * @return A Java Future containing the result of the StopMultiplex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You don't have permission to stop the multiplex.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The multiplex that you are trying to stop doesn’t exist. Check the ID and try
     *         again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on stop multiplex calls to multiplex service.</li>
     *         <li>ConflictException The multiplex is unable to stop due to an issue with multiplex resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.StopMultiplex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StopMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopMultiplexResponse> stopMultiplex(Consumer<StopMultiplexRequest.Builder> stopMultiplexRequest) {
        return stopMultiplex(StopMultiplexRequest.builder().applyMutation(stopMultiplexRequest).build());
    }

    /**
     * Start an input device transfer to another AWS account. After you make the request, the other account must accept
     * or reject the transfer.
     *
     * @param transferInputDeviceRequest
     *        A request to transfer an input device.
     * @return A Java Future containing the result of the TransferInputDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException Transfer operation failed, input could not be validated.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to transfer input devices.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException Input device not found.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on transfer device calls to the input device service.
     *         </li>
     *         <li>ConflictException Input device could not be transferred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.TransferInputDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/TransferInputDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TransferInputDeviceResponse> transferInputDevice(
            TransferInputDeviceRequest transferInputDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Start an input device transfer to another AWS account. After you make the request, the other account must accept
     * or reject the transfer.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TransferInputDeviceRequest.Builder} avoiding the
     * need to create one manually via {@link TransferInputDeviceRequest#builder()}
     * </p>
     *
     * @param transferInputDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.TransferInputDeviceRequest.Builder} to create a
     *        request. A request to transfer an input device.
     * @return A Java Future containing the result of the TransferInputDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException Transfer operation failed, input could not be validated.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to transfer input devices.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException Input device not found.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on transfer device calls to the input device service.
     *         </li>
     *         <li>ConflictException Input device could not be transferred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.TransferInputDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/TransferInputDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TransferInputDeviceResponse> transferInputDevice(
            Consumer<TransferInputDeviceRequest.Builder> transferInputDeviceRequest) {
        return transferInputDevice(TransferInputDeviceRequest.builder().applyMutation(transferInputDeviceRequest).build());
    }

    /**
     * Update account configuration
     *
     * @param updateAccountConfigurationRequest
     *        List of account configuration parameters to update.
     * @return A Java Future containing the result of the UpdateAccountConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException The update account configuration request failed validation.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to update the account's configuration.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on update account configuration calls.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateAccountConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateAccountConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAccountConfigurationResponse> updateAccountConfiguration(
            UpdateAccountConfigurationRequest updateAccountConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Update account configuration<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAccountConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateAccountConfigurationRequest#builder()}
     * </p>
     *
     * @param updateAccountConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.UpdateAccountConfigurationRequest.Builder} to
     *        create a request. List of account configuration parameters to update.
     * @return A Java Future containing the result of the UpdateAccountConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException The update account configuration request failed validation.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to update the account's configuration.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on update account configuration calls.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateAccountConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateAccountConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAccountConfigurationResponse> updateAccountConfiguration(
            Consumer<UpdateAccountConfigurationRequest.Builder> updateAccountConfigurationRequest) {
        return updateAccountConfiguration(UpdateAccountConfigurationRequest.builder()
                .applyMutation(updateAccountConfigurationRequest).build());
    }

    /**
     * Updates a channel.
     *
     * @param updateChannelRequest
     *        A request to update a channel.
     * @return A Java Future containing the result of the UpdateChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException The channel configuration failed validation and could not be updated.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to update the channel.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>ConflictException The channel is unable to update due to an issue with channel resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateChannelResponse> updateChannel(UpdateChannelRequest updateChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates a channel.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateChannelRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateChannelRequest#builder()}
     * </p>
     *
     * @param updateChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.UpdateChannelRequest.Builder} to create a request.
     *        A request to update a channel.
     * @return A Java Future containing the result of the UpdateChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException The channel configuration failed validation and could not be updated.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to update the channel.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>ConflictException The channel is unable to update due to an issue with channel resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateChannelResponse> updateChannel(Consumer<UpdateChannelRequest.Builder> updateChannelRequest) {
        return updateChannel(UpdateChannelRequest.builder().applyMutation(updateChannelRequest).build());
    }

    /**
     * Changes the class of the channel.
     *
     * @param updateChannelClassRequest
     *        Channel class that the channel should be updated to.
     * @return A Java Future containing the result of the UpdateChannelClass operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request to update the channel class was invalid.</li>
     *         <li>UnprocessableEntityException The channel configuration failed validation when attempting to update
     *         the channel class.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to update the class of this channel.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The channel you're trying to update the class on does not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on update channel class calls.</li>
     *         <li>ConflictException The channel class cannot be updated due to an issue with channel resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateChannelClass
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateChannelClass" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateChannelClassResponse> updateChannelClass(UpdateChannelClassRequest updateChannelClassRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Changes the class of the channel.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateChannelClassRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateChannelClassRequest#builder()}
     * </p>
     *
     * @param updateChannelClassRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.UpdateChannelClassRequest.Builder} to create a
     *        request. Channel class that the channel should be updated to.
     * @return A Java Future containing the result of the UpdateChannelClass operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request to update the channel class was invalid.</li>
     *         <li>UnprocessableEntityException The channel configuration failed validation when attempting to update
     *         the channel class.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to update the class of this channel.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The channel you're trying to update the class on does not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on update channel class calls.</li>
     *         <li>ConflictException The channel class cannot be updated due to an issue with channel resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateChannelClass
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateChannelClass" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateChannelClassResponse> updateChannelClass(
            Consumer<UpdateChannelClassRequest.Builder> updateChannelClassRequest) {
        return updateChannelClass(UpdateChannelClassRequest.builder().applyMutation(updateChannelClassRequest).build());
    }

    /**
     * Updates the specified cloudwatch alarm template.
     *
     * @param updateCloudWatchAlarmTemplateRequest
     *        Placeholder documentation for UpdateCloudWatchAlarmTemplateRequest
     * @return A Java Future containing the result of the UpdateCloudWatchAlarmTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateCloudWatchAlarmTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateCloudWatchAlarmTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCloudWatchAlarmTemplateResponse> updateCloudWatchAlarmTemplate(
            UpdateCloudWatchAlarmTemplateRequest updateCloudWatchAlarmTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates the specified cloudwatch alarm template.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCloudWatchAlarmTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateCloudWatchAlarmTemplateRequest#builder()}
     * </p>
     *
     * @param updateCloudWatchAlarmTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.UpdateCloudWatchAlarmTemplateRequest.Builder} to
     *        create a request. Placeholder documentation for UpdateCloudWatchAlarmTemplateRequest
     * @return A Java Future containing the result of the UpdateCloudWatchAlarmTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateCloudWatchAlarmTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateCloudWatchAlarmTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCloudWatchAlarmTemplateResponse> updateCloudWatchAlarmTemplate(
            Consumer<UpdateCloudWatchAlarmTemplateRequest.Builder> updateCloudWatchAlarmTemplateRequest) {
        return updateCloudWatchAlarmTemplate(UpdateCloudWatchAlarmTemplateRequest.builder()
                .applyMutation(updateCloudWatchAlarmTemplateRequest).build());
    }

    /**
     * Updates the specified cloudwatch alarm template group.
     *
     * @param updateCloudWatchAlarmTemplateGroupRequest
     *        Placeholder documentation for UpdateCloudWatchAlarmTemplateGroupRequest
     * @return A Java Future containing the result of the UpdateCloudWatchAlarmTemplateGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateCloudWatchAlarmTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateCloudWatchAlarmTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCloudWatchAlarmTemplateGroupResponse> updateCloudWatchAlarmTemplateGroup(
            UpdateCloudWatchAlarmTemplateGroupRequest updateCloudWatchAlarmTemplateGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates the specified cloudwatch alarm template group.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCloudWatchAlarmTemplateGroupRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateCloudWatchAlarmTemplateGroupRequest#builder()}
     * </p>
     *
     * @param updateCloudWatchAlarmTemplateGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.UpdateCloudWatchAlarmTemplateGroupRequest.Builder}
     *        to create a request. Placeholder documentation for UpdateCloudWatchAlarmTemplateGroupRequest
     * @return A Java Future containing the result of the UpdateCloudWatchAlarmTemplateGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateCloudWatchAlarmTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateCloudWatchAlarmTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCloudWatchAlarmTemplateGroupResponse> updateCloudWatchAlarmTemplateGroup(
            Consumer<UpdateCloudWatchAlarmTemplateGroupRequest.Builder> updateCloudWatchAlarmTemplateGroupRequest) {
        return updateCloudWatchAlarmTemplateGroup(UpdateCloudWatchAlarmTemplateGroupRequest.builder()
                .applyMutation(updateCloudWatchAlarmTemplateGroupRequest).build());
    }

    /**
     * Updates the specified eventbridge rule template.
     *
     * @param updateEventBridgeRuleTemplateRequest
     *        Placeholder documentation for UpdateEventBridgeRuleTemplateRequest
     * @return A Java Future containing the result of the UpdateEventBridgeRuleTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateEventBridgeRuleTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateEventBridgeRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEventBridgeRuleTemplateResponse> updateEventBridgeRuleTemplate(
            UpdateEventBridgeRuleTemplateRequest updateEventBridgeRuleTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates the specified eventbridge rule template.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEventBridgeRuleTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateEventBridgeRuleTemplateRequest#builder()}
     * </p>
     *
     * @param updateEventBridgeRuleTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.UpdateEventBridgeRuleTemplateRequest.Builder} to
     *        create a request. Placeholder documentation for UpdateEventBridgeRuleTemplateRequest
     * @return A Java Future containing the result of the UpdateEventBridgeRuleTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateEventBridgeRuleTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateEventBridgeRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEventBridgeRuleTemplateResponse> updateEventBridgeRuleTemplate(
            Consumer<UpdateEventBridgeRuleTemplateRequest.Builder> updateEventBridgeRuleTemplateRequest) {
        return updateEventBridgeRuleTemplate(UpdateEventBridgeRuleTemplateRequest.builder()
                .applyMutation(updateEventBridgeRuleTemplateRequest).build());
    }

    /**
     * Updates the specified eventbridge rule template group.
     *
     * @param updateEventBridgeRuleTemplateGroupRequest
     *        Placeholder documentation for UpdateEventBridgeRuleTemplateGroupRequest
     * @return A Java Future containing the result of the UpdateEventBridgeRuleTemplateGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateEventBridgeRuleTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateEventBridgeRuleTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEventBridgeRuleTemplateGroupResponse> updateEventBridgeRuleTemplateGroup(
            UpdateEventBridgeRuleTemplateGroupRequest updateEventBridgeRuleTemplateGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates the specified eventbridge rule template group.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEventBridgeRuleTemplateGroupRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateEventBridgeRuleTemplateGroupRequest#builder()}
     * </p>
     *
     * @param updateEventBridgeRuleTemplateGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.UpdateEventBridgeRuleTemplateGroupRequest.Builder}
     *        to create a request. Placeholder documentation for UpdateEventBridgeRuleTemplateGroupRequest
     * @return A Java Future containing the result of the UpdateEventBridgeRuleTemplateGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateEventBridgeRuleTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateEventBridgeRuleTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEventBridgeRuleTemplateGroupResponse> updateEventBridgeRuleTemplateGroup(
            Consumer<UpdateEventBridgeRuleTemplateGroupRequest.Builder> updateEventBridgeRuleTemplateGroupRequest) {
        return updateEventBridgeRuleTemplateGroup(UpdateEventBridgeRuleTemplateGroupRequest.builder()
                .applyMutation(updateEventBridgeRuleTemplateGroupRequest).build());
    }

    /**
     * Updates an input.
     *
     * @param updateInputRequest
     *        A request to update an input.
     * @return A Java Future containing the result of the UpdateInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request to update the input was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException The requester does not have permission to update an input.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The input was not found.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>ConflictException The input was unable to be updated at this time due to an issue with input
     *         resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInput" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateInputResponse> updateInput(UpdateInputRequest updateInputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates an input.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateInputRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateInputRequest#builder()}
     * </p>
     *
     * @param updateInputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.UpdateInputRequest.Builder} to create a request. A
     *        request to update an input.
     * @return A Java Future containing the result of the UpdateInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request to update the input was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException The requester does not have permission to update an input.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The input was not found.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>ConflictException The input was unable to be updated at this time due to an issue with input
     *         resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInput" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateInputResponse> updateInput(Consumer<UpdateInputRequest.Builder> updateInputRequest) {
        return updateInput(UpdateInputRequest.builder().applyMutation(updateInputRequest).build());
    }

    /**
     * Updates the parameters for the input device.
     *
     * @param updateInputDeviceRequest
     *        A request to update an input device.
     * @return A Java Future containing the result of the UpdateInputDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException Input device failed validation and could not be created.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to update the input device.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException The input device you're requesting to does not exist. Check the ID.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on update calls to the input device service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateInputDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInputDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateInputDeviceResponse> updateInputDevice(UpdateInputDeviceRequest updateInputDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates the parameters for the input device.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateInputDeviceRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateInputDeviceRequest#builder()}
     * </p>
     *
     * @param updateInputDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.UpdateInputDeviceRequest.Builder} to create a
     *        request. A request to update an input device.
     * @return A Java Future containing the result of the UpdateInputDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException Input device failed validation and could not be created.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to update the input device.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException The input device you're requesting to does not exist. Check the ID.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on update calls to the input device service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateInputDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInputDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateInputDeviceResponse> updateInputDevice(
            Consumer<UpdateInputDeviceRequest.Builder> updateInputDeviceRequest) {
        return updateInputDevice(UpdateInputDeviceRequest.builder().applyMutation(updateInputDeviceRequest).build());
    }

    /**
     * Update an Input Security Group's Whilelists.
     *
     * @param updateInputSecurityGroupRequest
     *        The request to update some combination of the Input Security Group name and the IPv4 CIDRs the Input
     *        Security Group should allow.
     * @return A Java Future containing the result of the UpdateInputSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request to update the Input Security Group was invalid</li>
     *         <li>InternalServerErrorException Internal Server Error</li>
     *         <li>ForbiddenException The requester does not have permission to update an Input Security Group</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The Input Security Group was not found.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>ConflictException The Input Security Group was unable to be updated due to an issue with input
     *         security group resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateInputSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateInputSecurityGroupResponse> updateInputSecurityGroup(
            UpdateInputSecurityGroupRequest updateInputSecurityGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Update an Input Security Group's Whilelists.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateInputSecurityGroupRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateInputSecurityGroupRequest#builder()}
     * </p>
     *
     * @param updateInputSecurityGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.UpdateInputSecurityGroupRequest.Builder} to create
     *        a request. The request to update some combination of the Input Security Group name and the IPv4 CIDRs the
     *        Input Security Group should allow.
     * @return A Java Future containing the result of the UpdateInputSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request to update the Input Security Group was invalid</li>
     *         <li>InternalServerErrorException Internal Server Error</li>
     *         <li>ForbiddenException The requester does not have permission to update an Input Security Group</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The Input Security Group was not found.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>ConflictException The Input Security Group was unable to be updated due to an issue with input
     *         security group resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateInputSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateInputSecurityGroupResponse> updateInputSecurityGroup(
            Consumer<UpdateInputSecurityGroupRequest.Builder> updateInputSecurityGroupRequest) {
        return updateInputSecurityGroup(UpdateInputSecurityGroupRequest.builder().applyMutation(updateInputSecurityGroupRequest)
                .build());
    }

    /**
     * Updates a multiplex.
     *
     * @param updateMultiplexRequest
     *        A request to update a multiplex.
     * @return A Java Future containing the result of the UpdateMultiplex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>UnprocessableEntityException The multiplex configuration failed validation and could not be updated.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You don't have permission to update the multiplex.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The multiplex that you are trying to update doesn’t exist. Check the ID and try
     *         again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>ConflictException The multiplex is unable to update due to an issue with multiplex resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateMultiplex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateMultiplexResponse> updateMultiplex(UpdateMultiplexRequest updateMultiplexRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates a multiplex.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMultiplexRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateMultiplexRequest#builder()}
     * </p>
     *
     * @param updateMultiplexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.UpdateMultiplexRequest.Builder} to create a
     *        request. A request to update a multiplex.
     * @return A Java Future containing the result of the UpdateMultiplex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>UnprocessableEntityException The multiplex configuration failed validation and could not be updated.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You don't have permission to update the multiplex.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The multiplex that you are trying to update doesn’t exist. Check the ID and try
     *         again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>ConflictException The multiplex is unable to update due to an issue with multiplex resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateMultiplex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateMultiplexResponse> updateMultiplex(
            Consumer<UpdateMultiplexRequest.Builder> updateMultiplexRequest) {
        return updateMultiplex(UpdateMultiplexRequest.builder().applyMutation(updateMultiplexRequest).build());
    }

    /**
     * Update a program in a multiplex.
     *
     * @param updateMultiplexProgramRequest
     *        A request to update a program in a multiplex.
     * @return A Java Future containing the result of the UpdateMultiplexProgram operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>UnprocessableEntityException The multiplex program failed validation and could not be updated.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You don't have permission to update the multiplex program.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException MediaLive can't update the program. The multiplex or the program that you specified
     *         doesn’t exist. Check the IDs and try again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>ConflictException The multiplex program is unable to update due to an issue with multiplex resources.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateMultiplexProgram
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateMultiplexProgramResponse> updateMultiplexProgram(
            UpdateMultiplexProgramRequest updateMultiplexProgramRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Update a program in a multiplex.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMultiplexProgramRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateMultiplexProgramRequest#builder()}
     * </p>
     *
     * @param updateMultiplexProgramRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.UpdateMultiplexProgramRequest.Builder} to create a
     *        request. A request to update a program in a multiplex.
     * @return A Java Future containing the result of the UpdateMultiplexProgram operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>UnprocessableEntityException The multiplex program failed validation and could not be updated.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You don't have permission to update the multiplex program.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException MediaLive can't update the program. The multiplex or the program that you specified
     *         doesn’t exist. Check the IDs and try again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>ConflictException The multiplex program is unable to update due to an issue with multiplex resources.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateMultiplexProgram
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateMultiplexProgramResponse> updateMultiplexProgram(
            Consumer<UpdateMultiplexProgramRequest.Builder> updateMultiplexProgramRequest) {
        return updateMultiplexProgram(UpdateMultiplexProgramRequest.builder().applyMutation(updateMultiplexProgramRequest)
                .build());
    }

    /**
     * Update reservation.
     *
     * @param updateReservationRequest
     *        Request to update a reservation
     * @return A Java Future containing the result of the UpdateReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to update reservation</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>NotFoundException Reservation not found</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded</li>
     *         <li>ConflictException The reservation could not be updated</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateReservation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateReservationResponse> updateReservation(UpdateReservationRequest updateReservationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Update reservation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateReservationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateReservationRequest#builder()}
     * </p>
     *
     * @param updateReservationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.UpdateReservationRequest.Builder} to create a
     *        request. Request to update a reservation
     * @return A Java Future containing the result of the UpdateReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to update reservation</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>NotFoundException Reservation not found</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded</li>
     *         <li>ConflictException The reservation could not be updated</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateReservation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateReservationResponse> updateReservation(
            Consumer<UpdateReservationRequest.Builder> updateReservationRequest) {
        return updateReservation(UpdateReservationRequest.builder().applyMutation(updateReservationRequest).build());
    }

    /**
     * Create an instance of {@link MediaLiveAsyncWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link MediaLiveAsyncWaiter}
     */
    default MediaLiveAsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    @Override
    default MediaLiveServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link MediaLiveAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MediaLiveAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MediaLiveAsyncClient}.
     */
    static MediaLiveAsyncClientBuilder builder() {
        return new DefaultMediaLiveAsyncClientBuilder();
    }
}
