/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for CreateEventBridgeRuleTemplateRequest
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEventBridgeRuleTemplateRequest extends MediaLiveRequest implements
        ToCopyableBuilder<CreateEventBridgeRuleTemplateRequest.Builder, CreateEventBridgeRuleTemplateRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateEventBridgeRuleTemplateRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<EventBridgeRuleTemplateTarget>> EVENT_TARGETS_FIELD = SdkField
            .<List<EventBridgeRuleTemplateTarget>> builder(MarshallingType.LIST)
            .memberName("EventTargets")
            .getter(getter(CreateEventBridgeRuleTemplateRequest::eventTargets))
            .setter(setter(Builder::eventTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTargets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventBridgeRuleTemplateTarget> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventBridgeRuleTemplateTarget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventType").getter(getter(CreateEventBridgeRuleTemplateRequest::eventTypeAsString))
            .setter(setter(Builder::eventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()).build();

    private static final SdkField<String> GROUP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupIdentifier").getter(getter(CreateEventBridgeRuleTemplateRequest::groupIdentifier))
            .setter(setter(Builder::groupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupIdentifier").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateEventBridgeRuleTemplateRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateEventBridgeRuleTemplateRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            EVENT_TARGETS_FIELD, EVENT_TYPE_FIELD, GROUP_IDENTIFIER_FIELD, NAME_FIELD, TAGS_FIELD));

    private final String description;

    private final List<EventBridgeRuleTemplateTarget> eventTargets;

    private final String eventType;

    private final String groupIdentifier;

    private final String name;

    private final Map<String, String> tags;

    private CreateEventBridgeRuleTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.eventTargets = builder.eventTargets;
        this.eventType = builder.eventType;
        this.groupIdentifier = builder.groupIdentifier;
        this.name = builder.name;
        this.tags = builder.tags;
    }

    /**
     * A resource's optional description.
     * 
     * @return A resource's optional description.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventTargets property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventTargets() {
        return eventTargets != null && !(eventTargets instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the EventTargets property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventTargets} method.
     * </p>
     * 
     * @return The value of the EventTargets property for this object.
     */
    public final List<EventBridgeRuleTemplateTarget> eventTargets() {
        return eventTargets;
    }

    /**
     * Returns the value of the EventType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link EventBridgeRuleTemplateEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The value of the EventType property for this object.
     * @see EventBridgeRuleTemplateEventType
     */
    public final EventBridgeRuleTemplateEventType eventType() {
        return EventBridgeRuleTemplateEventType.fromValue(eventType);
    }

    /**
     * Returns the value of the EventType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link EventBridgeRuleTemplateEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The value of the EventType property for this object.
     * @see EventBridgeRuleTemplateEventType
     */
    public final String eventTypeAsString() {
        return eventType;
    }

    /**
     * An eventbridge rule template group's identifier. Can be either be its id or current name.
     * 
     * @return An eventbridge rule template group's identifier. Can be either be its id or current name.
     */
    public final String groupIdentifier() {
        return groupIdentifier;
    }

    /**
     * A resource's name. Names must be unique within the scope of a resource type in a specific region.
     * 
     * @return A resource's name. Names must be unique within the scope of a resource type in a specific region.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasEventTargets() ? eventTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(groupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEventBridgeRuleTemplateRequest)) {
            return false;
        }
        CreateEventBridgeRuleTemplateRequest other = (CreateEventBridgeRuleTemplateRequest) obj;
        return Objects.equals(description(), other.description()) && hasEventTargets() == other.hasEventTargets()
                && Objects.equals(eventTargets(), other.eventTargets())
                && Objects.equals(eventTypeAsString(), other.eventTypeAsString())
                && Objects.equals(groupIdentifier(), other.groupIdentifier()) && Objects.equals(name(), other.name())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEventBridgeRuleTemplateRequest").add("Description", description())
                .add("EventTargets", hasEventTargets() ? eventTargets() : null).add("EventType", eventTypeAsString())
                .add("GroupIdentifier", groupIdentifier()).add("Name", name()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EventTargets":
            return Optional.ofNullable(clazz.cast(eventTargets()));
        case "EventType":
            return Optional.ofNullable(clazz.cast(eventTypeAsString()));
        case "GroupIdentifier":
            return Optional.ofNullable(clazz.cast(groupIdentifier()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEventBridgeRuleTemplateRequest, T> g) {
        return obj -> g.apply((CreateEventBridgeRuleTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateEventBridgeRuleTemplateRequest> {
        /**
         * A resource's optional description.
         * 
         * @param description
         *        A resource's optional description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the EventTargets property for this object.
         *
         * @param eventTargets
         *        The new value for the EventTargets property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTargets(Collection<EventBridgeRuleTemplateTarget> eventTargets);

        /**
         * Sets the value of the EventTargets property for this object.
         *
         * @param eventTargets
         *        The new value for the EventTargets property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTargets(EventBridgeRuleTemplateTarget... eventTargets);

        /**
         * Sets the value of the EventTargets property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.medialive.model.EventBridgeRuleTemplateTarget.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.medialive.model.EventBridgeRuleTemplateTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.EventBridgeRuleTemplateTarget.Builder#build()} is
         * called immediately and its result is passed to {@link #eventTargets(List<EventBridgeRuleTemplateTarget>)}.
         * 
         * @param eventTargets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.EventBridgeRuleTemplateTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventTargets(java.util.Collection<EventBridgeRuleTemplateTarget>)
         */
        Builder eventTargets(Consumer<EventBridgeRuleTemplateTarget.Builder>... eventTargets);

        /**
         * Sets the value of the EventType property for this object.
         *
         * @param eventType
         *        The new value for the EventType property for this object.
         * @see EventBridgeRuleTemplateEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventBridgeRuleTemplateEventType
         */
        Builder eventType(String eventType);

        /**
         * Sets the value of the EventType property for this object.
         *
         * @param eventType
         *        The new value for the EventType property for this object.
         * @see EventBridgeRuleTemplateEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventBridgeRuleTemplateEventType
         */
        Builder eventType(EventBridgeRuleTemplateEventType eventType);

        /**
         * An eventbridge rule template group's identifier. Can be either be its id or current name.
         * 
         * @param groupIdentifier
         *        An eventbridge rule template group's identifier. Can be either be its id or current name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupIdentifier(String groupIdentifier);

        /**
         * A resource's name. Names must be unique within the scope of a resource type in a specific region.
         * 
         * @param name
         *        A resource's name. Names must be unique within the scope of a resource type in a specific region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaLiveRequest.BuilderImpl implements Builder {
        private String description;

        private List<EventBridgeRuleTemplateTarget> eventTargets = DefaultSdkAutoConstructList.getInstance();

        private String eventType;

        private String groupIdentifier;

        private String name;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEventBridgeRuleTemplateRequest model) {
            super(model);
            description(model.description);
            eventTargets(model.eventTargets);
            eventType(model.eventType);
            groupIdentifier(model.groupIdentifier);
            name(model.name);
            tags(model.tags);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<EventBridgeRuleTemplateTarget.Builder> getEventTargets() {
            List<EventBridgeRuleTemplateTarget.Builder> result = ___listOfEventBridgeRuleTemplateTargetCopier
                    .copyToBuilder(this.eventTargets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventTargets(Collection<EventBridgeRuleTemplateTarget.BuilderImpl> eventTargets) {
            this.eventTargets = ___listOfEventBridgeRuleTemplateTargetCopier.copyFromBuilder(eventTargets);
        }

        @Override
        public final Builder eventTargets(Collection<EventBridgeRuleTemplateTarget> eventTargets) {
            this.eventTargets = ___listOfEventBridgeRuleTemplateTargetCopier.copy(eventTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTargets(EventBridgeRuleTemplateTarget... eventTargets) {
            eventTargets(Arrays.asList(eventTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTargets(Consumer<EventBridgeRuleTemplateTarget.Builder>... eventTargets) {
            eventTargets(Stream.of(eventTargets).map(c -> EventBridgeRuleTemplateTarget.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getEventType() {
            return eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(EventBridgeRuleTemplateEventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final String getGroupIdentifier() {
            return groupIdentifier;
        }

        public final void setGroupIdentifier(String groupIdentifier) {
            this.groupIdentifier = groupIdentifier;
        }

        @Override
        public final Builder groupIdentifier(String groupIdentifier) {
            this.groupIdentifier = groupIdentifier;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEventBridgeRuleTemplateRequest build() {
            return new CreateEventBridgeRuleTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
