/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A request to create a program in a multiplex.
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMultiplexProgramRequest extends MediaLiveRequest implements
        ToCopyableBuilder<CreateMultiplexProgramRequest.Builder, CreateMultiplexProgramRequest> {
    private static final SdkField<String> MULTIPLEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MultiplexId").getter(getter(CreateMultiplexProgramRequest::multiplexId))
            .setter(setter(Builder::multiplexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("multiplexId").build()).build();

    private static final SdkField<MultiplexProgramSettings> MULTIPLEX_PROGRAM_SETTINGS_FIELD = SdkField
            .<MultiplexProgramSettings> builder(MarshallingType.SDK_POJO).memberName("MultiplexProgramSettings")
            .getter(getter(CreateMultiplexProgramRequest::multiplexProgramSettings))
            .setter(setter(Builder::multiplexProgramSettings)).constructor(MultiplexProgramSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiplexProgramSettings").build())
            .build();

    private static final SdkField<String> PROGRAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProgramName").getter(getter(CreateMultiplexProgramRequest::programName))
            .setter(setter(Builder::programName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programName").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RequestId")
            .getter(getter(CreateMultiplexProgramRequest::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MULTIPLEX_ID_FIELD,
            MULTIPLEX_PROGRAM_SETTINGS_FIELD, PROGRAM_NAME_FIELD, REQUEST_ID_FIELD));

    private final String multiplexId;

    private final MultiplexProgramSettings multiplexProgramSettings;

    private final String programName;

    private final String requestId;

    private CreateMultiplexProgramRequest(BuilderImpl builder) {
        super(builder);
        this.multiplexId = builder.multiplexId;
        this.multiplexProgramSettings = builder.multiplexProgramSettings;
        this.programName = builder.programName;
        this.requestId = builder.requestId;
    }

    /**
     * ID of the multiplex where the program is to be created.
     * 
     * @return ID of the multiplex where the program is to be created.
     */
    public final String multiplexId() {
        return multiplexId;
    }

    /**
     * The settings for this multiplex program.
     * 
     * @return The settings for this multiplex program.
     */
    public final MultiplexProgramSettings multiplexProgramSettings() {
        return multiplexProgramSettings;
    }

    /**
     * Name of multiplex program.
     * 
     * @return Name of multiplex program.
     */
    public final String programName() {
        return programName;
    }

    /**
     * Unique request ID. This prevents retries from creating multiple resources.
     * 
     * @return Unique request ID. This prevents retries from creating multiple resources.
     */
    public final String requestId() {
        return requestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(multiplexId());
        hashCode = 31 * hashCode + Objects.hashCode(multiplexProgramSettings());
        hashCode = 31 * hashCode + Objects.hashCode(programName());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMultiplexProgramRequest)) {
            return false;
        }
        CreateMultiplexProgramRequest other = (CreateMultiplexProgramRequest) obj;
        return Objects.equals(multiplexId(), other.multiplexId())
                && Objects.equals(multiplexProgramSettings(), other.multiplexProgramSettings())
                && Objects.equals(programName(), other.programName()) && Objects.equals(requestId(), other.requestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMultiplexProgramRequest").add("MultiplexId", multiplexId())
                .add("MultiplexProgramSettings", multiplexProgramSettings()).add("ProgramName", programName())
                .add("RequestId", requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MultiplexId":
            return Optional.ofNullable(clazz.cast(multiplexId()));
        case "MultiplexProgramSettings":
            return Optional.ofNullable(clazz.cast(multiplexProgramSettings()));
        case "ProgramName":
            return Optional.ofNullable(clazz.cast(programName()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMultiplexProgramRequest, T> g) {
        return obj -> g.apply((CreateMultiplexProgramRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateMultiplexProgramRequest> {
        /**
         * ID of the multiplex where the program is to be created.
         * 
         * @param multiplexId
         *        ID of the multiplex where the program is to be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiplexId(String multiplexId);

        /**
         * The settings for this multiplex program.
         * 
         * @param multiplexProgramSettings
         *        The settings for this multiplex program.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiplexProgramSettings(MultiplexProgramSettings multiplexProgramSettings);

        /**
         * The settings for this multiplex program. This is a convenience method that creates an instance of the
         * {@link MultiplexProgramSettings.Builder} avoiding the need to create one manually via
         * {@link MultiplexProgramSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MultiplexProgramSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #multiplexProgramSettings(MultiplexProgramSettings)}.
         * 
         * @param multiplexProgramSettings
         *        a consumer that will call methods on {@link MultiplexProgramSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multiplexProgramSettings(MultiplexProgramSettings)
         */
        default Builder multiplexProgramSettings(Consumer<MultiplexProgramSettings.Builder> multiplexProgramSettings) {
            return multiplexProgramSettings(MultiplexProgramSettings.builder().applyMutation(multiplexProgramSettings).build());
        }

        /**
         * Name of multiplex program.
         * 
         * @param programName
         *        Name of multiplex program.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programName(String programName);

        /**
         * Unique request ID. This prevents retries from creating multiple resources.
         * 
         * @param requestId
         *        Unique request ID. This prevents retries from creating multiple resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaLiveRequest.BuilderImpl implements Builder {
        private String multiplexId;

        private MultiplexProgramSettings multiplexProgramSettings;

        private String programName;

        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMultiplexProgramRequest model) {
            super(model);
            multiplexId(model.multiplexId);
            multiplexProgramSettings(model.multiplexProgramSettings);
            programName(model.programName);
            requestId(model.requestId);
        }

        public final String getMultiplexId() {
            return multiplexId;
        }

        public final void setMultiplexId(String multiplexId) {
            this.multiplexId = multiplexId;
        }

        @Override
        public final Builder multiplexId(String multiplexId) {
            this.multiplexId = multiplexId;
            return this;
        }

        public final MultiplexProgramSettings.Builder getMultiplexProgramSettings() {
            return multiplexProgramSettings != null ? multiplexProgramSettings.toBuilder() : null;
        }

        public final void setMultiplexProgramSettings(MultiplexProgramSettings.BuilderImpl multiplexProgramSettings) {
            this.multiplexProgramSettings = multiplexProgramSettings != null ? multiplexProgramSettings.build() : null;
        }

        @Override
        public final Builder multiplexProgramSettings(MultiplexProgramSettings multiplexProgramSettings) {
            this.multiplexProgramSettings = multiplexProgramSettings;
            return this;
        }

        public final String getProgramName() {
            return programName;
        }

        public final void setProgramName(String programName) {
            this.programName = programName;
        }

        @Override
        public final Builder programName(String programName) {
            this.programName = programName;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMultiplexProgramRequest build() {
            return new CreateMultiplexProgramRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
