/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Eac3 Atmos Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class Eac3AtmosSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<Eac3AtmosSettings.Builder, Eac3AtmosSettings> {
    private static final SdkField<Double> BITRATE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Bitrate")
            .getter(getter(Eac3AtmosSettings::bitrate)).setter(setter(Builder::bitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrate").build()).build();

    private static final SdkField<String> CODING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodingMode").getter(getter(Eac3AtmosSettings::codingModeAsString)).setter(setter(Builder::codingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codingMode").build()).build();

    private static final SdkField<Integer> DIALNORM_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Dialnorm").getter(getter(Eac3AtmosSettings::dialnorm)).setter(setter(Builder::dialnorm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialnorm").build()).build();

    private static final SdkField<String> DRC_LINE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DrcLine").getter(getter(Eac3AtmosSettings::drcLineAsString)).setter(setter(Builder::drcLine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("drcLine").build()).build();

    private static final SdkField<String> DRC_RF_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("DrcRf")
            .getter(getter(Eac3AtmosSettings::drcRfAsString)).setter(setter(Builder::drcRf))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("drcRf").build()).build();

    private static final SdkField<Double> HEIGHT_TRIM_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("HeightTrim").getter(getter(Eac3AtmosSettings::heightTrim)).setter(setter(Builder::heightTrim))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("heightTrim").build()).build();

    private static final SdkField<Double> SURROUND_TRIM_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("SurroundTrim").getter(getter(Eac3AtmosSettings::surroundTrim)).setter(setter(Builder::surroundTrim))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("surroundTrim").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BITRATE_FIELD,
            CODING_MODE_FIELD, DIALNORM_FIELD, DRC_LINE_FIELD, DRC_RF_FIELD, HEIGHT_TRIM_FIELD, SURROUND_TRIM_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double bitrate;

    private final String codingMode;

    private final Integer dialnorm;

    private final String drcLine;

    private final String drcRf;

    private final Double heightTrim;

    private final Double surroundTrim;

    private Eac3AtmosSettings(BuilderImpl builder) {
        this.bitrate = builder.bitrate;
        this.codingMode = builder.codingMode;
        this.dialnorm = builder.dialnorm;
        this.drcLine = builder.drcLine;
        this.drcRf = builder.drcRf;
        this.heightTrim = builder.heightTrim;
        this.surroundTrim = builder.surroundTrim;
    }

    /**
     * Average bitrate in bits/second. Valid bitrates depend on the coding mode.
     * 
     * @return Average bitrate in bits/second. Valid bitrates depend on the coding mode.
     */
    public final Double bitrate() {
        return bitrate;
    }

    /**
     * Dolby Digital Plus with Dolby Atmos coding mode. Determines number of channels.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codingMode} will
     * return {@link Eac3AtmosCodingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #codingModeAsString}.
     * </p>
     * 
     * @return Dolby Digital Plus with Dolby Atmos coding mode. Determines number of channels.
     * @see Eac3AtmosCodingMode
     */
    public final Eac3AtmosCodingMode codingMode() {
        return Eac3AtmosCodingMode.fromValue(codingMode);
    }

    /**
     * Dolby Digital Plus with Dolby Atmos coding mode. Determines number of channels.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codingMode} will
     * return {@link Eac3AtmosCodingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #codingModeAsString}.
     * </p>
     * 
     * @return Dolby Digital Plus with Dolby Atmos coding mode. Determines number of channels.
     * @see Eac3AtmosCodingMode
     */
    public final String codingModeAsString() {
        return codingMode;
    }

    /**
     * Sets the dialnorm for the output. Default 23.
     * 
     * @return Sets the dialnorm for the output. Default 23.
     */
    public final Integer dialnorm() {
        return dialnorm;
    }

    /**
     * Sets the Dolby dynamic range compression profile.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #drcLine} will
     * return {@link Eac3AtmosDrcLine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #drcLineAsString}.
     * </p>
     * 
     * @return Sets the Dolby dynamic range compression profile.
     * @see Eac3AtmosDrcLine
     */
    public final Eac3AtmosDrcLine drcLine() {
        return Eac3AtmosDrcLine.fromValue(drcLine);
    }

    /**
     * Sets the Dolby dynamic range compression profile.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #drcLine} will
     * return {@link Eac3AtmosDrcLine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #drcLineAsString}.
     * </p>
     * 
     * @return Sets the Dolby dynamic range compression profile.
     * @see Eac3AtmosDrcLine
     */
    public final String drcLineAsString() {
        return drcLine;
    }

    /**
     * Sets the profile for heavy Dolby dynamic range compression, ensures that the instantaneous signal peaks do not
     * exceed specified levels.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #drcRf} will return
     * {@link Eac3AtmosDrcRf#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #drcRfAsString}.
     * </p>
     * 
     * @return Sets the profile for heavy Dolby dynamic range compression, ensures that the instantaneous signal peaks
     *         do not exceed specified levels.
     * @see Eac3AtmosDrcRf
     */
    public final Eac3AtmosDrcRf drcRf() {
        return Eac3AtmosDrcRf.fromValue(drcRf);
    }

    /**
     * Sets the profile for heavy Dolby dynamic range compression, ensures that the instantaneous signal peaks do not
     * exceed specified levels.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #drcRf} will return
     * {@link Eac3AtmosDrcRf#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #drcRfAsString}.
     * </p>
     * 
     * @return Sets the profile for heavy Dolby dynamic range compression, ensures that the instantaneous signal peaks
     *         do not exceed specified levels.
     * @see Eac3AtmosDrcRf
     */
    public final String drcRfAsString() {
        return drcRf;
    }

    /**
     * Height dimensional trim. Sets the maximum amount to attenuate the height channels when the downstream player
     * isn??t configured to handle Dolby Digital Plus with Dolby Atmos and must remix the channels.
     * 
     * @return Height dimensional trim. Sets the maximum amount to attenuate the height channels when the downstream
     *         player isn??t configured to handle Dolby Digital Plus with Dolby Atmos and must remix the channels.
     */
    public final Double heightTrim() {
        return heightTrim;
    }

    /**
     * Surround dimensional trim. Sets the maximum amount to attenuate the surround channels when the downstream player
     * isn't configured to handle Dolby Digital Plus with Dolby Atmos and must remix the channels.
     * 
     * @return Surround dimensional trim. Sets the maximum amount to attenuate the surround channels when the downstream
     *         player isn't configured to handle Dolby Digital Plus with Dolby Atmos and must remix the channels.
     */
    public final Double surroundTrim() {
        return surroundTrim;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(codingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dialnorm());
        hashCode = 31 * hashCode + Objects.hashCode(drcLineAsString());
        hashCode = 31 * hashCode + Objects.hashCode(drcRfAsString());
        hashCode = 31 * hashCode + Objects.hashCode(heightTrim());
        hashCode = 31 * hashCode + Objects.hashCode(surroundTrim());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Eac3AtmosSettings)) {
            return false;
        }
        Eac3AtmosSettings other = (Eac3AtmosSettings) obj;
        return Objects.equals(bitrate(), other.bitrate()) && Objects.equals(codingModeAsString(), other.codingModeAsString())
                && Objects.equals(dialnorm(), other.dialnorm()) && Objects.equals(drcLineAsString(), other.drcLineAsString())
                && Objects.equals(drcRfAsString(), other.drcRfAsString()) && Objects.equals(heightTrim(), other.heightTrim())
                && Objects.equals(surroundTrim(), other.surroundTrim());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Eac3AtmosSettings").add("Bitrate", bitrate()).add("CodingMode", codingModeAsString())
                .add("Dialnorm", dialnorm()).add("DrcLine", drcLineAsString()).add("DrcRf", drcRfAsString())
                .add("HeightTrim", heightTrim()).add("SurroundTrim", surroundTrim()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bitrate":
            return Optional.ofNullable(clazz.cast(bitrate()));
        case "CodingMode":
            return Optional.ofNullable(clazz.cast(codingModeAsString()));
        case "Dialnorm":
            return Optional.ofNullable(clazz.cast(dialnorm()));
        case "DrcLine":
            return Optional.ofNullable(clazz.cast(drcLineAsString()));
        case "DrcRf":
            return Optional.ofNullable(clazz.cast(drcRfAsString()));
        case "HeightTrim":
            return Optional.ofNullable(clazz.cast(heightTrim()));
        case "SurroundTrim":
            return Optional.ofNullable(clazz.cast(surroundTrim()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Eac3AtmosSettings, T> g) {
        return obj -> g.apply((Eac3AtmosSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Eac3AtmosSettings> {
        /**
         * Average bitrate in bits/second. Valid bitrates depend on the coding mode.
         * 
         * @param bitrate
         *        Average bitrate in bits/second. Valid bitrates depend on the coding mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bitrate(Double bitrate);

        /**
         * Dolby Digital Plus with Dolby Atmos coding mode. Determines number of channels.
         * 
         * @param codingMode
         *        Dolby Digital Plus with Dolby Atmos coding mode. Determines number of channels.
         * @see Eac3AtmosCodingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosCodingMode
         */
        Builder codingMode(String codingMode);

        /**
         * Dolby Digital Plus with Dolby Atmos coding mode. Determines number of channels.
         * 
         * @param codingMode
         *        Dolby Digital Plus with Dolby Atmos coding mode. Determines number of channels.
         * @see Eac3AtmosCodingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosCodingMode
         */
        Builder codingMode(Eac3AtmosCodingMode codingMode);

        /**
         * Sets the dialnorm for the output. Default 23.
         * 
         * @param dialnorm
         *        Sets the dialnorm for the output. Default 23.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dialnorm(Integer dialnorm);

        /**
         * Sets the Dolby dynamic range compression profile.
         * 
         * @param drcLine
         *        Sets the Dolby dynamic range compression profile.
         * @see Eac3AtmosDrcLine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosDrcLine
         */
        Builder drcLine(String drcLine);

        /**
         * Sets the Dolby dynamic range compression profile.
         * 
         * @param drcLine
         *        Sets the Dolby dynamic range compression profile.
         * @see Eac3AtmosDrcLine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosDrcLine
         */
        Builder drcLine(Eac3AtmosDrcLine drcLine);

        /**
         * Sets the profile for heavy Dolby dynamic range compression, ensures that the instantaneous signal peaks do
         * not exceed specified levels.
         * 
         * @param drcRf
         *        Sets the profile for heavy Dolby dynamic range compression, ensures that the instantaneous signal
         *        peaks do not exceed specified levels.
         * @see Eac3AtmosDrcRf
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosDrcRf
         */
        Builder drcRf(String drcRf);

        /**
         * Sets the profile for heavy Dolby dynamic range compression, ensures that the instantaneous signal peaks do
         * not exceed specified levels.
         * 
         * @param drcRf
         *        Sets the profile for heavy Dolby dynamic range compression, ensures that the instantaneous signal
         *        peaks do not exceed specified levels.
         * @see Eac3AtmosDrcRf
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosDrcRf
         */
        Builder drcRf(Eac3AtmosDrcRf drcRf);

        /**
         * Height dimensional trim. Sets the maximum amount to attenuate the height channels when the downstream player
         * isn??t configured to handle Dolby Digital Plus with Dolby Atmos and must remix the channels.
         * 
         * @param heightTrim
         *        Height dimensional trim. Sets the maximum amount to attenuate the height channels when the downstream
         *        player isn??t configured to handle Dolby Digital Plus with Dolby Atmos and must remix the channels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder heightTrim(Double heightTrim);

        /**
         * Surround dimensional trim. Sets the maximum amount to attenuate the surround channels when the downstream
         * player isn't configured to handle Dolby Digital Plus with Dolby Atmos and must remix the channels.
         * 
         * @param surroundTrim
         *        Surround dimensional trim. Sets the maximum amount to attenuate the surround channels when the
         *        downstream player isn't configured to handle Dolby Digital Plus with Dolby Atmos and must remix the
         *        channels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder surroundTrim(Double surroundTrim);
    }

    static final class BuilderImpl implements Builder {
        private Double bitrate;

        private String codingMode;

        private Integer dialnorm;

        private String drcLine;

        private String drcRf;

        private Double heightTrim;

        private Double surroundTrim;

        private BuilderImpl() {
        }

        private BuilderImpl(Eac3AtmosSettings model) {
            bitrate(model.bitrate);
            codingMode(model.codingMode);
            dialnorm(model.dialnorm);
            drcLine(model.drcLine);
            drcRf(model.drcRf);
            heightTrim(model.heightTrim);
            surroundTrim(model.surroundTrim);
        }

        public final Double getBitrate() {
            return bitrate;
        }

        public final void setBitrate(Double bitrate) {
            this.bitrate = bitrate;
        }

        @Override
        public final Builder bitrate(Double bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final String getCodingMode() {
            return codingMode;
        }

        public final void setCodingMode(String codingMode) {
            this.codingMode = codingMode;
        }

        @Override
        public final Builder codingMode(String codingMode) {
            this.codingMode = codingMode;
            return this;
        }

        @Override
        public final Builder codingMode(Eac3AtmosCodingMode codingMode) {
            this.codingMode(codingMode == null ? null : codingMode.toString());
            return this;
        }

        public final Integer getDialnorm() {
            return dialnorm;
        }

        public final void setDialnorm(Integer dialnorm) {
            this.dialnorm = dialnorm;
        }

        @Override
        public final Builder dialnorm(Integer dialnorm) {
            this.dialnorm = dialnorm;
            return this;
        }

        public final String getDrcLine() {
            return drcLine;
        }

        public final void setDrcLine(String drcLine) {
            this.drcLine = drcLine;
        }

        @Override
        public final Builder drcLine(String drcLine) {
            this.drcLine = drcLine;
            return this;
        }

        @Override
        public final Builder drcLine(Eac3AtmosDrcLine drcLine) {
            this.drcLine(drcLine == null ? null : drcLine.toString());
            return this;
        }

        public final String getDrcRf() {
            return drcRf;
        }

        public final void setDrcRf(String drcRf) {
            this.drcRf = drcRf;
        }

        @Override
        public final Builder drcRf(String drcRf) {
            this.drcRf = drcRf;
            return this;
        }

        @Override
        public final Builder drcRf(Eac3AtmosDrcRf drcRf) {
            this.drcRf(drcRf == null ? null : drcRf.toString());
            return this;
        }

        public final Double getHeightTrim() {
            return heightTrim;
        }

        public final void setHeightTrim(Double heightTrim) {
            this.heightTrim = heightTrim;
        }

        @Override
        public final Builder heightTrim(Double heightTrim) {
            this.heightTrim = heightTrim;
            return this;
        }

        public final Double getSurroundTrim() {
            return surroundTrim;
        }

        public final void setSurroundTrim(Double surroundTrim) {
            this.surroundTrim = surroundTrim;
        }

        @Override
        public final Builder surroundTrim(Double surroundTrim) {
            this.surroundTrim = surroundTrim;
            return this;
        }

        @Override
        public Eac3AtmosSettings build() {
            return new Eac3AtmosSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
