/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * H264 Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class H264Settings implements SdkPojo, Serializable, ToCopyableBuilder<H264Settings.Builder, H264Settings> {
    private static final SdkField<String> ADAPTIVE_QUANTIZATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdaptiveQuantization").getter(getter(H264Settings::adaptiveQuantizationAsString))
            .setter(setter(Builder::adaptiveQuantization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adaptiveQuantization").build())
            .build();

    private static final SdkField<String> AFD_SIGNALING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AfdSignaling").getter(getter(H264Settings::afdSignalingAsString)).setter(setter(Builder::afdSignaling))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afdSignaling").build()).build();

    private static final SdkField<Integer> BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Bitrate").getter(getter(H264Settings::bitrate)).setter(setter(Builder::bitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrate").build()).build();

    private static final SdkField<Integer> BUF_FILL_PCT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BufFillPct").getter(getter(H264Settings::bufFillPct)).setter(setter(Builder::bufFillPct))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bufFillPct").build()).build();

    private static final SdkField<Integer> BUF_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BufSize").getter(getter(H264Settings::bufSize)).setter(setter(Builder::bufSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bufSize").build()).build();

    private static final SdkField<String> COLOR_METADATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColorMetadata").getter(getter(H264Settings::colorMetadataAsString))
            .setter(setter(Builder::colorMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorMetadata").build()).build();

    private static final SdkField<H264ColorSpaceSettings> COLOR_SPACE_SETTINGS_FIELD = SdkField
            .<H264ColorSpaceSettings> builder(MarshallingType.SDK_POJO).memberName("ColorSpaceSettings")
            .getter(getter(H264Settings::colorSpaceSettings)).setter(setter(Builder::colorSpaceSettings))
            .constructor(H264ColorSpaceSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorSpaceSettings").build())
            .build();

    private static final SdkField<String> ENTROPY_ENCODING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntropyEncoding").getter(getter(H264Settings::entropyEncodingAsString))
            .setter(setter(Builder::entropyEncoding))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entropyEncoding").build()).build();

    private static final SdkField<H264FilterSettings> FILTER_SETTINGS_FIELD = SdkField
            .<H264FilterSettings> builder(MarshallingType.SDK_POJO).memberName("FilterSettings")
            .getter(getter(H264Settings::filterSettings)).setter(setter(Builder::filterSettings))
            .constructor(H264FilterSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterSettings").build()).build();

    private static final SdkField<String> FIXED_AFD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FixedAfd").getter(getter(H264Settings::fixedAfdAsString)).setter(setter(Builder::fixedAfd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fixedAfd").build()).build();

    private static final SdkField<String> FLICKER_AQ_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlickerAq").getter(getter(H264Settings::flickerAqAsString)).setter(setter(Builder::flickerAq))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flickerAq").build()).build();

    private static final SdkField<String> FORCE_FIELD_PICTURES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ForceFieldPictures").getter(getter(H264Settings::forceFieldPicturesAsString))
            .setter(setter(Builder::forceFieldPictures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forceFieldPictures").build())
            .build();

    private static final SdkField<String> FRAMERATE_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FramerateControl").getter(getter(H264Settings::framerateControlAsString))
            .setter(setter(Builder::framerateControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateControl").build()).build();

    private static final SdkField<Integer> FRAMERATE_DENOMINATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FramerateDenominator").getter(getter(H264Settings::framerateDenominator))
            .setter(setter(Builder::framerateDenominator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateDenominator").build())
            .build();

    private static final SdkField<Integer> FRAMERATE_NUMERATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FramerateNumerator").getter(getter(H264Settings::framerateNumerator))
            .setter(setter(Builder::framerateNumerator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateNumerator").build())
            .build();

    private static final SdkField<String> GOP_B_REFERENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GopBReference").getter(getter(H264Settings::gopBReferenceAsString))
            .setter(setter(Builder::gopBReference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopBReference").build()).build();

    private static final SdkField<Integer> GOP_CLOSED_CADENCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("GopClosedCadence").getter(getter(H264Settings::gopClosedCadence))
            .setter(setter(Builder::gopClosedCadence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopClosedCadence").build()).build();

    private static final SdkField<Integer> GOP_NUM_B_FRAMES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("GopNumBFrames").getter(getter(H264Settings::gopNumBFrames)).setter(setter(Builder::gopNumBFrames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopNumBFrames").build()).build();

    private static final SdkField<Double> GOP_SIZE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("GopSize").getter(getter(H264Settings::gopSize)).setter(setter(Builder::gopSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopSize").build()).build();

    private static final SdkField<String> GOP_SIZE_UNITS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GopSizeUnits").getter(getter(H264Settings::gopSizeUnitsAsString)).setter(setter(Builder::gopSizeUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopSizeUnits").build()).build();

    private static final SdkField<String> LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Level")
            .getter(getter(H264Settings::levelAsString)).setter(setter(Builder::level))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("level").build()).build();

    private static final SdkField<String> LOOK_AHEAD_RATE_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LookAheadRateControl").getter(getter(H264Settings::lookAheadRateControlAsString))
            .setter(setter(Builder::lookAheadRateControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lookAheadRateControl").build())
            .build();

    private static final SdkField<Integer> MAX_BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxBitrate").getter(getter(H264Settings::maxBitrate)).setter(setter(Builder::maxBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBitrate").build()).build();

    private static final SdkField<Integer> MIN_I_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinIInterval").getter(getter(H264Settings::minIInterval)).setter(setter(Builder::minIInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minIInterval").build()).build();

    private static final SdkField<Integer> NUM_REF_FRAMES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumRefFrames").getter(getter(H264Settings::numRefFrames)).setter(setter(Builder::numRefFrames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numRefFrames").build()).build();

    private static final SdkField<String> PAR_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParControl").getter(getter(H264Settings::parControlAsString)).setter(setter(Builder::parControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parControl").build()).build();

    private static final SdkField<Integer> PAR_DENOMINATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ParDenominator").getter(getter(H264Settings::parDenominator)).setter(setter(Builder::parDenominator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parDenominator").build()).build();

    private static final SdkField<Integer> PAR_NUMERATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ParNumerator").getter(getter(H264Settings::parNumerator)).setter(setter(Builder::parNumerator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parNumerator").build()).build();

    private static final SdkField<String> PROFILE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Profile")
            .getter(getter(H264Settings::profileAsString)).setter(setter(Builder::profile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profile").build()).build();

    private static final SdkField<String> QUALITY_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QualityLevel").getter(getter(H264Settings::qualityLevelAsString)).setter(setter(Builder::qualityLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qualityLevel").build()).build();

    private static final SdkField<Integer> QVBR_QUALITY_LEVEL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("QvbrQualityLevel").getter(getter(H264Settings::qvbrQualityLevel))
            .setter(setter(Builder::qvbrQualityLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qvbrQualityLevel").build()).build();

    private static final SdkField<String> RATE_CONTROL_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RateControlMode").getter(getter(H264Settings::rateControlModeAsString))
            .setter(setter(Builder::rateControlMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateControlMode").build()).build();

    private static final SdkField<String> SCAN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScanType").getter(getter(H264Settings::scanTypeAsString)).setter(setter(Builder::scanType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanType").build()).build();

    private static final SdkField<String> SCENE_CHANGE_DETECT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SceneChangeDetect").getter(getter(H264Settings::sceneChangeDetectAsString))
            .setter(setter(Builder::sceneChangeDetect))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sceneChangeDetect").build()).build();

    private static final SdkField<Integer> SLICES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Slices").getter(getter(H264Settings::slices)).setter(setter(Builder::slices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slices").build()).build();

    private static final SdkField<Integer> SOFTNESS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Softness").getter(getter(H264Settings::softness)).setter(setter(Builder::softness))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("softness").build()).build();

    private static final SdkField<String> SPATIAL_AQ_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SpatialAq").getter(getter(H264Settings::spatialAqAsString)).setter(setter(Builder::spatialAq))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spatialAq").build()).build();

    private static final SdkField<String> SUBGOP_LENGTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubgopLength").getter(getter(H264Settings::subgopLengthAsString)).setter(setter(Builder::subgopLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subgopLength").build()).build();

    private static final SdkField<String> SYNTAX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Syntax")
            .getter(getter(H264Settings::syntaxAsString)).setter(setter(Builder::syntax))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syntax").build()).build();

    private static final SdkField<String> TEMPORAL_AQ_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemporalAq").getter(getter(H264Settings::temporalAqAsString)).setter(setter(Builder::temporalAq))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("temporalAq").build()).build();

    private static final SdkField<String> TIMECODE_INSERTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimecodeInsertion").getter(getter(H264Settings::timecodeInsertionAsString))
            .setter(setter(Builder::timecodeInsertion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecodeInsertion").build()).build();

    private static final SdkField<TimecodeBurninSettings> TIMECODE_BURNIN_SETTINGS_FIELD = SdkField
            .<TimecodeBurninSettings> builder(MarshallingType.SDK_POJO).memberName("TimecodeBurninSettings")
            .getter(getter(H264Settings::timecodeBurninSettings)).setter(setter(Builder::timecodeBurninSettings))
            .constructor(TimecodeBurninSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecodeBurninSettings").build())
            .build();

    private static final SdkField<Integer> MIN_QP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("MinQp")
            .getter(getter(H264Settings::minQp)).setter(setter(Builder::minQp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minQp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADAPTIVE_QUANTIZATION_FIELD,
            AFD_SIGNALING_FIELD, BITRATE_FIELD, BUF_FILL_PCT_FIELD, BUF_SIZE_FIELD, COLOR_METADATA_FIELD,
            COLOR_SPACE_SETTINGS_FIELD, ENTROPY_ENCODING_FIELD, FILTER_SETTINGS_FIELD, FIXED_AFD_FIELD, FLICKER_AQ_FIELD,
            FORCE_FIELD_PICTURES_FIELD, FRAMERATE_CONTROL_FIELD, FRAMERATE_DENOMINATOR_FIELD, FRAMERATE_NUMERATOR_FIELD,
            GOP_B_REFERENCE_FIELD, GOP_CLOSED_CADENCE_FIELD, GOP_NUM_B_FRAMES_FIELD, GOP_SIZE_FIELD, GOP_SIZE_UNITS_FIELD,
            LEVEL_FIELD, LOOK_AHEAD_RATE_CONTROL_FIELD, MAX_BITRATE_FIELD, MIN_I_INTERVAL_FIELD, NUM_REF_FRAMES_FIELD,
            PAR_CONTROL_FIELD, PAR_DENOMINATOR_FIELD, PAR_NUMERATOR_FIELD, PROFILE_FIELD, QUALITY_LEVEL_FIELD,
            QVBR_QUALITY_LEVEL_FIELD, RATE_CONTROL_MODE_FIELD, SCAN_TYPE_FIELD, SCENE_CHANGE_DETECT_FIELD, SLICES_FIELD,
            SOFTNESS_FIELD, SPATIAL_AQ_FIELD, SUBGOP_LENGTH_FIELD, SYNTAX_FIELD, TEMPORAL_AQ_FIELD, TIMECODE_INSERTION_FIELD,
            TIMECODE_BURNIN_SETTINGS_FIELD, MIN_QP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String adaptiveQuantization;

    private final String afdSignaling;

    private final Integer bitrate;

    private final Integer bufFillPct;

    private final Integer bufSize;

    private final String colorMetadata;

    private final H264ColorSpaceSettings colorSpaceSettings;

    private final String entropyEncoding;

    private final H264FilterSettings filterSettings;

    private final String fixedAfd;

    private final String flickerAq;

    private final String forceFieldPictures;

    private final String framerateControl;

    private final Integer framerateDenominator;

    private final Integer framerateNumerator;

    private final String gopBReference;

    private final Integer gopClosedCadence;

    private final Integer gopNumBFrames;

    private final Double gopSize;

    private final String gopSizeUnits;

    private final String level;

    private final String lookAheadRateControl;

    private final Integer maxBitrate;

    private final Integer minIInterval;

    private final Integer numRefFrames;

    private final String parControl;

    private final Integer parDenominator;

    private final Integer parNumerator;

    private final String profile;

    private final String qualityLevel;

    private final Integer qvbrQualityLevel;

    private final String rateControlMode;

    private final String scanType;

    private final String sceneChangeDetect;

    private final Integer slices;

    private final Integer softness;

    private final String spatialAq;

    private final String subgopLength;

    private final String syntax;

    private final String temporalAq;

    private final String timecodeInsertion;

    private final TimecodeBurninSettings timecodeBurninSettings;

    private final Integer minQp;

    private H264Settings(BuilderImpl builder) {
        this.adaptiveQuantization = builder.adaptiveQuantization;
        this.afdSignaling = builder.afdSignaling;
        this.bitrate = builder.bitrate;
        this.bufFillPct = builder.bufFillPct;
        this.bufSize = builder.bufSize;
        this.colorMetadata = builder.colorMetadata;
        this.colorSpaceSettings = builder.colorSpaceSettings;
        this.entropyEncoding = builder.entropyEncoding;
        this.filterSettings = builder.filterSettings;
        this.fixedAfd = builder.fixedAfd;
        this.flickerAq = builder.flickerAq;
        this.forceFieldPictures = builder.forceFieldPictures;
        this.framerateControl = builder.framerateControl;
        this.framerateDenominator = builder.framerateDenominator;
        this.framerateNumerator = builder.framerateNumerator;
        this.gopBReference = builder.gopBReference;
        this.gopClosedCadence = builder.gopClosedCadence;
        this.gopNumBFrames = builder.gopNumBFrames;
        this.gopSize = builder.gopSize;
        this.gopSizeUnits = builder.gopSizeUnits;
        this.level = builder.level;
        this.lookAheadRateControl = builder.lookAheadRateControl;
        this.maxBitrate = builder.maxBitrate;
        this.minIInterval = builder.minIInterval;
        this.numRefFrames = builder.numRefFrames;
        this.parControl = builder.parControl;
        this.parDenominator = builder.parDenominator;
        this.parNumerator = builder.parNumerator;
        this.profile = builder.profile;
        this.qualityLevel = builder.qualityLevel;
        this.qvbrQualityLevel = builder.qvbrQualityLevel;
        this.rateControlMode = builder.rateControlMode;
        this.scanType = builder.scanType;
        this.sceneChangeDetect = builder.sceneChangeDetect;
        this.slices = builder.slices;
        this.softness = builder.softness;
        this.spatialAq = builder.spatialAq;
        this.subgopLength = builder.subgopLength;
        this.syntax = builder.syntax;
        this.temporalAq = builder.temporalAq;
        this.timecodeInsertion = builder.timecodeInsertion;
        this.timecodeBurninSettings = builder.timecodeBurninSettings;
        this.minQp = builder.minQp;
    }

    /**
     * Enables or disables adaptive quantization, which is a technique MediaLive can apply to video on a frame-by-frame
     * basis to produce more compression without losing quality. There are three types of adaptive quantization:
     * flicker, spatial, and temporal. Set the field in one of these ways: Set to Auto. Recommended. For each type of
     * AQ, MediaLive will determine if AQ is needed, and if so, the appropriate strength. Set a strength (a value other
     * than Auto or Disable). This strength will apply to any of the AQ fields that you choose to enable. Set to
     * Disabled to disable all types of adaptive quantization.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #adaptiveQuantization} will return {@link H264AdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #adaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Enables or disables adaptive quantization, which is a technique MediaLive can apply to video on a
     *         frame-by-frame basis to produce more compression without losing quality. There are three types of
     *         adaptive quantization: flicker, spatial, and temporal. Set the field in one of these ways: Set to Auto.
     *         Recommended. For each type of AQ, MediaLive will determine if AQ is needed, and if so, the appropriate
     *         strength. Set a strength (a value other than Auto or Disable). This strength will apply to any of the AQ
     *         fields that you choose to enable. Set to Disabled to disable all types of adaptive quantization.
     * @see H264AdaptiveQuantization
     */
    public final H264AdaptiveQuantization adaptiveQuantization() {
        return H264AdaptiveQuantization.fromValue(adaptiveQuantization);
    }

    /**
     * Enables or disables adaptive quantization, which is a technique MediaLive can apply to video on a frame-by-frame
     * basis to produce more compression without losing quality. There are three types of adaptive quantization:
     * flicker, spatial, and temporal. Set the field in one of these ways: Set to Auto. Recommended. For each type of
     * AQ, MediaLive will determine if AQ is needed, and if so, the appropriate strength. Set a strength (a value other
     * than Auto or Disable). This strength will apply to any of the AQ fields that you choose to enable. Set to
     * Disabled to disable all types of adaptive quantization.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #adaptiveQuantization} will return {@link H264AdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #adaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Enables or disables adaptive quantization, which is a technique MediaLive can apply to video on a
     *         frame-by-frame basis to produce more compression without losing quality. There are three types of
     *         adaptive quantization: flicker, spatial, and temporal. Set the field in one of these ways: Set to Auto.
     *         Recommended. For each type of AQ, MediaLive will determine if AQ is needed, and if so, the appropriate
     *         strength. Set a strength (a value other than Auto or Disable). This strength will apply to any of the AQ
     *         fields that you choose to enable. Set to Disabled to disable all types of adaptive quantization.
     * @see H264AdaptiveQuantization
     */
    public final String adaptiveQuantizationAsString() {
        return adaptiveQuantization;
    }

    /**
     * Indicates that AFD values will be written into the output stream. If afdSignaling is "auto", the system will try
     * to preserve the input AFD value (in cases where multiple AFD values are valid). If set to "fixed", the AFD value
     * will be the value configured in the fixedAfd parameter.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #afdSignaling} will
     * return {@link AfdSignaling#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #afdSignalingAsString}.
     * </p>
     * 
     * @return Indicates that AFD values will be written into the output stream. If afdSignaling is "auto", the system
     *         will try to preserve the input AFD value (in cases where multiple AFD values are valid). If set to
     *         "fixed", the AFD value will be the value configured in the fixedAfd parameter.
     * @see AfdSignaling
     */
    public final AfdSignaling afdSignaling() {
        return AfdSignaling.fromValue(afdSignaling);
    }

    /**
     * Indicates that AFD values will be written into the output stream. If afdSignaling is "auto", the system will try
     * to preserve the input AFD value (in cases where multiple AFD values are valid). If set to "fixed", the AFD value
     * will be the value configured in the fixedAfd parameter.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #afdSignaling} will
     * return {@link AfdSignaling#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #afdSignalingAsString}.
     * </p>
     * 
     * @return Indicates that AFD values will be written into the output stream. If afdSignaling is "auto", the system
     *         will try to preserve the input AFD value (in cases where multiple AFD values are valid). If set to
     *         "fixed", the AFD value will be the value configured in the fixedAfd parameter.
     * @see AfdSignaling
     */
    public final String afdSignalingAsString() {
        return afdSignaling;
    }

    /**
     * Average bitrate in bits/second. Required when the rate control mode is VBR or CBR. Not used for QVBR. In an MS
     * Smooth output group, each output must have a unique value when its bitrate is rounded down to the nearest
     * multiple of 1000.
     * 
     * @return Average bitrate in bits/second. Required when the rate control mode is VBR or CBR. Not used for QVBR. In
     *         an MS Smooth output group, each output must have a unique value when its bitrate is rounded down to the
     *         nearest multiple of 1000.
     */
    public final Integer bitrate() {
        return bitrate;
    }

    /**
     * Percentage of the buffer that should initially be filled (HRD buffer model).
     * 
     * @return Percentage of the buffer that should initially be filled (HRD buffer model).
     */
    public final Integer bufFillPct() {
        return bufFillPct;
    }

    /**
     * Size of buffer (HRD buffer model) in bits.
     * 
     * @return Size of buffer (HRD buffer model) in bits.
     */
    public final Integer bufSize() {
        return bufSize;
    }

    /**
     * Includes colorspace metadata in the output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #colorMetadata}
     * will return {@link H264ColorMetadata#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #colorMetadataAsString}.
     * </p>
     * 
     * @return Includes colorspace metadata in the output.
     * @see H264ColorMetadata
     */
    public final H264ColorMetadata colorMetadata() {
        return H264ColorMetadata.fromValue(colorMetadata);
    }

    /**
     * Includes colorspace metadata in the output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #colorMetadata}
     * will return {@link H264ColorMetadata#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #colorMetadataAsString}.
     * </p>
     * 
     * @return Includes colorspace metadata in the output.
     * @see H264ColorMetadata
     */
    public final String colorMetadataAsString() {
        return colorMetadata;
    }

    /**
     * Color Space settings
     * 
     * @return Color Space settings
     */
    public final H264ColorSpaceSettings colorSpaceSettings() {
        return colorSpaceSettings;
    }

    /**
     * Entropy encoding mode. Use cabac (must be in Main or High profile) or cavlc.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entropyEncoding}
     * will return {@link H264EntropyEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #entropyEncodingAsString}.
     * </p>
     * 
     * @return Entropy encoding mode. Use cabac (must be in Main or High profile) or cavlc.
     * @see H264EntropyEncoding
     */
    public final H264EntropyEncoding entropyEncoding() {
        return H264EntropyEncoding.fromValue(entropyEncoding);
    }

    /**
     * Entropy encoding mode. Use cabac (must be in Main or High profile) or cavlc.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entropyEncoding}
     * will return {@link H264EntropyEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #entropyEncodingAsString}.
     * </p>
     * 
     * @return Entropy encoding mode. Use cabac (must be in Main or High profile) or cavlc.
     * @see H264EntropyEncoding
     */
    public final String entropyEncodingAsString() {
        return entropyEncoding;
    }

    /**
     * Optional. Both filters reduce bandwidth by removing imperceptible details. You can enable one of the filters. We
     * recommend that you try both filters and observe the results to decide which one to use.
     *
     * The Temporal Filter reduces bandwidth by removing imperceptible details in the content. It combines perceptual
     * filtering and motion compensated temporal filtering (MCTF). It operates independently of the compression level.
     *
     * The Bandwidth Reduction filter is a perceptual filter located within the encoding loop. It adapts to the current
     * compression level to filter imperceptible signals. This filter works only when the resolution is 1080p or lower.
     * 
     * @return Optional. Both filters reduce bandwidth by removing imperceptible details. You can enable one of the
     *         filters. We recommend that you try both filters and observe the results to decide which one to use.
     *
     *         The Temporal Filter reduces bandwidth by removing imperceptible details in the content. It combines
     *         perceptual filtering and motion compensated temporal filtering (MCTF). It operates independently of the
     *         compression level.
     *
     *         The Bandwidth Reduction filter is a perceptual filter located within the encoding loop. It adapts to the
     *         current compression level to filter imperceptible signals. This filter works only when the resolution is
     *         1080p or lower.
     */
    public final H264FilterSettings filterSettings() {
        return filterSettings;
    }

    /**
     * Four bit AFD value to write on all frames of video in the output stream. Only valid when afdSignaling is set to
     * 'Fixed'.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fixedAfd} will
     * return {@link FixedAfd#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fixedAfdAsString}.
     * </p>
     * 
     * @return Four bit AFD value to write on all frames of video in the output stream. Only valid when afdSignaling is
     *         set to 'Fixed'.
     * @see FixedAfd
     */
    public final FixedAfd fixedAfd() {
        return FixedAfd.fromValue(fixedAfd);
    }

    /**
     * Four bit AFD value to write on all frames of video in the output stream. Only valid when afdSignaling is set to
     * 'Fixed'.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fixedAfd} will
     * return {@link FixedAfd#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fixedAfdAsString}.
     * </p>
     * 
     * @return Four bit AFD value to write on all frames of video in the output stream. Only valid when afdSignaling is
     *         set to 'Fixed'.
     * @see FixedAfd
     */
    public final String fixedAfdAsString() {
        return fixedAfd;
    }

    /**
     * Flicker AQ makes adjustments within each frame to reduce flicker or 'pop' on I-frames. The value to enter in this
     * field depends on the value in the Adaptive quantization field: If you have set the Adaptive quantization field to
     * Auto, MediaLive ignores any value in this field. MediaLive will determine if flicker AQ is appropriate and will
     * apply the appropriate strength. If you have set the Adaptive quantization field to a strength, you can set this
     * field to Enabled or Disabled. Enabled: MediaLive will apply flicker AQ using the specified strength. Disabled:
     * MediaLive won't apply flicker AQ. If you have set the Adaptive quantization to Disabled, MediaLive ignores any
     * value in this field and doesn't apply flicker AQ.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #flickerAq} will
     * return {@link H264FlickerAq#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #flickerAqAsString}.
     * </p>
     * 
     * @return Flicker AQ makes adjustments within each frame to reduce flicker or 'pop' on I-frames. The value to enter
     *         in this field depends on the value in the Adaptive quantization field: If you have set the Adaptive
     *         quantization field to Auto, MediaLive ignores any value in this field. MediaLive will determine if
     *         flicker AQ is appropriate and will apply the appropriate strength. If you have set the Adaptive
     *         quantization field to a strength, you can set this field to Enabled or Disabled. Enabled: MediaLive will
     *         apply flicker AQ using the specified strength. Disabled: MediaLive won't apply flicker AQ. If you have
     *         set the Adaptive quantization to Disabled, MediaLive ignores any value in this field and doesn't apply
     *         flicker AQ.
     * @see H264FlickerAq
     */
    public final H264FlickerAq flickerAq() {
        return H264FlickerAq.fromValue(flickerAq);
    }

    /**
     * Flicker AQ makes adjustments within each frame to reduce flicker or 'pop' on I-frames. The value to enter in this
     * field depends on the value in the Adaptive quantization field: If you have set the Adaptive quantization field to
     * Auto, MediaLive ignores any value in this field. MediaLive will determine if flicker AQ is appropriate and will
     * apply the appropriate strength. If you have set the Adaptive quantization field to a strength, you can set this
     * field to Enabled or Disabled. Enabled: MediaLive will apply flicker AQ using the specified strength. Disabled:
     * MediaLive won't apply flicker AQ. If you have set the Adaptive quantization to Disabled, MediaLive ignores any
     * value in this field and doesn't apply flicker AQ.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #flickerAq} will
     * return {@link H264FlickerAq#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #flickerAqAsString}.
     * </p>
     * 
     * @return Flicker AQ makes adjustments within each frame to reduce flicker or 'pop' on I-frames. The value to enter
     *         in this field depends on the value in the Adaptive quantization field: If you have set the Adaptive
     *         quantization field to Auto, MediaLive ignores any value in this field. MediaLive will determine if
     *         flicker AQ is appropriate and will apply the appropriate strength. If you have set the Adaptive
     *         quantization field to a strength, you can set this field to Enabled or Disabled. Enabled: MediaLive will
     *         apply flicker AQ using the specified strength. Disabled: MediaLive won't apply flicker AQ. If you have
     *         set the Adaptive quantization to Disabled, MediaLive ignores any value in this field and doesn't apply
     *         flicker AQ.
     * @see H264FlickerAq
     */
    public final String flickerAqAsString() {
        return flickerAq;
    }

    /**
     * This setting applies only when scan type is "interlaced." It controls whether coding is performed on a field
     * basis or on a frame basis. (When the video is progressive, the coding is always performed on a frame basis.)
     * enabled: Force MediaLive to code on a field basis, so that odd and even sets of fields are coded separately.
     * disabled: Code the two sets of fields separately (on a field basis) or together (on a frame basis using PAFF),
     * depending on what is most appropriate for the content.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #forceFieldPictures} will return {@link H264ForceFieldPictures#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #forceFieldPicturesAsString}.
     * </p>
     * 
     * @return This setting applies only when scan type is "interlaced." It controls whether coding is performed on a
     *         field basis or on a frame basis. (When the video is progressive, the coding is always performed on a
     *         frame basis.) enabled: Force MediaLive to code on a field basis, so that odd and even sets of fields are
     *         coded separately. disabled: Code the two sets of fields separately (on a field basis) or together (on a
     *         frame basis using PAFF), depending on what is most appropriate for the content.
     * @see H264ForceFieldPictures
     */
    public final H264ForceFieldPictures forceFieldPictures() {
        return H264ForceFieldPictures.fromValue(forceFieldPictures);
    }

    /**
     * This setting applies only when scan type is "interlaced." It controls whether coding is performed on a field
     * basis or on a frame basis. (When the video is progressive, the coding is always performed on a frame basis.)
     * enabled: Force MediaLive to code on a field basis, so that odd and even sets of fields are coded separately.
     * disabled: Code the two sets of fields separately (on a field basis) or together (on a frame basis using PAFF),
     * depending on what is most appropriate for the content.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #forceFieldPictures} will return {@link H264ForceFieldPictures#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #forceFieldPicturesAsString}.
     * </p>
     * 
     * @return This setting applies only when scan type is "interlaced." It controls whether coding is performed on a
     *         field basis or on a frame basis. (When the video is progressive, the coding is always performed on a
     *         frame basis.) enabled: Force MediaLive to code on a field basis, so that odd and even sets of fields are
     *         coded separately. disabled: Code the two sets of fields separately (on a field basis) or together (on a
     *         frame basis using PAFF), depending on what is most appropriate for the content.
     * @see H264ForceFieldPictures
     */
    public final String forceFieldPicturesAsString() {
        return forceFieldPictures;
    }

    /**
     * This field indicates how the output video frame rate is specified. If "specified" is selected then the output
     * video frame rate is determined by framerateNumerator and framerateDenominator, else if "initializeFromSource" is
     * selected then the output video frame rate will be set equal to the input video frame rate of the first input.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #framerateControl}
     * will return {@link H264FramerateControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #framerateControlAsString}.
     * </p>
     * 
     * @return This field indicates how the output video frame rate is specified. If "specified" is selected then the
     *         output video frame rate is determined by framerateNumerator and framerateDenominator, else if
     *         "initializeFromSource" is selected then the output video frame rate will be set equal to the input video
     *         frame rate of the first input.
     * @see H264FramerateControl
     */
    public final H264FramerateControl framerateControl() {
        return H264FramerateControl.fromValue(framerateControl);
    }

    /**
     * This field indicates how the output video frame rate is specified. If "specified" is selected then the output
     * video frame rate is determined by framerateNumerator and framerateDenominator, else if "initializeFromSource" is
     * selected then the output video frame rate will be set equal to the input video frame rate of the first input.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #framerateControl}
     * will return {@link H264FramerateControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #framerateControlAsString}.
     * </p>
     * 
     * @return This field indicates how the output video frame rate is specified. If "specified" is selected then the
     *         output video frame rate is determined by framerateNumerator and framerateDenominator, else if
     *         "initializeFromSource" is selected then the output video frame rate will be set equal to the input video
     *         frame rate of the first input.
     * @see H264FramerateControl
     */
    public final String framerateControlAsString() {
        return framerateControl;
    }

    /**
     * Framerate denominator.
     * 
     * @return Framerate denominator.
     */
    public final Integer framerateDenominator() {
        return framerateDenominator;
    }

    /**
     * Framerate numerator - framerate is a fraction, e.g. 24000 / 1001 = 23.976 fps.
     * 
     * @return Framerate numerator - framerate is a fraction, e.g. 24000 / 1001 = 23.976 fps.
     */
    public final Integer framerateNumerator() {
        return framerateNumerator;
    }

    /**
     * Documentation update needed
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gopBReference}
     * will return {@link H264GopBReference#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #gopBReferenceAsString}.
     * </p>
     * 
     * @return Documentation update needed
     * @see H264GopBReference
     */
    public final H264GopBReference gopBReference() {
        return H264GopBReference.fromValue(gopBReference);
    }

    /**
     * Documentation update needed
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gopBReference}
     * will return {@link H264GopBReference#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #gopBReferenceAsString}.
     * </p>
     * 
     * @return Documentation update needed
     * @see H264GopBReference
     */
    public final String gopBReferenceAsString() {
        return gopBReference;
    }

    /**
     * Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining
     * mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output
     * segmenting.
     * 
     * @return Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder
     *         joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break
     *         output segmenting.
     */
    public final Integer gopClosedCadence() {
        return gopClosedCadence;
    }

    /**
     * Number of B-frames between reference frames.
     * 
     * @return Number of B-frames between reference frames.
     */
    public final Integer gopNumBFrames() {
        return gopNumBFrames;
    }

    /**
     * GOP size (keyframe interval) in units of either frames or seconds per gopSizeUnits. If gopSizeUnits is frames,
     * gopSize must be an integer and must be greater than or equal to 1. If gopSizeUnits is seconds, gopSize must be
     * greater than 0, but need not be an integer.
     * 
     * @return GOP size (keyframe interval) in units of either frames or seconds per gopSizeUnits. If gopSizeUnits is
     *         frames, gopSize must be an integer and must be greater than or equal to 1. If gopSizeUnits is seconds,
     *         gopSize must be greater than 0, but need not be an integer.
     */
    public final Double gopSize() {
        return gopSize;
    }

    /**
     * Indicates if the gopSize is specified in frames or seconds. If seconds the system will convert the gopSize into a
     * frame count at run time.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gopSizeUnits} will
     * return {@link H264GopSizeUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #gopSizeUnitsAsString}.
     * </p>
     * 
     * @return Indicates if the gopSize is specified in frames or seconds. If seconds the system will convert the
     *         gopSize into a frame count at run time.
     * @see H264GopSizeUnits
     */
    public final H264GopSizeUnits gopSizeUnits() {
        return H264GopSizeUnits.fromValue(gopSizeUnits);
    }

    /**
     * Indicates if the gopSize is specified in frames or seconds. If seconds the system will convert the gopSize into a
     * frame count at run time.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gopSizeUnits} will
     * return {@link H264GopSizeUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #gopSizeUnitsAsString}.
     * </p>
     * 
     * @return Indicates if the gopSize is specified in frames or seconds. If seconds the system will convert the
     *         gopSize into a frame count at run time.
     * @see H264GopSizeUnits
     */
    public final String gopSizeUnitsAsString() {
        return gopSizeUnits;
    }

    /**
     * H.264 Level.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #level} will return
     * {@link H264Level#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #levelAsString}.
     * </p>
     * 
     * @return H.264 Level.
     * @see H264Level
     */
    public final H264Level level() {
        return H264Level.fromValue(level);
    }

    /**
     * H.264 Level.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #level} will return
     * {@link H264Level#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #levelAsString}.
     * </p>
     * 
     * @return H.264 Level.
     * @see H264Level
     */
    public final String levelAsString() {
        return level;
    }

    /**
     * Amount of lookahead. A value of low can decrease latency and memory usage, while high can produce better quality
     * for certain content.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lookAheadRateControl} will return {@link H264LookAheadRateControl#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #lookAheadRateControlAsString}.
     * </p>
     * 
     * @return Amount of lookahead. A value of low can decrease latency and memory usage, while high can produce better
     *         quality for certain content.
     * @see H264LookAheadRateControl
     */
    public final H264LookAheadRateControl lookAheadRateControl() {
        return H264LookAheadRateControl.fromValue(lookAheadRateControl);
    }

    /**
     * Amount of lookahead. A value of low can decrease latency and memory usage, while high can produce better quality
     * for certain content.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lookAheadRateControl} will return {@link H264LookAheadRateControl#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #lookAheadRateControlAsString}.
     * </p>
     * 
     * @return Amount of lookahead. A value of low can decrease latency and memory usage, while high can produce better
     *         quality for certain content.
     * @see H264LookAheadRateControl
     */
    public final String lookAheadRateControlAsString() {
        return lookAheadRateControl;
    }

    /**
     * For QVBR: See the tooltip for Quality level
     *
     * For VBR: Set the maximum bitrate in order to accommodate expected spikes in the complexity of the video.
     * 
     * @return For QVBR: See the tooltip for Quality level
     *
     *         For VBR: Set the maximum bitrate in order to accommodate expected spikes in the complexity of the video.
     */
    public final Integer maxBitrate() {
        return maxBitrate;
    }

    /**
     * Only meaningful if sceneChangeDetect is set to enabled. Defaults to 5 if multiplex rate control is used. Enforces
     * separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a scene change
     * I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or stretched to the scene change
     * I-frame. GOP stretch requires enabling lookahead as well as setting I-interval. The normal cadence resumes for
     * the next GOP. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1
     * 
     * @return Only meaningful if sceneChangeDetect is set to enabled. Defaults to 5 if multiplex rate control is used.
     *         Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection.
     *         If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or
     *         stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well as setting
     *         I-interval. The normal cadence resumes for the next GOP. Note: Maximum GOP stretch = GOP size +
     *         Min-I-interval - 1
     */
    public final Integer minIInterval() {
        return minIInterval;
    }

    /**
     * Number of reference frames to use. The encoder may use more than requested if using B-frames and/or interlaced
     * encoding.
     * 
     * @return Number of reference frames to use. The encoder may use more than requested if using B-frames and/or
     *         interlaced encoding.
     */
    public final Integer numRefFrames() {
        return numRefFrames;
    }

    /**
     * This field indicates how the output pixel aspect ratio is specified. If "specified" is selected then the output
     * video pixel aspect ratio is determined by parNumerator and parDenominator, else if "initializeFromSource" is
     * selected then the output pixsel aspect ratio will be set equal to the input video pixel aspect ratio of the first
     * input.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parControl} will
     * return {@link H264ParControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #parControlAsString}.
     * </p>
     * 
     * @return This field indicates how the output pixel aspect ratio is specified. If "specified" is selected then the
     *         output video pixel aspect ratio is determined by parNumerator and parDenominator, else if
     *         "initializeFromSource" is selected then the output pixsel aspect ratio will be set equal to the input
     *         video pixel aspect ratio of the first input.
     * @see H264ParControl
     */
    public final H264ParControl parControl() {
        return H264ParControl.fromValue(parControl);
    }

    /**
     * This field indicates how the output pixel aspect ratio is specified. If "specified" is selected then the output
     * video pixel aspect ratio is determined by parNumerator and parDenominator, else if "initializeFromSource" is
     * selected then the output pixsel aspect ratio will be set equal to the input video pixel aspect ratio of the first
     * input.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parControl} will
     * return {@link H264ParControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #parControlAsString}.
     * </p>
     * 
     * @return This field indicates how the output pixel aspect ratio is specified. If "specified" is selected then the
     *         output video pixel aspect ratio is determined by parNumerator and parDenominator, else if
     *         "initializeFromSource" is selected then the output pixsel aspect ratio will be set equal to the input
     *         video pixel aspect ratio of the first input.
     * @see H264ParControl
     */
    public final String parControlAsString() {
        return parControl;
    }

    /**
     * Pixel Aspect Ratio denominator.
     * 
     * @return Pixel Aspect Ratio denominator.
     */
    public final Integer parDenominator() {
        return parDenominator;
    }

    /**
     * Pixel Aspect Ratio numerator.
     * 
     * @return Pixel Aspect Ratio numerator.
     */
    public final Integer parNumerator() {
        return parNumerator;
    }

    /**
     * H.264 Profile.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #profile} will
     * return {@link H264Profile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #profileAsString}.
     * </p>
     * 
     * @return H.264 Profile.
     * @see H264Profile
     */
    public final H264Profile profile() {
        return H264Profile.fromValue(profile);
    }

    /**
     * H.264 Profile.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #profile} will
     * return {@link H264Profile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #profileAsString}.
     * </p>
     * 
     * @return H.264 Profile.
     * @see H264Profile
     */
    public final String profileAsString() {
        return profile;
    }

    /**
     * Leave as STANDARD_QUALITY or choose a different value (which might result in additional costs to run the
     * channel). - ENHANCED_QUALITY: Produces a slightly better video quality without an increase in the bitrate. Has an
     * effect only when the Rate control mode is QVBR or CBR. If this channel is in a MediaLive multiplex, the value
     * must be ENHANCED_QUALITY. - STANDARD_QUALITY: Valid for any Rate control mode.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #qualityLevel} will
     * return {@link H264QualityLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #qualityLevelAsString}.
     * </p>
     * 
     * @return Leave as STANDARD_QUALITY or choose a different value (which might result in additional costs to run the
     *         channel). - ENHANCED_QUALITY: Produces a slightly better video quality without an increase in the
     *         bitrate. Has an effect only when the Rate control mode is QVBR or CBR. If this channel is in a MediaLive
     *         multiplex, the value must be ENHANCED_QUALITY. - STANDARD_QUALITY: Valid for any Rate control mode.
     * @see H264QualityLevel
     */
    public final H264QualityLevel qualityLevel() {
        return H264QualityLevel.fromValue(qualityLevel);
    }

    /**
     * Leave as STANDARD_QUALITY or choose a different value (which might result in additional costs to run the
     * channel). - ENHANCED_QUALITY: Produces a slightly better video quality without an increase in the bitrate. Has an
     * effect only when the Rate control mode is QVBR or CBR. If this channel is in a MediaLive multiplex, the value
     * must be ENHANCED_QUALITY. - STANDARD_QUALITY: Valid for any Rate control mode.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #qualityLevel} will
     * return {@link H264QualityLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #qualityLevelAsString}.
     * </p>
     * 
     * @return Leave as STANDARD_QUALITY or choose a different value (which might result in additional costs to run the
     *         channel). - ENHANCED_QUALITY: Produces a slightly better video quality without an increase in the
     *         bitrate. Has an effect only when the Rate control mode is QVBR or CBR. If this channel is in a MediaLive
     *         multiplex, the value must be ENHANCED_QUALITY. - STANDARD_QUALITY: Valid for any Rate control mode.
     * @see H264QualityLevel
     */
    public final String qualityLevelAsString() {
        return qualityLevel;
    }

    /**
     * Controls the target quality for the video encode. Applies only when the rate control mode is QVBR. You can set a
     * target quality or you can let MediaLive determine the best quality. To set a target quality, enter values in the
     * QVBR quality level field and the Max bitrate field. Enter values that suit your most important viewing devices.
     * Recommended values are: - Primary screen: Quality level: 8 to 10. Max bitrate: 4M - PC or tablet: Quality level:
     * 7. Max bitrate: 1.5M to 3M - Smartphone: Quality level: 6. Max bitrate: 1M to 1.5M To let MediaLive decide, leave
     * the QVBR quality level field empty, and in Max bitrate enter the maximum rate you want in the video. For more
     * information, see the section called "Video - rate control mode" in the MediaLive user guide
     * 
     * @return Controls the target quality for the video encode. Applies only when the rate control mode is QVBR. You
     *         can set a target quality or you can let MediaLive determine the best quality. To set a target quality,
     *         enter values in the QVBR quality level field and the Max bitrate field. Enter values that suit your most
     *         important viewing devices. Recommended values are: - Primary screen: Quality level: 8 to 10. Max bitrate:
     *         4M - PC or tablet: Quality level: 7. Max bitrate: 1.5M to 3M - Smartphone: Quality level: 6. Max bitrate:
     *         1M to 1.5M To let MediaLive decide, leave the QVBR quality level field empty, and in Max bitrate enter
     *         the maximum rate you want in the video. For more information, see the section called
     *         "Video - rate control mode" in the MediaLive user guide
     */
    public final Integer qvbrQualityLevel() {
        return qvbrQualityLevel;
    }

    /**
     * Rate control mode.
     *
     * QVBR: Quality will match the specified quality level except when it is constrained by the maximum bitrate.
     * Recommended if you or your viewers pay for bandwidth.
     *
     * VBR: Quality and bitrate vary, depending on the video complexity. Recommended instead of QVBR if you want to
     * maintain a specific average bitrate over the duration of the channel.
     *
     * CBR: Quality varies, depending on the video complexity. Recommended only if you distribute your assets to devices
     * that cannot handle variable bitrates.
     *
     * Multiplex: This rate control mode is only supported (and is required) when the video is being delivered to a
     * MediaLive Multiplex in which case the rate control configuration is controlled by the properties within the
     * Multiplex Program.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rateControlMode}
     * will return {@link H264RateControlMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #rateControlModeAsString}.
     * </p>
     * 
     * @return Rate control mode.
     *
     *         QVBR: Quality will match the specified quality level except when it is constrained by the maximum
     *         bitrate. Recommended if you or your viewers pay for bandwidth.
     *
     *         VBR: Quality and bitrate vary, depending on the video complexity. Recommended instead of QVBR if you want
     *         to maintain a specific average bitrate over the duration of the channel.
     *
     *         CBR: Quality varies, depending on the video complexity. Recommended only if you distribute your assets to
     *         devices that cannot handle variable bitrates.
     *
     *         Multiplex: This rate control mode is only supported (and is required) when the video is being delivered
     *         to a MediaLive Multiplex in which case the rate control configuration is controlled by the properties
     *         within the Multiplex Program.
     * @see H264RateControlMode
     */
    public final H264RateControlMode rateControlMode() {
        return H264RateControlMode.fromValue(rateControlMode);
    }

    /**
     * Rate control mode.
     *
     * QVBR: Quality will match the specified quality level except when it is constrained by the maximum bitrate.
     * Recommended if you or your viewers pay for bandwidth.
     *
     * VBR: Quality and bitrate vary, depending on the video complexity. Recommended instead of QVBR if you want to
     * maintain a specific average bitrate over the duration of the channel.
     *
     * CBR: Quality varies, depending on the video complexity. Recommended only if you distribute your assets to devices
     * that cannot handle variable bitrates.
     *
     * Multiplex: This rate control mode is only supported (and is required) when the video is being delivered to a
     * MediaLive Multiplex in which case the rate control configuration is controlled by the properties within the
     * Multiplex Program.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rateControlMode}
     * will return {@link H264RateControlMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #rateControlModeAsString}.
     * </p>
     * 
     * @return Rate control mode.
     *
     *         QVBR: Quality will match the specified quality level except when it is constrained by the maximum
     *         bitrate. Recommended if you or your viewers pay for bandwidth.
     *
     *         VBR: Quality and bitrate vary, depending on the video complexity. Recommended instead of QVBR if you want
     *         to maintain a specific average bitrate over the duration of the channel.
     *
     *         CBR: Quality varies, depending on the video complexity. Recommended only if you distribute your assets to
     *         devices that cannot handle variable bitrates.
     *
     *         Multiplex: This rate control mode is only supported (and is required) when the video is being delivered
     *         to a MediaLive Multiplex in which case the rate control configuration is controlled by the properties
     *         within the Multiplex Program.
     * @see H264RateControlMode
     */
    public final String rateControlModeAsString() {
        return rateControlMode;
    }

    /**
     * Sets the scan type of the output to progressive or top-field-first interlaced.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanType} will
     * return {@link H264ScanType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanTypeAsString}.
     * </p>
     * 
     * @return Sets the scan type of the output to progressive or top-field-first interlaced.
     * @see H264ScanType
     */
    public final H264ScanType scanType() {
        return H264ScanType.fromValue(scanType);
    }

    /**
     * Sets the scan type of the output to progressive or top-field-first interlaced.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanType} will
     * return {@link H264ScanType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanTypeAsString}.
     * </p>
     * 
     * @return Sets the scan type of the output to progressive or top-field-first interlaced.
     * @see H264ScanType
     */
    public final String scanTypeAsString() {
        return scanType;
    }

    /**
     * Scene change detection.
     *
     * - On: inserts I-frames when scene change is detected. - Off: does not force an I-frame when scene change is
     * detected.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sceneChangeDetect}
     * will return {@link H264SceneChangeDetect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sceneChangeDetectAsString}.
     * </p>
     * 
     * @return Scene change detection.
     *
     *         - On: inserts I-frames when scene change is detected. - Off: does not force an I-frame when scene change
     *         is detected.
     * @see H264SceneChangeDetect
     */
    public final H264SceneChangeDetect sceneChangeDetect() {
        return H264SceneChangeDetect.fromValue(sceneChangeDetect);
    }

    /**
     * Scene change detection.
     *
     * - On: inserts I-frames when scene change is detected. - Off: does not force an I-frame when scene change is
     * detected.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sceneChangeDetect}
     * will return {@link H264SceneChangeDetect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sceneChangeDetectAsString}.
     * </p>
     * 
     * @return Scene change detection.
     *
     *         - On: inserts I-frames when scene change is detected. - Off: does not force an I-frame when scene change
     *         is detected.
     * @see H264SceneChangeDetect
     */
    public final String sceneChangeDetectAsString() {
        return sceneChangeDetect;
    }

    /**
     * Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive
     * pictures, and less than or equal to half the number of macroblock rows for interlaced pictures. This field is
     * optional; when no value is specified the encoder will choose the number of slices based on encode resolution.
     * 
     * @return Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive
     *         pictures, and less than or equal to half the number of macroblock rows for interlaced pictures. This
     *         field is optional; when no value is specified the encoder will choose the number of slices based on
     *         encode resolution.
     */
    public final Integer slices() {
        return slices;
    }

    /**
     * Softness. Selects quantizer matrix, larger values reduce high-frequency content in the encoded image. If not set
     * to zero, must be greater than 15.
     * 
     * @return Softness. Selects quantizer matrix, larger values reduce high-frequency content in the encoded image. If
     *         not set to zero, must be greater than 15.
     */
    public final Integer softness() {
        return softness;
    }

    /**
     * Spatial AQ makes adjustments within each frame based on spatial variation of content complexity. The value to
     * enter in this field depends on the value in the Adaptive quantization field: If you have set the Adaptive
     * quantization field to Auto, MediaLive ignores any value in this field. MediaLive will determine if spatial AQ is
     * appropriate and will apply the appropriate strength. If you have set the Adaptive quantization field to a
     * strength, you can set this field to Enabled or Disabled. Enabled: MediaLive will apply spatial AQ using the
     * specified strength. Disabled: MediaLive won't apply spatial AQ. If you have set the Adaptive quantization to
     * Disabled, MediaLive ignores any value in this field and doesn't apply spatial AQ.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #spatialAq} will
     * return {@link H264SpatialAq#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #spatialAqAsString}.
     * </p>
     * 
     * @return Spatial AQ makes adjustments within each frame based on spatial variation of content complexity. The
     *         value to enter in this field depends on the value in the Adaptive quantization field: If you have set the
     *         Adaptive quantization field to Auto, MediaLive ignores any value in this field. MediaLive will determine
     *         if spatial AQ is appropriate and will apply the appropriate strength. If you have set the Adaptive
     *         quantization field to a strength, you can set this field to Enabled or Disabled. Enabled: MediaLive will
     *         apply spatial AQ using the specified strength. Disabled: MediaLive won't apply spatial AQ. If you have
     *         set the Adaptive quantization to Disabled, MediaLive ignores any value in this field and doesn't apply
     *         spatial AQ.
     * @see H264SpatialAq
     */
    public final H264SpatialAq spatialAq() {
        return H264SpatialAq.fromValue(spatialAq);
    }

    /**
     * Spatial AQ makes adjustments within each frame based on spatial variation of content complexity. The value to
     * enter in this field depends on the value in the Adaptive quantization field: If you have set the Adaptive
     * quantization field to Auto, MediaLive ignores any value in this field. MediaLive will determine if spatial AQ is
     * appropriate and will apply the appropriate strength. If you have set the Adaptive quantization field to a
     * strength, you can set this field to Enabled or Disabled. Enabled: MediaLive will apply spatial AQ using the
     * specified strength. Disabled: MediaLive won't apply spatial AQ. If you have set the Adaptive quantization to
     * Disabled, MediaLive ignores any value in this field and doesn't apply spatial AQ.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #spatialAq} will
     * return {@link H264SpatialAq#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #spatialAqAsString}.
     * </p>
     * 
     * @return Spatial AQ makes adjustments within each frame based on spatial variation of content complexity. The
     *         value to enter in this field depends on the value in the Adaptive quantization field: If you have set the
     *         Adaptive quantization field to Auto, MediaLive ignores any value in this field. MediaLive will determine
     *         if spatial AQ is appropriate and will apply the appropriate strength. If you have set the Adaptive
     *         quantization field to a strength, you can set this field to Enabled or Disabled. Enabled: MediaLive will
     *         apply spatial AQ using the specified strength. Disabled: MediaLive won't apply spatial AQ. If you have
     *         set the Adaptive quantization to Disabled, MediaLive ignores any value in this field and doesn't apply
     *         spatial AQ.
     * @see H264SpatialAq
     */
    public final String spatialAqAsString() {
        return spatialAq;
    }

    /**
     * If set to fixed, use gopNumBFrames B-frames per sub-GOP. If set to dynamic, optimize the number of B-frames used
     * for each sub-GOP to improve visual quality.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #subgopLength} will
     * return {@link H264SubGopLength#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #subgopLengthAsString}.
     * </p>
     * 
     * @return If set to fixed, use gopNumBFrames B-frames per sub-GOP. If set to dynamic, optimize the number of
     *         B-frames used for each sub-GOP to improve visual quality.
     * @see H264SubGopLength
     */
    public final H264SubGopLength subgopLength() {
        return H264SubGopLength.fromValue(subgopLength);
    }

    /**
     * If set to fixed, use gopNumBFrames B-frames per sub-GOP. If set to dynamic, optimize the number of B-frames used
     * for each sub-GOP to improve visual quality.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #subgopLength} will
     * return {@link H264SubGopLength#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #subgopLengthAsString}.
     * </p>
     * 
     * @return If set to fixed, use gopNumBFrames B-frames per sub-GOP. If set to dynamic, optimize the number of
     *         B-frames used for each sub-GOP to improve visual quality.
     * @see H264SubGopLength
     */
    public final String subgopLengthAsString() {
        return subgopLength;
    }

    /**
     * Produces a bitstream compliant with SMPTE RP-2027.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #syntax} will
     * return {@link H264Syntax#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #syntaxAsString}.
     * </p>
     * 
     * @return Produces a bitstream compliant with SMPTE RP-2027.
     * @see H264Syntax
     */
    public final H264Syntax syntax() {
        return H264Syntax.fromValue(syntax);
    }

    /**
     * Produces a bitstream compliant with SMPTE RP-2027.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #syntax} will
     * return {@link H264Syntax#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #syntaxAsString}.
     * </p>
     * 
     * @return Produces a bitstream compliant with SMPTE RP-2027.
     * @see H264Syntax
     */
    public final String syntaxAsString() {
        return syntax;
    }

    /**
     * Temporal makes adjustments within each frame based on temporal variation of content complexity. The value to
     * enter in this field depends on the value in the Adaptive quantization field: If you have set the Adaptive
     * quantization field to Auto, MediaLive ignores any value in this field. MediaLive will determine if temporal AQ is
     * appropriate and will apply the appropriate strength. If you have set the Adaptive quantization field to a
     * strength, you can set this field to Enabled or Disabled. Enabled: MediaLive will apply temporal AQ using the
     * specified strength. Disabled: MediaLive won't apply temporal AQ. If you have set the Adaptive quantization to
     * Disabled, MediaLive ignores any value in this field and doesn't apply temporal AQ.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #temporalAq} will
     * return {@link H264TemporalAq#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #temporalAqAsString}.
     * </p>
     * 
     * @return Temporal makes adjustments within each frame based on temporal variation of content complexity. The value
     *         to enter in this field depends on the value in the Adaptive quantization field: If you have set the
     *         Adaptive quantization field to Auto, MediaLive ignores any value in this field. MediaLive will determine
     *         if temporal AQ is appropriate and will apply the appropriate strength. If you have set the Adaptive
     *         quantization field to a strength, you can set this field to Enabled or Disabled. Enabled: MediaLive will
     *         apply temporal AQ using the specified strength. Disabled: MediaLive won't apply temporal AQ. If you have
     *         set the Adaptive quantization to Disabled, MediaLive ignores any value in this field and doesn't apply
     *         temporal AQ.
     * @see H264TemporalAq
     */
    public final H264TemporalAq temporalAq() {
        return H264TemporalAq.fromValue(temporalAq);
    }

    /**
     * Temporal makes adjustments within each frame based on temporal variation of content complexity. The value to
     * enter in this field depends on the value in the Adaptive quantization field: If you have set the Adaptive
     * quantization field to Auto, MediaLive ignores any value in this field. MediaLive will determine if temporal AQ is
     * appropriate and will apply the appropriate strength. If you have set the Adaptive quantization field to a
     * strength, you can set this field to Enabled or Disabled. Enabled: MediaLive will apply temporal AQ using the
     * specified strength. Disabled: MediaLive won't apply temporal AQ. If you have set the Adaptive quantization to
     * Disabled, MediaLive ignores any value in this field and doesn't apply temporal AQ.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #temporalAq} will
     * return {@link H264TemporalAq#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #temporalAqAsString}.
     * </p>
     * 
     * @return Temporal makes adjustments within each frame based on temporal variation of content complexity. The value
     *         to enter in this field depends on the value in the Adaptive quantization field: If you have set the
     *         Adaptive quantization field to Auto, MediaLive ignores any value in this field. MediaLive will determine
     *         if temporal AQ is appropriate and will apply the appropriate strength. If you have set the Adaptive
     *         quantization field to a strength, you can set this field to Enabled or Disabled. Enabled: MediaLive will
     *         apply temporal AQ using the specified strength. Disabled: MediaLive won't apply temporal AQ. If you have
     *         set the Adaptive quantization to Disabled, MediaLive ignores any value in this field and doesn't apply
     *         temporal AQ.
     * @see H264TemporalAq
     */
    public final String temporalAqAsString() {
        return temporalAq;
    }

    /**
     * Determines how timecodes should be inserted into the video elementary stream. - 'disabled': Do not include
     * timecodes - 'picTimingSei': Pass through picture timing SEI messages from the source specified in Timecode Config
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timecodeInsertion}
     * will return {@link H264TimecodeInsertionBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #timecodeInsertionAsString}.
     * </p>
     * 
     * @return Determines how timecodes should be inserted into the video elementary stream. - 'disabled': Do not
     *         include timecodes - 'picTimingSei': Pass through picture timing SEI messages from the source specified in
     *         Timecode Config
     * @see H264TimecodeInsertionBehavior
     */
    public final H264TimecodeInsertionBehavior timecodeInsertion() {
        return H264TimecodeInsertionBehavior.fromValue(timecodeInsertion);
    }

    /**
     * Determines how timecodes should be inserted into the video elementary stream. - 'disabled': Do not include
     * timecodes - 'picTimingSei': Pass through picture timing SEI messages from the source specified in Timecode Config
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timecodeInsertion}
     * will return {@link H264TimecodeInsertionBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #timecodeInsertionAsString}.
     * </p>
     * 
     * @return Determines how timecodes should be inserted into the video elementary stream. - 'disabled': Do not
     *         include timecodes - 'picTimingSei': Pass through picture timing SEI messages from the source specified in
     *         Timecode Config
     * @see H264TimecodeInsertionBehavior
     */
    public final String timecodeInsertionAsString() {
        return timecodeInsertion;
    }

    /**
     * Timecode burn-in settings
     * 
     * @return Timecode burn-in settings
     */
    public final TimecodeBurninSettings timecodeBurninSettings() {
        return timecodeBurninSettings;
    }

    /**
     * Sets the minimum QP. If you aren't familiar with quantization adjustment, leave the field empty. MediaLive will
     * apply an appropriate value.
     * 
     * @return Sets the minimum QP. If you aren't familiar with quantization adjustment, leave the field empty.
     *         MediaLive will apply an appropriate value.
     */
    public final Integer minQp() {
        return minQp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(afdSignalingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(bufFillPct());
        hashCode = 31 * hashCode + Objects.hashCode(bufSize());
        hashCode = 31 * hashCode + Objects.hashCode(colorMetadataAsString());
        hashCode = 31 * hashCode + Objects.hashCode(colorSpaceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(entropyEncodingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filterSettings());
        hashCode = 31 * hashCode + Objects.hashCode(fixedAfdAsString());
        hashCode = 31 * hashCode + Objects.hashCode(flickerAqAsString());
        hashCode = 31 * hashCode + Objects.hashCode(forceFieldPicturesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(framerateControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(framerateDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(framerateNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(gopBReferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(gopClosedCadence());
        hashCode = 31 * hashCode + Objects.hashCode(gopNumBFrames());
        hashCode = 31 * hashCode + Objects.hashCode(gopSize());
        hashCode = 31 * hashCode + Objects.hashCode(gopSizeUnitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(levelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lookAheadRateControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(minIInterval());
        hashCode = 31 * hashCode + Objects.hashCode(numRefFrames());
        hashCode = 31 * hashCode + Objects.hashCode(parControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(parDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(parNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(profileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(qualityLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(qvbrQualityLevel());
        hashCode = 31 * hashCode + Objects.hashCode(rateControlModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scanTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sceneChangeDetectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(slices());
        hashCode = 31 * hashCode + Objects.hashCode(softness());
        hashCode = 31 * hashCode + Objects.hashCode(spatialAqAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subgopLengthAsString());
        hashCode = 31 * hashCode + Objects.hashCode(syntaxAsString());
        hashCode = 31 * hashCode + Objects.hashCode(temporalAqAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timecodeInsertionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timecodeBurninSettings());
        hashCode = 31 * hashCode + Objects.hashCode(minQp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof H264Settings)) {
            return false;
        }
        H264Settings other = (H264Settings) obj;
        return Objects.equals(adaptiveQuantizationAsString(), other.adaptiveQuantizationAsString())
                && Objects.equals(afdSignalingAsString(), other.afdSignalingAsString())
                && Objects.equals(bitrate(), other.bitrate()) && Objects.equals(bufFillPct(), other.bufFillPct())
                && Objects.equals(bufSize(), other.bufSize())
                && Objects.equals(colorMetadataAsString(), other.colorMetadataAsString())
                && Objects.equals(colorSpaceSettings(), other.colorSpaceSettings())
                && Objects.equals(entropyEncodingAsString(), other.entropyEncodingAsString())
                && Objects.equals(filterSettings(), other.filterSettings())
                && Objects.equals(fixedAfdAsString(), other.fixedAfdAsString())
                && Objects.equals(flickerAqAsString(), other.flickerAqAsString())
                && Objects.equals(forceFieldPicturesAsString(), other.forceFieldPicturesAsString())
                && Objects.equals(framerateControlAsString(), other.framerateControlAsString())
                && Objects.equals(framerateDenominator(), other.framerateDenominator())
                && Objects.equals(framerateNumerator(), other.framerateNumerator())
                && Objects.equals(gopBReferenceAsString(), other.gopBReferenceAsString())
                && Objects.equals(gopClosedCadence(), other.gopClosedCadence())
                && Objects.equals(gopNumBFrames(), other.gopNumBFrames()) && Objects.equals(gopSize(), other.gopSize())
                && Objects.equals(gopSizeUnitsAsString(), other.gopSizeUnitsAsString())
                && Objects.equals(levelAsString(), other.levelAsString())
                && Objects.equals(lookAheadRateControlAsString(), other.lookAheadRateControlAsString())
                && Objects.equals(maxBitrate(), other.maxBitrate()) && Objects.equals(minIInterval(), other.minIInterval())
                && Objects.equals(numRefFrames(), other.numRefFrames())
                && Objects.equals(parControlAsString(), other.parControlAsString())
                && Objects.equals(parDenominator(), other.parDenominator())
                && Objects.equals(parNumerator(), other.parNumerator())
                && Objects.equals(profileAsString(), other.profileAsString())
                && Objects.equals(qualityLevelAsString(), other.qualityLevelAsString())
                && Objects.equals(qvbrQualityLevel(), other.qvbrQualityLevel())
                && Objects.equals(rateControlModeAsString(), other.rateControlModeAsString())
                && Objects.equals(scanTypeAsString(), other.scanTypeAsString())
                && Objects.equals(sceneChangeDetectAsString(), other.sceneChangeDetectAsString())
                && Objects.equals(slices(), other.slices()) && Objects.equals(softness(), other.softness())
                && Objects.equals(spatialAqAsString(), other.spatialAqAsString())
                && Objects.equals(subgopLengthAsString(), other.subgopLengthAsString())
                && Objects.equals(syntaxAsString(), other.syntaxAsString())
                && Objects.equals(temporalAqAsString(), other.temporalAqAsString())
                && Objects.equals(timecodeInsertionAsString(), other.timecodeInsertionAsString())
                && Objects.equals(timecodeBurninSettings(), other.timecodeBurninSettings())
                && Objects.equals(minQp(), other.minQp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("H264Settings").add("AdaptiveQuantization", adaptiveQuantizationAsString())
                .add("AfdSignaling", afdSignalingAsString()).add("Bitrate", bitrate()).add("BufFillPct", bufFillPct())
                .add("BufSize", bufSize()).add("ColorMetadata", colorMetadataAsString())
                .add("ColorSpaceSettings", colorSpaceSettings()).add("EntropyEncoding", entropyEncodingAsString())
                .add("FilterSettings", filterSettings()).add("FixedAfd", fixedAfdAsString())
                .add("FlickerAq", flickerAqAsString()).add("ForceFieldPictures", forceFieldPicturesAsString())
                .add("FramerateControl", framerateControlAsString()).add("FramerateDenominator", framerateDenominator())
                .add("FramerateNumerator", framerateNumerator()).add("GopBReference", gopBReferenceAsString())
                .add("GopClosedCadence", gopClosedCadence()).add("GopNumBFrames", gopNumBFrames()).add("GopSize", gopSize())
                .add("GopSizeUnits", gopSizeUnitsAsString()).add("Level", levelAsString())
                .add("LookAheadRateControl", lookAheadRateControlAsString()).add("MaxBitrate", maxBitrate())
                .add("MinIInterval", minIInterval()).add("NumRefFrames", numRefFrames()).add("ParControl", parControlAsString())
                .add("ParDenominator", parDenominator()).add("ParNumerator", parNumerator()).add("Profile", profileAsString())
                .add("QualityLevel", qualityLevelAsString()).add("QvbrQualityLevel", qvbrQualityLevel())
                .add("RateControlMode", rateControlModeAsString()).add("ScanType", scanTypeAsString())
                .add("SceneChangeDetect", sceneChangeDetectAsString()).add("Slices", slices()).add("Softness", softness())
                .add("SpatialAq", spatialAqAsString()).add("SubgopLength", subgopLengthAsString())
                .add("Syntax", syntaxAsString()).add("TemporalAq", temporalAqAsString())
                .add("TimecodeInsertion", timecodeInsertionAsString()).add("TimecodeBurninSettings", timecodeBurninSettings())
                .add("MinQp", minQp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdaptiveQuantization":
            return Optional.ofNullable(clazz.cast(adaptiveQuantizationAsString()));
        case "AfdSignaling":
            return Optional.ofNullable(clazz.cast(afdSignalingAsString()));
        case "Bitrate":
            return Optional.ofNullable(clazz.cast(bitrate()));
        case "BufFillPct":
            return Optional.ofNullable(clazz.cast(bufFillPct()));
        case "BufSize":
            return Optional.ofNullable(clazz.cast(bufSize()));
        case "ColorMetadata":
            return Optional.ofNullable(clazz.cast(colorMetadataAsString()));
        case "ColorSpaceSettings":
            return Optional.ofNullable(clazz.cast(colorSpaceSettings()));
        case "EntropyEncoding":
            return Optional.ofNullable(clazz.cast(entropyEncodingAsString()));
        case "FilterSettings":
            return Optional.ofNullable(clazz.cast(filterSettings()));
        case "FixedAfd":
            return Optional.ofNullable(clazz.cast(fixedAfdAsString()));
        case "FlickerAq":
            return Optional.ofNullable(clazz.cast(flickerAqAsString()));
        case "ForceFieldPictures":
            return Optional.ofNullable(clazz.cast(forceFieldPicturesAsString()));
        case "FramerateControl":
            return Optional.ofNullable(clazz.cast(framerateControlAsString()));
        case "FramerateDenominator":
            return Optional.ofNullable(clazz.cast(framerateDenominator()));
        case "FramerateNumerator":
            return Optional.ofNullable(clazz.cast(framerateNumerator()));
        case "GopBReference":
            return Optional.ofNullable(clazz.cast(gopBReferenceAsString()));
        case "GopClosedCadence":
            return Optional.ofNullable(clazz.cast(gopClosedCadence()));
        case "GopNumBFrames":
            return Optional.ofNullable(clazz.cast(gopNumBFrames()));
        case "GopSize":
            return Optional.ofNullable(clazz.cast(gopSize()));
        case "GopSizeUnits":
            return Optional.ofNullable(clazz.cast(gopSizeUnitsAsString()));
        case "Level":
            return Optional.ofNullable(clazz.cast(levelAsString()));
        case "LookAheadRateControl":
            return Optional.ofNullable(clazz.cast(lookAheadRateControlAsString()));
        case "MaxBitrate":
            return Optional.ofNullable(clazz.cast(maxBitrate()));
        case "MinIInterval":
            return Optional.ofNullable(clazz.cast(minIInterval()));
        case "NumRefFrames":
            return Optional.ofNullable(clazz.cast(numRefFrames()));
        case "ParControl":
            return Optional.ofNullable(clazz.cast(parControlAsString()));
        case "ParDenominator":
            return Optional.ofNullable(clazz.cast(parDenominator()));
        case "ParNumerator":
            return Optional.ofNullable(clazz.cast(parNumerator()));
        case "Profile":
            return Optional.ofNullable(clazz.cast(profileAsString()));
        case "QualityLevel":
            return Optional.ofNullable(clazz.cast(qualityLevelAsString()));
        case "QvbrQualityLevel":
            return Optional.ofNullable(clazz.cast(qvbrQualityLevel()));
        case "RateControlMode":
            return Optional.ofNullable(clazz.cast(rateControlModeAsString()));
        case "ScanType":
            return Optional.ofNullable(clazz.cast(scanTypeAsString()));
        case "SceneChangeDetect":
            return Optional.ofNullable(clazz.cast(sceneChangeDetectAsString()));
        case "Slices":
            return Optional.ofNullable(clazz.cast(slices()));
        case "Softness":
            return Optional.ofNullable(clazz.cast(softness()));
        case "SpatialAq":
            return Optional.ofNullable(clazz.cast(spatialAqAsString()));
        case "SubgopLength":
            return Optional.ofNullable(clazz.cast(subgopLengthAsString()));
        case "Syntax":
            return Optional.ofNullable(clazz.cast(syntaxAsString()));
        case "TemporalAq":
            return Optional.ofNullable(clazz.cast(temporalAqAsString()));
        case "TimecodeInsertion":
            return Optional.ofNullable(clazz.cast(timecodeInsertionAsString()));
        case "TimecodeBurninSettings":
            return Optional.ofNullable(clazz.cast(timecodeBurninSettings()));
        case "MinQp":
            return Optional.ofNullable(clazz.cast(minQp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<H264Settings, T> g) {
        return obj -> g.apply((H264Settings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, H264Settings> {
        /**
         * Enables or disables adaptive quantization, which is a technique MediaLive can apply to video on a
         * frame-by-frame basis to produce more compression without losing quality. There are three types of adaptive
         * quantization: flicker, spatial, and temporal. Set the field in one of these ways: Set to Auto. Recommended.
         * For each type of AQ, MediaLive will determine if AQ is needed, and if so, the appropriate strength. Set a
         * strength (a value other than Auto or Disable). This strength will apply to any of the AQ fields that you
         * choose to enable. Set to Disabled to disable all types of adaptive quantization.
         * 
         * @param adaptiveQuantization
         *        Enables or disables adaptive quantization, which is a technique MediaLive can apply to video on a
         *        frame-by-frame basis to produce more compression without losing quality. There are three types of
         *        adaptive quantization: flicker, spatial, and temporal. Set the field in one of these ways: Set to
         *        Auto. Recommended. For each type of AQ, MediaLive will determine if AQ is needed, and if so, the
         *        appropriate strength. Set a strength (a value other than Auto or Disable). This strength will apply to
         *        any of the AQ fields that you choose to enable. Set to Disabled to disable all types of adaptive
         *        quantization.
         * @see H264AdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264AdaptiveQuantization
         */
        Builder adaptiveQuantization(String adaptiveQuantization);

        /**
         * Enables or disables adaptive quantization, which is a technique MediaLive can apply to video on a
         * frame-by-frame basis to produce more compression without losing quality. There are three types of adaptive
         * quantization: flicker, spatial, and temporal. Set the field in one of these ways: Set to Auto. Recommended.
         * For each type of AQ, MediaLive will determine if AQ is needed, and if so, the appropriate strength. Set a
         * strength (a value other than Auto or Disable). This strength will apply to any of the AQ fields that you
         * choose to enable. Set to Disabled to disable all types of adaptive quantization.
         * 
         * @param adaptiveQuantization
         *        Enables or disables adaptive quantization, which is a technique MediaLive can apply to video on a
         *        frame-by-frame basis to produce more compression without losing quality. There are three types of
         *        adaptive quantization: flicker, spatial, and temporal. Set the field in one of these ways: Set to
         *        Auto. Recommended. For each type of AQ, MediaLive will determine if AQ is needed, and if so, the
         *        appropriate strength. Set a strength (a value other than Auto or Disable). This strength will apply to
         *        any of the AQ fields that you choose to enable. Set to Disabled to disable all types of adaptive
         *        quantization.
         * @see H264AdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264AdaptiveQuantization
         */
        Builder adaptiveQuantization(H264AdaptiveQuantization adaptiveQuantization);

        /**
         * Indicates that AFD values will be written into the output stream. If afdSignaling is "auto", the system will
         * try to preserve the input AFD value (in cases where multiple AFD values are valid). If set to "fixed", the
         * AFD value will be the value configured in the fixedAfd parameter.
         * 
         * @param afdSignaling
         *        Indicates that AFD values will be written into the output stream. If afdSignaling is "auto", the
         *        system will try to preserve the input AFD value (in cases where multiple AFD values are valid). If set
         *        to "fixed", the AFD value will be the value configured in the fixedAfd parameter.
         * @see AfdSignaling
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AfdSignaling
         */
        Builder afdSignaling(String afdSignaling);

        /**
         * Indicates that AFD values will be written into the output stream. If afdSignaling is "auto", the system will
         * try to preserve the input AFD value (in cases where multiple AFD values are valid). If set to "fixed", the
         * AFD value will be the value configured in the fixedAfd parameter.
         * 
         * @param afdSignaling
         *        Indicates that AFD values will be written into the output stream. If afdSignaling is "auto", the
         *        system will try to preserve the input AFD value (in cases where multiple AFD values are valid). If set
         *        to "fixed", the AFD value will be the value configured in the fixedAfd parameter.
         * @see AfdSignaling
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AfdSignaling
         */
        Builder afdSignaling(AfdSignaling afdSignaling);

        /**
         * Average bitrate in bits/second. Required when the rate control mode is VBR or CBR. Not used for QVBR. In an
         * MS Smooth output group, each output must have a unique value when its bitrate is rounded down to the nearest
         * multiple of 1000.
         * 
         * @param bitrate
         *        Average bitrate in bits/second. Required when the rate control mode is VBR or CBR. Not used for QVBR.
         *        In an MS Smooth output group, each output must have a unique value when its bitrate is rounded down to
         *        the nearest multiple of 1000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bitrate(Integer bitrate);

        /**
         * Percentage of the buffer that should initially be filled (HRD buffer model).
         * 
         * @param bufFillPct
         *        Percentage of the buffer that should initially be filled (HRD buffer model).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bufFillPct(Integer bufFillPct);

        /**
         * Size of buffer (HRD buffer model) in bits.
         * 
         * @param bufSize
         *        Size of buffer (HRD buffer model) in bits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bufSize(Integer bufSize);

        /**
         * Includes colorspace metadata in the output.
         * 
         * @param colorMetadata
         *        Includes colorspace metadata in the output.
         * @see H264ColorMetadata
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264ColorMetadata
         */
        Builder colorMetadata(String colorMetadata);

        /**
         * Includes colorspace metadata in the output.
         * 
         * @param colorMetadata
         *        Includes colorspace metadata in the output.
         * @see H264ColorMetadata
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264ColorMetadata
         */
        Builder colorMetadata(H264ColorMetadata colorMetadata);

        /**
         * Color Space settings
         * 
         * @param colorSpaceSettings
         *        Color Space settings
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder colorSpaceSettings(H264ColorSpaceSettings colorSpaceSettings);

        /**
         * Color Space settings This is a convenience method that creates an instance of the
         * {@link H264ColorSpaceSettings.Builder} avoiding the need to create one manually via
         * {@link H264ColorSpaceSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link H264ColorSpaceSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #colorSpaceSettings(H264ColorSpaceSettings)}.
         * 
         * @param colorSpaceSettings
         *        a consumer that will call methods on {@link H264ColorSpaceSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #colorSpaceSettings(H264ColorSpaceSettings)
         */
        default Builder colorSpaceSettings(Consumer<H264ColorSpaceSettings.Builder> colorSpaceSettings) {
            return colorSpaceSettings(H264ColorSpaceSettings.builder().applyMutation(colorSpaceSettings).build());
        }

        /**
         * Entropy encoding mode. Use cabac (must be in Main or High profile) or cavlc.
         * 
         * @param entropyEncoding
         *        Entropy encoding mode. Use cabac (must be in Main or High profile) or cavlc.
         * @see H264EntropyEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264EntropyEncoding
         */
        Builder entropyEncoding(String entropyEncoding);

        /**
         * Entropy encoding mode. Use cabac (must be in Main or High profile) or cavlc.
         * 
         * @param entropyEncoding
         *        Entropy encoding mode. Use cabac (must be in Main or High profile) or cavlc.
         * @see H264EntropyEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264EntropyEncoding
         */
        Builder entropyEncoding(H264EntropyEncoding entropyEncoding);

        /**
         * Optional. Both filters reduce bandwidth by removing imperceptible details. You can enable one of the filters.
         * We recommend that you try both filters and observe the results to decide which one to use.
         *
         * The Temporal Filter reduces bandwidth by removing imperceptible details in the content. It combines
         * perceptual filtering and motion compensated temporal filtering (MCTF). It operates independently of the
         * compression level.
         *
         * The Bandwidth Reduction filter is a perceptual filter located within the encoding loop. It adapts to the
         * current compression level to filter imperceptible signals. This filter works only when the resolution is
         * 1080p or lower.
         * 
         * @param filterSettings
         *        Optional. Both filters reduce bandwidth by removing imperceptible details. You can enable one of the
         *        filters. We recommend that you try both filters and observe the results to decide which one to use.
         *
         *        The Temporal Filter reduces bandwidth by removing imperceptible details in the content. It combines
         *        perceptual filtering and motion compensated temporal filtering (MCTF). It operates independently of
         *        the compression level.
         *
         *        The Bandwidth Reduction filter is a perceptual filter located within the encoding loop. It adapts to
         *        the current compression level to filter imperceptible signals. This filter works only when the
         *        resolution is 1080p or lower.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterSettings(H264FilterSettings filterSettings);

        /**
         * Optional. Both filters reduce bandwidth by removing imperceptible details. You can enable one of the filters.
         * We recommend that you try both filters and observe the results to decide which one to use.
         *
         * The Temporal Filter reduces bandwidth by removing imperceptible details in the content. It combines
         * perceptual filtering and motion compensated temporal filtering (MCTF). It operates independently of the
         * compression level.
         *
         * The Bandwidth Reduction filter is a perceptual filter located within the encoding loop. It adapts to the
         * current compression level to filter imperceptible signals. This filter works only when the resolution is
         * 1080p or lower. This is a convenience method that creates an instance of the
         * {@link H264FilterSettings.Builder} avoiding the need to create one manually via
         * {@link H264FilterSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link H264FilterSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #filterSettings(H264FilterSettings)}.
         * 
         * @param filterSettings
         *        a consumer that will call methods on {@link H264FilterSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterSettings(H264FilterSettings)
         */
        default Builder filterSettings(Consumer<H264FilterSettings.Builder> filterSettings) {
            return filterSettings(H264FilterSettings.builder().applyMutation(filterSettings).build());
        }

        /**
         * Four bit AFD value to write on all frames of video in the output stream. Only valid when afdSignaling is set
         * to 'Fixed'.
         * 
         * @param fixedAfd
         *        Four bit AFD value to write on all frames of video in the output stream. Only valid when afdSignaling
         *        is set to 'Fixed'.
         * @see FixedAfd
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FixedAfd
         */
        Builder fixedAfd(String fixedAfd);

        /**
         * Four bit AFD value to write on all frames of video in the output stream. Only valid when afdSignaling is set
         * to 'Fixed'.
         * 
         * @param fixedAfd
         *        Four bit AFD value to write on all frames of video in the output stream. Only valid when afdSignaling
         *        is set to 'Fixed'.
         * @see FixedAfd
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FixedAfd
         */
        Builder fixedAfd(FixedAfd fixedAfd);

        /**
         * Flicker AQ makes adjustments within each frame to reduce flicker or 'pop' on I-frames. The value to enter in
         * this field depends on the value in the Adaptive quantization field: If you have set the Adaptive quantization
         * field to Auto, MediaLive ignores any value in this field. MediaLive will determine if flicker AQ is
         * appropriate and will apply the appropriate strength. If you have set the Adaptive quantization field to a
         * strength, you can set this field to Enabled or Disabled. Enabled: MediaLive will apply flicker AQ using the
         * specified strength. Disabled: MediaLive won't apply flicker AQ. If you have set the Adaptive quantization to
         * Disabled, MediaLive ignores any value in this field and doesn't apply flicker AQ.
         * 
         * @param flickerAq
         *        Flicker AQ makes adjustments within each frame to reduce flicker or 'pop' on I-frames. The value to
         *        enter in this field depends on the value in the Adaptive quantization field: If you have set the
         *        Adaptive quantization field to Auto, MediaLive ignores any value in this field. MediaLive will
         *        determine if flicker AQ is appropriate and will apply the appropriate strength. If you have set the
         *        Adaptive quantization field to a strength, you can set this field to Enabled or Disabled. Enabled:
         *        MediaLive will apply flicker AQ using the specified strength. Disabled: MediaLive won't apply flicker
         *        AQ. If you have set the Adaptive quantization to Disabled, MediaLive ignores any value in this field
         *        and doesn't apply flicker AQ.
         * @see H264FlickerAq
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264FlickerAq
         */
        Builder flickerAq(String flickerAq);

        /**
         * Flicker AQ makes adjustments within each frame to reduce flicker or 'pop' on I-frames. The value to enter in
         * this field depends on the value in the Adaptive quantization field: If you have set the Adaptive quantization
         * field to Auto, MediaLive ignores any value in this field. MediaLive will determine if flicker AQ is
         * appropriate and will apply the appropriate strength. If you have set the Adaptive quantization field to a
         * strength, you can set this field to Enabled or Disabled. Enabled: MediaLive will apply flicker AQ using the
         * specified strength. Disabled: MediaLive won't apply flicker AQ. If you have set the Adaptive quantization to
         * Disabled, MediaLive ignores any value in this field and doesn't apply flicker AQ.
         * 
         * @param flickerAq
         *        Flicker AQ makes adjustments within each frame to reduce flicker or 'pop' on I-frames. The value to
         *        enter in this field depends on the value in the Adaptive quantization field: If you have set the
         *        Adaptive quantization field to Auto, MediaLive ignores any value in this field. MediaLive will
         *        determine if flicker AQ is appropriate and will apply the appropriate strength. If you have set the
         *        Adaptive quantization field to a strength, you can set this field to Enabled or Disabled. Enabled:
         *        MediaLive will apply flicker AQ using the specified strength. Disabled: MediaLive won't apply flicker
         *        AQ. If you have set the Adaptive quantization to Disabled, MediaLive ignores any value in this field
         *        and doesn't apply flicker AQ.
         * @see H264FlickerAq
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264FlickerAq
         */
        Builder flickerAq(H264FlickerAq flickerAq);

        /**
         * This setting applies only when scan type is "interlaced." It controls whether coding is performed on a field
         * basis or on a frame basis. (When the video is progressive, the coding is always performed on a frame basis.)
         * enabled: Force MediaLive to code on a field basis, so that odd and even sets of fields are coded separately.
         * disabled: Code the two sets of fields separately (on a field basis) or together (on a frame basis using
         * PAFF), depending on what is most appropriate for the content.
         * 
         * @param forceFieldPictures
         *        This setting applies only when scan type is "interlaced." It controls whether coding is performed on a
         *        field basis or on a frame basis. (When the video is progressive, the coding is always performed on a
         *        frame basis.) enabled: Force MediaLive to code on a field basis, so that odd and even sets of fields
         *        are coded separately. disabled: Code the two sets of fields separately (on a field basis) or together
         *        (on a frame basis using PAFF), depending on what is most appropriate for the content.
         * @see H264ForceFieldPictures
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264ForceFieldPictures
         */
        Builder forceFieldPictures(String forceFieldPictures);

        /**
         * This setting applies only when scan type is "interlaced." It controls whether coding is performed on a field
         * basis or on a frame basis. (When the video is progressive, the coding is always performed on a frame basis.)
         * enabled: Force MediaLive to code on a field basis, so that odd and even sets of fields are coded separately.
         * disabled: Code the two sets of fields separately (on a field basis) or together (on a frame basis using
         * PAFF), depending on what is most appropriate for the content.
         * 
         * @param forceFieldPictures
         *        This setting applies only when scan type is "interlaced." It controls whether coding is performed on a
         *        field basis or on a frame basis. (When the video is progressive, the coding is always performed on a
         *        frame basis.) enabled: Force MediaLive to code on a field basis, so that odd and even sets of fields
         *        are coded separately. disabled: Code the two sets of fields separately (on a field basis) or together
         *        (on a frame basis using PAFF), depending on what is most appropriate for the content.
         * @see H264ForceFieldPictures
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264ForceFieldPictures
         */
        Builder forceFieldPictures(H264ForceFieldPictures forceFieldPictures);

        /**
         * This field indicates how the output video frame rate is specified. If "specified" is selected then the output
         * video frame rate is determined by framerateNumerator and framerateDenominator, else if "initializeFromSource"
         * is selected then the output video frame rate will be set equal to the input video frame rate of the first
         * input.
         * 
         * @param framerateControl
         *        This field indicates how the output video frame rate is specified. If "specified" is selected then the
         *        output video frame rate is determined by framerateNumerator and framerateDenominator, else if
         *        "initializeFromSource" is selected then the output video frame rate will be set equal to the input
         *        video frame rate of the first input.
         * @see H264FramerateControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264FramerateControl
         */
        Builder framerateControl(String framerateControl);

        /**
         * This field indicates how the output video frame rate is specified. If "specified" is selected then the output
         * video frame rate is determined by framerateNumerator and framerateDenominator, else if "initializeFromSource"
         * is selected then the output video frame rate will be set equal to the input video frame rate of the first
         * input.
         * 
         * @param framerateControl
         *        This field indicates how the output video frame rate is specified. If "specified" is selected then the
         *        output video frame rate is determined by framerateNumerator and framerateDenominator, else if
         *        "initializeFromSource" is selected then the output video frame rate will be set equal to the input
         *        video frame rate of the first input.
         * @see H264FramerateControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264FramerateControl
         */
        Builder framerateControl(H264FramerateControl framerateControl);

        /**
         * Framerate denominator.
         * 
         * @param framerateDenominator
         *        Framerate denominator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerateDenominator(Integer framerateDenominator);

        /**
         * Framerate numerator - framerate is a fraction, e.g. 24000 / 1001 = 23.976 fps.
         * 
         * @param framerateNumerator
         *        Framerate numerator - framerate is a fraction, e.g. 24000 / 1001 = 23.976 fps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerateNumerator(Integer framerateNumerator);

        /**
         * Documentation update needed
         * 
         * @param gopBReference
         *        Documentation update needed
         * @see H264GopBReference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264GopBReference
         */
        Builder gopBReference(String gopBReference);

        /**
         * Documentation update needed
         * 
         * @param gopBReference
         *        Documentation update needed
         * @see H264GopBReference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264GopBReference
         */
        Builder gopBReference(H264GopBReference gopBReference);

        /**
         * Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder
         * joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break
         * output segmenting.
         * 
         * @param gopClosedCadence
         *        Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a
         *        decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0
         *        will break output segmenting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gopClosedCadence(Integer gopClosedCadence);

        /**
         * Number of B-frames between reference frames.
         * 
         * @param gopNumBFrames
         *        Number of B-frames between reference frames.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gopNumBFrames(Integer gopNumBFrames);

        /**
         * GOP size (keyframe interval) in units of either frames or seconds per gopSizeUnits. If gopSizeUnits is
         * frames, gopSize must be an integer and must be greater than or equal to 1. If gopSizeUnits is seconds,
         * gopSize must be greater than 0, but need not be an integer.
         * 
         * @param gopSize
         *        GOP size (keyframe interval) in units of either frames or seconds per gopSizeUnits. If gopSizeUnits is
         *        frames, gopSize must be an integer and must be greater than or equal to 1. If gopSizeUnits is seconds,
         *        gopSize must be greater than 0, but need not be an integer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gopSize(Double gopSize);

        /**
         * Indicates if the gopSize is specified in frames or seconds. If seconds the system will convert the gopSize
         * into a frame count at run time.
         * 
         * @param gopSizeUnits
         *        Indicates if the gopSize is specified in frames or seconds. If seconds the system will convert the
         *        gopSize into a frame count at run time.
         * @see H264GopSizeUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264GopSizeUnits
         */
        Builder gopSizeUnits(String gopSizeUnits);

        /**
         * Indicates if the gopSize is specified in frames or seconds. If seconds the system will convert the gopSize
         * into a frame count at run time.
         * 
         * @param gopSizeUnits
         *        Indicates if the gopSize is specified in frames or seconds. If seconds the system will convert the
         *        gopSize into a frame count at run time.
         * @see H264GopSizeUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264GopSizeUnits
         */
        Builder gopSizeUnits(H264GopSizeUnits gopSizeUnits);

        /**
         * H.264 Level.
         * 
         * @param level
         *        H.264 Level.
         * @see H264Level
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264Level
         */
        Builder level(String level);

        /**
         * H.264 Level.
         * 
         * @param level
         *        H.264 Level.
         * @see H264Level
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264Level
         */
        Builder level(H264Level level);

        /**
         * Amount of lookahead. A value of low can decrease latency and memory usage, while high can produce better
         * quality for certain content.
         * 
         * @param lookAheadRateControl
         *        Amount of lookahead. A value of low can decrease latency and memory usage, while high can produce
         *        better quality for certain content.
         * @see H264LookAheadRateControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264LookAheadRateControl
         */
        Builder lookAheadRateControl(String lookAheadRateControl);

        /**
         * Amount of lookahead. A value of low can decrease latency and memory usage, while high can produce better
         * quality for certain content.
         * 
         * @param lookAheadRateControl
         *        Amount of lookahead. A value of low can decrease latency and memory usage, while high can produce
         *        better quality for certain content.
         * @see H264LookAheadRateControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264LookAheadRateControl
         */
        Builder lookAheadRateControl(H264LookAheadRateControl lookAheadRateControl);

        /**
         * For QVBR: See the tooltip for Quality level
         *
         * For VBR: Set the maximum bitrate in order to accommodate expected spikes in the complexity of the video.
         * 
         * @param maxBitrate
         *        For QVBR: See the tooltip for Quality level
         *
         *        For VBR: Set the maximum bitrate in order to accommodate expected spikes in the complexity of the
         *        video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxBitrate(Integer maxBitrate);

        /**
         * Only meaningful if sceneChangeDetect is set to enabled. Defaults to 5 if multiplex rate control is used.
         * Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a
         * scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or stretched to
         * the scene change I-frame. GOP stretch requires enabling lookahead as well as setting I-interval. The normal
         * cadence resumes for the next GOP. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1
         * 
         * @param minIInterval
         *        Only meaningful if sceneChangeDetect is set to enabled. Defaults to 5 if multiplex rate control is
         *        used. Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change
         *        Detection. If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is
         *        shrunk and/or stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well
         *        as setting I-interval. The normal cadence resumes for the next GOP. Note: Maximum GOP stretch = GOP
         *        size + Min-I-interval - 1
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minIInterval(Integer minIInterval);

        /**
         * Number of reference frames to use. The encoder may use more than requested if using B-frames and/or
         * interlaced encoding.
         * 
         * @param numRefFrames
         *        Number of reference frames to use. The encoder may use more than requested if using B-frames and/or
         *        interlaced encoding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numRefFrames(Integer numRefFrames);

        /**
         * This field indicates how the output pixel aspect ratio is specified. If "specified" is selected then the
         * output video pixel aspect ratio is determined by parNumerator and parDenominator, else if
         * "initializeFromSource" is selected then the output pixsel aspect ratio will be set equal to the input video
         * pixel aspect ratio of the first input.
         * 
         * @param parControl
         *        This field indicates how the output pixel aspect ratio is specified. If "specified" is selected then
         *        the output video pixel aspect ratio is determined by parNumerator and parDenominator, else if
         *        "initializeFromSource" is selected then the output pixsel aspect ratio will be set equal to the input
         *        video pixel aspect ratio of the first input.
         * @see H264ParControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264ParControl
         */
        Builder parControl(String parControl);

        /**
         * This field indicates how the output pixel aspect ratio is specified. If "specified" is selected then the
         * output video pixel aspect ratio is determined by parNumerator and parDenominator, else if
         * "initializeFromSource" is selected then the output pixsel aspect ratio will be set equal to the input video
         * pixel aspect ratio of the first input.
         * 
         * @param parControl
         *        This field indicates how the output pixel aspect ratio is specified. If "specified" is selected then
         *        the output video pixel aspect ratio is determined by parNumerator and parDenominator, else if
         *        "initializeFromSource" is selected then the output pixsel aspect ratio will be set equal to the input
         *        video pixel aspect ratio of the first input.
         * @see H264ParControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264ParControl
         */
        Builder parControl(H264ParControl parControl);

        /**
         * Pixel Aspect Ratio denominator.
         * 
         * @param parDenominator
         *        Pixel Aspect Ratio denominator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parDenominator(Integer parDenominator);

        /**
         * Pixel Aspect Ratio numerator.
         * 
         * @param parNumerator
         *        Pixel Aspect Ratio numerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parNumerator(Integer parNumerator);

        /**
         * H.264 Profile.
         * 
         * @param profile
         *        H.264 Profile.
         * @see H264Profile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264Profile
         */
        Builder profile(String profile);

        /**
         * H.264 Profile.
         * 
         * @param profile
         *        H.264 Profile.
         * @see H264Profile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264Profile
         */
        Builder profile(H264Profile profile);

        /**
         * Leave as STANDARD_QUALITY or choose a different value (which might result in additional costs to run the
         * channel). - ENHANCED_QUALITY: Produces a slightly better video quality without an increase in the bitrate.
         * Has an effect only when the Rate control mode is QVBR or CBR. If this channel is in a MediaLive multiplex,
         * the value must be ENHANCED_QUALITY. - STANDARD_QUALITY: Valid for any Rate control mode.
         * 
         * @param qualityLevel
         *        Leave as STANDARD_QUALITY or choose a different value (which might result in additional costs to run
         *        the channel). - ENHANCED_QUALITY: Produces a slightly better video quality without an increase in the
         *        bitrate. Has an effect only when the Rate control mode is QVBR or CBR. If this channel is in a
         *        MediaLive multiplex, the value must be ENHANCED_QUALITY. - STANDARD_QUALITY: Valid for any Rate
         *        control mode.
         * @see H264QualityLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264QualityLevel
         */
        Builder qualityLevel(String qualityLevel);

        /**
         * Leave as STANDARD_QUALITY or choose a different value (which might result in additional costs to run the
         * channel). - ENHANCED_QUALITY: Produces a slightly better video quality without an increase in the bitrate.
         * Has an effect only when the Rate control mode is QVBR or CBR. If this channel is in a MediaLive multiplex,
         * the value must be ENHANCED_QUALITY. - STANDARD_QUALITY: Valid for any Rate control mode.
         * 
         * @param qualityLevel
         *        Leave as STANDARD_QUALITY or choose a different value (which might result in additional costs to run
         *        the channel). - ENHANCED_QUALITY: Produces a slightly better video quality without an increase in the
         *        bitrate. Has an effect only when the Rate control mode is QVBR or CBR. If this channel is in a
         *        MediaLive multiplex, the value must be ENHANCED_QUALITY. - STANDARD_QUALITY: Valid for any Rate
         *        control mode.
         * @see H264QualityLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264QualityLevel
         */
        Builder qualityLevel(H264QualityLevel qualityLevel);

        /**
         * Controls the target quality for the video encode. Applies only when the rate control mode is QVBR. You can
         * set a target quality or you can let MediaLive determine the best quality. To set a target quality, enter
         * values in the QVBR quality level field and the Max bitrate field. Enter values that suit your most important
         * viewing devices. Recommended values are: - Primary screen: Quality level: 8 to 10. Max bitrate: 4M - PC or
         * tablet: Quality level: 7. Max bitrate: 1.5M to 3M - Smartphone: Quality level: 6. Max bitrate: 1M to 1.5M To
         * let MediaLive decide, leave the QVBR quality level field empty, and in Max bitrate enter the maximum rate you
         * want in the video. For more information, see the section called "Video - rate control mode" in the MediaLive
         * user guide
         * 
         * @param qvbrQualityLevel
         *        Controls the target quality for the video encode. Applies only when the rate control mode is QVBR. You
         *        can set a target quality or you can let MediaLive determine the best quality. To set a target quality,
         *        enter values in the QVBR quality level field and the Max bitrate field. Enter values that suit your
         *        most important viewing devices. Recommended values are: - Primary screen: Quality level: 8 to 10. Max
         *        bitrate: 4M - PC or tablet: Quality level: 7. Max bitrate: 1.5M to 3M - Smartphone: Quality level: 6.
         *        Max bitrate: 1M to 1.5M To let MediaLive decide, leave the QVBR quality level field empty, and in Max
         *        bitrate enter the maximum rate you want in the video. For more information, see the section called
         *        "Video - rate control mode" in the MediaLive user guide
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qvbrQualityLevel(Integer qvbrQualityLevel);

        /**
         * Rate control mode.
         *
         * QVBR: Quality will match the specified quality level except when it is constrained by the maximum bitrate.
         * Recommended if you or your viewers pay for bandwidth.
         *
         * VBR: Quality and bitrate vary, depending on the video complexity. Recommended instead of QVBR if you want to
         * maintain a specific average bitrate over the duration of the channel.
         *
         * CBR: Quality varies, depending on the video complexity. Recommended only if you distribute your assets to
         * devices that cannot handle variable bitrates.
         *
         * Multiplex: This rate control mode is only supported (and is required) when the video is being delivered to a
         * MediaLive Multiplex in which case the rate control configuration is controlled by the properties within the
         * Multiplex Program.
         * 
         * @param rateControlMode
         *        Rate control mode.
         *
         *        QVBR: Quality will match the specified quality level except when it is constrained by the maximum
         *        bitrate. Recommended if you or your viewers pay for bandwidth.
         *
         *        VBR: Quality and bitrate vary, depending on the video complexity. Recommended instead of QVBR if you
         *        want to maintain a specific average bitrate over the duration of the channel.
         *
         *        CBR: Quality varies, depending on the video complexity. Recommended only if you distribute your assets
         *        to devices that cannot handle variable bitrates.
         *
         *        Multiplex: This rate control mode is only supported (and is required) when the video is being
         *        delivered to a MediaLive Multiplex in which case the rate control configuration is controlled by the
         *        properties within the Multiplex Program.
         * @see H264RateControlMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264RateControlMode
         */
        Builder rateControlMode(String rateControlMode);

        /**
         * Rate control mode.
         *
         * QVBR: Quality will match the specified quality level except when it is constrained by the maximum bitrate.
         * Recommended if you or your viewers pay for bandwidth.
         *
         * VBR: Quality and bitrate vary, depending on the video complexity. Recommended instead of QVBR if you want to
         * maintain a specific average bitrate over the duration of the channel.
         *
         * CBR: Quality varies, depending on the video complexity. Recommended only if you distribute your assets to
         * devices that cannot handle variable bitrates.
         *
         * Multiplex: This rate control mode is only supported (and is required) when the video is being delivered to a
         * MediaLive Multiplex in which case the rate control configuration is controlled by the properties within the
         * Multiplex Program.
         * 
         * @param rateControlMode
         *        Rate control mode.
         *
         *        QVBR: Quality will match the specified quality level except when it is constrained by the maximum
         *        bitrate. Recommended if you or your viewers pay for bandwidth.
         *
         *        VBR: Quality and bitrate vary, depending on the video complexity. Recommended instead of QVBR if you
         *        want to maintain a specific average bitrate over the duration of the channel.
         *
         *        CBR: Quality varies, depending on the video complexity. Recommended only if you distribute your assets
         *        to devices that cannot handle variable bitrates.
         *
         *        Multiplex: This rate control mode is only supported (and is required) when the video is being
         *        delivered to a MediaLive Multiplex in which case the rate control configuration is controlled by the
         *        properties within the Multiplex Program.
         * @see H264RateControlMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264RateControlMode
         */
        Builder rateControlMode(H264RateControlMode rateControlMode);

        /**
         * Sets the scan type of the output to progressive or top-field-first interlaced.
         * 
         * @param scanType
         *        Sets the scan type of the output to progressive or top-field-first interlaced.
         * @see H264ScanType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264ScanType
         */
        Builder scanType(String scanType);

        /**
         * Sets the scan type of the output to progressive or top-field-first interlaced.
         * 
         * @param scanType
         *        Sets the scan type of the output to progressive or top-field-first interlaced.
         * @see H264ScanType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264ScanType
         */
        Builder scanType(H264ScanType scanType);

        /**
         * Scene change detection.
         *
         * - On: inserts I-frames when scene change is detected. - Off: does not force an I-frame when scene change is
         * detected.
         * 
         * @param sceneChangeDetect
         *        Scene change detection.
         *
         *        - On: inserts I-frames when scene change is detected. - Off: does not force an I-frame when scene
         *        change is detected.
         * @see H264SceneChangeDetect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264SceneChangeDetect
         */
        Builder sceneChangeDetect(String sceneChangeDetect);

        /**
         * Scene change detection.
         *
         * - On: inserts I-frames when scene change is detected. - Off: does not force an I-frame when scene change is
         * detected.
         * 
         * @param sceneChangeDetect
         *        Scene change detection.
         *
         *        - On: inserts I-frames when scene change is detected. - Off: does not force an I-frame when scene
         *        change is detected.
         * @see H264SceneChangeDetect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264SceneChangeDetect
         */
        Builder sceneChangeDetect(H264SceneChangeDetect sceneChangeDetect);

        /**
         * Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive
         * pictures, and less than or equal to half the number of macroblock rows for interlaced pictures. This field is
         * optional; when no value is specified the encoder will choose the number of slices based on encode resolution.
         * 
         * @param slices
         *        Number of slices per picture. Must be less than or equal to the number of macroblock rows for
         *        progressive pictures, and less than or equal to half the number of macroblock rows for interlaced
         *        pictures. This field is optional; when no value is specified the encoder will choose the number of
         *        slices based on encode resolution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slices(Integer slices);

        /**
         * Softness. Selects quantizer matrix, larger values reduce high-frequency content in the encoded image. If not
         * set to zero, must be greater than 15.
         * 
         * @param softness
         *        Softness. Selects quantizer matrix, larger values reduce high-frequency content in the encoded image.
         *        If not set to zero, must be greater than 15.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder softness(Integer softness);

        /**
         * Spatial AQ makes adjustments within each frame based on spatial variation of content complexity. The value to
         * enter in this field depends on the value in the Adaptive quantization field: If you have set the Adaptive
         * quantization field to Auto, MediaLive ignores any value in this field. MediaLive will determine if spatial AQ
         * is appropriate and will apply the appropriate strength. If you have set the Adaptive quantization field to a
         * strength, you can set this field to Enabled or Disabled. Enabled: MediaLive will apply spatial AQ using the
         * specified strength. Disabled: MediaLive won't apply spatial AQ. If you have set the Adaptive quantization to
         * Disabled, MediaLive ignores any value in this field and doesn't apply spatial AQ.
         * 
         * @param spatialAq
         *        Spatial AQ makes adjustments within each frame based on spatial variation of content complexity. The
         *        value to enter in this field depends on the value in the Adaptive quantization field: If you have set
         *        the Adaptive quantization field to Auto, MediaLive ignores any value in this field. MediaLive will
         *        determine if spatial AQ is appropriate and will apply the appropriate strength. If you have set the
         *        Adaptive quantization field to a strength, you can set this field to Enabled or Disabled. Enabled:
         *        MediaLive will apply spatial AQ using the specified strength. Disabled: MediaLive won't apply spatial
         *        AQ. If you have set the Adaptive quantization to Disabled, MediaLive ignores any value in this field
         *        and doesn't apply spatial AQ.
         * @see H264SpatialAq
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264SpatialAq
         */
        Builder spatialAq(String spatialAq);

        /**
         * Spatial AQ makes adjustments within each frame based on spatial variation of content complexity. The value to
         * enter in this field depends on the value in the Adaptive quantization field: If you have set the Adaptive
         * quantization field to Auto, MediaLive ignores any value in this field. MediaLive will determine if spatial AQ
         * is appropriate and will apply the appropriate strength. If you have set the Adaptive quantization field to a
         * strength, you can set this field to Enabled or Disabled. Enabled: MediaLive will apply spatial AQ using the
         * specified strength. Disabled: MediaLive won't apply spatial AQ. If you have set the Adaptive quantization to
         * Disabled, MediaLive ignores any value in this field and doesn't apply spatial AQ.
         * 
         * @param spatialAq
         *        Spatial AQ makes adjustments within each frame based on spatial variation of content complexity. The
         *        value to enter in this field depends on the value in the Adaptive quantization field: If you have set
         *        the Adaptive quantization field to Auto, MediaLive ignores any value in this field. MediaLive will
         *        determine if spatial AQ is appropriate and will apply the appropriate strength. If you have set the
         *        Adaptive quantization field to a strength, you can set this field to Enabled or Disabled. Enabled:
         *        MediaLive will apply spatial AQ using the specified strength. Disabled: MediaLive won't apply spatial
         *        AQ. If you have set the Adaptive quantization to Disabled, MediaLive ignores any value in this field
         *        and doesn't apply spatial AQ.
         * @see H264SpatialAq
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264SpatialAq
         */
        Builder spatialAq(H264SpatialAq spatialAq);

        /**
         * If set to fixed, use gopNumBFrames B-frames per sub-GOP. If set to dynamic, optimize the number of B-frames
         * used for each sub-GOP to improve visual quality.
         * 
         * @param subgopLength
         *        If set to fixed, use gopNumBFrames B-frames per sub-GOP. If set to dynamic, optimize the number of
         *        B-frames used for each sub-GOP to improve visual quality.
         * @see H264SubGopLength
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264SubGopLength
         */
        Builder subgopLength(String subgopLength);

        /**
         * If set to fixed, use gopNumBFrames B-frames per sub-GOP. If set to dynamic, optimize the number of B-frames
         * used for each sub-GOP to improve visual quality.
         * 
         * @param subgopLength
         *        If set to fixed, use gopNumBFrames B-frames per sub-GOP. If set to dynamic, optimize the number of
         *        B-frames used for each sub-GOP to improve visual quality.
         * @see H264SubGopLength
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264SubGopLength
         */
        Builder subgopLength(H264SubGopLength subgopLength);

        /**
         * Produces a bitstream compliant with SMPTE RP-2027.
         * 
         * @param syntax
         *        Produces a bitstream compliant with SMPTE RP-2027.
         * @see H264Syntax
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264Syntax
         */
        Builder syntax(String syntax);

        /**
         * Produces a bitstream compliant with SMPTE RP-2027.
         * 
         * @param syntax
         *        Produces a bitstream compliant with SMPTE RP-2027.
         * @see H264Syntax
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264Syntax
         */
        Builder syntax(H264Syntax syntax);

        /**
         * Temporal makes adjustments within each frame based on temporal variation of content complexity. The value to
         * enter in this field depends on the value in the Adaptive quantization field: If you have set the Adaptive
         * quantization field to Auto, MediaLive ignores any value in this field. MediaLive will determine if temporal
         * AQ is appropriate and will apply the appropriate strength. If you have set the Adaptive quantization field to
         * a strength, you can set this field to Enabled or Disabled. Enabled: MediaLive will apply temporal AQ using
         * the specified strength. Disabled: MediaLive won't apply temporal AQ. If you have set the Adaptive
         * quantization to Disabled, MediaLive ignores any value in this field and doesn't apply temporal AQ.
         * 
         * @param temporalAq
         *        Temporal makes adjustments within each frame based on temporal variation of content complexity. The
         *        value to enter in this field depends on the value in the Adaptive quantization field: If you have set
         *        the Adaptive quantization field to Auto, MediaLive ignores any value in this field. MediaLive will
         *        determine if temporal AQ is appropriate and will apply the appropriate strength. If you have set the
         *        Adaptive quantization field to a strength, you can set this field to Enabled or Disabled. Enabled:
         *        MediaLive will apply temporal AQ using the specified strength. Disabled: MediaLive won't apply
         *        temporal AQ. If you have set the Adaptive quantization to Disabled, MediaLive ignores any value in
         *        this field and doesn't apply temporal AQ.
         * @see H264TemporalAq
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264TemporalAq
         */
        Builder temporalAq(String temporalAq);

        /**
         * Temporal makes adjustments within each frame based on temporal variation of content complexity. The value to
         * enter in this field depends on the value in the Adaptive quantization field: If you have set the Adaptive
         * quantization field to Auto, MediaLive ignores any value in this field. MediaLive will determine if temporal
         * AQ is appropriate and will apply the appropriate strength. If you have set the Adaptive quantization field to
         * a strength, you can set this field to Enabled or Disabled. Enabled: MediaLive will apply temporal AQ using
         * the specified strength. Disabled: MediaLive won't apply temporal AQ. If you have set the Adaptive
         * quantization to Disabled, MediaLive ignores any value in this field and doesn't apply temporal AQ.
         * 
         * @param temporalAq
         *        Temporal makes adjustments within each frame based on temporal variation of content complexity. The
         *        value to enter in this field depends on the value in the Adaptive quantization field: If you have set
         *        the Adaptive quantization field to Auto, MediaLive ignores any value in this field. MediaLive will
         *        determine if temporal AQ is appropriate and will apply the appropriate strength. If you have set the
         *        Adaptive quantization field to a strength, you can set this field to Enabled or Disabled. Enabled:
         *        MediaLive will apply temporal AQ using the specified strength. Disabled: MediaLive won't apply
         *        temporal AQ. If you have set the Adaptive quantization to Disabled, MediaLive ignores any value in
         *        this field and doesn't apply temporal AQ.
         * @see H264TemporalAq
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264TemporalAq
         */
        Builder temporalAq(H264TemporalAq temporalAq);

        /**
         * Determines how timecodes should be inserted into the video elementary stream. - 'disabled': Do not include
         * timecodes - 'picTimingSei': Pass through picture timing SEI messages from the source specified in Timecode
         * Config
         * 
         * @param timecodeInsertion
         *        Determines how timecodes should be inserted into the video elementary stream. - 'disabled': Do not
         *        include timecodes - 'picTimingSei': Pass through picture timing SEI messages from the source specified
         *        in Timecode Config
         * @see H264TimecodeInsertionBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264TimecodeInsertionBehavior
         */
        Builder timecodeInsertion(String timecodeInsertion);

        /**
         * Determines how timecodes should be inserted into the video elementary stream. - 'disabled': Do not include
         * timecodes - 'picTimingSei': Pass through picture timing SEI messages from the source specified in Timecode
         * Config
         * 
         * @param timecodeInsertion
         *        Determines how timecodes should be inserted into the video elementary stream. - 'disabled': Do not
         *        include timecodes - 'picTimingSei': Pass through picture timing SEI messages from the source specified
         *        in Timecode Config
         * @see H264TimecodeInsertionBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264TimecodeInsertionBehavior
         */
        Builder timecodeInsertion(H264TimecodeInsertionBehavior timecodeInsertion);

        /**
         * Timecode burn-in settings
         * 
         * @param timecodeBurninSettings
         *        Timecode burn-in settings
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timecodeBurninSettings(TimecodeBurninSettings timecodeBurninSettings);

        /**
         * Timecode burn-in settings This is a convenience method that creates an instance of the
         * {@link TimecodeBurninSettings.Builder} avoiding the need to create one manually via
         * {@link TimecodeBurninSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimecodeBurninSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #timecodeBurninSettings(TimecodeBurninSettings)}.
         * 
         * @param timecodeBurninSettings
         *        a consumer that will call methods on {@link TimecodeBurninSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timecodeBurninSettings(TimecodeBurninSettings)
         */
        default Builder timecodeBurninSettings(Consumer<TimecodeBurninSettings.Builder> timecodeBurninSettings) {
            return timecodeBurninSettings(TimecodeBurninSettings.builder().applyMutation(timecodeBurninSettings).build());
        }

        /**
         * Sets the minimum QP. If you aren't familiar with quantization adjustment, leave the field empty. MediaLive
         * will apply an appropriate value.
         * 
         * @param minQp
         *        Sets the minimum QP. If you aren't familiar with quantization adjustment, leave the field empty.
         *        MediaLive will apply an appropriate value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minQp(Integer minQp);
    }

    static final class BuilderImpl implements Builder {
        private String adaptiveQuantization;

        private String afdSignaling;

        private Integer bitrate;

        private Integer bufFillPct;

        private Integer bufSize;

        private String colorMetadata;

        private H264ColorSpaceSettings colorSpaceSettings;

        private String entropyEncoding;

        private H264FilterSettings filterSettings;

        private String fixedAfd;

        private String flickerAq;

        private String forceFieldPictures;

        private String framerateControl;

        private Integer framerateDenominator;

        private Integer framerateNumerator;

        private String gopBReference;

        private Integer gopClosedCadence;

        private Integer gopNumBFrames;

        private Double gopSize;

        private String gopSizeUnits;

        private String level;

        private String lookAheadRateControl;

        private Integer maxBitrate;

        private Integer minIInterval;

        private Integer numRefFrames;

        private String parControl;

        private Integer parDenominator;

        private Integer parNumerator;

        private String profile;

        private String qualityLevel;

        private Integer qvbrQualityLevel;

        private String rateControlMode;

        private String scanType;

        private String sceneChangeDetect;

        private Integer slices;

        private Integer softness;

        private String spatialAq;

        private String subgopLength;

        private String syntax;

        private String temporalAq;

        private String timecodeInsertion;

        private TimecodeBurninSettings timecodeBurninSettings;

        private Integer minQp;

        private BuilderImpl() {
        }

        private BuilderImpl(H264Settings model) {
            adaptiveQuantization(model.adaptiveQuantization);
            afdSignaling(model.afdSignaling);
            bitrate(model.bitrate);
            bufFillPct(model.bufFillPct);
            bufSize(model.bufSize);
            colorMetadata(model.colorMetadata);
            colorSpaceSettings(model.colorSpaceSettings);
            entropyEncoding(model.entropyEncoding);
            filterSettings(model.filterSettings);
            fixedAfd(model.fixedAfd);
            flickerAq(model.flickerAq);
            forceFieldPictures(model.forceFieldPictures);
            framerateControl(model.framerateControl);
            framerateDenominator(model.framerateDenominator);
            framerateNumerator(model.framerateNumerator);
            gopBReference(model.gopBReference);
            gopClosedCadence(model.gopClosedCadence);
            gopNumBFrames(model.gopNumBFrames);
            gopSize(model.gopSize);
            gopSizeUnits(model.gopSizeUnits);
            level(model.level);
            lookAheadRateControl(model.lookAheadRateControl);
            maxBitrate(model.maxBitrate);
            minIInterval(model.minIInterval);
            numRefFrames(model.numRefFrames);
            parControl(model.parControl);
            parDenominator(model.parDenominator);
            parNumerator(model.parNumerator);
            profile(model.profile);
            qualityLevel(model.qualityLevel);
            qvbrQualityLevel(model.qvbrQualityLevel);
            rateControlMode(model.rateControlMode);
            scanType(model.scanType);
            sceneChangeDetect(model.sceneChangeDetect);
            slices(model.slices);
            softness(model.softness);
            spatialAq(model.spatialAq);
            subgopLength(model.subgopLength);
            syntax(model.syntax);
            temporalAq(model.temporalAq);
            timecodeInsertion(model.timecodeInsertion);
            timecodeBurninSettings(model.timecodeBurninSettings);
            minQp(model.minQp);
        }

        public final String getAdaptiveQuantization() {
            return adaptiveQuantization;
        }

        public final void setAdaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
        }

        @Override
        public final Builder adaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
            return this;
        }

        @Override
        public final Builder adaptiveQuantization(H264AdaptiveQuantization adaptiveQuantization) {
            this.adaptiveQuantization(adaptiveQuantization == null ? null : adaptiveQuantization.toString());
            return this;
        }

        public final String getAfdSignaling() {
            return afdSignaling;
        }

        public final void setAfdSignaling(String afdSignaling) {
            this.afdSignaling = afdSignaling;
        }

        @Override
        public final Builder afdSignaling(String afdSignaling) {
            this.afdSignaling = afdSignaling;
            return this;
        }

        @Override
        public final Builder afdSignaling(AfdSignaling afdSignaling) {
            this.afdSignaling(afdSignaling == null ? null : afdSignaling.toString());
            return this;
        }

        public final Integer getBitrate() {
            return bitrate;
        }

        public final void setBitrate(Integer bitrate) {
            this.bitrate = bitrate;
        }

        @Override
        public final Builder bitrate(Integer bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final Integer getBufFillPct() {
            return bufFillPct;
        }

        public final void setBufFillPct(Integer bufFillPct) {
            this.bufFillPct = bufFillPct;
        }

        @Override
        public final Builder bufFillPct(Integer bufFillPct) {
            this.bufFillPct = bufFillPct;
            return this;
        }

        public final Integer getBufSize() {
            return bufSize;
        }

        public final void setBufSize(Integer bufSize) {
            this.bufSize = bufSize;
        }

        @Override
        public final Builder bufSize(Integer bufSize) {
            this.bufSize = bufSize;
            return this;
        }

        public final String getColorMetadata() {
            return colorMetadata;
        }

        public final void setColorMetadata(String colorMetadata) {
            this.colorMetadata = colorMetadata;
        }

        @Override
        public final Builder colorMetadata(String colorMetadata) {
            this.colorMetadata = colorMetadata;
            return this;
        }

        @Override
        public final Builder colorMetadata(H264ColorMetadata colorMetadata) {
            this.colorMetadata(colorMetadata == null ? null : colorMetadata.toString());
            return this;
        }

        public final H264ColorSpaceSettings.Builder getColorSpaceSettings() {
            return colorSpaceSettings != null ? colorSpaceSettings.toBuilder() : null;
        }

        public final void setColorSpaceSettings(H264ColorSpaceSettings.BuilderImpl colorSpaceSettings) {
            this.colorSpaceSettings = colorSpaceSettings != null ? colorSpaceSettings.build() : null;
        }

        @Override
        public final Builder colorSpaceSettings(H264ColorSpaceSettings colorSpaceSettings) {
            this.colorSpaceSettings = colorSpaceSettings;
            return this;
        }

        public final String getEntropyEncoding() {
            return entropyEncoding;
        }

        public final void setEntropyEncoding(String entropyEncoding) {
            this.entropyEncoding = entropyEncoding;
        }

        @Override
        public final Builder entropyEncoding(String entropyEncoding) {
            this.entropyEncoding = entropyEncoding;
            return this;
        }

        @Override
        public final Builder entropyEncoding(H264EntropyEncoding entropyEncoding) {
            this.entropyEncoding(entropyEncoding == null ? null : entropyEncoding.toString());
            return this;
        }

        public final H264FilterSettings.Builder getFilterSettings() {
            return filterSettings != null ? filterSettings.toBuilder() : null;
        }

        public final void setFilterSettings(H264FilterSettings.BuilderImpl filterSettings) {
            this.filterSettings = filterSettings != null ? filterSettings.build() : null;
        }

        @Override
        public final Builder filterSettings(H264FilterSettings filterSettings) {
            this.filterSettings = filterSettings;
            return this;
        }

        public final String getFixedAfd() {
            return fixedAfd;
        }

        public final void setFixedAfd(String fixedAfd) {
            this.fixedAfd = fixedAfd;
        }

        @Override
        public final Builder fixedAfd(String fixedAfd) {
            this.fixedAfd = fixedAfd;
            return this;
        }

        @Override
        public final Builder fixedAfd(FixedAfd fixedAfd) {
            this.fixedAfd(fixedAfd == null ? null : fixedAfd.toString());
            return this;
        }

        public final String getFlickerAq() {
            return flickerAq;
        }

        public final void setFlickerAq(String flickerAq) {
            this.flickerAq = flickerAq;
        }

        @Override
        public final Builder flickerAq(String flickerAq) {
            this.flickerAq = flickerAq;
            return this;
        }

        @Override
        public final Builder flickerAq(H264FlickerAq flickerAq) {
            this.flickerAq(flickerAq == null ? null : flickerAq.toString());
            return this;
        }

        public final String getForceFieldPictures() {
            return forceFieldPictures;
        }

        public final void setForceFieldPictures(String forceFieldPictures) {
            this.forceFieldPictures = forceFieldPictures;
        }

        @Override
        public final Builder forceFieldPictures(String forceFieldPictures) {
            this.forceFieldPictures = forceFieldPictures;
            return this;
        }

        @Override
        public final Builder forceFieldPictures(H264ForceFieldPictures forceFieldPictures) {
            this.forceFieldPictures(forceFieldPictures == null ? null : forceFieldPictures.toString());
            return this;
        }

        public final String getFramerateControl() {
            return framerateControl;
        }

        public final void setFramerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
        }

        @Override
        public final Builder framerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
            return this;
        }

        @Override
        public final Builder framerateControl(H264FramerateControl framerateControl) {
            this.framerateControl(framerateControl == null ? null : framerateControl.toString());
            return this;
        }

        public final Integer getFramerateDenominator() {
            return framerateDenominator;
        }

        public final void setFramerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
        }

        @Override
        public final Builder framerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
            return this;
        }

        public final Integer getFramerateNumerator() {
            return framerateNumerator;
        }

        public final void setFramerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
        }

        @Override
        public final Builder framerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
            return this;
        }

        public final String getGopBReference() {
            return gopBReference;
        }

        public final void setGopBReference(String gopBReference) {
            this.gopBReference = gopBReference;
        }

        @Override
        public final Builder gopBReference(String gopBReference) {
            this.gopBReference = gopBReference;
            return this;
        }

        @Override
        public final Builder gopBReference(H264GopBReference gopBReference) {
            this.gopBReference(gopBReference == null ? null : gopBReference.toString());
            return this;
        }

        public final Integer getGopClosedCadence() {
            return gopClosedCadence;
        }

        public final void setGopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
        }

        @Override
        public final Builder gopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
            return this;
        }

        public final Integer getGopNumBFrames() {
            return gopNumBFrames;
        }

        public final void setGopNumBFrames(Integer gopNumBFrames) {
            this.gopNumBFrames = gopNumBFrames;
        }

        @Override
        public final Builder gopNumBFrames(Integer gopNumBFrames) {
            this.gopNumBFrames = gopNumBFrames;
            return this;
        }

        public final Double getGopSize() {
            return gopSize;
        }

        public final void setGopSize(Double gopSize) {
            this.gopSize = gopSize;
        }

        @Override
        public final Builder gopSize(Double gopSize) {
            this.gopSize = gopSize;
            return this;
        }

        public final String getGopSizeUnits() {
            return gopSizeUnits;
        }

        public final void setGopSizeUnits(String gopSizeUnits) {
            this.gopSizeUnits = gopSizeUnits;
        }

        @Override
        public final Builder gopSizeUnits(String gopSizeUnits) {
            this.gopSizeUnits = gopSizeUnits;
            return this;
        }

        @Override
        public final Builder gopSizeUnits(H264GopSizeUnits gopSizeUnits) {
            this.gopSizeUnits(gopSizeUnits == null ? null : gopSizeUnits.toString());
            return this;
        }

        public final String getLevel() {
            return level;
        }

        public final void setLevel(String level) {
            this.level = level;
        }

        @Override
        public final Builder level(String level) {
            this.level = level;
            return this;
        }

        @Override
        public final Builder level(H264Level level) {
            this.level(level == null ? null : level.toString());
            return this;
        }

        public final String getLookAheadRateControl() {
            return lookAheadRateControl;
        }

        public final void setLookAheadRateControl(String lookAheadRateControl) {
            this.lookAheadRateControl = lookAheadRateControl;
        }

        @Override
        public final Builder lookAheadRateControl(String lookAheadRateControl) {
            this.lookAheadRateControl = lookAheadRateControl;
            return this;
        }

        @Override
        public final Builder lookAheadRateControl(H264LookAheadRateControl lookAheadRateControl) {
            this.lookAheadRateControl(lookAheadRateControl == null ? null : lookAheadRateControl.toString());
            return this;
        }

        public final Integer getMaxBitrate() {
            return maxBitrate;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        @Override
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public final Integer getMinIInterval() {
            return minIInterval;
        }

        public final void setMinIInterval(Integer minIInterval) {
            this.minIInterval = minIInterval;
        }

        @Override
        public final Builder minIInterval(Integer minIInterval) {
            this.minIInterval = minIInterval;
            return this;
        }

        public final Integer getNumRefFrames() {
            return numRefFrames;
        }

        public final void setNumRefFrames(Integer numRefFrames) {
            this.numRefFrames = numRefFrames;
        }

        @Override
        public final Builder numRefFrames(Integer numRefFrames) {
            this.numRefFrames = numRefFrames;
            return this;
        }

        public final String getParControl() {
            return parControl;
        }

        public final void setParControl(String parControl) {
            this.parControl = parControl;
        }

        @Override
        public final Builder parControl(String parControl) {
            this.parControl = parControl;
            return this;
        }

        @Override
        public final Builder parControl(H264ParControl parControl) {
            this.parControl(parControl == null ? null : parControl.toString());
            return this;
        }

        public final Integer getParDenominator() {
            return parDenominator;
        }

        public final void setParDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
        }

        @Override
        public final Builder parDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
            return this;
        }

        public final Integer getParNumerator() {
            return parNumerator;
        }

        public final void setParNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
        }

        @Override
        public final Builder parNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
            return this;
        }

        public final String getProfile() {
            return profile;
        }

        public final void setProfile(String profile) {
            this.profile = profile;
        }

        @Override
        public final Builder profile(String profile) {
            this.profile = profile;
            return this;
        }

        @Override
        public final Builder profile(H264Profile profile) {
            this.profile(profile == null ? null : profile.toString());
            return this;
        }

        public final String getQualityLevel() {
            return qualityLevel;
        }

        public final void setQualityLevel(String qualityLevel) {
            this.qualityLevel = qualityLevel;
        }

        @Override
        public final Builder qualityLevel(String qualityLevel) {
            this.qualityLevel = qualityLevel;
            return this;
        }

        @Override
        public final Builder qualityLevel(H264QualityLevel qualityLevel) {
            this.qualityLevel(qualityLevel == null ? null : qualityLevel.toString());
            return this;
        }

        public final Integer getQvbrQualityLevel() {
            return qvbrQualityLevel;
        }

        public final void setQvbrQualityLevel(Integer qvbrQualityLevel) {
            this.qvbrQualityLevel = qvbrQualityLevel;
        }

        @Override
        public final Builder qvbrQualityLevel(Integer qvbrQualityLevel) {
            this.qvbrQualityLevel = qvbrQualityLevel;
            return this;
        }

        public final String getRateControlMode() {
            return rateControlMode;
        }

        public final void setRateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
        }

        @Override
        public final Builder rateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
            return this;
        }

        @Override
        public final Builder rateControlMode(H264RateControlMode rateControlMode) {
            this.rateControlMode(rateControlMode == null ? null : rateControlMode.toString());
            return this;
        }

        public final String getScanType() {
            return scanType;
        }

        public final void setScanType(String scanType) {
            this.scanType = scanType;
        }

        @Override
        public final Builder scanType(String scanType) {
            this.scanType = scanType;
            return this;
        }

        @Override
        public final Builder scanType(H264ScanType scanType) {
            this.scanType(scanType == null ? null : scanType.toString());
            return this;
        }

        public final String getSceneChangeDetect() {
            return sceneChangeDetect;
        }

        public final void setSceneChangeDetect(String sceneChangeDetect) {
            this.sceneChangeDetect = sceneChangeDetect;
        }

        @Override
        public final Builder sceneChangeDetect(String sceneChangeDetect) {
            this.sceneChangeDetect = sceneChangeDetect;
            return this;
        }

        @Override
        public final Builder sceneChangeDetect(H264SceneChangeDetect sceneChangeDetect) {
            this.sceneChangeDetect(sceneChangeDetect == null ? null : sceneChangeDetect.toString());
            return this;
        }

        public final Integer getSlices() {
            return slices;
        }

        public final void setSlices(Integer slices) {
            this.slices = slices;
        }

        @Override
        public final Builder slices(Integer slices) {
            this.slices = slices;
            return this;
        }

        public final Integer getSoftness() {
            return softness;
        }

        public final void setSoftness(Integer softness) {
            this.softness = softness;
        }

        @Override
        public final Builder softness(Integer softness) {
            this.softness = softness;
            return this;
        }

        public final String getSpatialAq() {
            return spatialAq;
        }

        public final void setSpatialAq(String spatialAq) {
            this.spatialAq = spatialAq;
        }

        @Override
        public final Builder spatialAq(String spatialAq) {
            this.spatialAq = spatialAq;
            return this;
        }

        @Override
        public final Builder spatialAq(H264SpatialAq spatialAq) {
            this.spatialAq(spatialAq == null ? null : spatialAq.toString());
            return this;
        }

        public final String getSubgopLength() {
            return subgopLength;
        }

        public final void setSubgopLength(String subgopLength) {
            this.subgopLength = subgopLength;
        }

        @Override
        public final Builder subgopLength(String subgopLength) {
            this.subgopLength = subgopLength;
            return this;
        }

        @Override
        public final Builder subgopLength(H264SubGopLength subgopLength) {
            this.subgopLength(subgopLength == null ? null : subgopLength.toString());
            return this;
        }

        public final String getSyntax() {
            return syntax;
        }

        public final void setSyntax(String syntax) {
            this.syntax = syntax;
        }

        @Override
        public final Builder syntax(String syntax) {
            this.syntax = syntax;
            return this;
        }

        @Override
        public final Builder syntax(H264Syntax syntax) {
            this.syntax(syntax == null ? null : syntax.toString());
            return this;
        }

        public final String getTemporalAq() {
            return temporalAq;
        }

        public final void setTemporalAq(String temporalAq) {
            this.temporalAq = temporalAq;
        }

        @Override
        public final Builder temporalAq(String temporalAq) {
            this.temporalAq = temporalAq;
            return this;
        }

        @Override
        public final Builder temporalAq(H264TemporalAq temporalAq) {
            this.temporalAq(temporalAq == null ? null : temporalAq.toString());
            return this;
        }

        public final String getTimecodeInsertion() {
            return timecodeInsertion;
        }

        public final void setTimecodeInsertion(String timecodeInsertion) {
            this.timecodeInsertion = timecodeInsertion;
        }

        @Override
        public final Builder timecodeInsertion(String timecodeInsertion) {
            this.timecodeInsertion = timecodeInsertion;
            return this;
        }

        @Override
        public final Builder timecodeInsertion(H264TimecodeInsertionBehavior timecodeInsertion) {
            this.timecodeInsertion(timecodeInsertion == null ? null : timecodeInsertion.toString());
            return this;
        }

        public final TimecodeBurninSettings.Builder getTimecodeBurninSettings() {
            return timecodeBurninSettings != null ? timecodeBurninSettings.toBuilder() : null;
        }

        public final void setTimecodeBurninSettings(TimecodeBurninSettings.BuilderImpl timecodeBurninSettings) {
            this.timecodeBurninSettings = timecodeBurninSettings != null ? timecodeBurninSettings.build() : null;
        }

        @Override
        public final Builder timecodeBurninSettings(TimecodeBurninSettings timecodeBurninSettings) {
            this.timecodeBurninSettings = timecodeBurninSettings;
            return this;
        }

        public final Integer getMinQp() {
            return minQp;
        }

        public final void setMinQp(Integer minQp) {
            this.minQp = minQp;
        }

        @Override
        public final Builder minQp(Integer minQp) {
            this.minQp = minQp;
            return this;
        }

        @Override
        public H264Settings build() {
            return new H264Settings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
