/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Configurable settings for the input device.
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputDeviceConfigurableSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<InputDeviceConfigurableSettings.Builder, InputDeviceConfigurableSettings> {
    private static final SdkField<String> CONFIGURED_INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfiguredInput").getter(getter(InputDeviceConfigurableSettings::configuredInputAsString))
            .setter(setter(Builder::configuredInput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredInput").build()).build();

    private static final SdkField<Integer> MAX_BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxBitrate").getter(getter(InputDeviceConfigurableSettings::maxBitrate))
            .setter(setter(Builder::maxBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBitrate").build()).build();

    private static final SdkField<Integer> LATENCY_MS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("LatencyMs").getter(getter(InputDeviceConfigurableSettings::latencyMs))
            .setter(setter(Builder::latencyMs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latencyMs").build()).build();

    private static final SdkField<String> CODEC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Codec")
            .getter(getter(InputDeviceConfigurableSettings::codecAsString)).setter(setter(Builder::codec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codec").build()).build();

    private static final SdkField<InputDeviceMediaConnectConfigurableSettings> MEDIACONNECT_SETTINGS_FIELD = SdkField
            .<InputDeviceMediaConnectConfigurableSettings> builder(MarshallingType.SDK_POJO).memberName("MediaconnectSettings")
            .getter(getter(InputDeviceConfigurableSettings::mediaconnectSettings)).setter(setter(Builder::mediaconnectSettings))
            .constructor(InputDeviceMediaConnectConfigurableSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaconnectSettings").build())
            .build();

    private static final SdkField<List<InputDeviceConfigurableAudioChannelPairConfig>> AUDIO_CHANNEL_PAIRS_FIELD = SdkField
            .<List<InputDeviceConfigurableAudioChannelPairConfig>> builder(MarshallingType.LIST)
            .memberName("AudioChannelPairs")
            .getter(getter(InputDeviceConfigurableSettings::audioChannelPairs))
            .setter(setter(Builder::audioChannelPairs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioChannelPairs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputDeviceConfigurableAudioChannelPairConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputDeviceConfigurableAudioChannelPairConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURED_INPUT_FIELD,
            MAX_BITRATE_FIELD, LATENCY_MS_FIELD, CODEC_FIELD, MEDIACONNECT_SETTINGS_FIELD, AUDIO_CHANNEL_PAIRS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String configuredInput;

    private final Integer maxBitrate;

    private final Integer latencyMs;

    private final String codec;

    private final InputDeviceMediaConnectConfigurableSettings mediaconnectSettings;

    private final List<InputDeviceConfigurableAudioChannelPairConfig> audioChannelPairs;

    private InputDeviceConfigurableSettings(BuilderImpl builder) {
        this.configuredInput = builder.configuredInput;
        this.maxBitrate = builder.maxBitrate;
        this.latencyMs = builder.latencyMs;
        this.codec = builder.codec;
        this.mediaconnectSettings = builder.mediaconnectSettings;
        this.audioChannelPairs = builder.audioChannelPairs;
    }

    /**
     * The input source that you want to use. If the device has a source connected to only one of its input ports, or if
     * you don't care which source the device sends, specify Auto. If the device has sources connected to both its input
     * ports, and you want to use a specific source, specify the source.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #configuredInput}
     * will return {@link InputDeviceConfiguredInput#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #configuredInputAsString}.
     * </p>
     * 
     * @return The input source that you want to use. If the device has a source connected to only one of its input
     *         ports, or if you don't care which source the device sends, specify Auto. If the device has sources
     *         connected to both its input ports, and you want to use a specific source, specify the source.
     * @see InputDeviceConfiguredInput
     */
    public final InputDeviceConfiguredInput configuredInput() {
        return InputDeviceConfiguredInput.fromValue(configuredInput);
    }

    /**
     * The input source that you want to use. If the device has a source connected to only one of its input ports, or if
     * you don't care which source the device sends, specify Auto. If the device has sources connected to both its input
     * ports, and you want to use a specific source, specify the source.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #configuredInput}
     * will return {@link InputDeviceConfiguredInput#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #configuredInputAsString}.
     * </p>
     * 
     * @return The input source that you want to use. If the device has a source connected to only one of its input
     *         ports, or if you don't care which source the device sends, specify Auto. If the device has sources
     *         connected to both its input ports, and you want to use a specific source, specify the source.
     * @see InputDeviceConfiguredInput
     */
    public final String configuredInputAsString() {
        return configuredInput;
    }

    /**
     * The maximum bitrate in bits per second. Set a value here to throttle the bitrate of the source video.
     * 
     * @return The maximum bitrate in bits per second. Set a value here to throttle the bitrate of the source video.
     */
    public final Integer maxBitrate() {
        return maxBitrate;
    }

    /**
     * The Link device's buffer size (latency) in milliseconds (ms).
     * 
     * @return The Link device's buffer size (latency) in milliseconds (ms).
     */
    public final Integer latencyMs() {
        return latencyMs;
    }

    /**
     * Choose the codec for the video that the device produces. Only UHD devices can specify this parameter.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codec} will return
     * {@link InputDeviceCodec#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codecAsString}.
     * </p>
     * 
     * @return Choose the codec for the video that the device produces. Only UHD devices can specify this parameter.
     * @see InputDeviceCodec
     */
    public final InputDeviceCodec codec() {
        return InputDeviceCodec.fromValue(codec);
    }

    /**
     * Choose the codec for the video that the device produces. Only UHD devices can specify this parameter.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codec} will return
     * {@link InputDeviceCodec#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codecAsString}.
     * </p>
     * 
     * @return Choose the codec for the video that the device produces. Only UHD devices can specify this parameter.
     * @see InputDeviceCodec
     */
    public final String codecAsString() {
        return codec;
    }

    /**
     * To attach this device to a MediaConnect flow, specify these parameters. To detach an existing flow, enter {} for
     * the value of mediaconnectSettings. Only UHD devices can specify this parameter.
     * 
     * @return To attach this device to a MediaConnect flow, specify these parameters. To detach an existing flow, enter
     *         {} for the value of mediaconnectSettings. Only UHD devices can specify this parameter.
     */
    public final InputDeviceMediaConnectConfigurableSettings mediaconnectSettings() {
        return mediaconnectSettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the AudioChannelPairs property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAudioChannelPairs() {
        return audioChannelPairs != null && !(audioChannelPairs instanceof SdkAutoConstructList);
    }

    /**
     * An array of eight audio configurations, one for each audio pair in the source. Set up each audio configuration
     * either to exclude the pair, or to format it and include it in the output from the device. This parameter applies
     * only to UHD devices, and only when the device is configured as the source for a MediaConnect flow. For an HD
     * device, you configure the audio by setting up audio selectors in the channel configuration.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAudioChannelPairs} method.
     * </p>
     * 
     * @return An array of eight audio configurations, one for each audio pair in the source. Set up each audio
     *         configuration either to exclude the pair, or to format it and include it in the output from the device.
     *         This parameter applies only to UHD devices, and only when the device is configured as the source for a
     *         MediaConnect flow. For an HD device, you configure the audio by setting up audio selectors in the channel
     *         configuration.
     */
    public final List<InputDeviceConfigurableAudioChannelPairConfig> audioChannelPairs() {
        return audioChannelPairs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configuredInputAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(latencyMs());
        hashCode = 31 * hashCode + Objects.hashCode(codecAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mediaconnectSettings());
        hashCode = 31 * hashCode + Objects.hashCode(hasAudioChannelPairs() ? audioChannelPairs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDeviceConfigurableSettings)) {
            return false;
        }
        InputDeviceConfigurableSettings other = (InputDeviceConfigurableSettings) obj;
        return Objects.equals(configuredInputAsString(), other.configuredInputAsString())
                && Objects.equals(maxBitrate(), other.maxBitrate()) && Objects.equals(latencyMs(), other.latencyMs())
                && Objects.equals(codecAsString(), other.codecAsString())
                && Objects.equals(mediaconnectSettings(), other.mediaconnectSettings())
                && hasAudioChannelPairs() == other.hasAudioChannelPairs()
                && Objects.equals(audioChannelPairs(), other.audioChannelPairs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputDeviceConfigurableSettings").add("ConfiguredInput", configuredInputAsString())
                .add("MaxBitrate", maxBitrate()).add("LatencyMs", latencyMs()).add("Codec", codecAsString())
                .add("MediaconnectSettings", mediaconnectSettings())
                .add("AudioChannelPairs", hasAudioChannelPairs() ? audioChannelPairs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfiguredInput":
            return Optional.ofNullable(clazz.cast(configuredInputAsString()));
        case "MaxBitrate":
            return Optional.ofNullable(clazz.cast(maxBitrate()));
        case "LatencyMs":
            return Optional.ofNullable(clazz.cast(latencyMs()));
        case "Codec":
            return Optional.ofNullable(clazz.cast(codecAsString()));
        case "MediaconnectSettings":
            return Optional.ofNullable(clazz.cast(mediaconnectSettings()));
        case "AudioChannelPairs":
            return Optional.ofNullable(clazz.cast(audioChannelPairs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputDeviceConfigurableSettings, T> g) {
        return obj -> g.apply((InputDeviceConfigurableSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputDeviceConfigurableSettings> {
        /**
         * The input source that you want to use. If the device has a source connected to only one of its input ports,
         * or if you don't care which source the device sends, specify Auto. If the device has sources connected to both
         * its input ports, and you want to use a specific source, specify the source.
         * 
         * @param configuredInput
         *        The input source that you want to use. If the device has a source connected to only one of its input
         *        ports, or if you don't care which source the device sends, specify Auto. If the device has sources
         *        connected to both its input ports, and you want to use a specific source, specify the source.
         * @see InputDeviceConfiguredInput
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceConfiguredInput
         */
        Builder configuredInput(String configuredInput);

        /**
         * The input source that you want to use. If the device has a source connected to only one of its input ports,
         * or if you don't care which source the device sends, specify Auto. If the device has sources connected to both
         * its input ports, and you want to use a specific source, specify the source.
         * 
         * @param configuredInput
         *        The input source that you want to use. If the device has a source connected to only one of its input
         *        ports, or if you don't care which source the device sends, specify Auto. If the device has sources
         *        connected to both its input ports, and you want to use a specific source, specify the source.
         * @see InputDeviceConfiguredInput
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceConfiguredInput
         */
        Builder configuredInput(InputDeviceConfiguredInput configuredInput);

        /**
         * The maximum bitrate in bits per second. Set a value here to throttle the bitrate of the source video.
         * 
         * @param maxBitrate
         *        The maximum bitrate in bits per second. Set a value here to throttle the bitrate of the source video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxBitrate(Integer maxBitrate);

        /**
         * The Link device's buffer size (latency) in milliseconds (ms).
         * 
         * @param latencyMs
         *        The Link device's buffer size (latency) in milliseconds (ms).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latencyMs(Integer latencyMs);

        /**
         * Choose the codec for the video that the device produces. Only UHD devices can specify this parameter.
         * 
         * @param codec
         *        Choose the codec for the video that the device produces. Only UHD devices can specify this parameter.
         * @see InputDeviceCodec
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceCodec
         */
        Builder codec(String codec);

        /**
         * Choose the codec for the video that the device produces. Only UHD devices can specify this parameter.
         * 
         * @param codec
         *        Choose the codec for the video that the device produces. Only UHD devices can specify this parameter.
         * @see InputDeviceCodec
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceCodec
         */
        Builder codec(InputDeviceCodec codec);

        /**
         * To attach this device to a MediaConnect flow, specify these parameters. To detach an existing flow, enter {}
         * for the value of mediaconnectSettings. Only UHD devices can specify this parameter.
         * 
         * @param mediaconnectSettings
         *        To attach this device to a MediaConnect flow, specify these parameters. To detach an existing flow,
         *        enter {} for the value of mediaconnectSettings. Only UHD devices can specify this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaconnectSettings(InputDeviceMediaConnectConfigurableSettings mediaconnectSettings);

        /**
         * To attach this device to a MediaConnect flow, specify these parameters. To detach an existing flow, enter {}
         * for the value of mediaconnectSettings. Only UHD devices can specify this parameter. This is a convenience
         * method that creates an instance of the {@link InputDeviceMediaConnectConfigurableSettings.Builder} avoiding
         * the need to create one manually via {@link InputDeviceMediaConnectConfigurableSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputDeviceMediaConnectConfigurableSettings.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #mediaconnectSettings(InputDeviceMediaConnectConfigurableSettings)}.
         * 
         * @param mediaconnectSettings
         *        a consumer that will call methods on {@link InputDeviceMediaConnectConfigurableSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaconnectSettings(InputDeviceMediaConnectConfigurableSettings)
         */
        default Builder mediaconnectSettings(Consumer<InputDeviceMediaConnectConfigurableSettings.Builder> mediaconnectSettings) {
            return mediaconnectSettings(InputDeviceMediaConnectConfigurableSettings.builder().applyMutation(mediaconnectSettings)
                    .build());
        }

        /**
         * An array of eight audio configurations, one for each audio pair in the source. Set up each audio
         * configuration either to exclude the pair, or to format it and include it in the output from the device. This
         * parameter applies only to UHD devices, and only when the device is configured as the source for a
         * MediaConnect flow. For an HD device, you configure the audio by setting up audio selectors in the channel
         * configuration.
         * 
         * @param audioChannelPairs
         *        An array of eight audio configurations, one for each audio pair in the source. Set up each audio
         *        configuration either to exclude the pair, or to format it and include it in the output from the
         *        device. This parameter applies only to UHD devices, and only when the device is configured as the
         *        source for a MediaConnect flow. For an HD device, you configure the audio by setting up audio
         *        selectors in the channel configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioChannelPairs(Collection<InputDeviceConfigurableAudioChannelPairConfig> audioChannelPairs);

        /**
         * An array of eight audio configurations, one for each audio pair in the source. Set up each audio
         * configuration either to exclude the pair, or to format it and include it in the output from the device. This
         * parameter applies only to UHD devices, and only when the device is configured as the source for a
         * MediaConnect flow. For an HD device, you configure the audio by setting up audio selectors in the channel
         * configuration.
         * 
         * @param audioChannelPairs
         *        An array of eight audio configurations, one for each audio pair in the source. Set up each audio
         *        configuration either to exclude the pair, or to format it and include it in the output from the
         *        device. This parameter applies only to UHD devices, and only when the device is configured as the
         *        source for a MediaConnect flow. For an HD device, you configure the audio by setting up audio
         *        selectors in the channel configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioChannelPairs(InputDeviceConfigurableAudioChannelPairConfig... audioChannelPairs);

        /**
         * An array of eight audio configurations, one for each audio pair in the source. Set up each audio
         * configuration either to exclude the pair, or to format it and include it in the output from the device. This
         * parameter applies only to UHD devices, and only when the device is configured as the source for a
         * MediaConnect flow. For an HD device, you configure the audio by setting up audio selectors in the channel
         * configuration. This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.medialive.model.InputDeviceConfigurableAudioChannelPairConfig.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.medialive.model.InputDeviceConfigurableAudioChannelPairConfig#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.InputDeviceConfigurableAudioChannelPairConfig.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #audioChannelPairs(List<InputDeviceConfigurableAudioChannelPairConfig>)}.
         * 
         * @param audioChannelPairs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.InputDeviceConfigurableAudioChannelPairConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audioChannelPairs(java.util.Collection<InputDeviceConfigurableAudioChannelPairConfig>)
         */
        Builder audioChannelPairs(Consumer<InputDeviceConfigurableAudioChannelPairConfig.Builder>... audioChannelPairs);
    }

    static final class BuilderImpl implements Builder {
        private String configuredInput;

        private Integer maxBitrate;

        private Integer latencyMs;

        private String codec;

        private InputDeviceMediaConnectConfigurableSettings mediaconnectSettings;

        private List<InputDeviceConfigurableAudioChannelPairConfig> audioChannelPairs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InputDeviceConfigurableSettings model) {
            configuredInput(model.configuredInput);
            maxBitrate(model.maxBitrate);
            latencyMs(model.latencyMs);
            codec(model.codec);
            mediaconnectSettings(model.mediaconnectSettings);
            audioChannelPairs(model.audioChannelPairs);
        }

        public final String getConfiguredInput() {
            return configuredInput;
        }

        public final void setConfiguredInput(String configuredInput) {
            this.configuredInput = configuredInput;
        }

        @Override
        public final Builder configuredInput(String configuredInput) {
            this.configuredInput = configuredInput;
            return this;
        }

        @Override
        public final Builder configuredInput(InputDeviceConfiguredInput configuredInput) {
            this.configuredInput(configuredInput == null ? null : configuredInput.toString());
            return this;
        }

        public final Integer getMaxBitrate() {
            return maxBitrate;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        @Override
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public final Integer getLatencyMs() {
            return latencyMs;
        }

        public final void setLatencyMs(Integer latencyMs) {
            this.latencyMs = latencyMs;
        }

        @Override
        public final Builder latencyMs(Integer latencyMs) {
            this.latencyMs = latencyMs;
            return this;
        }

        public final String getCodec() {
            return codec;
        }

        public final void setCodec(String codec) {
            this.codec = codec;
        }

        @Override
        public final Builder codec(String codec) {
            this.codec = codec;
            return this;
        }

        @Override
        public final Builder codec(InputDeviceCodec codec) {
            this.codec(codec == null ? null : codec.toString());
            return this;
        }

        public final InputDeviceMediaConnectConfigurableSettings.Builder getMediaconnectSettings() {
            return mediaconnectSettings != null ? mediaconnectSettings.toBuilder() : null;
        }

        public final void setMediaconnectSettings(InputDeviceMediaConnectConfigurableSettings.BuilderImpl mediaconnectSettings) {
            this.mediaconnectSettings = mediaconnectSettings != null ? mediaconnectSettings.build() : null;
        }

        @Override
        public final Builder mediaconnectSettings(InputDeviceMediaConnectConfigurableSettings mediaconnectSettings) {
            this.mediaconnectSettings = mediaconnectSettings;
            return this;
        }

        public final List<InputDeviceConfigurableAudioChannelPairConfig.Builder> getAudioChannelPairs() {
            List<InputDeviceConfigurableAudioChannelPairConfig.Builder> result = ___listOfInputDeviceConfigurableAudioChannelPairConfigCopier
                    .copyToBuilder(this.audioChannelPairs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAudioChannelPairs(
                Collection<InputDeviceConfigurableAudioChannelPairConfig.BuilderImpl> audioChannelPairs) {
            this.audioChannelPairs = ___listOfInputDeviceConfigurableAudioChannelPairConfigCopier
                    .copyFromBuilder(audioChannelPairs);
        }

        @Override
        public final Builder audioChannelPairs(Collection<InputDeviceConfigurableAudioChannelPairConfig> audioChannelPairs) {
            this.audioChannelPairs = ___listOfInputDeviceConfigurableAudioChannelPairConfigCopier.copy(audioChannelPairs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioChannelPairs(InputDeviceConfigurableAudioChannelPairConfig... audioChannelPairs) {
            audioChannelPairs(Arrays.asList(audioChannelPairs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioChannelPairs(
                Consumer<InputDeviceConfigurableAudioChannelPairConfig.Builder>... audioChannelPairs) {
            audioChannelPairs(Stream.of(audioChannelPairs)
                    .map(c -> InputDeviceConfigurableAudioChannelPairConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public InputDeviceConfigurableSettings build() {
            return new InputDeviceConfigurableSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
