/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Property of InputDeviceUhdAudioChannelPairConfig, which describes one audio channel that the device is configured to
 * produce.
 */
@Generated("software.amazon.awssdk:codegen")
public enum InputDeviceUhdAudioChannelPairProfile {
    DISABLED("DISABLED"),

    VBR_AAC_HHE_16000("VBR-AAC_HHE-16000"),

    VBR_AAC_HE_64000("VBR-AAC_HE-64000"),

    VBR_AAC_LC_128000("VBR-AAC_LC-128000"),

    CBR_AAC_HQ_192000("CBR-AAC_HQ-192000"),

    CBR_AAC_HQ_256000("CBR-AAC_HQ-256000"),

    CBR_AAC_HQ_384000("CBR-AAC_HQ-384000"),

    CBR_AAC_HQ_512000("CBR-AAC_HQ-512000"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InputDeviceUhdAudioChannelPairProfile> VALUE_MAP = EnumUtils.uniqueIndex(
            InputDeviceUhdAudioChannelPairProfile.class, InputDeviceUhdAudioChannelPairProfile::toString);

    private final String value;

    private InputDeviceUhdAudioChannelPairProfile(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return InputDeviceUhdAudioChannelPairProfile corresponding to the value
     */
    public static InputDeviceUhdAudioChannelPairProfile fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link InputDeviceUhdAudioChannelPairProfile}s
     */
    public static Set<InputDeviceUhdAudioChannelPairProfile> knownValues() {
        Set<InputDeviceUhdAudioChannelPairProfile> knownValues = EnumSet.allOf(InputDeviceUhdAudioChannelPairProfile.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
