/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for ListSignalMapsResponse
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSignalMapsResponse extends MediaLiveResponse implements
        ToCopyableBuilder<ListSignalMapsResponse.Builder, ListSignalMapsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListSignalMapsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<SignalMapSummary>> SIGNAL_MAPS_FIELD = SdkField
            .<List<SignalMapSummary>> builder(MarshallingType.LIST)
            .memberName("SignalMaps")
            .getter(getter(ListSignalMapsResponse::signalMaps))
            .setter(setter(Builder::signalMaps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signalMaps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SignalMapSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(SignalMapSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SIGNAL_MAPS_FIELD));

    private final String nextToken;

    private final List<SignalMapSummary> signalMaps;

    private ListSignalMapsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.signalMaps = builder.signalMaps;
    }

    /**
     * A token used to retrieve the next set of results in paginated list responses.
     * 
     * @return A token used to retrieve the next set of results in paginated list responses.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SignalMaps property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSignalMaps() {
        return signalMaps != null && !(signalMaps instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the SignalMaps property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSignalMaps} method.
     * </p>
     * 
     * @return The value of the SignalMaps property for this object.
     */
    public final List<SignalMapSummary> signalMaps() {
        return signalMaps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasSignalMaps() ? signalMaps() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSignalMapsResponse)) {
            return false;
        }
        ListSignalMapsResponse other = (ListSignalMapsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasSignalMaps() == other.hasSignalMaps()
                && Objects.equals(signalMaps(), other.signalMaps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSignalMapsResponse").add("NextToken", nextToken())
                .add("SignalMaps", hasSignalMaps() ? signalMaps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "SignalMaps":
            return Optional.ofNullable(clazz.cast(signalMaps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSignalMapsResponse, T> g) {
        return obj -> g.apply((ListSignalMapsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSignalMapsResponse> {
        /**
         * A token used to retrieve the next set of results in paginated list responses.
         * 
         * @param nextToken
         *        A token used to retrieve the next set of results in paginated list responses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * Sets the value of the SignalMaps property for this object.
         *
         * @param signalMaps
         *        The new value for the SignalMaps property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signalMaps(Collection<SignalMapSummary> signalMaps);

        /**
         * Sets the value of the SignalMaps property for this object.
         *
         * @param signalMaps
         *        The new value for the SignalMaps property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signalMaps(SignalMapSummary... signalMaps);

        /**
         * Sets the value of the SignalMaps property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.medialive.model.SignalMapSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.medialive.model.SignalMapSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.SignalMapSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #signalMaps(List<SignalMapSummary>)}.
         * 
         * @param signalMaps
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.SignalMapSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signalMaps(java.util.Collection<SignalMapSummary>)
         */
        Builder signalMaps(Consumer<SignalMapSummary.Builder>... signalMaps);
    }

    static final class BuilderImpl extends MediaLiveResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<SignalMapSummary> signalMaps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSignalMapsResponse model) {
            super(model);
            nextToken(model.nextToken);
            signalMaps(model.signalMaps);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SignalMapSummary.Builder> getSignalMaps() {
            List<SignalMapSummary.Builder> result = ___listOfSignalMapSummaryCopier.copyToBuilder(this.signalMaps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSignalMaps(Collection<SignalMapSummary.BuilderImpl> signalMaps) {
            this.signalMaps = ___listOfSignalMapSummaryCopier.copyFromBuilder(signalMaps);
        }

        @Override
        public final Builder signalMaps(Collection<SignalMapSummary> signalMaps) {
            this.signalMaps = ___listOfSignalMapSummaryCopier.copy(signalMaps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signalMaps(SignalMapSummary... signalMaps) {
            signalMaps(Arrays.asList(signalMaps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signalMaps(Consumer<SignalMapSummary.Builder>... signalMaps) {
            signalMaps(Stream.of(signalMaps).map(c -> SignalMapSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSignalMapsResponse build() {
            return new ListSignalMapsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
