/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Indicates which pipeline is preferred by the multiplex for program ingest. If set to \"PIPELINE_0\" or \"PIPELINE_1\"
 * and an unhealthy ingest causes the multiplex to switch to the non-preferred pipeline, it will switch back once that
 * ingest is healthy again. If set to \"CURRENTLY_ACTIVE\", it will not switch back to the other pipeline based on it
 * recovering to a healthy state, it will only switch if the active pipeline becomes unhealthy.
 */
@Generated("software.amazon.awssdk:codegen")
public enum PreferredChannelPipeline {
    CURRENTLY_ACTIVE("CURRENTLY_ACTIVE"),

    PIPELINE_0("PIPELINE_0"),

    PIPELINE_1("PIPELINE_1"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PreferredChannelPipeline> VALUE_MAP = EnumUtils.uniqueIndex(PreferredChannelPipeline.class,
            PreferredChannelPipeline::toString);

    private final String value;

    private PreferredChannelPipeline(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return PreferredChannelPipeline corresponding to the value
     */
    public static PreferredChannelPipeline fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link PreferredChannelPipeline}s
     */
    public static Set<PreferredChannelPipeline> knownValues() {
        Set<PreferredChannelPipeline> knownValues = EnumSet.allOf(PreferredChannelPipeline.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
