/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Pipelines to restart.
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestartChannelPipelinesRequest extends MediaLiveRequest implements
        ToCopyableBuilder<RestartChannelPipelinesRequest.Builder, RestartChannelPipelinesRequest> {
    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelId").getter(getter(RestartChannelPipelinesRequest::channelId)).setter(setter(Builder::channelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelId").build()).build();

    private static final SdkField<List<String>> PIPELINE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PipelineIds")
            .getter(getter(RestartChannelPipelinesRequest::pipelineIdsAsStrings))
            .setter(setter(Builder::pipelineIdsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ID_FIELD,
            PIPELINE_IDS_FIELD));

    private final String channelId;

    private final List<String> pipelineIds;

    private RestartChannelPipelinesRequest(BuilderImpl builder) {
        super(builder);
        this.channelId = builder.channelId;
        this.pipelineIds = builder.pipelineIds;
    }

    /**
     * ID of channel
     * 
     * @return ID of channel
     */
    public final String channelId() {
        return channelId;
    }

    /**
     * An array of pipelines to restart in this channel. Format PIPELINE_0 or PIPELINE_1.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPipelineIds} method.
     * </p>
     * 
     * @return An array of pipelines to restart in this channel. Format PIPELINE_0 or PIPELINE_1.
     */
    public final List<ChannelPipelineIdToRestart> pipelineIds() {
        return ___listOfChannelPipelineIdToRestartCopier.copyStringToEnum(pipelineIds);
    }

    /**
     * For responses, this returns true if the service returned a value for the PipelineIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPipelineIds() {
        return pipelineIds != null && !(pipelineIds instanceof SdkAutoConstructList);
    }

    /**
     * An array of pipelines to restart in this channel. Format PIPELINE_0 or PIPELINE_1.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPipelineIds} method.
     * </p>
     * 
     * @return An array of pipelines to restart in this channel. Format PIPELINE_0 or PIPELINE_1.
     */
    public final List<String> pipelineIdsAsStrings() {
        return pipelineIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelId());
        hashCode = 31 * hashCode + Objects.hashCode(hasPipelineIds() ? pipelineIdsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestartChannelPipelinesRequest)) {
            return false;
        }
        RestartChannelPipelinesRequest other = (RestartChannelPipelinesRequest) obj;
        return Objects.equals(channelId(), other.channelId()) && hasPipelineIds() == other.hasPipelineIds()
                && Objects.equals(pipelineIdsAsStrings(), other.pipelineIdsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RestartChannelPipelinesRequest").add("ChannelId", channelId())
                .add("PipelineIds", hasPipelineIds() ? pipelineIdsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelId":
            return Optional.ofNullable(clazz.cast(channelId()));
        case "PipelineIds":
            return Optional.ofNullable(clazz.cast(pipelineIdsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestartChannelPipelinesRequest, T> g) {
        return obj -> g.apply((RestartChannelPipelinesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveRequest.Builder, SdkPojo, CopyableBuilder<Builder, RestartChannelPipelinesRequest> {
        /**
         * ID of channel
         * 
         * @param channelId
         *        ID of channel
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelId(String channelId);

        /**
         * An array of pipelines to restart in this channel. Format PIPELINE_0 or PIPELINE_1.
         * 
         * @param pipelineIds
         *        An array of pipelines to restart in this channel. Format PIPELINE_0 or PIPELINE_1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineIdsWithStrings(Collection<String> pipelineIds);

        /**
         * An array of pipelines to restart in this channel. Format PIPELINE_0 or PIPELINE_1.
         * 
         * @param pipelineIds
         *        An array of pipelines to restart in this channel. Format PIPELINE_0 or PIPELINE_1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineIdsWithStrings(String... pipelineIds);

        /**
         * An array of pipelines to restart in this channel. Format PIPELINE_0 or PIPELINE_1.
         * 
         * @param pipelineIds
         *        An array of pipelines to restart in this channel. Format PIPELINE_0 or PIPELINE_1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineIds(Collection<ChannelPipelineIdToRestart> pipelineIds);

        /**
         * An array of pipelines to restart in this channel. Format PIPELINE_0 or PIPELINE_1.
         * 
         * @param pipelineIds
         *        An array of pipelines to restart in this channel. Format PIPELINE_0 or PIPELINE_1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineIds(ChannelPipelineIdToRestart... pipelineIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaLiveRequest.BuilderImpl implements Builder {
        private String channelId;

        private List<String> pipelineIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RestartChannelPipelinesRequest model) {
            super(model);
            channelId(model.channelId);
            pipelineIdsWithStrings(model.pipelineIds);
        }

        public final String getChannelId() {
            return channelId;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final Collection<String> getPipelineIds() {
            if (pipelineIds instanceof SdkAutoConstructList) {
                return null;
            }
            return pipelineIds;
        }

        public final void setPipelineIds(Collection<String> pipelineIds) {
            this.pipelineIds = ___listOfChannelPipelineIdToRestartCopier.copy(pipelineIds);
        }

        @Override
        public final Builder pipelineIdsWithStrings(Collection<String> pipelineIds) {
            this.pipelineIds = ___listOfChannelPipelineIdToRestartCopier.copy(pipelineIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineIdsWithStrings(String... pipelineIds) {
            pipelineIdsWithStrings(Arrays.asList(pipelineIds));
            return this;
        }

        @Override
        public final Builder pipelineIds(Collection<ChannelPipelineIdToRestart> pipelineIds) {
            this.pipelineIds = ___listOfChannelPipelineIdToRestartCopier.copyEnumToString(pipelineIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineIds(ChannelPipelineIdToRestart... pipelineIds) {
            pipelineIds(Arrays.asList(pipelineIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestartChannelPipelinesRequest build() {
            return new RestartChannelPipelinesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
