/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Complete these parameters only if the content is encrypted.
 */
@Generated("software.amazon.awssdk:codegen")
public final class SrtCallerDecryptionRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<SrtCallerDecryptionRequest.Builder, SrtCallerDecryptionRequest> {
    private static final SdkField<String> ALGORITHM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Algorithm").getter(getter(SrtCallerDecryptionRequest::algorithmAsString))
            .setter(setter(Builder::algorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("algorithm").build()).build();

    private static final SdkField<String> PASSPHRASE_SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PassphraseSecretArn").getter(getter(SrtCallerDecryptionRequest::passphraseSecretArn))
            .setter(setter(Builder::passphraseSecretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("passphraseSecretArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_FIELD,
            PASSPHRASE_SECRET_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String algorithm;

    private final String passphraseSecretArn;

    private SrtCallerDecryptionRequest(BuilderImpl builder) {
        this.algorithm = builder.algorithm;
        this.passphraseSecretArn = builder.passphraseSecretArn;
    }

    /**
     * The algorithm used to encrypt content.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #algorithm} will
     * return {@link Algorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #algorithmAsString}.
     * </p>
     * 
     * @return The algorithm used to encrypt content.
     * @see Algorithm
     */
    public final Algorithm algorithm() {
        return Algorithm.fromValue(algorithm);
    }

    /**
     * The algorithm used to encrypt content.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #algorithm} will
     * return {@link Algorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #algorithmAsString}.
     * </p>
     * 
     * @return The algorithm used to encrypt content.
     * @see Algorithm
     */
    public final String algorithmAsString() {
        return algorithm;
    }

    /**
     * The ARN for the secret in Secrets Manager. Someone in your organization must create a secret and provide you with
     * its ARN. This secret holds the passphrase that MediaLive will use to decrypt the source content.
     * 
     * @return The ARN for the secret in Secrets Manager. Someone in your organization must create a secret and provide
     *         you with its ARN. This secret holds the passphrase that MediaLive will use to decrypt the source content.
     */
    public final String passphraseSecretArn() {
        return passphraseSecretArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(algorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(passphraseSecretArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SrtCallerDecryptionRequest)) {
            return false;
        }
        SrtCallerDecryptionRequest other = (SrtCallerDecryptionRequest) obj;
        return Objects.equals(algorithmAsString(), other.algorithmAsString())
                && Objects.equals(passphraseSecretArn(), other.passphraseSecretArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SrtCallerDecryptionRequest").add("Algorithm", algorithmAsString())
                .add("PassphraseSecretArn", passphraseSecretArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Algorithm":
            return Optional.ofNullable(clazz.cast(algorithmAsString()));
        case "PassphraseSecretArn":
            return Optional.ofNullable(clazz.cast(passphraseSecretArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SrtCallerDecryptionRequest, T> g) {
        return obj -> g.apply((SrtCallerDecryptionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SrtCallerDecryptionRequest> {
        /**
         * The algorithm used to encrypt content.
         * 
         * @param algorithm
         *        The algorithm used to encrypt content.
         * @see Algorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Algorithm
         */
        Builder algorithm(String algorithm);

        /**
         * The algorithm used to encrypt content.
         * 
         * @param algorithm
         *        The algorithm used to encrypt content.
         * @see Algorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Algorithm
         */
        Builder algorithm(Algorithm algorithm);

        /**
         * The ARN for the secret in Secrets Manager. Someone in your organization must create a secret and provide you
         * with its ARN. This secret holds the passphrase that MediaLive will use to decrypt the source content.
         * 
         * @param passphraseSecretArn
         *        The ARN for the secret in Secrets Manager. Someone in your organization must create a secret and
         *        provide you with its ARN. This secret holds the passphrase that MediaLive will use to decrypt the
         *        source content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passphraseSecretArn(String passphraseSecretArn);
    }

    static final class BuilderImpl implements Builder {
        private String algorithm;

        private String passphraseSecretArn;

        private BuilderImpl() {
        }

        private BuilderImpl(SrtCallerDecryptionRequest model) {
            algorithm(model.algorithm);
            passphraseSecretArn(model.passphraseSecretArn);
        }

        public final String getAlgorithm() {
            return algorithm;
        }

        public final void setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        @Override
        public final Builder algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        @Override
        public final Builder algorithm(Algorithm algorithm) {
            this.algorithm(algorithm == null ? null : algorithm.toString());
            return this;
        }

        public final String getPassphraseSecretArn() {
            return passphraseSecretArn;
        }

        public final void setPassphraseSecretArn(String passphraseSecretArn) {
            this.passphraseSecretArn = passphraseSecretArn;
        }

        @Override
        public final Builder passphraseSecretArn(String passphraseSecretArn) {
            this.passphraseSecretArn = passphraseSecretArn;
            return this;
        }

        @Override
        public SrtCallerDecryptionRequest build() {
            return new SrtCallerDecryptionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
