/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for StartUpdateSignalMapResponse
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartUpdateSignalMapResponse extends MediaLiveResponse implements
        ToCopyableBuilder<StartUpdateSignalMapResponse.Builder, StartUpdateSignalMapResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(StartUpdateSignalMapResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<List<String>> CLOUD_WATCH_ALARM_TEMPLATE_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CloudWatchAlarmTemplateGroupIds")
            .getter(getter(StartUpdateSignalMapResponse::cloudWatchAlarmTemplateGroupIds))
            .setter(setter(Builder::cloudWatchAlarmTemplateGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchAlarmTemplateGroupIds")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt")
            .getter(getter(StartUpdateSignalMapResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(StartUpdateSignalMapResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DISCOVERY_ENTRY_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DiscoveryEntryPointArn").getter(getter(StartUpdateSignalMapResponse::discoveryEntryPointArn))
            .setter(setter(Builder::discoveryEntryPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("discoveryEntryPointArn").build())
            .build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(StartUpdateSignalMapResponse::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<List<String>> EVENT_BRIDGE_RULE_TEMPLATE_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EventBridgeRuleTemplateGroupIds")
            .getter(getter(StartUpdateSignalMapResponse::eventBridgeRuleTemplateGroupIds))
            .setter(setter(Builder::eventBridgeRuleTemplateGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventBridgeRuleTemplateGroupIds")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, MediaResource>> FAILED_MEDIA_RESOURCE_MAP_FIELD = SdkField
            .<Map<String, MediaResource>> builder(MarshallingType.MAP)
            .memberName("FailedMediaResourceMap")
            .getter(getter(StartUpdateSignalMapResponse::failedMediaResourceMap))
            .setter(setter(Builder::failedMediaResourceMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedMediaResourceMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<MediaResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(MediaResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(StartUpdateSignalMapResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Instant> LAST_DISCOVERED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastDiscoveredAt")
            .getter(getter(StartUpdateSignalMapResponse::lastDiscoveredAt))
            .setter(setter(Builder::lastDiscoveredAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastDiscoveredAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<SuccessfulMonitorDeployment> LAST_SUCCESSFUL_MONITOR_DEPLOYMENT_FIELD = SdkField
            .<SuccessfulMonitorDeployment> builder(MarshallingType.SDK_POJO)
            .memberName("LastSuccessfulMonitorDeployment")
            .getter(getter(StartUpdateSignalMapResponse::lastSuccessfulMonitorDeployment))
            .setter(setter(Builder::lastSuccessfulMonitorDeployment))
            .constructor(SuccessfulMonitorDeployment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastSuccessfulMonitorDeployment")
                    .build()).build();

    private static final SdkField<Map<String, MediaResource>> MEDIA_RESOURCE_MAP_FIELD = SdkField
            .<Map<String, MediaResource>> builder(MarshallingType.MAP)
            .memberName("MediaResourceMap")
            .getter(getter(StartUpdateSignalMapResponse::mediaResourceMap))
            .setter(setter(Builder::mediaResourceMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaResourceMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<MediaResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(MediaResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ModifiedAt")
            .getter(getter(StartUpdateSignalMapResponse::modifiedAt))
            .setter(setter(Builder::modifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Boolean> MONITOR_CHANGES_PENDING_DEPLOYMENT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MonitorChangesPendingDeployment")
            .getter(getter(StartUpdateSignalMapResponse::monitorChangesPendingDeployment))
            .setter(setter(Builder::monitorChangesPendingDeployment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitorChangesPendingDeployment")
                    .build()).build();

    private static final SdkField<MonitorDeployment> MONITOR_DEPLOYMENT_FIELD = SdkField
            .<MonitorDeployment> builder(MarshallingType.SDK_POJO).memberName("MonitorDeployment")
            .getter(getter(StartUpdateSignalMapResponse::monitorDeployment)).setter(setter(Builder::monitorDeployment))
            .constructor(MonitorDeployment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitorDeployment").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(StartUpdateSignalMapResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(StartUpdateSignalMapResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(StartUpdateSignalMapResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CLOUD_WATCH_ALARM_TEMPLATE_GROUP_IDS_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, DISCOVERY_ENTRY_POINT_ARN_FIELD,
            ERROR_MESSAGE_FIELD, EVENT_BRIDGE_RULE_TEMPLATE_GROUP_IDS_FIELD, FAILED_MEDIA_RESOURCE_MAP_FIELD, ID_FIELD,
            LAST_DISCOVERED_AT_FIELD, LAST_SUCCESSFUL_MONITOR_DEPLOYMENT_FIELD, MEDIA_RESOURCE_MAP_FIELD, MODIFIED_AT_FIELD,
            MONITOR_CHANGES_PENDING_DEPLOYMENT_FIELD, MONITOR_DEPLOYMENT_FIELD, NAME_FIELD, STATUS_FIELD, TAGS_FIELD));

    private final String arn;

    private final List<String> cloudWatchAlarmTemplateGroupIds;

    private final Instant createdAt;

    private final String description;

    private final String discoveryEntryPointArn;

    private final String errorMessage;

    private final List<String> eventBridgeRuleTemplateGroupIds;

    private final Map<String, MediaResource> failedMediaResourceMap;

    private final String id;

    private final Instant lastDiscoveredAt;

    private final SuccessfulMonitorDeployment lastSuccessfulMonitorDeployment;

    private final Map<String, MediaResource> mediaResourceMap;

    private final Instant modifiedAt;

    private final Boolean monitorChangesPendingDeployment;

    private final MonitorDeployment monitorDeployment;

    private final String name;

    private final String status;

    private final Map<String, String> tags;

    private StartUpdateSignalMapResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.cloudWatchAlarmTemplateGroupIds = builder.cloudWatchAlarmTemplateGroupIds;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.discoveryEntryPointArn = builder.discoveryEntryPointArn;
        this.errorMessage = builder.errorMessage;
        this.eventBridgeRuleTemplateGroupIds = builder.eventBridgeRuleTemplateGroupIds;
        this.failedMediaResourceMap = builder.failedMediaResourceMap;
        this.id = builder.id;
        this.lastDiscoveredAt = builder.lastDiscoveredAt;
        this.lastSuccessfulMonitorDeployment = builder.lastSuccessfulMonitorDeployment;
        this.mediaResourceMap = builder.mediaResourceMap;
        this.modifiedAt = builder.modifiedAt;
        this.monitorChangesPendingDeployment = builder.monitorChangesPendingDeployment;
        this.monitorDeployment = builder.monitorDeployment;
        this.name = builder.name;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    /**
     * A signal map's ARN (Amazon Resource Name)
     * 
     * @return A signal map's ARN (Amazon Resource Name)
     */
    public final String arn() {
        return arn;
    }

    /**
     * For responses, this returns true if the service returned a value for the CloudWatchAlarmTemplateGroupIds
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasCloudWatchAlarmTemplateGroupIds() {
        return cloudWatchAlarmTemplateGroupIds != null && !(cloudWatchAlarmTemplateGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the CloudWatchAlarmTemplateGroupIds property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCloudWatchAlarmTemplateGroupIds}
     * method.
     * </p>
     * 
     * @return The value of the CloudWatchAlarmTemplateGroupIds property for this object.
     */
    public final List<String> cloudWatchAlarmTemplateGroupIds() {
        return cloudWatchAlarmTemplateGroupIds;
    }

    /**
     * Returns the value of the CreatedAt property for this object.
     * 
     * @return The value of the CreatedAt property for this object.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * A resource's optional description.
     * 
     * @return A resource's optional description.
     */
    public final String description() {
        return description;
    }

    /**
     * A top-level supported AWS resource ARN to discovery a signal map from.
     * 
     * @return A top-level supported AWS resource ARN to discovery a signal map from.
     */
    public final String discoveryEntryPointArn() {
        return discoveryEntryPointArn;
    }

    /**
     * Error message associated with a failed creation or failed update attempt of a signal map.
     * 
     * @return Error message associated with a failed creation or failed update attempt of a signal map.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventBridgeRuleTemplateGroupIds
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasEventBridgeRuleTemplateGroupIds() {
        return eventBridgeRuleTemplateGroupIds != null && !(eventBridgeRuleTemplateGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the EventBridgeRuleTemplateGroupIds property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventBridgeRuleTemplateGroupIds}
     * method.
     * </p>
     * 
     * @return The value of the EventBridgeRuleTemplateGroupIds property for this object.
     */
    public final List<String> eventBridgeRuleTemplateGroupIds() {
        return eventBridgeRuleTemplateGroupIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailedMediaResourceMap property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasFailedMediaResourceMap() {
        return failedMediaResourceMap != null && !(failedMediaResourceMap instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the FailedMediaResourceMap property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailedMediaResourceMap} method.
     * </p>
     * 
     * @return The value of the FailedMediaResourceMap property for this object.
     */
    public final Map<String, MediaResource> failedMediaResourceMap() {
        return failedMediaResourceMap;
    }

    /**
     * A signal map's id.
     * 
     * @return A signal map's id.
     */
    public final String id() {
        return id;
    }

    /**
     * Returns the value of the LastDiscoveredAt property for this object.
     * 
     * @return The value of the LastDiscoveredAt property for this object.
     */
    public final Instant lastDiscoveredAt() {
        return lastDiscoveredAt;
    }

    /**
     * Returns the value of the LastSuccessfulMonitorDeployment property for this object.
     * 
     * @return The value of the LastSuccessfulMonitorDeployment property for this object.
     */
    public final SuccessfulMonitorDeployment lastSuccessfulMonitorDeployment() {
        return lastSuccessfulMonitorDeployment;
    }

    /**
     * For responses, this returns true if the service returned a value for the MediaResourceMap property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMediaResourceMap() {
        return mediaResourceMap != null && !(mediaResourceMap instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the MediaResourceMap property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMediaResourceMap} method.
     * </p>
     * 
     * @return The value of the MediaResourceMap property for this object.
     */
    public final Map<String, MediaResource> mediaResourceMap() {
        return mediaResourceMap;
    }

    /**
     * Returns the value of the ModifiedAt property for this object.
     * 
     * @return The value of the ModifiedAt property for this object.
     */
    public final Instant modifiedAt() {
        return modifiedAt;
    }

    /**
     * If true, there are pending monitor changes for this signal map that can be deployed.
     * 
     * @return If true, there are pending monitor changes for this signal map that can be deployed.
     */
    public final Boolean monitorChangesPendingDeployment() {
        return monitorChangesPendingDeployment;
    }

    /**
     * Returns the value of the MonitorDeployment property for this object.
     * 
     * @return The value of the MonitorDeployment property for this object.
     */
    public final MonitorDeployment monitorDeployment() {
        return monitorDeployment;
    }

    /**
     * A resource's name. Names must be unique within the scope of a resource type in a specific region.
     * 
     * @return A resource's name. Names must be unique within the scope of a resource type in a specific region.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the Status property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SignalMapStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The value of the Status property for this object.
     * @see SignalMapStatus
     */
    public final SignalMapStatus status() {
        return SignalMapStatus.fromValue(status);
    }

    /**
     * Returns the value of the Status property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SignalMapStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The value of the Status property for this object.
     * @see SignalMapStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasCloudWatchAlarmTemplateGroupIds() ? cloudWatchAlarmTemplateGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(discoveryEntryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasEventBridgeRuleTemplateGroupIds() ? eventBridgeRuleTemplateGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedMediaResourceMap() ? failedMediaResourceMap() : null);
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(lastDiscoveredAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastSuccessfulMonitorDeployment());
        hashCode = 31 * hashCode + Objects.hashCode(hasMediaResourceMap() ? mediaResourceMap() : null);
        hashCode = 31 * hashCode + Objects.hashCode(modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(monitorChangesPendingDeployment());
        hashCode = 31 * hashCode + Objects.hashCode(monitorDeployment());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartUpdateSignalMapResponse)) {
            return false;
        }
        StartUpdateSignalMapResponse other = (StartUpdateSignalMapResponse) obj;
        return Objects.equals(arn(), other.arn())
                && hasCloudWatchAlarmTemplateGroupIds() == other.hasCloudWatchAlarmTemplateGroupIds()
                && Objects.equals(cloudWatchAlarmTemplateGroupIds(), other.cloudWatchAlarmTemplateGroupIds())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(description(), other.description())
                && Objects.equals(discoveryEntryPointArn(), other.discoveryEntryPointArn())
                && Objects.equals(errorMessage(), other.errorMessage())
                && hasEventBridgeRuleTemplateGroupIds() == other.hasEventBridgeRuleTemplateGroupIds()
                && Objects.equals(eventBridgeRuleTemplateGroupIds(), other.eventBridgeRuleTemplateGroupIds())
                && hasFailedMediaResourceMap() == other.hasFailedMediaResourceMap()
                && Objects.equals(failedMediaResourceMap(), other.failedMediaResourceMap()) && Objects.equals(id(), other.id())
                && Objects.equals(lastDiscoveredAt(), other.lastDiscoveredAt())
                && Objects.equals(lastSuccessfulMonitorDeployment(), other.lastSuccessfulMonitorDeployment())
                && hasMediaResourceMap() == other.hasMediaResourceMap()
                && Objects.equals(mediaResourceMap(), other.mediaResourceMap())
                && Objects.equals(modifiedAt(), other.modifiedAt())
                && Objects.equals(monitorChangesPendingDeployment(), other.monitorChangesPendingDeployment())
                && Objects.equals(monitorDeployment(), other.monitorDeployment()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("StartUpdateSignalMapResponse")
                .add("Arn", arn())
                .add("CloudWatchAlarmTemplateGroupIds",
                        hasCloudWatchAlarmTemplateGroupIds() ? cloudWatchAlarmTemplateGroupIds() : null)
                .add("CreatedAt", createdAt())
                .add("Description", description())
                .add("DiscoveryEntryPointArn", discoveryEntryPointArn())
                .add("ErrorMessage", errorMessage())
                .add("EventBridgeRuleTemplateGroupIds",
                        hasEventBridgeRuleTemplateGroupIds() ? eventBridgeRuleTemplateGroupIds() : null)
                .add("FailedMediaResourceMap", hasFailedMediaResourceMap() ? failedMediaResourceMap() : null).add("Id", id())
                .add("LastDiscoveredAt", lastDiscoveredAt())
                .add("LastSuccessfulMonitorDeployment", lastSuccessfulMonitorDeployment())
                .add("MediaResourceMap", hasMediaResourceMap() ? mediaResourceMap() : null).add("ModifiedAt", modifiedAt())
                .add("MonitorChangesPendingDeployment", monitorChangesPendingDeployment())
                .add("MonitorDeployment", monitorDeployment()).add("Name", name()).add("Status", statusAsString())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CloudWatchAlarmTemplateGroupIds":
            return Optional.ofNullable(clazz.cast(cloudWatchAlarmTemplateGroupIds()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DiscoveryEntryPointArn":
            return Optional.ofNullable(clazz.cast(discoveryEntryPointArn()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "EventBridgeRuleTemplateGroupIds":
            return Optional.ofNullable(clazz.cast(eventBridgeRuleTemplateGroupIds()));
        case "FailedMediaResourceMap":
            return Optional.ofNullable(clazz.cast(failedMediaResourceMap()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "LastDiscoveredAt":
            return Optional.ofNullable(clazz.cast(lastDiscoveredAt()));
        case "LastSuccessfulMonitorDeployment":
            return Optional.ofNullable(clazz.cast(lastSuccessfulMonitorDeployment()));
        case "MediaResourceMap":
            return Optional.ofNullable(clazz.cast(mediaResourceMap()));
        case "ModifiedAt":
            return Optional.ofNullable(clazz.cast(modifiedAt()));
        case "MonitorChangesPendingDeployment":
            return Optional.ofNullable(clazz.cast(monitorChangesPendingDeployment()));
        case "MonitorDeployment":
            return Optional.ofNullable(clazz.cast(monitorDeployment()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartUpdateSignalMapResponse, T> g) {
        return obj -> g.apply((StartUpdateSignalMapResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartUpdateSignalMapResponse> {
        /**
         * A signal map's ARN (Amazon Resource Name)
         * 
         * @param arn
         *        A signal map's ARN (Amazon Resource Name)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * Sets the value of the CloudWatchAlarmTemplateGroupIds property for this object.
         *
         * @param cloudWatchAlarmTemplateGroupIds
         *        The new value for the CloudWatchAlarmTemplateGroupIds property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchAlarmTemplateGroupIds(Collection<String> cloudWatchAlarmTemplateGroupIds);

        /**
         * Sets the value of the CloudWatchAlarmTemplateGroupIds property for this object.
         *
         * @param cloudWatchAlarmTemplateGroupIds
         *        The new value for the CloudWatchAlarmTemplateGroupIds property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchAlarmTemplateGroupIds(String... cloudWatchAlarmTemplateGroupIds);

        /**
         * Sets the value of the CreatedAt property for this object.
         *
         * @param createdAt
         *        The new value for the CreatedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * A resource's optional description.
         * 
         * @param description
         *        A resource's optional description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * A top-level supported AWS resource ARN to discovery a signal map from.
         * 
         * @param discoveryEntryPointArn
         *        A top-level supported AWS resource ARN to discovery a signal map from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder discoveryEntryPointArn(String discoveryEntryPointArn);

        /**
         * Error message associated with a failed creation or failed update attempt of a signal map.
         * 
         * @param errorMessage
         *        Error message associated with a failed creation or failed update attempt of a signal map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * Sets the value of the EventBridgeRuleTemplateGroupIds property for this object.
         *
         * @param eventBridgeRuleTemplateGroupIds
         *        The new value for the EventBridgeRuleTemplateGroupIds property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventBridgeRuleTemplateGroupIds(Collection<String> eventBridgeRuleTemplateGroupIds);

        /**
         * Sets the value of the EventBridgeRuleTemplateGroupIds property for this object.
         *
         * @param eventBridgeRuleTemplateGroupIds
         *        The new value for the EventBridgeRuleTemplateGroupIds property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventBridgeRuleTemplateGroupIds(String... eventBridgeRuleTemplateGroupIds);

        /**
         * Sets the value of the FailedMediaResourceMap property for this object.
         *
         * @param failedMediaResourceMap
         *        The new value for the FailedMediaResourceMap property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedMediaResourceMap(Map<String, MediaResource> failedMediaResourceMap);

        /**
         * A signal map's id.
         * 
         * @param id
         *        A signal map's id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Sets the value of the LastDiscoveredAt property for this object.
         *
         * @param lastDiscoveredAt
         *        The new value for the LastDiscoveredAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastDiscoveredAt(Instant lastDiscoveredAt);

        /**
         * Sets the value of the LastSuccessfulMonitorDeployment property for this object.
         *
         * @param lastSuccessfulMonitorDeployment
         *        The new value for the LastSuccessfulMonitorDeployment property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSuccessfulMonitorDeployment(SuccessfulMonitorDeployment lastSuccessfulMonitorDeployment);

        /**
         * Sets the value of the LastSuccessfulMonitorDeployment property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SuccessfulMonitorDeployment.Builder}
         * avoiding the need to create one manually via {@link SuccessfulMonitorDeployment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SuccessfulMonitorDeployment.Builder#build()} is called
         * immediately and its result is passed to {@link #lastSuccessfulMonitorDeployment(SuccessfulMonitorDeployment)}.
         * 
         * @param lastSuccessfulMonitorDeployment
         *        a consumer that will call methods on {@link SuccessfulMonitorDeployment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastSuccessfulMonitorDeployment(SuccessfulMonitorDeployment)
         */
        default Builder lastSuccessfulMonitorDeployment(
                Consumer<SuccessfulMonitorDeployment.Builder> lastSuccessfulMonitorDeployment) {
            return lastSuccessfulMonitorDeployment(SuccessfulMonitorDeployment.builder()
                    .applyMutation(lastSuccessfulMonitorDeployment).build());
        }

        /**
         * Sets the value of the MediaResourceMap property for this object.
         *
         * @param mediaResourceMap
         *        The new value for the MediaResourceMap property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaResourceMap(Map<String, MediaResource> mediaResourceMap);

        /**
         * Sets the value of the ModifiedAt property for this object.
         *
         * @param modifiedAt
         *        The new value for the ModifiedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedAt(Instant modifiedAt);

        /**
         * If true, there are pending monitor changes for this signal map that can be deployed.
         * 
         * @param monitorChangesPendingDeployment
         *        If true, there are pending monitor changes for this signal map that can be deployed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitorChangesPendingDeployment(Boolean monitorChangesPendingDeployment);

        /**
         * Sets the value of the MonitorDeployment property for this object.
         *
         * @param monitorDeployment
         *        The new value for the MonitorDeployment property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitorDeployment(MonitorDeployment monitorDeployment);

        /**
         * Sets the value of the MonitorDeployment property for this object.
         *
         * This is a convenience method that creates an instance of the {@link MonitorDeployment.Builder} avoiding the
         * need to create one manually via {@link MonitorDeployment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonitorDeployment.Builder#build()} is called immediately and its
         * result is passed to {@link #monitorDeployment(MonitorDeployment)}.
         * 
         * @param monitorDeployment
         *        a consumer that will call methods on {@link MonitorDeployment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitorDeployment(MonitorDeployment)
         */
        default Builder monitorDeployment(Consumer<MonitorDeployment.Builder> monitorDeployment) {
            return monitorDeployment(MonitorDeployment.builder().applyMutation(monitorDeployment).build());
        }

        /**
         * A resource's name. Names must be unique within the scope of a resource type in a specific region.
         * 
         * @param name
         *        A resource's name. Names must be unique within the scope of a resource type in a specific region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the Status property for this object.
         *
         * @param status
         *        The new value for the Status property for this object.
         * @see SignalMapStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SignalMapStatus
         */
        Builder status(String status);

        /**
         * Sets the value of the Status property for this object.
         *
         * @param status
         *        The new value for the Status property for this object.
         * @see SignalMapStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SignalMapStatus
         */
        Builder status(SignalMapStatus status);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends MediaLiveResponse.BuilderImpl implements Builder {
        private String arn;

        private List<String> cloudWatchAlarmTemplateGroupIds = DefaultSdkAutoConstructList.getInstance();

        private Instant createdAt;

        private String description;

        private String discoveryEntryPointArn;

        private String errorMessage;

        private List<String> eventBridgeRuleTemplateGroupIds = DefaultSdkAutoConstructList.getInstance();

        private Map<String, MediaResource> failedMediaResourceMap = DefaultSdkAutoConstructMap.getInstance();

        private String id;

        private Instant lastDiscoveredAt;

        private SuccessfulMonitorDeployment lastSuccessfulMonitorDeployment;

        private Map<String, MediaResource> mediaResourceMap = DefaultSdkAutoConstructMap.getInstance();

        private Instant modifiedAt;

        private Boolean monitorChangesPendingDeployment;

        private MonitorDeployment monitorDeployment;

        private String name;

        private String status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartUpdateSignalMapResponse model) {
            super(model);
            arn(model.arn);
            cloudWatchAlarmTemplateGroupIds(model.cloudWatchAlarmTemplateGroupIds);
            createdAt(model.createdAt);
            description(model.description);
            discoveryEntryPointArn(model.discoveryEntryPointArn);
            errorMessage(model.errorMessage);
            eventBridgeRuleTemplateGroupIds(model.eventBridgeRuleTemplateGroupIds);
            failedMediaResourceMap(model.failedMediaResourceMap);
            id(model.id);
            lastDiscoveredAt(model.lastDiscoveredAt);
            lastSuccessfulMonitorDeployment(model.lastSuccessfulMonitorDeployment);
            mediaResourceMap(model.mediaResourceMap);
            modifiedAt(model.modifiedAt);
            monitorChangesPendingDeployment(model.monitorChangesPendingDeployment);
            monitorDeployment(model.monitorDeployment);
            name(model.name);
            status(model.status);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Collection<String> getCloudWatchAlarmTemplateGroupIds() {
            if (cloudWatchAlarmTemplateGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return cloudWatchAlarmTemplateGroupIds;
        }

        public final void setCloudWatchAlarmTemplateGroupIds(Collection<String> cloudWatchAlarmTemplateGroupIds) {
            this.cloudWatchAlarmTemplateGroupIds = ___listOf__stringMin7Max11PatternAws097Copier
                    .copy(cloudWatchAlarmTemplateGroupIds);
        }

        @Override
        public final Builder cloudWatchAlarmTemplateGroupIds(Collection<String> cloudWatchAlarmTemplateGroupIds) {
            this.cloudWatchAlarmTemplateGroupIds = ___listOf__stringMin7Max11PatternAws097Copier
                    .copy(cloudWatchAlarmTemplateGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchAlarmTemplateGroupIds(String... cloudWatchAlarmTemplateGroupIds) {
            cloudWatchAlarmTemplateGroupIds(Arrays.asList(cloudWatchAlarmTemplateGroupIds));
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDiscoveryEntryPointArn() {
            return discoveryEntryPointArn;
        }

        public final void setDiscoveryEntryPointArn(String discoveryEntryPointArn) {
            this.discoveryEntryPointArn = discoveryEntryPointArn;
        }

        @Override
        public final Builder discoveryEntryPointArn(String discoveryEntryPointArn) {
            this.discoveryEntryPointArn = discoveryEntryPointArn;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final Collection<String> getEventBridgeRuleTemplateGroupIds() {
            if (eventBridgeRuleTemplateGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return eventBridgeRuleTemplateGroupIds;
        }

        public final void setEventBridgeRuleTemplateGroupIds(Collection<String> eventBridgeRuleTemplateGroupIds) {
            this.eventBridgeRuleTemplateGroupIds = ___listOf__stringMin7Max11PatternAws097Copier
                    .copy(eventBridgeRuleTemplateGroupIds);
        }

        @Override
        public final Builder eventBridgeRuleTemplateGroupIds(Collection<String> eventBridgeRuleTemplateGroupIds) {
            this.eventBridgeRuleTemplateGroupIds = ___listOf__stringMin7Max11PatternAws097Copier
                    .copy(eventBridgeRuleTemplateGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventBridgeRuleTemplateGroupIds(String... eventBridgeRuleTemplateGroupIds) {
            eventBridgeRuleTemplateGroupIds(Arrays.asList(eventBridgeRuleTemplateGroupIds));
            return this;
        }

        public final Map<String, MediaResource.Builder> getFailedMediaResourceMap() {
            Map<String, MediaResource.Builder> result = FailedMediaResourceMapCopier.copyToBuilder(this.failedMediaResourceMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFailedMediaResourceMap(Map<String, MediaResource.BuilderImpl> failedMediaResourceMap) {
            this.failedMediaResourceMap = FailedMediaResourceMapCopier.copyFromBuilder(failedMediaResourceMap);
        }

        @Override
        public final Builder failedMediaResourceMap(Map<String, MediaResource> failedMediaResourceMap) {
            this.failedMediaResourceMap = FailedMediaResourceMapCopier.copy(failedMediaResourceMap);
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastDiscoveredAt() {
            return lastDiscoveredAt;
        }

        public final void setLastDiscoveredAt(Instant lastDiscoveredAt) {
            this.lastDiscoveredAt = lastDiscoveredAt;
        }

        @Override
        public final Builder lastDiscoveredAt(Instant lastDiscoveredAt) {
            this.lastDiscoveredAt = lastDiscoveredAt;
            return this;
        }

        public final SuccessfulMonitorDeployment.Builder getLastSuccessfulMonitorDeployment() {
            return lastSuccessfulMonitorDeployment != null ? lastSuccessfulMonitorDeployment.toBuilder() : null;
        }

        public final void setLastSuccessfulMonitorDeployment(
                SuccessfulMonitorDeployment.BuilderImpl lastSuccessfulMonitorDeployment) {
            this.lastSuccessfulMonitorDeployment = lastSuccessfulMonitorDeployment != null ? lastSuccessfulMonitorDeployment
                    .build() : null;
        }

        @Override
        public final Builder lastSuccessfulMonitorDeployment(SuccessfulMonitorDeployment lastSuccessfulMonitorDeployment) {
            this.lastSuccessfulMonitorDeployment = lastSuccessfulMonitorDeployment;
            return this;
        }

        public final Map<String, MediaResource.Builder> getMediaResourceMap() {
            Map<String, MediaResource.Builder> result = MediaResourceMapCopier.copyToBuilder(this.mediaResourceMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setMediaResourceMap(Map<String, MediaResource.BuilderImpl> mediaResourceMap) {
            this.mediaResourceMap = MediaResourceMapCopier.copyFromBuilder(mediaResourceMap);
        }

        @Override
        public final Builder mediaResourceMap(Map<String, MediaResource> mediaResourceMap) {
            this.mediaResourceMap = MediaResourceMapCopier.copy(mediaResourceMap);
            return this;
        }

        public final Instant getModifiedAt() {
            return modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final Boolean getMonitorChangesPendingDeployment() {
            return monitorChangesPendingDeployment;
        }

        public final void setMonitorChangesPendingDeployment(Boolean monitorChangesPendingDeployment) {
            this.monitorChangesPendingDeployment = monitorChangesPendingDeployment;
        }

        @Override
        public final Builder monitorChangesPendingDeployment(Boolean monitorChangesPendingDeployment) {
            this.monitorChangesPendingDeployment = monitorChangesPendingDeployment;
            return this;
        }

        public final MonitorDeployment.Builder getMonitorDeployment() {
            return monitorDeployment != null ? monitorDeployment.toBuilder() : null;
        }

        public final void setMonitorDeployment(MonitorDeployment.BuilderImpl monitorDeployment) {
            this.monitorDeployment = monitorDeployment != null ? monitorDeployment.build() : null;
        }

        @Override
        public final Builder monitorDeployment(MonitorDeployment monitorDeployment) {
            this.monitorDeployment = monitorDeployment;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SignalMapStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public StartUpdateSignalMapResponse build() {
            return new StartUpdateSignalMapResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
