/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Av1 Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class Av1Settings implements SdkPojo, Serializable, ToCopyableBuilder<Av1Settings.Builder, Av1Settings> {
    private static final SdkField<String> AFD_SIGNALING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AfdSignaling").getter(getter(Av1Settings::afdSignalingAsString)).setter(setter(Builder::afdSignaling))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afdSignaling").build()).build();

    private static final SdkField<Integer> BUF_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BufSize").getter(getter(Av1Settings::bufSize)).setter(setter(Builder::bufSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bufSize").build()).build();

    private static final SdkField<Av1ColorSpaceSettings> COLOR_SPACE_SETTINGS_FIELD = SdkField
            .<Av1ColorSpaceSettings> builder(MarshallingType.SDK_POJO).memberName("ColorSpaceSettings")
            .getter(getter(Av1Settings::colorSpaceSettings)).setter(setter(Builder::colorSpaceSettings))
            .constructor(Av1ColorSpaceSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorSpaceSettings").build())
            .build();

    private static final SdkField<String> FIXED_AFD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FixedAfd").getter(getter(Av1Settings::fixedAfdAsString)).setter(setter(Builder::fixedAfd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fixedAfd").build()).build();

    private static final SdkField<Integer> FRAMERATE_DENOMINATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FramerateDenominator").getter(getter(Av1Settings::framerateDenominator))
            .setter(setter(Builder::framerateDenominator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateDenominator").build())
            .build();

    private static final SdkField<Integer> FRAMERATE_NUMERATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FramerateNumerator").getter(getter(Av1Settings::framerateNumerator))
            .setter(setter(Builder::framerateNumerator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateNumerator").build())
            .build();

    private static final SdkField<Double> GOP_SIZE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("GopSize").getter(getter(Av1Settings::gopSize)).setter(setter(Builder::gopSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopSize").build()).build();

    private static final SdkField<String> GOP_SIZE_UNITS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GopSizeUnits").getter(getter(Av1Settings::gopSizeUnitsAsString)).setter(setter(Builder::gopSizeUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopSizeUnits").build()).build();

    private static final SdkField<String> LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Level")
            .getter(getter(Av1Settings::levelAsString)).setter(setter(Builder::level))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("level").build()).build();

    private static final SdkField<String> LOOK_AHEAD_RATE_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LookAheadRateControl").getter(getter(Av1Settings::lookAheadRateControlAsString))
            .setter(setter(Builder::lookAheadRateControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lookAheadRateControl").build())
            .build();

    private static final SdkField<Integer> MAX_BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxBitrate").getter(getter(Av1Settings::maxBitrate)).setter(setter(Builder::maxBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBitrate").build()).build();

    private static final SdkField<Integer> MIN_I_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinIInterval").getter(getter(Av1Settings::minIInterval)).setter(setter(Builder::minIInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minIInterval").build()).build();

    private static final SdkField<Integer> PAR_DENOMINATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ParDenominator").getter(getter(Av1Settings::parDenominator)).setter(setter(Builder::parDenominator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parDenominator").build()).build();

    private static final SdkField<Integer> PAR_NUMERATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ParNumerator").getter(getter(Av1Settings::parNumerator)).setter(setter(Builder::parNumerator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parNumerator").build()).build();

    private static final SdkField<Integer> QVBR_QUALITY_LEVEL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("QvbrQualityLevel").getter(getter(Av1Settings::qvbrQualityLevel))
            .setter(setter(Builder::qvbrQualityLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qvbrQualityLevel").build()).build();

    private static final SdkField<String> SCENE_CHANGE_DETECT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SceneChangeDetect").getter(getter(Av1Settings::sceneChangeDetectAsString))
            .setter(setter(Builder::sceneChangeDetect))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sceneChangeDetect").build()).build();

    private static final SdkField<TimecodeBurninSettings> TIMECODE_BURNIN_SETTINGS_FIELD = SdkField
            .<TimecodeBurninSettings> builder(MarshallingType.SDK_POJO).memberName("TimecodeBurninSettings")
            .getter(getter(Av1Settings::timecodeBurninSettings)).setter(setter(Builder::timecodeBurninSettings))
            .constructor(TimecodeBurninSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecodeBurninSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AFD_SIGNALING_FIELD,
            BUF_SIZE_FIELD, COLOR_SPACE_SETTINGS_FIELD, FIXED_AFD_FIELD, FRAMERATE_DENOMINATOR_FIELD, FRAMERATE_NUMERATOR_FIELD,
            GOP_SIZE_FIELD, GOP_SIZE_UNITS_FIELD, LEVEL_FIELD, LOOK_AHEAD_RATE_CONTROL_FIELD, MAX_BITRATE_FIELD,
            MIN_I_INTERVAL_FIELD, PAR_DENOMINATOR_FIELD, PAR_NUMERATOR_FIELD, QVBR_QUALITY_LEVEL_FIELD,
            SCENE_CHANGE_DETECT_FIELD, TIMECODE_BURNIN_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String afdSignaling;

    private final Integer bufSize;

    private final Av1ColorSpaceSettings colorSpaceSettings;

    private final String fixedAfd;

    private final Integer framerateDenominator;

    private final Integer framerateNumerator;

    private final Double gopSize;

    private final String gopSizeUnits;

    private final String level;

    private final String lookAheadRateControl;

    private final Integer maxBitrate;

    private final Integer minIInterval;

    private final Integer parDenominator;

    private final Integer parNumerator;

    private final Integer qvbrQualityLevel;

    private final String sceneChangeDetect;

    private final TimecodeBurninSettings timecodeBurninSettings;

    private Av1Settings(BuilderImpl builder) {
        this.afdSignaling = builder.afdSignaling;
        this.bufSize = builder.bufSize;
        this.colorSpaceSettings = builder.colorSpaceSettings;
        this.fixedAfd = builder.fixedAfd;
        this.framerateDenominator = builder.framerateDenominator;
        this.framerateNumerator = builder.framerateNumerator;
        this.gopSize = builder.gopSize;
        this.gopSizeUnits = builder.gopSizeUnits;
        this.level = builder.level;
        this.lookAheadRateControl = builder.lookAheadRateControl;
        this.maxBitrate = builder.maxBitrate;
        this.minIInterval = builder.minIInterval;
        this.parDenominator = builder.parDenominator;
        this.parNumerator = builder.parNumerator;
        this.qvbrQualityLevel = builder.qvbrQualityLevel;
        this.sceneChangeDetect = builder.sceneChangeDetect;
        this.timecodeBurninSettings = builder.timecodeBurninSettings;
    }

    /**
     * Configures whether MediaLive will write AFD values into the video. AUTO: MediaLive will try to preserve the input
     * AFD value (in cases where multiple AFD values are valid). FIXED: the AFD value will be the value configured in
     * the fixedAfd parameter. NONE: MediaLive won't write AFD into the video
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #afdSignaling} will
     * return {@link AfdSignaling#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #afdSignalingAsString}.
     * </p>
     * 
     * @return Configures whether MediaLive will write AFD values into the video. AUTO: MediaLive will try to preserve
     *         the input AFD value (in cases where multiple AFD values are valid). FIXED: the AFD value will be the
     *         value configured in the fixedAfd parameter. NONE: MediaLive won't write AFD into the video
     * @see AfdSignaling
     */
    public final AfdSignaling afdSignaling() {
        return AfdSignaling.fromValue(afdSignaling);
    }

    /**
     * Configures whether MediaLive will write AFD values into the video. AUTO: MediaLive will try to preserve the input
     * AFD value (in cases where multiple AFD values are valid). FIXED: the AFD value will be the value configured in
     * the fixedAfd parameter. NONE: MediaLive won't write AFD into the video
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #afdSignaling} will
     * return {@link AfdSignaling#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #afdSignalingAsString}.
     * </p>
     * 
     * @return Configures whether MediaLive will write AFD values into the video. AUTO: MediaLive will try to preserve
     *         the input AFD value (in cases where multiple AFD values are valid). FIXED: the AFD value will be the
     *         value configured in the fixedAfd parameter. NONE: MediaLive won't write AFD into the video
     * @see AfdSignaling
     */
    public final String afdSignalingAsString() {
        return afdSignaling;
    }

    /**
     * The size of the buffer (HRD buffer model) in bits.
     * 
     * @return The size of the buffer (HRD buffer model) in bits.
     */
    public final Integer bufSize() {
        return bufSize;
    }

    /**
     * Color Space settings
     * 
     * @return Color Space settings
     */
    public final Av1ColorSpaceSettings colorSpaceSettings() {
        return colorSpaceSettings;
    }

    /**
     * Complete this property only if you set the afdSignaling property to FIXED. Choose the AFD value (4 bits) to write
     * on all frames of the video encode.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fixedAfd} will
     * return {@link FixedAfd#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fixedAfdAsString}.
     * </p>
     * 
     * @return Complete this property only if you set the afdSignaling property to FIXED. Choose the AFD value (4 bits)
     *         to write on all frames of the video encode.
     * @see FixedAfd
     */
    public final FixedAfd fixedAfd() {
        return FixedAfd.fromValue(fixedAfd);
    }

    /**
     * Complete this property only if you set the afdSignaling property to FIXED. Choose the AFD value (4 bits) to write
     * on all frames of the video encode.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fixedAfd} will
     * return {@link FixedAfd#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fixedAfdAsString}.
     * </p>
     * 
     * @return Complete this property only if you set the afdSignaling property to FIXED. Choose the AFD value (4 bits)
     *         to write on all frames of the video encode.
     * @see FixedAfd
     */
    public final String fixedAfdAsString() {
        return fixedAfd;
    }

    /**
     * The denominator for the framerate. Framerate is a fraction, for example, 24000 / 1001.
     * 
     * @return The denominator for the framerate. Framerate is a fraction, for example, 24000 / 1001.
     */
    public final Integer framerateDenominator() {
        return framerateDenominator;
    }

    /**
     * The numerator for the framerate. Framerate is a fraction, for example, 24000 / 1001.
     * 
     * @return The numerator for the framerate. Framerate is a fraction, for example, 24000 / 1001.
     */
    public final Integer framerateNumerator() {
        return framerateNumerator;
    }

    /**
     * The GOP size (keyframe interval). If GopSizeUnits is frames, GopSize must be a whole number and must be greater
     * than or equal to 1. If GopSizeUnits is seconds, GopSize must be greater than 0, but it can be a decimal.
     * 
     * @return The GOP size (keyframe interval). If GopSizeUnits is frames, GopSize must be a whole number and must be
     *         greater than or equal to 1. If GopSizeUnits is seconds, GopSize must be greater than 0, but it can be a
     *         decimal.
     */
    public final Double gopSize() {
        return gopSize;
    }

    /**
     * Choose the units for the GOP size: FRAMES or SECONDS. For SECONDS, MediaLive converts the size into a frame count
     * at run time.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gopSizeUnits} will
     * return {@link Av1GopSizeUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #gopSizeUnitsAsString}.
     * </p>
     * 
     * @return Choose the units for the GOP size: FRAMES or SECONDS. For SECONDS, MediaLive converts the size into a
     *         frame count at run time.
     * @see Av1GopSizeUnits
     */
    public final Av1GopSizeUnits gopSizeUnits() {
        return Av1GopSizeUnits.fromValue(gopSizeUnits);
    }

    /**
     * Choose the units for the GOP size: FRAMES or SECONDS. For SECONDS, MediaLive converts the size into a frame count
     * at run time.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gopSizeUnits} will
     * return {@link Av1GopSizeUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #gopSizeUnitsAsString}.
     * </p>
     * 
     * @return Choose the units for the GOP size: FRAMES or SECONDS. For SECONDS, MediaLive converts the size into a
     *         frame count at run time.
     * @see Av1GopSizeUnits
     */
    public final String gopSizeUnitsAsString() {
        return gopSizeUnits;
    }

    /**
     * Sets the level. This parameter is one of the properties of the encoding scheme for AV1.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #level} will return
     * {@link Av1Level#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #levelAsString}.
     * </p>
     * 
     * @return Sets the level. This parameter is one of the properties of the encoding scheme for AV1.
     * @see Av1Level
     */
    public final Av1Level level() {
        return Av1Level.fromValue(level);
    }

    /**
     * Sets the level. This parameter is one of the properties of the encoding scheme for AV1.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #level} will return
     * {@link Av1Level#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #levelAsString}.
     * </p>
     * 
     * @return Sets the level. This parameter is one of the properties of the encoding scheme for AV1.
     * @see Av1Level
     */
    public final String levelAsString() {
        return level;
    }

    /**
     * Sets the amount of lookahead. A value of LOW can decrease latency and memory usage. A value of HIGH can produce
     * better quality for certain content.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lookAheadRateControl} will return {@link Av1LookAheadRateControl#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #lookAheadRateControlAsString}.
     * </p>
     * 
     * @return Sets the amount of lookahead. A value of LOW can decrease latency and memory usage. A value of HIGH can
     *         produce better quality for certain content.
     * @see Av1LookAheadRateControl
     */
    public final Av1LookAheadRateControl lookAheadRateControl() {
        return Av1LookAheadRateControl.fromValue(lookAheadRateControl);
    }

    /**
     * Sets the amount of lookahead. A value of LOW can decrease latency and memory usage. A value of HIGH can produce
     * better quality for certain content.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lookAheadRateControl} will return {@link Av1LookAheadRateControl#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #lookAheadRateControlAsString}.
     * </p>
     * 
     * @return Sets the amount of lookahead. A value of LOW can decrease latency and memory usage. A value of HIGH can
     *         produce better quality for certain content.
     * @see Av1LookAheadRateControl
     */
    public final String lookAheadRateControlAsString() {
        return lookAheadRateControl;
    }

    /**
     * The maximum bitrate to assign. For recommendations, see the description for qvbrQualityLevel.
     * 
     * @return The maximum bitrate to assign. For recommendations, see the description for qvbrQualityLevel.
     */
    public final Integer maxBitrate() {
        return maxBitrate;
    }

    /**
     * Applies only if you enable SceneChangeDetect. Sets the interval between frames. This property ensures a minimum
     * separation between repeated (cadence) I-frames and any I-frames inserted by scene change detection (SCD frames).
     * Enter a number for the interval, measured in number of frames. If an SCD frame and a cadence frame are closer
     * than the specified number of frames, MediaLive shrinks or stretches the GOP to include the SCD frame. Then normal
     * cadence resumes in the next GOP. For GOP stretch to succeed, you must enable LookAheadRateControl. Note that the
     * maximum GOP stretch = (GOP size) + (Minimum I-interval) - 1
     * 
     * @return Applies only if you enable SceneChangeDetect. Sets the interval between frames. This property ensures a
     *         minimum separation between repeated (cadence) I-frames and any I-frames inserted by scene change
     *         detection (SCD frames). Enter a number for the interval, measured in number of frames. If an SCD frame
     *         and a cadence frame are closer than the specified number of frames, MediaLive shrinks or stretches the
     *         GOP to include the SCD frame. Then normal cadence resumes in the next GOP. For GOP stretch to succeed,
     *         you must enable LookAheadRateControl. Note that the maximum GOP stretch = (GOP size) + (Minimum
     *         I-interval) - 1
     */
    public final Integer minIInterval() {
        return minIInterval;
    }

    /**
     * The denominator for the output pixel aspect ratio (PAR).
     * 
     * @return The denominator for the output pixel aspect ratio (PAR).
     */
    public final Integer parDenominator() {
        return parDenominator;
    }

    /**
     * The numerator for the output pixel aspect ratio (PAR).
     * 
     * @return The numerator for the output pixel aspect ratio (PAR).
     */
    public final Integer parNumerator() {
        return parNumerator;
    }

    /**
     * Controls the target quality for the video encode. With QVBR rate control mode, the final quality is the target
     * quality, constrained by the maxBitrate. Set values for the qvbrQualityLevel property and maxBitrate property that
     * suit your most important viewing devices. To let MediaLive set the quality level (AUTO mode), leave the
     * qvbrQualityLevel field empty. In this case, MediaLive uses the maximum bitrate, and the quality follows from
     * that: more complex content might have a lower quality. Or set a target quality level and a maximum bitrate. With
     * more complex content, MediaLive will try to achieve the target quality, but it won't exceed the maximum bitrate.
     * With less complex content, This option will use only the bitrate needed to reach the target quality. Recommended
     * values are: Primary screen: qvbrQualityLevel: Leave empty. maxBitrate: 4,000,000 PC or tablet: qvbrQualityLevel:
     * Leave empty. maxBitrate: 1,500,000 to 3,000,000 Smartphone: qvbrQualityLevel: Leave empty. maxBitrate: 1,000,000
     * to 1,500,000
     * 
     * @return Controls the target quality for the video encode. With QVBR rate control mode, the final quality is the
     *         target quality, constrained by the maxBitrate. Set values for the qvbrQualityLevel property and
     *         maxBitrate property that suit your most important viewing devices. To let MediaLive set the quality level
     *         (AUTO mode), leave the qvbrQualityLevel field empty. In this case, MediaLive uses the maximum bitrate,
     *         and the quality follows from that: more complex content might have a lower quality. Or set a target
     *         quality level and a maximum bitrate. With more complex content, MediaLive will try to achieve the target
     *         quality, but it won't exceed the maximum bitrate. With less complex content, This option will use only
     *         the bitrate needed to reach the target quality. Recommended values are: Primary screen: qvbrQualityLevel:
     *         Leave empty. maxBitrate: 4,000,000 PC or tablet: qvbrQualityLevel: Leave empty. maxBitrate: 1,500,000 to
     *         3,000,000 Smartphone: qvbrQualityLevel: Leave empty. maxBitrate: 1,000,000 to 1,500,000
     */
    public final Integer qvbrQualityLevel() {
        return qvbrQualityLevel;
    }

    /**
     * Controls whether MediaLive inserts I-frames when it detects a scene change. ENABLED or DISABLED.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sceneChangeDetect}
     * will return {@link Av1SceneChangeDetect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sceneChangeDetectAsString}.
     * </p>
     * 
     * @return Controls whether MediaLive inserts I-frames when it detects a scene change. ENABLED or DISABLED.
     * @see Av1SceneChangeDetect
     */
    public final Av1SceneChangeDetect sceneChangeDetect() {
        return Av1SceneChangeDetect.fromValue(sceneChangeDetect);
    }

    /**
     * Controls whether MediaLive inserts I-frames when it detects a scene change. ENABLED or DISABLED.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sceneChangeDetect}
     * will return {@link Av1SceneChangeDetect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sceneChangeDetectAsString}.
     * </p>
     * 
     * @return Controls whether MediaLive inserts I-frames when it detects a scene change. ENABLED or DISABLED.
     * @see Av1SceneChangeDetect
     */
    public final String sceneChangeDetectAsString() {
        return sceneChangeDetect;
    }

    /**
     * Configures the timecode burn-in feature. If you enable this feature, the timecode will become part of the video.
     * 
     * @return Configures the timecode burn-in feature. If you enable this feature, the timecode will become part of the
     *         video.
     */
    public final TimecodeBurninSettings timecodeBurninSettings() {
        return timecodeBurninSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(afdSignalingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(bufSize());
        hashCode = 31 * hashCode + Objects.hashCode(colorSpaceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(fixedAfdAsString());
        hashCode = 31 * hashCode + Objects.hashCode(framerateDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(framerateNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(gopSize());
        hashCode = 31 * hashCode + Objects.hashCode(gopSizeUnitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(levelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lookAheadRateControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(minIInterval());
        hashCode = 31 * hashCode + Objects.hashCode(parDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(parNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(qvbrQualityLevel());
        hashCode = 31 * hashCode + Objects.hashCode(sceneChangeDetectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timecodeBurninSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Av1Settings)) {
            return false;
        }
        Av1Settings other = (Av1Settings) obj;
        return Objects.equals(afdSignalingAsString(), other.afdSignalingAsString()) && Objects.equals(bufSize(), other.bufSize())
                && Objects.equals(colorSpaceSettings(), other.colorSpaceSettings())
                && Objects.equals(fixedAfdAsString(), other.fixedAfdAsString())
                && Objects.equals(framerateDenominator(), other.framerateDenominator())
                && Objects.equals(framerateNumerator(), other.framerateNumerator()) && Objects.equals(gopSize(), other.gopSize())
                && Objects.equals(gopSizeUnitsAsString(), other.gopSizeUnitsAsString())
                && Objects.equals(levelAsString(), other.levelAsString())
                && Objects.equals(lookAheadRateControlAsString(), other.lookAheadRateControlAsString())
                && Objects.equals(maxBitrate(), other.maxBitrate()) && Objects.equals(minIInterval(), other.minIInterval())
                && Objects.equals(parDenominator(), other.parDenominator())
                && Objects.equals(parNumerator(), other.parNumerator())
                && Objects.equals(qvbrQualityLevel(), other.qvbrQualityLevel())
                && Objects.equals(sceneChangeDetectAsString(), other.sceneChangeDetectAsString())
                && Objects.equals(timecodeBurninSettings(), other.timecodeBurninSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Av1Settings").add("AfdSignaling", afdSignalingAsString()).add("BufSize", bufSize())
                .add("ColorSpaceSettings", colorSpaceSettings()).add("FixedAfd", fixedAfdAsString())
                .add("FramerateDenominator", framerateDenominator()).add("FramerateNumerator", framerateNumerator())
                .add("GopSize", gopSize()).add("GopSizeUnits", gopSizeUnitsAsString()).add("Level", levelAsString())
                .add("LookAheadRateControl", lookAheadRateControlAsString()).add("MaxBitrate", maxBitrate())
                .add("MinIInterval", minIInterval()).add("ParDenominator", parDenominator()).add("ParNumerator", parNumerator())
                .add("QvbrQualityLevel", qvbrQualityLevel()).add("SceneChangeDetect", sceneChangeDetectAsString())
                .add("TimecodeBurninSettings", timecodeBurninSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AfdSignaling":
            return Optional.ofNullable(clazz.cast(afdSignalingAsString()));
        case "BufSize":
            return Optional.ofNullable(clazz.cast(bufSize()));
        case "ColorSpaceSettings":
            return Optional.ofNullable(clazz.cast(colorSpaceSettings()));
        case "FixedAfd":
            return Optional.ofNullable(clazz.cast(fixedAfdAsString()));
        case "FramerateDenominator":
            return Optional.ofNullable(clazz.cast(framerateDenominator()));
        case "FramerateNumerator":
            return Optional.ofNullable(clazz.cast(framerateNumerator()));
        case "GopSize":
            return Optional.ofNullable(clazz.cast(gopSize()));
        case "GopSizeUnits":
            return Optional.ofNullable(clazz.cast(gopSizeUnitsAsString()));
        case "Level":
            return Optional.ofNullable(clazz.cast(levelAsString()));
        case "LookAheadRateControl":
            return Optional.ofNullable(clazz.cast(lookAheadRateControlAsString()));
        case "MaxBitrate":
            return Optional.ofNullable(clazz.cast(maxBitrate()));
        case "MinIInterval":
            return Optional.ofNullable(clazz.cast(minIInterval()));
        case "ParDenominator":
            return Optional.ofNullable(clazz.cast(parDenominator()));
        case "ParNumerator":
            return Optional.ofNullable(clazz.cast(parNumerator()));
        case "QvbrQualityLevel":
            return Optional.ofNullable(clazz.cast(qvbrQualityLevel()));
        case "SceneChangeDetect":
            return Optional.ofNullable(clazz.cast(sceneChangeDetectAsString()));
        case "TimecodeBurninSettings":
            return Optional.ofNullable(clazz.cast(timecodeBurninSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Av1Settings, T> g) {
        return obj -> g.apply((Av1Settings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Av1Settings> {
        /**
         * Configures whether MediaLive will write AFD values into the video. AUTO: MediaLive will try to preserve the
         * input AFD value (in cases where multiple AFD values are valid). FIXED: the AFD value will be the value
         * configured in the fixedAfd parameter. NONE: MediaLive won't write AFD into the video
         * 
         * @param afdSignaling
         *        Configures whether MediaLive will write AFD values into the video. AUTO: MediaLive will try to
         *        preserve the input AFD value (in cases where multiple AFD values are valid). FIXED: the AFD value will
         *        be the value configured in the fixedAfd parameter. NONE: MediaLive won't write AFD into the video
         * @see AfdSignaling
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AfdSignaling
         */
        Builder afdSignaling(String afdSignaling);

        /**
         * Configures whether MediaLive will write AFD values into the video. AUTO: MediaLive will try to preserve the
         * input AFD value (in cases where multiple AFD values are valid). FIXED: the AFD value will be the value
         * configured in the fixedAfd parameter. NONE: MediaLive won't write AFD into the video
         * 
         * @param afdSignaling
         *        Configures whether MediaLive will write AFD values into the video. AUTO: MediaLive will try to
         *        preserve the input AFD value (in cases where multiple AFD values are valid). FIXED: the AFD value will
         *        be the value configured in the fixedAfd parameter. NONE: MediaLive won't write AFD into the video
         * @see AfdSignaling
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AfdSignaling
         */
        Builder afdSignaling(AfdSignaling afdSignaling);

        /**
         * The size of the buffer (HRD buffer model) in bits.
         * 
         * @param bufSize
         *        The size of the buffer (HRD buffer model) in bits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bufSize(Integer bufSize);

        /**
         * Color Space settings
         * 
         * @param colorSpaceSettings
         *        Color Space settings
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder colorSpaceSettings(Av1ColorSpaceSettings colorSpaceSettings);

        /**
         * Color Space settings This is a convenience method that creates an instance of the
         * {@link Av1ColorSpaceSettings.Builder} avoiding the need to create one manually via
         * {@link Av1ColorSpaceSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Av1ColorSpaceSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #colorSpaceSettings(Av1ColorSpaceSettings)}.
         * 
         * @param colorSpaceSettings
         *        a consumer that will call methods on {@link Av1ColorSpaceSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #colorSpaceSettings(Av1ColorSpaceSettings)
         */
        default Builder colorSpaceSettings(Consumer<Av1ColorSpaceSettings.Builder> colorSpaceSettings) {
            return colorSpaceSettings(Av1ColorSpaceSettings.builder().applyMutation(colorSpaceSettings).build());
        }

        /**
         * Complete this property only if you set the afdSignaling property to FIXED. Choose the AFD value (4 bits) to
         * write on all frames of the video encode.
         * 
         * @param fixedAfd
         *        Complete this property only if you set the afdSignaling property to FIXED. Choose the AFD value (4
         *        bits) to write on all frames of the video encode.
         * @see FixedAfd
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FixedAfd
         */
        Builder fixedAfd(String fixedAfd);

        /**
         * Complete this property only if you set the afdSignaling property to FIXED. Choose the AFD value (4 bits) to
         * write on all frames of the video encode.
         * 
         * @param fixedAfd
         *        Complete this property only if you set the afdSignaling property to FIXED. Choose the AFD value (4
         *        bits) to write on all frames of the video encode.
         * @see FixedAfd
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FixedAfd
         */
        Builder fixedAfd(FixedAfd fixedAfd);

        /**
         * The denominator for the framerate. Framerate is a fraction, for example, 24000 / 1001.
         * 
         * @param framerateDenominator
         *        The denominator for the framerate. Framerate is a fraction, for example, 24000 / 1001.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerateDenominator(Integer framerateDenominator);

        /**
         * The numerator for the framerate. Framerate is a fraction, for example, 24000 / 1001.
         * 
         * @param framerateNumerator
         *        The numerator for the framerate. Framerate is a fraction, for example, 24000 / 1001.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerateNumerator(Integer framerateNumerator);

        /**
         * The GOP size (keyframe interval). If GopSizeUnits is frames, GopSize must be a whole number and must be
         * greater than or equal to 1. If GopSizeUnits is seconds, GopSize must be greater than 0, but it can be a
         * decimal.
         * 
         * @param gopSize
         *        The GOP size (keyframe interval). If GopSizeUnits is frames, GopSize must be a whole number and must
         *        be greater than or equal to 1. If GopSizeUnits is seconds, GopSize must be greater than 0, but it can
         *        be a decimal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gopSize(Double gopSize);

        /**
         * Choose the units for the GOP size: FRAMES or SECONDS. For SECONDS, MediaLive converts the size into a frame
         * count at run time.
         * 
         * @param gopSizeUnits
         *        Choose the units for the GOP size: FRAMES or SECONDS. For SECONDS, MediaLive converts the size into a
         *        frame count at run time.
         * @see Av1GopSizeUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Av1GopSizeUnits
         */
        Builder gopSizeUnits(String gopSizeUnits);

        /**
         * Choose the units for the GOP size: FRAMES or SECONDS. For SECONDS, MediaLive converts the size into a frame
         * count at run time.
         * 
         * @param gopSizeUnits
         *        Choose the units for the GOP size: FRAMES or SECONDS. For SECONDS, MediaLive converts the size into a
         *        frame count at run time.
         * @see Av1GopSizeUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Av1GopSizeUnits
         */
        Builder gopSizeUnits(Av1GopSizeUnits gopSizeUnits);

        /**
         * Sets the level. This parameter is one of the properties of the encoding scheme for AV1.
         * 
         * @param level
         *        Sets the level. This parameter is one of the properties of the encoding scheme for AV1.
         * @see Av1Level
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Av1Level
         */
        Builder level(String level);

        /**
         * Sets the level. This parameter is one of the properties of the encoding scheme for AV1.
         * 
         * @param level
         *        Sets the level. This parameter is one of the properties of the encoding scheme for AV1.
         * @see Av1Level
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Av1Level
         */
        Builder level(Av1Level level);

        /**
         * Sets the amount of lookahead. A value of LOW can decrease latency and memory usage. A value of HIGH can
         * produce better quality for certain content.
         * 
         * @param lookAheadRateControl
         *        Sets the amount of lookahead. A value of LOW can decrease latency and memory usage. A value of HIGH
         *        can produce better quality for certain content.
         * @see Av1LookAheadRateControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Av1LookAheadRateControl
         */
        Builder lookAheadRateControl(String lookAheadRateControl);

        /**
         * Sets the amount of lookahead. A value of LOW can decrease latency and memory usage. A value of HIGH can
         * produce better quality for certain content.
         * 
         * @param lookAheadRateControl
         *        Sets the amount of lookahead. A value of LOW can decrease latency and memory usage. A value of HIGH
         *        can produce better quality for certain content.
         * @see Av1LookAheadRateControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Av1LookAheadRateControl
         */
        Builder lookAheadRateControl(Av1LookAheadRateControl lookAheadRateControl);

        /**
         * The maximum bitrate to assign. For recommendations, see the description for qvbrQualityLevel.
         * 
         * @param maxBitrate
         *        The maximum bitrate to assign. For recommendations, see the description for qvbrQualityLevel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxBitrate(Integer maxBitrate);

        /**
         * Applies only if you enable SceneChangeDetect. Sets the interval between frames. This property ensures a
         * minimum separation between repeated (cadence) I-frames and any I-frames inserted by scene change detection
         * (SCD frames). Enter a number for the interval, measured in number of frames. If an SCD frame and a cadence
         * frame are closer than the specified number of frames, MediaLive shrinks or stretches the GOP to include the
         * SCD frame. Then normal cadence resumes in the next GOP. For GOP stretch to succeed, you must enable
         * LookAheadRateControl. Note that the maximum GOP stretch = (GOP size) + (Minimum I-interval) - 1
         * 
         * @param minIInterval
         *        Applies only if you enable SceneChangeDetect. Sets the interval between frames. This property ensures
         *        a minimum separation between repeated (cadence) I-frames and any I-frames inserted by scene change
         *        detection (SCD frames). Enter a number for the interval, measured in number of frames. If an SCD frame
         *        and a cadence frame are closer than the specified number of frames, MediaLive shrinks or stretches the
         *        GOP to include the SCD frame. Then normal cadence resumes in the next GOP. For GOP stretch to succeed,
         *        you must enable LookAheadRateControl. Note that the maximum GOP stretch = (GOP size) + (Minimum
         *        I-interval) - 1
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minIInterval(Integer minIInterval);

        /**
         * The denominator for the output pixel aspect ratio (PAR).
         * 
         * @param parDenominator
         *        The denominator for the output pixel aspect ratio (PAR).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parDenominator(Integer parDenominator);

        /**
         * The numerator for the output pixel aspect ratio (PAR).
         * 
         * @param parNumerator
         *        The numerator for the output pixel aspect ratio (PAR).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parNumerator(Integer parNumerator);

        /**
         * Controls the target quality for the video encode. With QVBR rate control mode, the final quality is the
         * target quality, constrained by the maxBitrate. Set values for the qvbrQualityLevel property and maxBitrate
         * property that suit your most important viewing devices. To let MediaLive set the quality level (AUTO mode),
         * leave the qvbrQualityLevel field empty. In this case, MediaLive uses the maximum bitrate, and the quality
         * follows from that: more complex content might have a lower quality. Or set a target quality level and a
         * maximum bitrate. With more complex content, MediaLive will try to achieve the target quality, but it won't
         * exceed the maximum bitrate. With less complex content, This option will use only the bitrate needed to reach
         * the target quality. Recommended values are: Primary screen: qvbrQualityLevel: Leave empty. maxBitrate:
         * 4,000,000 PC or tablet: qvbrQualityLevel: Leave empty. maxBitrate: 1,500,000 to 3,000,000 Smartphone:
         * qvbrQualityLevel: Leave empty. maxBitrate: 1,000,000 to 1,500,000
         * 
         * @param qvbrQualityLevel
         *        Controls the target quality for the video encode. With QVBR rate control mode, the final quality is
         *        the target quality, constrained by the maxBitrate. Set values for the qvbrQualityLevel property and
         *        maxBitrate property that suit your most important viewing devices. To let MediaLive set the quality
         *        level (AUTO mode), leave the qvbrQualityLevel field empty. In this case, MediaLive uses the maximum
         *        bitrate, and the quality follows from that: more complex content might have a lower quality. Or set a
         *        target quality level and a maximum bitrate. With more complex content, MediaLive will try to achieve
         *        the target quality, but it won't exceed the maximum bitrate. With less complex content, This option
         *        will use only the bitrate needed to reach the target quality. Recommended values are: Primary screen:
         *        qvbrQualityLevel: Leave empty. maxBitrate: 4,000,000 PC or tablet: qvbrQualityLevel: Leave empty.
         *        maxBitrate: 1,500,000 to 3,000,000 Smartphone: qvbrQualityLevel: Leave empty. maxBitrate: 1,000,000 to
         *        1,500,000
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qvbrQualityLevel(Integer qvbrQualityLevel);

        /**
         * Controls whether MediaLive inserts I-frames when it detects a scene change. ENABLED or DISABLED.
         * 
         * @param sceneChangeDetect
         *        Controls whether MediaLive inserts I-frames when it detects a scene change. ENABLED or DISABLED.
         * @see Av1SceneChangeDetect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Av1SceneChangeDetect
         */
        Builder sceneChangeDetect(String sceneChangeDetect);

        /**
         * Controls whether MediaLive inserts I-frames when it detects a scene change. ENABLED or DISABLED.
         * 
         * @param sceneChangeDetect
         *        Controls whether MediaLive inserts I-frames when it detects a scene change. ENABLED or DISABLED.
         * @see Av1SceneChangeDetect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Av1SceneChangeDetect
         */
        Builder sceneChangeDetect(Av1SceneChangeDetect sceneChangeDetect);

        /**
         * Configures the timecode burn-in feature. If you enable this feature, the timecode will become part of the
         * video.
         * 
         * @param timecodeBurninSettings
         *        Configures the timecode burn-in feature. If you enable this feature, the timecode will become part of
         *        the video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timecodeBurninSettings(TimecodeBurninSettings timecodeBurninSettings);

        /**
         * Configures the timecode burn-in feature. If you enable this feature, the timecode will become part of the
         * video. This is a convenience method that creates an instance of the {@link TimecodeBurninSettings.Builder}
         * avoiding the need to create one manually via {@link TimecodeBurninSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimecodeBurninSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #timecodeBurninSettings(TimecodeBurninSettings)}.
         * 
         * @param timecodeBurninSettings
         *        a consumer that will call methods on {@link TimecodeBurninSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timecodeBurninSettings(TimecodeBurninSettings)
         */
        default Builder timecodeBurninSettings(Consumer<TimecodeBurninSettings.Builder> timecodeBurninSettings) {
            return timecodeBurninSettings(TimecodeBurninSettings.builder().applyMutation(timecodeBurninSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String afdSignaling;

        private Integer bufSize;

        private Av1ColorSpaceSettings colorSpaceSettings;

        private String fixedAfd;

        private Integer framerateDenominator;

        private Integer framerateNumerator;

        private Double gopSize;

        private String gopSizeUnits;

        private String level;

        private String lookAheadRateControl;

        private Integer maxBitrate;

        private Integer minIInterval;

        private Integer parDenominator;

        private Integer parNumerator;

        private Integer qvbrQualityLevel;

        private String sceneChangeDetect;

        private TimecodeBurninSettings timecodeBurninSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(Av1Settings model) {
            afdSignaling(model.afdSignaling);
            bufSize(model.bufSize);
            colorSpaceSettings(model.colorSpaceSettings);
            fixedAfd(model.fixedAfd);
            framerateDenominator(model.framerateDenominator);
            framerateNumerator(model.framerateNumerator);
            gopSize(model.gopSize);
            gopSizeUnits(model.gopSizeUnits);
            level(model.level);
            lookAheadRateControl(model.lookAheadRateControl);
            maxBitrate(model.maxBitrate);
            minIInterval(model.minIInterval);
            parDenominator(model.parDenominator);
            parNumerator(model.parNumerator);
            qvbrQualityLevel(model.qvbrQualityLevel);
            sceneChangeDetect(model.sceneChangeDetect);
            timecodeBurninSettings(model.timecodeBurninSettings);
        }

        public final String getAfdSignaling() {
            return afdSignaling;
        }

        public final void setAfdSignaling(String afdSignaling) {
            this.afdSignaling = afdSignaling;
        }

        @Override
        public final Builder afdSignaling(String afdSignaling) {
            this.afdSignaling = afdSignaling;
            return this;
        }

        @Override
        public final Builder afdSignaling(AfdSignaling afdSignaling) {
            this.afdSignaling(afdSignaling == null ? null : afdSignaling.toString());
            return this;
        }

        public final Integer getBufSize() {
            return bufSize;
        }

        public final void setBufSize(Integer bufSize) {
            this.bufSize = bufSize;
        }

        @Override
        public final Builder bufSize(Integer bufSize) {
            this.bufSize = bufSize;
            return this;
        }

        public final Av1ColorSpaceSettings.Builder getColorSpaceSettings() {
            return colorSpaceSettings != null ? colorSpaceSettings.toBuilder() : null;
        }

        public final void setColorSpaceSettings(Av1ColorSpaceSettings.BuilderImpl colorSpaceSettings) {
            this.colorSpaceSettings = colorSpaceSettings != null ? colorSpaceSettings.build() : null;
        }

        @Override
        public final Builder colorSpaceSettings(Av1ColorSpaceSettings colorSpaceSettings) {
            this.colorSpaceSettings = colorSpaceSettings;
            return this;
        }

        public final String getFixedAfd() {
            return fixedAfd;
        }

        public final void setFixedAfd(String fixedAfd) {
            this.fixedAfd = fixedAfd;
        }

        @Override
        public final Builder fixedAfd(String fixedAfd) {
            this.fixedAfd = fixedAfd;
            return this;
        }

        @Override
        public final Builder fixedAfd(FixedAfd fixedAfd) {
            this.fixedAfd(fixedAfd == null ? null : fixedAfd.toString());
            return this;
        }

        public final Integer getFramerateDenominator() {
            return framerateDenominator;
        }

        public final void setFramerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
        }

        @Override
        public final Builder framerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
            return this;
        }

        public final Integer getFramerateNumerator() {
            return framerateNumerator;
        }

        public final void setFramerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
        }

        @Override
        public final Builder framerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
            return this;
        }

        public final Double getGopSize() {
            return gopSize;
        }

        public final void setGopSize(Double gopSize) {
            this.gopSize = gopSize;
        }

        @Override
        public final Builder gopSize(Double gopSize) {
            this.gopSize = gopSize;
            return this;
        }

        public final String getGopSizeUnits() {
            return gopSizeUnits;
        }

        public final void setGopSizeUnits(String gopSizeUnits) {
            this.gopSizeUnits = gopSizeUnits;
        }

        @Override
        public final Builder gopSizeUnits(String gopSizeUnits) {
            this.gopSizeUnits = gopSizeUnits;
            return this;
        }

        @Override
        public final Builder gopSizeUnits(Av1GopSizeUnits gopSizeUnits) {
            this.gopSizeUnits(gopSizeUnits == null ? null : gopSizeUnits.toString());
            return this;
        }

        public final String getLevel() {
            return level;
        }

        public final void setLevel(String level) {
            this.level = level;
        }

        @Override
        public final Builder level(String level) {
            this.level = level;
            return this;
        }

        @Override
        public final Builder level(Av1Level level) {
            this.level(level == null ? null : level.toString());
            return this;
        }

        public final String getLookAheadRateControl() {
            return lookAheadRateControl;
        }

        public final void setLookAheadRateControl(String lookAheadRateControl) {
            this.lookAheadRateControl = lookAheadRateControl;
        }

        @Override
        public final Builder lookAheadRateControl(String lookAheadRateControl) {
            this.lookAheadRateControl = lookAheadRateControl;
            return this;
        }

        @Override
        public final Builder lookAheadRateControl(Av1LookAheadRateControl lookAheadRateControl) {
            this.lookAheadRateControl(lookAheadRateControl == null ? null : lookAheadRateControl.toString());
            return this;
        }

        public final Integer getMaxBitrate() {
            return maxBitrate;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        @Override
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public final Integer getMinIInterval() {
            return minIInterval;
        }

        public final void setMinIInterval(Integer minIInterval) {
            this.minIInterval = minIInterval;
        }

        @Override
        public final Builder minIInterval(Integer minIInterval) {
            this.minIInterval = minIInterval;
            return this;
        }

        public final Integer getParDenominator() {
            return parDenominator;
        }

        public final void setParDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
        }

        @Override
        public final Builder parDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
            return this;
        }

        public final Integer getParNumerator() {
            return parNumerator;
        }

        public final void setParNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
        }

        @Override
        public final Builder parNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
            return this;
        }

        public final Integer getQvbrQualityLevel() {
            return qvbrQualityLevel;
        }

        public final void setQvbrQualityLevel(Integer qvbrQualityLevel) {
            this.qvbrQualityLevel = qvbrQualityLevel;
        }

        @Override
        public final Builder qvbrQualityLevel(Integer qvbrQualityLevel) {
            this.qvbrQualityLevel = qvbrQualityLevel;
            return this;
        }

        public final String getSceneChangeDetect() {
            return sceneChangeDetect;
        }

        public final void setSceneChangeDetect(String sceneChangeDetect) {
            this.sceneChangeDetect = sceneChangeDetect;
        }

        @Override
        public final Builder sceneChangeDetect(String sceneChangeDetect) {
            this.sceneChangeDetect = sceneChangeDetect;
            return this;
        }

        @Override
        public final Builder sceneChangeDetect(Av1SceneChangeDetect sceneChangeDetect) {
            this.sceneChangeDetect(sceneChangeDetect == null ? null : sceneChangeDetect.toString());
            return this;
        }

        public final TimecodeBurninSettings.Builder getTimecodeBurninSettings() {
            return timecodeBurninSettings != null ? timecodeBurninSettings.toBuilder() : null;
        }

        public final void setTimecodeBurninSettings(TimecodeBurninSettings.BuilderImpl timecodeBurninSettings) {
            this.timecodeBurninSettings = timecodeBurninSettings != null ? timecodeBurninSettings.build() : null;
        }

        @Override
        public final Builder timecodeBurninSettings(TimecodeBurninSettings timecodeBurninSettings) {
            this.timecodeBurninSettings = timecodeBurninSettings;
            return this;
        }

        @Override
        public Av1Settings build() {
            return new Av1Settings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
