/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Bandwidth Reduction Filter Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class BandwidthReductionFilterSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<BandwidthReductionFilterSettings.Builder, BandwidthReductionFilterSettings> {
    private static final SdkField<String> POST_FILTER_SHARPENING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PostFilterSharpening").getter(getter(BandwidthReductionFilterSettings::postFilterSharpeningAsString))
            .setter(setter(Builder::postFilterSharpening))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postFilterSharpening").build())
            .build();

    private static final SdkField<String> STRENGTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Strength").getter(getter(BandwidthReductionFilterSettings::strengthAsString))
            .setter(setter(Builder::strength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("strength").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POST_FILTER_SHARPENING_FIELD,
            STRENGTH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String postFilterSharpening;

    private final String strength;

    private BandwidthReductionFilterSettings(BuilderImpl builder) {
        this.postFilterSharpening = builder.postFilterSharpening;
        this.strength = builder.strength;
    }

    /**
     * Configures the sharpening control, which is available when the bandwidth reduction filter is enabled. This
     * control sharpens edges and contours, which produces a specific artistic effect that you might want.
     *
     * We recommend that you test each of the values (including DISABLED) to observe the sharpening effect on the
     * content.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #postFilterSharpening} will return {@link BandwidthReductionPostFilterSharpening#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #postFilterSharpeningAsString}.
     * </p>
     * 
     * @return Configures the sharpening control, which is available when the bandwidth reduction filter is enabled.
     *         This control sharpens edges and contours, which produces a specific artistic effect that you might want.
     *
     *         We recommend that you test each of the values (including DISABLED) to observe the sharpening effect on
     *         the content.
     * @see BandwidthReductionPostFilterSharpening
     */
    public final BandwidthReductionPostFilterSharpening postFilterSharpening() {
        return BandwidthReductionPostFilterSharpening.fromValue(postFilterSharpening);
    }

    /**
     * Configures the sharpening control, which is available when the bandwidth reduction filter is enabled. This
     * control sharpens edges and contours, which produces a specific artistic effect that you might want.
     *
     * We recommend that you test each of the values (including DISABLED) to observe the sharpening effect on the
     * content.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #postFilterSharpening} will return {@link BandwidthReductionPostFilterSharpening#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #postFilterSharpeningAsString}.
     * </p>
     * 
     * @return Configures the sharpening control, which is available when the bandwidth reduction filter is enabled.
     *         This control sharpens edges and contours, which produces a specific artistic effect that you might want.
     *
     *         We recommend that you test each of the values (including DISABLED) to observe the sharpening effect on
     *         the content.
     * @see BandwidthReductionPostFilterSharpening
     */
    public final String postFilterSharpeningAsString() {
        return postFilterSharpening;
    }

    /**
     * Enables the bandwidth reduction filter. The filter strengths range from 1 to 4. We recommend that you always
     * enable this filter and use AUTO, to let MediaLive apply the optimum filtering for the context.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #strength} will
     * return {@link BandwidthReductionFilterStrength#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #strengthAsString}.
     * </p>
     * 
     * @return Enables the bandwidth reduction filter. The filter strengths range from 1 to 4. We recommend that you
     *         always enable this filter and use AUTO, to let MediaLive apply the optimum filtering for the context.
     * @see BandwidthReductionFilterStrength
     */
    public final BandwidthReductionFilterStrength strength() {
        return BandwidthReductionFilterStrength.fromValue(strength);
    }

    /**
     * Enables the bandwidth reduction filter. The filter strengths range from 1 to 4. We recommend that you always
     * enable this filter and use AUTO, to let MediaLive apply the optimum filtering for the context.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #strength} will
     * return {@link BandwidthReductionFilterStrength#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #strengthAsString}.
     * </p>
     * 
     * @return Enables the bandwidth reduction filter. The filter strengths range from 1 to 4. We recommend that you
     *         always enable this filter and use AUTO, to let MediaLive apply the optimum filtering for the context.
     * @see BandwidthReductionFilterStrength
     */
    public final String strengthAsString() {
        return strength;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(postFilterSharpeningAsString());
        hashCode = 31 * hashCode + Objects.hashCode(strengthAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BandwidthReductionFilterSettings)) {
            return false;
        }
        BandwidthReductionFilterSettings other = (BandwidthReductionFilterSettings) obj;
        return Objects.equals(postFilterSharpeningAsString(), other.postFilterSharpeningAsString())
                && Objects.equals(strengthAsString(), other.strengthAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BandwidthReductionFilterSettings").add("PostFilterSharpening", postFilterSharpeningAsString())
                .add("Strength", strengthAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PostFilterSharpening":
            return Optional.ofNullable(clazz.cast(postFilterSharpeningAsString()));
        case "Strength":
            return Optional.ofNullable(clazz.cast(strengthAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BandwidthReductionFilterSettings, T> g) {
        return obj -> g.apply((BandwidthReductionFilterSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BandwidthReductionFilterSettings> {
        /**
         * Configures the sharpening control, which is available when the bandwidth reduction filter is enabled. This
         * control sharpens edges and contours, which produces a specific artistic effect that you might want.
         *
         * We recommend that you test each of the values (including DISABLED) to observe the sharpening effect on the
         * content.
         * 
         * @param postFilterSharpening
         *        Configures the sharpening control, which is available when the bandwidth reduction filter is enabled.
         *        This control sharpens edges and contours, which produces a specific artistic effect that you might
         *        want.
         *
         *        We recommend that you test each of the values (including DISABLED) to observe the sharpening effect on
         *        the content.
         * @see BandwidthReductionPostFilterSharpening
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BandwidthReductionPostFilterSharpening
         */
        Builder postFilterSharpening(String postFilterSharpening);

        /**
         * Configures the sharpening control, which is available when the bandwidth reduction filter is enabled. This
         * control sharpens edges and contours, which produces a specific artistic effect that you might want.
         *
         * We recommend that you test each of the values (including DISABLED) to observe the sharpening effect on the
         * content.
         * 
         * @param postFilterSharpening
         *        Configures the sharpening control, which is available when the bandwidth reduction filter is enabled.
         *        This control sharpens edges and contours, which produces a specific artistic effect that you might
         *        want.
         *
         *        We recommend that you test each of the values (including DISABLED) to observe the sharpening effect on
         *        the content.
         * @see BandwidthReductionPostFilterSharpening
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BandwidthReductionPostFilterSharpening
         */
        Builder postFilterSharpening(BandwidthReductionPostFilterSharpening postFilterSharpening);

        /**
         * Enables the bandwidth reduction filter. The filter strengths range from 1 to 4. We recommend that you always
         * enable this filter and use AUTO, to let MediaLive apply the optimum filtering for the context.
         * 
         * @param strength
         *        Enables the bandwidth reduction filter. The filter strengths range from 1 to 4. We recommend that you
         *        always enable this filter and use AUTO, to let MediaLive apply the optimum filtering for the context.
         * @see BandwidthReductionFilterStrength
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BandwidthReductionFilterStrength
         */
        Builder strength(String strength);

        /**
         * Enables the bandwidth reduction filter. The filter strengths range from 1 to 4. We recommend that you always
         * enable this filter and use AUTO, to let MediaLive apply the optimum filtering for the context.
         * 
         * @param strength
         *        Enables the bandwidth reduction filter. The filter strengths range from 1 to 4. We recommend that you
         *        always enable this filter and use AUTO, to let MediaLive apply the optimum filtering for the context.
         * @see BandwidthReductionFilterStrength
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BandwidthReductionFilterStrength
         */
        Builder strength(BandwidthReductionFilterStrength strength);
    }

    static final class BuilderImpl implements Builder {
        private String postFilterSharpening;

        private String strength;

        private BuilderImpl() {
        }

        private BuilderImpl(BandwidthReductionFilterSettings model) {
            postFilterSharpening(model.postFilterSharpening);
            strength(model.strength);
        }

        public final String getPostFilterSharpening() {
            return postFilterSharpening;
        }

        public final void setPostFilterSharpening(String postFilterSharpening) {
            this.postFilterSharpening = postFilterSharpening;
        }

        @Override
        public final Builder postFilterSharpening(String postFilterSharpening) {
            this.postFilterSharpening = postFilterSharpening;
            return this;
        }

        @Override
        public final Builder postFilterSharpening(BandwidthReductionPostFilterSharpening postFilterSharpening) {
            this.postFilterSharpening(postFilterSharpening == null ? null : postFilterSharpening.toString());
            return this;
        }

        public final String getStrength() {
            return strength;
        }

        public final void setStrength(String strength) {
            this.strength = strength;
        }

        @Override
        public final Builder strength(String strength) {
            this.strength = strength;
            return this;
        }

        @Override
        public final Builder strength(BandwidthReductionFilterStrength strength) {
            this.strength(strength == null ? null : strength.toString());
            return this;
        }

        @Override
        public BandwidthReductionFilterSettings build() {
            return new BandwidthReductionFilterSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
