/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Used in DescribeClusterResult, DescribeClusterSummary, UpdateClusterResult.
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterNetworkSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<ClusterNetworkSettings.Builder, ClusterNetworkSettings> {
    private static final SdkField<String> DEFAULT_ROUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultRoute").getter(getter(ClusterNetworkSettings::defaultRoute))
            .setter(setter(Builder::defaultRoute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultRoute").build()).build();

    private static final SdkField<List<InterfaceMapping>> INTERFACE_MAPPINGS_FIELD = SdkField
            .<List<InterfaceMapping>> builder(MarshallingType.LIST)
            .memberName("InterfaceMappings")
            .getter(getter(ClusterNetworkSettings::interfaceMappings))
            .setter(setter(Builder::interfaceMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interfaceMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InterfaceMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(InterfaceMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_ROUTE_FIELD,
            INTERFACE_MAPPINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String defaultRoute;

    private final List<InterfaceMapping> interfaceMappings;

    private ClusterNetworkSettings(BuilderImpl builder) {
        this.defaultRoute = builder.defaultRoute;
        this.interfaceMappings = builder.interfaceMappings;
    }

    /**
     * The network interface that is the default route for traffic to and from the node. MediaLive Anywhere uses this
     * default when the destination for the traffic isn't covered by the route table for any of the networks. Specify
     * the value of the appropriate logicalInterfaceName parameter that you create in the interfaceMappings.
     * 
     * @return The network interface that is the default route for traffic to and from the node. MediaLive Anywhere uses
     *         this default when the destination for the traffic isn't covered by the route table for any of the
     *         networks. Specify the value of the appropriate logicalInterfaceName parameter that you create in the
     *         interfaceMappings.
     */
    public final String defaultRoute() {
        return defaultRoute;
    }

    /**
     * For responses, this returns true if the service returned a value for the InterfaceMappings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInterfaceMappings() {
        return interfaceMappings != null && !(interfaceMappings instanceof SdkAutoConstructList);
    }

    /**
     * An array of interfaceMapping objects for this Cluster. Each mapping logically connects one interface on the nodes
     * with one Network. You need only one mapping for each interface because all the Nodes share the mapping.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInterfaceMappings} method.
     * </p>
     * 
     * @return An array of interfaceMapping objects for this Cluster. Each mapping logically connects one interface on
     *         the nodes with one Network. You need only one mapping for each interface because all the Nodes share the
     *         mapping.
     */
    public final List<InterfaceMapping> interfaceMappings() {
        return interfaceMappings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultRoute());
        hashCode = 31 * hashCode + Objects.hashCode(hasInterfaceMappings() ? interfaceMappings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterNetworkSettings)) {
            return false;
        }
        ClusterNetworkSettings other = (ClusterNetworkSettings) obj;
        return Objects.equals(defaultRoute(), other.defaultRoute()) && hasInterfaceMappings() == other.hasInterfaceMappings()
                && Objects.equals(interfaceMappings(), other.interfaceMappings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusterNetworkSettings").add("DefaultRoute", defaultRoute())
                .add("InterfaceMappings", hasInterfaceMappings() ? interfaceMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DefaultRoute":
            return Optional.ofNullable(clazz.cast(defaultRoute()));
        case "InterfaceMappings":
            return Optional.ofNullable(clazz.cast(interfaceMappings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClusterNetworkSettings, T> g) {
        return obj -> g.apply((ClusterNetworkSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterNetworkSettings> {
        /**
         * The network interface that is the default route for traffic to and from the node. MediaLive Anywhere uses
         * this default when the destination for the traffic isn't covered by the route table for any of the networks.
         * Specify the value of the appropriate logicalInterfaceName parameter that you create in the interfaceMappings.
         * 
         * @param defaultRoute
         *        The network interface that is the default route for traffic to and from the node. MediaLive Anywhere
         *        uses this default when the destination for the traffic isn't covered by the route table for any of the
         *        networks. Specify the value of the appropriate logicalInterfaceName parameter that you create in the
         *        interfaceMappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultRoute(String defaultRoute);

        /**
         * An array of interfaceMapping objects for this Cluster. Each mapping logically connects one interface on the
         * nodes with one Network. You need only one mapping for each interface because all the Nodes share the mapping.
         * 
         * @param interfaceMappings
         *        An array of interfaceMapping objects for this Cluster. Each mapping logically connects one interface
         *        on the nodes with one Network. You need only one mapping for each interface because all the Nodes
         *        share the mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interfaceMappings(Collection<InterfaceMapping> interfaceMappings);

        /**
         * An array of interfaceMapping objects for this Cluster. Each mapping logically connects one interface on the
         * nodes with one Network. You need only one mapping for each interface because all the Nodes share the mapping.
         * 
         * @param interfaceMappings
         *        An array of interfaceMapping objects for this Cluster. Each mapping logically connects one interface
         *        on the nodes with one Network. You need only one mapping for each interface because all the Nodes
         *        share the mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interfaceMappings(InterfaceMapping... interfaceMappings);

        /**
         * An array of interfaceMapping objects for this Cluster. Each mapping logically connects one interface on the
         * nodes with one Network. You need only one mapping for each interface because all the Nodes share the mapping.
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.medialive.model.InterfaceMapping.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.medialive.model.InterfaceMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.InterfaceMapping.Builder#build()} is called
         * immediately and its result is passed to {@link #interfaceMappings(List<InterfaceMapping>)}.
         * 
         * @param interfaceMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.InterfaceMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interfaceMappings(java.util.Collection<InterfaceMapping>)
         */
        Builder interfaceMappings(Consumer<InterfaceMapping.Builder>... interfaceMappings);
    }

    static final class BuilderImpl implements Builder {
        private String defaultRoute;

        private List<InterfaceMapping> interfaceMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterNetworkSettings model) {
            defaultRoute(model.defaultRoute);
            interfaceMappings(model.interfaceMappings);
        }

        public final String getDefaultRoute() {
            return defaultRoute;
        }

        public final void setDefaultRoute(String defaultRoute) {
            this.defaultRoute = defaultRoute;
        }

        @Override
        public final Builder defaultRoute(String defaultRoute) {
            this.defaultRoute = defaultRoute;
            return this;
        }

        public final List<InterfaceMapping.Builder> getInterfaceMappings() {
            List<InterfaceMapping.Builder> result = ___listOfInterfaceMappingCopier.copyToBuilder(this.interfaceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInterfaceMappings(Collection<InterfaceMapping.BuilderImpl> interfaceMappings) {
            this.interfaceMappings = ___listOfInterfaceMappingCopier.copyFromBuilder(interfaceMappings);
        }

        @Override
        public final Builder interfaceMappings(Collection<InterfaceMapping> interfaceMappings) {
            this.interfaceMappings = ___listOfInterfaceMappingCopier.copy(interfaceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder interfaceMappings(InterfaceMapping... interfaceMappings) {
            interfaceMappings(Arrays.asList(interfaceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder interfaceMappings(Consumer<InterfaceMapping.Builder>... interfaceMappings) {
            interfaceMappings(Stream.of(interfaceMappings).map(c -> InterfaceMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ClusterNetworkSettings build() {
            return new ClusterNetworkSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
