/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for ClusterNetworkSettingsUpdateRequest
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterNetworkSettingsUpdateRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<ClusterNetworkSettingsUpdateRequest.Builder, ClusterNetworkSettingsUpdateRequest> {
    private static final SdkField<String> DEFAULT_ROUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultRoute").getter(getter(ClusterNetworkSettingsUpdateRequest::defaultRoute))
            .setter(setter(Builder::defaultRoute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultRoute").build()).build();

    private static final SdkField<List<InterfaceMappingUpdateRequest>> INTERFACE_MAPPINGS_FIELD = SdkField
            .<List<InterfaceMappingUpdateRequest>> builder(MarshallingType.LIST)
            .memberName("InterfaceMappings")
            .getter(getter(ClusterNetworkSettingsUpdateRequest::interfaceMappings))
            .setter(setter(Builder::interfaceMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interfaceMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InterfaceMappingUpdateRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(InterfaceMappingUpdateRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_ROUTE_FIELD,
            INTERFACE_MAPPINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String defaultRoute;

    private final List<InterfaceMappingUpdateRequest> interfaceMappings;

    private ClusterNetworkSettingsUpdateRequest(BuilderImpl builder) {
        this.defaultRoute = builder.defaultRoute;
        this.interfaceMappings = builder.interfaceMappings;
    }

    /**
     * Include this parameter only if you want to change the default route for the Cluster. Specify one network
     * interface as the default route for traffic to and from the node. MediaLive Anywhere uses this default when the
     * destination for the traffic isn't covered by the route table for any of the networks. Specify the value of the
     * appropriate logicalInterfaceName parameter that you create in the interfaceMappings.
     * 
     * @return Include this parameter only if you want to change the default route for the Cluster. Specify one network
     *         interface as the default route for traffic to and from the node. MediaLive Anywhere uses this default
     *         when the destination for the traffic isn't covered by the route table for any of the networks. Specify
     *         the value of the appropriate logicalInterfaceName parameter that you create in the interfaceMappings.
     */
    public final String defaultRoute() {
        return defaultRoute;
    }

    /**
     * For responses, this returns true if the service returned a value for the InterfaceMappings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInterfaceMappings() {
        return interfaceMappings != null && !(interfaceMappings instanceof SdkAutoConstructList);
    }

    /**
     * An array of interfaceMapping objects for this Cluster. Include this parameter only if you want to change the
     * interface mappings for the Cluster. Typically, you change the interface mappings only to fix an error you made
     * when creating the mapping. In an update request, make sure that you enter the entire set of mappings again, not
     * just the mappings that you want to add or change. You define this mapping so that the mapping can be used by all
     * the Nodes. Each mapping logically connects one interface on the nodes with one Network. Each mapping consists of
     * a pair of parameters. The logicalInterfaceName parameter creates a logical name for the Node interface that
     * handles a specific type of traffic. For example, my-Inputs-Interface. The networkID parameter refers to the ID of
     * the network. When you create the Nodes in this Cluster, you will associate the logicalInterfaceName with the
     * appropriate physical interface.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInterfaceMappings} method.
     * </p>
     * 
     * @return An array of interfaceMapping objects for this Cluster. Include this parameter only if you want to change
     *         the interface mappings for the Cluster. Typically, you change the interface mappings only to fix an error
     *         you made when creating the mapping. In an update request, make sure that you enter the entire set of
     *         mappings again, not just the mappings that you want to add or change. You define this mapping so that the
     *         mapping can be used by all the Nodes. Each mapping logically connects one interface on the nodes with one
     *         Network. Each mapping consists of a pair of parameters. The logicalInterfaceName parameter creates a
     *         logical name for the Node interface that handles a specific type of traffic. For example,
     *         my-Inputs-Interface. The networkID parameter refers to the ID of the network. When you create the Nodes
     *         in this Cluster, you will associate the logicalInterfaceName with the appropriate physical interface.
     */
    public final List<InterfaceMappingUpdateRequest> interfaceMappings() {
        return interfaceMappings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultRoute());
        hashCode = 31 * hashCode + Objects.hashCode(hasInterfaceMappings() ? interfaceMappings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterNetworkSettingsUpdateRequest)) {
            return false;
        }
        ClusterNetworkSettingsUpdateRequest other = (ClusterNetworkSettingsUpdateRequest) obj;
        return Objects.equals(defaultRoute(), other.defaultRoute()) && hasInterfaceMappings() == other.hasInterfaceMappings()
                && Objects.equals(interfaceMappings(), other.interfaceMappings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusterNetworkSettingsUpdateRequest").add("DefaultRoute", defaultRoute())
                .add("InterfaceMappings", hasInterfaceMappings() ? interfaceMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DefaultRoute":
            return Optional.ofNullable(clazz.cast(defaultRoute()));
        case "InterfaceMappings":
            return Optional.ofNullable(clazz.cast(interfaceMappings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClusterNetworkSettingsUpdateRequest, T> g) {
        return obj -> g.apply((ClusterNetworkSettingsUpdateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterNetworkSettingsUpdateRequest> {
        /**
         * Include this parameter only if you want to change the default route for the Cluster. Specify one network
         * interface as the default route for traffic to and from the node. MediaLive Anywhere uses this default when
         * the destination for the traffic isn't covered by the route table for any of the networks. Specify the value
         * of the appropriate logicalInterfaceName parameter that you create in the interfaceMappings.
         * 
         * @param defaultRoute
         *        Include this parameter only if you want to change the default route for the Cluster. Specify one
         *        network interface as the default route for traffic to and from the node. MediaLive Anywhere uses this
         *        default when the destination for the traffic isn't covered by the route table for any of the networks.
         *        Specify the value of the appropriate logicalInterfaceName parameter that you create in the
         *        interfaceMappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultRoute(String defaultRoute);

        /**
         * An array of interfaceMapping objects for this Cluster. Include this parameter only if you want to change the
         * interface mappings for the Cluster. Typically, you change the interface mappings only to fix an error you
         * made when creating the mapping. In an update request, make sure that you enter the entire set of mappings
         * again, not just the mappings that you want to add or change. You define this mapping so that the mapping can
         * be used by all the Nodes. Each mapping logically connects one interface on the nodes with one Network. Each
         * mapping consists of a pair of parameters. The logicalInterfaceName parameter creates a logical name for the
         * Node interface that handles a specific type of traffic. For example, my-Inputs-Interface. The networkID
         * parameter refers to the ID of the network. When you create the Nodes in this Cluster, you will associate the
         * logicalInterfaceName with the appropriate physical interface.
         * 
         * @param interfaceMappings
         *        An array of interfaceMapping objects for this Cluster. Include this parameter only if you want to
         *        change the interface mappings for the Cluster. Typically, you change the interface mappings only to
         *        fix an error you made when creating the mapping. In an update request, make sure that you enter the
         *        entire set of mappings again, not just the mappings that you want to add or change. You define this
         *        mapping so that the mapping can be used by all the Nodes. Each mapping logically connects one
         *        interface on the nodes with one Network. Each mapping consists of a pair of parameters. The
         *        logicalInterfaceName parameter creates a logical name for the Node interface that handles a specific
         *        type of traffic. For example, my-Inputs-Interface. The networkID parameter refers to the ID of the
         *        network. When you create the Nodes in this Cluster, you will associate the logicalInterfaceName with
         *        the appropriate physical interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interfaceMappings(Collection<InterfaceMappingUpdateRequest> interfaceMappings);

        /**
         * An array of interfaceMapping objects for this Cluster. Include this parameter only if you want to change the
         * interface mappings for the Cluster. Typically, you change the interface mappings only to fix an error you
         * made when creating the mapping. In an update request, make sure that you enter the entire set of mappings
         * again, not just the mappings that you want to add or change. You define this mapping so that the mapping can
         * be used by all the Nodes. Each mapping logically connects one interface on the nodes with one Network. Each
         * mapping consists of a pair of parameters. The logicalInterfaceName parameter creates a logical name for the
         * Node interface that handles a specific type of traffic. For example, my-Inputs-Interface. The networkID
         * parameter refers to the ID of the network. When you create the Nodes in this Cluster, you will associate the
         * logicalInterfaceName with the appropriate physical interface.
         * 
         * @param interfaceMappings
         *        An array of interfaceMapping objects for this Cluster. Include this parameter only if you want to
         *        change the interface mappings for the Cluster. Typically, you change the interface mappings only to
         *        fix an error you made when creating the mapping. In an update request, make sure that you enter the
         *        entire set of mappings again, not just the mappings that you want to add or change. You define this
         *        mapping so that the mapping can be used by all the Nodes. Each mapping logically connects one
         *        interface on the nodes with one Network. Each mapping consists of a pair of parameters. The
         *        logicalInterfaceName parameter creates a logical name for the Node interface that handles a specific
         *        type of traffic. For example, my-Inputs-Interface. The networkID parameter refers to the ID of the
         *        network. When you create the Nodes in this Cluster, you will associate the logicalInterfaceName with
         *        the appropriate physical interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interfaceMappings(InterfaceMappingUpdateRequest... interfaceMappings);

        /**
         * An array of interfaceMapping objects for this Cluster. Include this parameter only if you want to change the
         * interface mappings for the Cluster. Typically, you change the interface mappings only to fix an error you
         * made when creating the mapping. In an update request, make sure that you enter the entire set of mappings
         * again, not just the mappings that you want to add or change. You define this mapping so that the mapping can
         * be used by all the Nodes. Each mapping logically connects one interface on the nodes with one Network. Each
         * mapping consists of a pair of parameters. The logicalInterfaceName parameter creates a logical name for the
         * Node interface that handles a specific type of traffic. For example, my-Inputs-Interface. The networkID
         * parameter refers to the ID of the network. When you create the Nodes in this Cluster, you will associate the
         * logicalInterfaceName with the appropriate physical interface. This is a convenience method that creates an
         * instance of the {@link software.amazon.awssdk.services.medialive.model.InterfaceMappingUpdateRequest.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.medialive.model.InterfaceMappingUpdateRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.InterfaceMappingUpdateRequest.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #interfaceMappings(List<InterfaceMappingUpdateRequest>)}.
         * 
         * @param interfaceMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.InterfaceMappingUpdateRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interfaceMappings(java.util.Collection<InterfaceMappingUpdateRequest>)
         */
        Builder interfaceMappings(Consumer<InterfaceMappingUpdateRequest.Builder>... interfaceMappings);
    }

    static final class BuilderImpl implements Builder {
        private String defaultRoute;

        private List<InterfaceMappingUpdateRequest> interfaceMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterNetworkSettingsUpdateRequest model) {
            defaultRoute(model.defaultRoute);
            interfaceMappings(model.interfaceMappings);
        }

        public final String getDefaultRoute() {
            return defaultRoute;
        }

        public final void setDefaultRoute(String defaultRoute) {
            this.defaultRoute = defaultRoute;
        }

        @Override
        public final Builder defaultRoute(String defaultRoute) {
            this.defaultRoute = defaultRoute;
            return this;
        }

        public final List<InterfaceMappingUpdateRequest.Builder> getInterfaceMappings() {
            List<InterfaceMappingUpdateRequest.Builder> result = ___listOfInterfaceMappingUpdateRequestCopier
                    .copyToBuilder(this.interfaceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInterfaceMappings(Collection<InterfaceMappingUpdateRequest.BuilderImpl> interfaceMappings) {
            this.interfaceMappings = ___listOfInterfaceMappingUpdateRequestCopier.copyFromBuilder(interfaceMappings);
        }

        @Override
        public final Builder interfaceMappings(Collection<InterfaceMappingUpdateRequest> interfaceMappings) {
            this.interfaceMappings = ___listOfInterfaceMappingUpdateRequestCopier.copy(interfaceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder interfaceMappings(InterfaceMappingUpdateRequest... interfaceMappings) {
            interfaceMappings(Arrays.asList(interfaceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder interfaceMappings(Consumer<InterfaceMappingUpdateRequest.Builder>... interfaceMappings) {
            interfaceMappings(Stream.of(interfaceMappings)
                    .map(c -> InterfaceMappingUpdateRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ClusterNetworkSettingsUpdateRequest build() {
            return new ClusterNetworkSettingsUpdateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
