/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Create as many Clusters as you want, but create at least one. Each Cluster groups together Nodes that you want to
 * treat as a collection. Within the Cluster, you will set up some Nodes as active Nodes, and some as backup Nodes, for
 * Node failover purposes. Each Node can belong to only one Cluster.
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateClusterRequest extends MediaLiveRequest implements
        ToCopyableBuilder<CreateClusterRequest.Builder, CreateClusterRequest> {
    private static final SdkField<String> CLUSTER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterType").getter(getter(CreateClusterRequest::clusterTypeAsString))
            .setter(setter(Builder::clusterType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterType").build()).build();

    private static final SdkField<String> INSTANCE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceRoleArn").getter(getter(CreateClusterRequest::instanceRoleArn))
            .setter(setter(Builder::instanceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceRoleArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateClusterRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<ClusterNetworkSettingsCreateRequest> NETWORK_SETTINGS_FIELD = SdkField
            .<ClusterNetworkSettingsCreateRequest> builder(MarshallingType.SDK_POJO).memberName("NetworkSettings")
            .getter(getter(CreateClusterRequest::networkSettings)).setter(setter(Builder::networkSettings))
            .constructor(ClusterNetworkSettingsCreateRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkSettings").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RequestId")
            .getter(getter(CreateClusterRequest::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateClusterRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_TYPE_FIELD,
            INSTANCE_ROLE_ARN_FIELD, NAME_FIELD, NETWORK_SETTINGS_FIELD, REQUEST_ID_FIELD, TAGS_FIELD));

    private final String clusterType;

    private final String instanceRoleArn;

    private final String name;

    private final ClusterNetworkSettingsCreateRequest networkSettings;

    private final String requestId;

    private final Map<String, String> tags;

    private CreateClusterRequest(BuilderImpl builder) {
        super(builder);
        this.clusterType = builder.clusterType;
        this.instanceRoleArn = builder.instanceRoleArn;
        this.name = builder.name;
        this.networkSettings = builder.networkSettings;
        this.requestId = builder.requestId;
        this.tags = builder.tags;
    }

    /**
     * Specify a type. All the Nodes that you later add to this Cluster must be this type of hardware. One Cluster
     * instance can't contain different hardware types. You won't be able to change this parameter after you create the
     * Cluster.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clusterType} will
     * return {@link ClusterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clusterTypeAsString}.
     * </p>
     * 
     * @return Specify a type. All the Nodes that you later add to this Cluster must be this type of hardware. One
     *         Cluster instance can't contain different hardware types. You won't be able to change this parameter after
     *         you create the Cluster.
     * @see ClusterType
     */
    public final ClusterType clusterType() {
        return ClusterType.fromValue(clusterType);
    }

    /**
     * Specify a type. All the Nodes that you later add to this Cluster must be this type of hardware. One Cluster
     * instance can't contain different hardware types. You won't be able to change this parameter after you create the
     * Cluster.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clusterType} will
     * return {@link ClusterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clusterTypeAsString}.
     * </p>
     * 
     * @return Specify a type. All the Nodes that you later add to this Cluster must be this type of hardware. One
     *         Cluster instance can't contain different hardware types. You won't be able to change this parameter after
     *         you create the Cluster.
     * @see ClusterType
     */
    public final String clusterTypeAsString() {
        return clusterType;
    }

    /**
     * The ARN of the IAM role for the Node in this Cluster. The role must include all the operations that you expect
     * these Node to perform. If necessary, create a role in IAM, then attach it here.
     * 
     * @return The ARN of the IAM role for the Node in this Cluster. The role must include all the operations that you
     *         expect these Node to perform. If necessary, create a role in IAM, then attach it here.
     */
    public final String instanceRoleArn() {
        return instanceRoleArn;
    }

    /**
     * Specify a name that is unique in the AWS account. We recommend that you assign a name that hints at the types of
     * Nodes in the Cluster. Names are case-sensitive.
     * 
     * @return Specify a name that is unique in the AWS account. We recommend that you assign a name that hints at the
     *         types of Nodes in the Cluster. Names are case-sensitive.
     */
    public final String name() {
        return name;
    }

    /**
     * Network settings that connect the Nodes in the Cluster to one or more of the Networks that the Cluster is
     * associated with.
     * 
     * @return Network settings that connect the Nodes in the Cluster to one or more of the Networks that the Cluster is
     *         associated with.
     */
    public final ClusterNetworkSettingsCreateRequest networkSettings() {
        return networkSettings;
    }

    /**
     * The unique ID of the request.
     * 
     * @return The unique ID of the request.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * A collection of key-value pairs.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A collection of key-value pairs.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(networkSettings());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterRequest)) {
            return false;
        }
        CreateClusterRequest other = (CreateClusterRequest) obj;
        return Objects.equals(clusterTypeAsString(), other.clusterTypeAsString())
                && Objects.equals(instanceRoleArn(), other.instanceRoleArn()) && Objects.equals(name(), other.name())
                && Objects.equals(networkSettings(), other.networkSettings()) && Objects.equals(requestId(), other.requestId())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateClusterRequest").add("ClusterType", clusterTypeAsString())
                .add("InstanceRoleArn", instanceRoleArn()).add("Name", name()).add("NetworkSettings", networkSettings())
                .add("RequestId", requestId()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterType":
            return Optional.ofNullable(clazz.cast(clusterTypeAsString()));
        case "InstanceRoleArn":
            return Optional.ofNullable(clazz.cast(instanceRoleArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "NetworkSettings":
            return Optional.ofNullable(clazz.cast(networkSettings()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateClusterRequest, T> g) {
        return obj -> g.apply((CreateClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateClusterRequest> {
        /**
         * Specify a type. All the Nodes that you later add to this Cluster must be this type of hardware. One Cluster
         * instance can't contain different hardware types. You won't be able to change this parameter after you create
         * the Cluster.
         * 
         * @param clusterType
         *        Specify a type. All the Nodes that you later add to this Cluster must be this type of hardware. One
         *        Cluster instance can't contain different hardware types. You won't be able to change this parameter
         *        after you create the Cluster.
         * @see ClusterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterType
         */
        Builder clusterType(String clusterType);

        /**
         * Specify a type. All the Nodes that you later add to this Cluster must be this type of hardware. One Cluster
         * instance can't contain different hardware types. You won't be able to change this parameter after you create
         * the Cluster.
         * 
         * @param clusterType
         *        Specify a type. All the Nodes that you later add to this Cluster must be this type of hardware. One
         *        Cluster instance can't contain different hardware types. You won't be able to change this parameter
         *        after you create the Cluster.
         * @see ClusterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterType
         */
        Builder clusterType(ClusterType clusterType);

        /**
         * The ARN of the IAM role for the Node in this Cluster. The role must include all the operations that you
         * expect these Node to perform. If necessary, create a role in IAM, then attach it here.
         * 
         * @param instanceRoleArn
         *        The ARN of the IAM role for the Node in this Cluster. The role must include all the operations that
         *        you expect these Node to perform. If necessary, create a role in IAM, then attach it here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceRoleArn(String instanceRoleArn);

        /**
         * Specify a name that is unique in the AWS account. We recommend that you assign a name that hints at the types
         * of Nodes in the Cluster. Names are case-sensitive.
         * 
         * @param name
         *        Specify a name that is unique in the AWS account. We recommend that you assign a name that hints at
         *        the types of Nodes in the Cluster. Names are case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Network settings that connect the Nodes in the Cluster to one or more of the Networks that the Cluster is
         * associated with.
         * 
         * @param networkSettings
         *        Network settings that connect the Nodes in the Cluster to one or more of the Networks that the Cluster
         *        is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkSettings(ClusterNetworkSettingsCreateRequest networkSettings);

        /**
         * Network settings that connect the Nodes in the Cluster to one or more of the Networks that the Cluster is
         * associated with. This is a convenience method that creates an instance of the
         * {@link ClusterNetworkSettingsCreateRequest.Builder} avoiding the need to create one manually via
         * {@link ClusterNetworkSettingsCreateRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClusterNetworkSettingsCreateRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #networkSettings(ClusterNetworkSettingsCreateRequest)}.
         * 
         * @param networkSettings
         *        a consumer that will call methods on {@link ClusterNetworkSettingsCreateRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkSettings(ClusterNetworkSettingsCreateRequest)
         */
        default Builder networkSettings(Consumer<ClusterNetworkSettingsCreateRequest.Builder> networkSettings) {
            return networkSettings(ClusterNetworkSettingsCreateRequest.builder().applyMutation(networkSettings).build());
        }

        /**
         * The unique ID of the request.
         * 
         * @param requestId
         *        The unique ID of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * A collection of key-value pairs.
         * 
         * @param tags
         *        A collection of key-value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaLiveRequest.BuilderImpl implements Builder {
        private String clusterType;

        private String instanceRoleArn;

        private String name;

        private ClusterNetworkSettingsCreateRequest networkSettings;

        private String requestId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterRequest model) {
            super(model);
            clusterType(model.clusterType);
            instanceRoleArn(model.instanceRoleArn);
            name(model.name);
            networkSettings(model.networkSettings);
            requestId(model.requestId);
            tags(model.tags);
        }

        public final String getClusterType() {
            return clusterType;
        }

        public final void setClusterType(String clusterType) {
            this.clusterType = clusterType;
        }

        @Override
        public final Builder clusterType(String clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        @Override
        public final Builder clusterType(ClusterType clusterType) {
            this.clusterType(clusterType == null ? null : clusterType.toString());
            return this;
        }

        public final String getInstanceRoleArn() {
            return instanceRoleArn;
        }

        public final void setInstanceRoleArn(String instanceRoleArn) {
            this.instanceRoleArn = instanceRoleArn;
        }

        @Override
        public final Builder instanceRoleArn(String instanceRoleArn) {
            this.instanceRoleArn = instanceRoleArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ClusterNetworkSettingsCreateRequest.Builder getNetworkSettings() {
            return networkSettings != null ? networkSettings.toBuilder() : null;
        }

        public final void setNetworkSettings(ClusterNetworkSettingsCreateRequest.BuilderImpl networkSettings) {
            this.networkSettings = networkSettings != null ? networkSettings.build() : null;
        }

        @Override
        public final Builder networkSettings(ClusterNetworkSettingsCreateRequest networkSettings) {
            this.networkSettings = networkSettings;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateClusterRequest build() {
            return new CreateClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
