/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A request to create a Network.
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateNetworkRequest extends MediaLiveRequest implements
        ToCopyableBuilder<CreateNetworkRequest.Builder, CreateNetworkRequest> {
    private static final SdkField<List<IpPoolCreateRequest>> IP_POOLS_FIELD = SdkField
            .<List<IpPoolCreateRequest>> builder(MarshallingType.LIST)
            .memberName("IpPools")
            .getter(getter(CreateNetworkRequest::ipPools))
            .setter(setter(Builder::ipPools))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipPools").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IpPoolCreateRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpPoolCreateRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateNetworkRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RequestId")
            .getter(getter(CreateNetworkRequest::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<RouteCreateRequest>> ROUTES_FIELD = SdkField
            .<List<RouteCreateRequest>> builder(MarshallingType.LIST)
            .memberName("Routes")
            .getter(getter(CreateNetworkRequest::routes))
            .setter(setter(Builder::routes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteCreateRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteCreateRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateNetworkRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_POOLS_FIELD, NAME_FIELD,
            REQUEST_ID_FIELD, ROUTES_FIELD, TAGS_FIELD));

    private final List<IpPoolCreateRequest> ipPools;

    private final String name;

    private final String requestId;

    private final List<RouteCreateRequest> routes;

    private final Map<String, String> tags;

    private CreateNetworkRequest(BuilderImpl builder) {
        super(builder);
        this.ipPools = builder.ipPools;
        this.name = builder.name;
        this.requestId = builder.requestId;
        this.routes = builder.routes;
        this.tags = builder.tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the IpPools property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIpPools() {
        return ipPools != null && !(ipPools instanceof SdkAutoConstructList);
    }

    /**
     * An array of IpPoolCreateRequests that identify a collection of IP addresses in your network that you want to
     * reserve for use in MediaLive Anywhere. MediaLiveAnywhere uses these IP addresses for Push inputs (in both Bridge
     * and NATnetworks) and for output destinations (only in Bridge networks). EachIpPoolUpdateRequest specifies one
     * CIDR block.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpPools} method.
     * </p>
     * 
     * @return An array of IpPoolCreateRequests that identify a collection of IP addresses in your network that you want
     *         to reserve for use in MediaLive Anywhere. MediaLiveAnywhere uses these IP addresses for Push inputs (in
     *         both Bridge and NATnetworks) and for output destinations (only in Bridge networks).
     *         EachIpPoolUpdateRequest specifies one CIDR block.
     */
    public final List<IpPoolCreateRequest> ipPools() {
        return ipPools;
    }

    /**
     * Specify a name that is unique in the AWS account. We recommend that you assign a name that hints at the type of
     * traffic on the network. Names are case-sensitive.
     * 
     * @return Specify a name that is unique in the AWS account. We recommend that you assign a name that hints at the
     *         type of traffic on the network. Names are case-sensitive.
     */
    public final String name() {
        return name;
    }

    /**
     * An ID that you assign to a create request. This ID ensures idempotency when creating resources.
     * 
     * @return An ID that you assign to a create request. This ID ensures idempotency when creating resources.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Routes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRoutes() {
        return routes != null && !(routes instanceof SdkAutoConstructList);
    }

    /**
     * An array of routes that MediaLive Anywhere needs to know about in order to route encoding traffic.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoutes} method.
     * </p>
     * 
     * @return An array of routes that MediaLive Anywhere needs to know about in order to route encoding traffic.
     */
    public final List<RouteCreateRequest> routes() {
        return routes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * A collection of key-value pairs.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A collection of key-value pairs.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasIpPools() ? ipPools() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(hasRoutes() ? routes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNetworkRequest)) {
            return false;
        }
        CreateNetworkRequest other = (CreateNetworkRequest) obj;
        return hasIpPools() == other.hasIpPools() && Objects.equals(ipPools(), other.ipPools())
                && Objects.equals(name(), other.name()) && Objects.equals(requestId(), other.requestId())
                && hasRoutes() == other.hasRoutes() && Objects.equals(routes(), other.routes()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateNetworkRequest").add("IpPools", hasIpPools() ? ipPools() : null).add("Name", name())
                .add("RequestId", requestId()).add("Routes", hasRoutes() ? routes() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpPools":
            return Optional.ofNullable(clazz.cast(ipPools()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Routes":
            return Optional.ofNullable(clazz.cast(routes()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNetworkRequest, T> g) {
        return obj -> g.apply((CreateNetworkRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateNetworkRequest> {
        /**
         * An array of IpPoolCreateRequests that identify a collection of IP addresses in your network that you want to
         * reserve for use in MediaLive Anywhere. MediaLiveAnywhere uses these IP addresses for Push inputs (in both
         * Bridge and NATnetworks) and for output destinations (only in Bridge networks). EachIpPoolUpdateRequest
         * specifies one CIDR block.
         * 
         * @param ipPools
         *        An array of IpPoolCreateRequests that identify a collection of IP addresses in your network that you
         *        want to reserve for use in MediaLive Anywhere. MediaLiveAnywhere uses these IP addresses for Push
         *        inputs (in both Bridge and NATnetworks) and for output destinations (only in Bridge networks).
         *        EachIpPoolUpdateRequest specifies one CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPools(Collection<IpPoolCreateRequest> ipPools);

        /**
         * An array of IpPoolCreateRequests that identify a collection of IP addresses in your network that you want to
         * reserve for use in MediaLive Anywhere. MediaLiveAnywhere uses these IP addresses for Push inputs (in both
         * Bridge and NATnetworks) and for output destinations (only in Bridge networks). EachIpPoolUpdateRequest
         * specifies one CIDR block.
         * 
         * @param ipPools
         *        An array of IpPoolCreateRequests that identify a collection of IP addresses in your network that you
         *        want to reserve for use in MediaLive Anywhere. MediaLiveAnywhere uses these IP addresses for Push
         *        inputs (in both Bridge and NATnetworks) and for output destinations (only in Bridge networks).
         *        EachIpPoolUpdateRequest specifies one CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPools(IpPoolCreateRequest... ipPools);

        /**
         * An array of IpPoolCreateRequests that identify a collection of IP addresses in your network that you want to
         * reserve for use in MediaLive Anywhere. MediaLiveAnywhere uses these IP addresses for Push inputs (in both
         * Bridge and NATnetworks) and for output destinations (only in Bridge networks). EachIpPoolUpdateRequest
         * specifies one CIDR block. This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.medialive.model.IpPoolCreateRequest.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.medialive.model.IpPoolCreateRequest#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.IpPoolCreateRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #ipPools(List<IpPoolCreateRequest>)}.
         * 
         * @param ipPools
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.IpPoolCreateRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipPools(java.util.Collection<IpPoolCreateRequest>)
         */
        Builder ipPools(Consumer<IpPoolCreateRequest.Builder>... ipPools);

        /**
         * Specify a name that is unique in the AWS account. We recommend that you assign a name that hints at the type
         * of traffic on the network. Names are case-sensitive.
         * 
         * @param name
         *        Specify a name that is unique in the AWS account. We recommend that you assign a name that hints at
         *        the type of traffic on the network. Names are case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * An ID that you assign to a create request. This ID ensures idempotency when creating resources.
         * 
         * @param requestId
         *        An ID that you assign to a create request. This ID ensures idempotency when creating resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * An array of routes that MediaLive Anywhere needs to know about in order to route encoding traffic.
         * 
         * @param routes
         *        An array of routes that MediaLive Anywhere needs to know about in order to route encoding traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routes(Collection<RouteCreateRequest> routes);

        /**
         * An array of routes that MediaLive Anywhere needs to know about in order to route encoding traffic.
         * 
         * @param routes
         *        An array of routes that MediaLive Anywhere needs to know about in order to route encoding traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routes(RouteCreateRequest... routes);

        /**
         * An array of routes that MediaLive Anywhere needs to know about in order to route encoding traffic. This is a
         * convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.medialive.model.RouteCreateRequest.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.medialive.model.RouteCreateRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.RouteCreateRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #routes(List<RouteCreateRequest>)}.
         * 
         * @param routes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.RouteCreateRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routes(java.util.Collection<RouteCreateRequest>)
         */
        Builder routes(Consumer<RouteCreateRequest.Builder>... routes);

        /**
         * A collection of key-value pairs.
         * 
         * @param tags
         *        A collection of key-value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaLiveRequest.BuilderImpl implements Builder {
        private List<IpPoolCreateRequest> ipPools = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private String requestId;

        private List<RouteCreateRequest> routes = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNetworkRequest model) {
            super(model);
            ipPools(model.ipPools);
            name(model.name);
            requestId(model.requestId);
            routes(model.routes);
            tags(model.tags);
        }

        public final List<IpPoolCreateRequest.Builder> getIpPools() {
            List<IpPoolCreateRequest.Builder> result = ___listOfIpPoolCreateRequestCopier.copyToBuilder(this.ipPools);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpPools(Collection<IpPoolCreateRequest.BuilderImpl> ipPools) {
            this.ipPools = ___listOfIpPoolCreateRequestCopier.copyFromBuilder(ipPools);
        }

        @Override
        public final Builder ipPools(Collection<IpPoolCreateRequest> ipPools) {
            this.ipPools = ___listOfIpPoolCreateRequestCopier.copy(ipPools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPools(IpPoolCreateRequest... ipPools) {
            ipPools(Arrays.asList(ipPools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPools(Consumer<IpPoolCreateRequest.Builder>... ipPools) {
            ipPools(Stream.of(ipPools).map(c -> IpPoolCreateRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final List<RouteCreateRequest.Builder> getRoutes() {
            List<RouteCreateRequest.Builder> result = ___listOfRouteCreateRequestCopier.copyToBuilder(this.routes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutes(Collection<RouteCreateRequest.BuilderImpl> routes) {
            this.routes = ___listOfRouteCreateRequestCopier.copyFromBuilder(routes);
        }

        @Override
        public final Builder routes(Collection<RouteCreateRequest> routes) {
            this.routes = ___listOfRouteCreateRequestCopier.copy(routes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(RouteCreateRequest... routes) {
            routes(Arrays.asList(routes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Consumer<RouteCreateRequest.Builder>... routes) {
            routes(Stream.of(routes).map(c -> RouteCreateRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNetworkRequest build() {
            return new CreateNetworkRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
