/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for CreateNodeRegistrationScriptResponse
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateNodeRegistrationScriptResponse extends MediaLiveResponse implements
        ToCopyableBuilder<CreateNodeRegistrationScriptResponse.Builder, CreateNodeRegistrationScriptResponse> {
    private static final SdkField<String> NODE_REGISTRATION_SCRIPT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeRegistrationScript").getter(getter(CreateNodeRegistrationScriptResponse::nodeRegistrationScript))
            .setter(setter(Builder::nodeRegistrationScript))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeRegistrationScript").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(NODE_REGISTRATION_SCRIPT_FIELD));

    private final String nodeRegistrationScript;

    private CreateNodeRegistrationScriptResponse(BuilderImpl builder) {
        super(builder);
        this.nodeRegistrationScript = builder.nodeRegistrationScript;
    }

    /**
     * A script that can be run on a Bring Your Own Device Elemental Anywhere system to create a node in a cluster.
     * 
     * @return A script that can be run on a Bring Your Own Device Elemental Anywhere system to create a node in a
     *         cluster.
     */
    public final String nodeRegistrationScript() {
        return nodeRegistrationScript;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nodeRegistrationScript());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNodeRegistrationScriptResponse)) {
            return false;
        }
        CreateNodeRegistrationScriptResponse other = (CreateNodeRegistrationScriptResponse) obj;
        return Objects.equals(nodeRegistrationScript(), other.nodeRegistrationScript());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateNodeRegistrationScriptResponse").add("NodeRegistrationScript", nodeRegistrationScript())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NodeRegistrationScript":
            return Optional.ofNullable(clazz.cast(nodeRegistrationScript()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNodeRegistrationScriptResponse, T> g) {
        return obj -> g.apply((CreateNodeRegistrationScriptResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateNodeRegistrationScriptResponse> {
        /**
         * A script that can be run on a Bring Your Own Device Elemental Anywhere system to create a node in a cluster.
         * 
         * @param nodeRegistrationScript
         *        A script that can be run on a Bring Your Own Device Elemental Anywhere system to create a node in a
         *        cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeRegistrationScript(String nodeRegistrationScript);
    }

    static final class BuilderImpl extends MediaLiveResponse.BuilderImpl implements Builder {
        private String nodeRegistrationScript;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNodeRegistrationScriptResponse model) {
            super(model);
            nodeRegistrationScript(model.nodeRegistrationScript);
        }

        public final String getNodeRegistrationScript() {
            return nodeRegistrationScript;
        }

        public final void setNodeRegistrationScript(String nodeRegistrationScript) {
            this.nodeRegistrationScript = nodeRegistrationScript;
        }

        @Override
        public final Builder nodeRegistrationScript(String nodeRegistrationScript) {
            this.nodeRegistrationScript = nodeRegistrationScript;
            return this;
        }

        @Override
        public CreateNodeRegistrationScriptResponse build() {
            return new CreateNodeRegistrationScriptResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
