/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A request to create a node
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateNodeRequest extends MediaLiveRequest implements
        ToCopyableBuilder<CreateNodeRequest.Builder, CreateNodeRequest> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterId").getter(getter(CreateNodeRequest::clusterId)).setter(setter(Builder::clusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("clusterId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateNodeRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<NodeInterfaceMappingCreateRequest>> NODE_INTERFACE_MAPPINGS_FIELD = SdkField
            .<List<NodeInterfaceMappingCreateRequest>> builder(MarshallingType.LIST)
            .memberName("NodeInterfaceMappings")
            .getter(getter(CreateNodeRequest::nodeInterfaceMappings))
            .setter(setter(Builder::nodeInterfaceMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeInterfaceMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NodeInterfaceMappingCreateRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(NodeInterfaceMappingCreateRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RequestId")
            .getter(getter(CreateNodeRequest::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(CreateNodeRequest::roleAsString)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("role").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateNodeRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD, NAME_FIELD,
            NODE_INTERFACE_MAPPINGS_FIELD, REQUEST_ID_FIELD, ROLE_FIELD, TAGS_FIELD));

    private final String clusterId;

    private final String name;

    private final List<NodeInterfaceMappingCreateRequest> nodeInterfaceMappings;

    private final String requestId;

    private final String role;

    private final Map<String, String> tags;

    private CreateNodeRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.name = builder.name;
        this.nodeInterfaceMappings = builder.nodeInterfaceMappings;
        this.requestId = builder.requestId;
        this.role = builder.role;
        this.tags = builder.tags;
    }

    /**
     * The ID of the cluster.
     * 
     * @return The ID of the cluster.
     */
    public final String clusterId() {
        return clusterId;
    }

    /**
     * The user-specified name of the Node to be created.
     * 
     * @return The user-specified name of the Node to be created.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the NodeInterfaceMappings property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasNodeInterfaceMappings() {
        return nodeInterfaceMappings != null && !(nodeInterfaceMappings instanceof SdkAutoConstructList);
    }

    /**
     * Documentation update needed
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNodeInterfaceMappings} method.
     * </p>
     * 
     * @return Documentation update needed
     */
    public final List<NodeInterfaceMappingCreateRequest> nodeInterfaceMappings() {
        return nodeInterfaceMappings;
    }

    /**
     * An ID that you assign to a create request. This ID ensures idempotency when creating resources.
     * 
     * @return An ID that you assign to a create request. This ID ensures idempotency when creating resources.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * The initial role of the Node in the Cluster. ACTIVE means the Node is available for encoding. BACKUP means the
     * Node is a redundant Node and might get used if an ACTIVE Node fails.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link NodeRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The initial role of the Node in the Cluster. ACTIVE means the Node is available for encoding. BACKUP
     *         means the Node is a redundant Node and might get used if an ACTIVE Node fails.
     * @see NodeRole
     */
    public final NodeRole role() {
        return NodeRole.fromValue(role);
    }

    /**
     * The initial role of the Node in the Cluster. ACTIVE means the Node is available for encoding. BACKUP means the
     * Node is a redundant Node and might get used if an ACTIVE Node fails.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link NodeRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The initial role of the Node in the Cluster. ACTIVE means the Node is available for encoding. BACKUP
     *         means the Node is a redundant Node and might get used if an ACTIVE Node fails.
     * @see NodeRole
     */
    public final String roleAsString() {
        return role;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * A collection of key-value pairs.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A collection of key-value pairs.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasNodeInterfaceMappings() ? nodeInterfaceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(roleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNodeRequest)) {
            return false;
        }
        CreateNodeRequest other = (CreateNodeRequest) obj;
        return Objects.equals(clusterId(), other.clusterId()) && Objects.equals(name(), other.name())
                && hasNodeInterfaceMappings() == other.hasNodeInterfaceMappings()
                && Objects.equals(nodeInterfaceMappings(), other.nodeInterfaceMappings())
                && Objects.equals(requestId(), other.requestId()) && Objects.equals(roleAsString(), other.roleAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateNodeRequest").add("ClusterId", clusterId()).add("Name", name())
                .add("NodeInterfaceMappings", hasNodeInterfaceMappings() ? nodeInterfaceMappings() : null)
                .add("RequestId", requestId()).add("Role", roleAsString()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterId":
            return Optional.ofNullable(clazz.cast(clusterId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "NodeInterfaceMappings":
            return Optional.ofNullable(clazz.cast(nodeInterfaceMappings()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Role":
            return Optional.ofNullable(clazz.cast(roleAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNodeRequest, T> g) {
        return obj -> g.apply((CreateNodeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateNodeRequest> {
        /**
         * The ID of the cluster.
         * 
         * @param clusterId
         *        The ID of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        /**
         * The user-specified name of the Node to be created.
         * 
         * @param name
         *        The user-specified name of the Node to be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Documentation update needed
         * 
         * @param nodeInterfaceMappings
         *        Documentation update needed
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeInterfaceMappings(Collection<NodeInterfaceMappingCreateRequest> nodeInterfaceMappings);

        /**
         * Documentation update needed
         * 
         * @param nodeInterfaceMappings
         *        Documentation update needed
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeInterfaceMappings(NodeInterfaceMappingCreateRequest... nodeInterfaceMappings);

        /**
         * Documentation update needed This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.medialive.model.NodeInterfaceMappingCreateRequest.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.medialive.model.NodeInterfaceMappingCreateRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.NodeInterfaceMappingCreateRequest.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #nodeInterfaceMappings(List<NodeInterfaceMappingCreateRequest>)}.
         * 
         * @param nodeInterfaceMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.NodeInterfaceMappingCreateRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeInterfaceMappings(java.util.Collection<NodeInterfaceMappingCreateRequest>)
         */
        Builder nodeInterfaceMappings(Consumer<NodeInterfaceMappingCreateRequest.Builder>... nodeInterfaceMappings);

        /**
         * An ID that you assign to a create request. This ID ensures idempotency when creating resources.
         * 
         * @param requestId
         *        An ID that you assign to a create request. This ID ensures idempotency when creating resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * The initial role of the Node in the Cluster. ACTIVE means the Node is available for encoding. BACKUP means
         * the Node is a redundant Node and might get used if an ACTIVE Node fails.
         * 
         * @param role
         *        The initial role of the Node in the Cluster. ACTIVE means the Node is available for encoding. BACKUP
         *        means the Node is a redundant Node and might get used if an ACTIVE Node fails.
         * @see NodeRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeRole
         */
        Builder role(String role);

        /**
         * The initial role of the Node in the Cluster. ACTIVE means the Node is available for encoding. BACKUP means
         * the Node is a redundant Node and might get used if an ACTIVE Node fails.
         * 
         * @param role
         *        The initial role of the Node in the Cluster. ACTIVE means the Node is available for encoding. BACKUP
         *        means the Node is a redundant Node and might get used if an ACTIVE Node fails.
         * @see NodeRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeRole
         */
        Builder role(NodeRole role);

        /**
         * A collection of key-value pairs.
         * 
         * @param tags
         *        A collection of key-value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaLiveRequest.BuilderImpl implements Builder {
        private String clusterId;

        private String name;

        private List<NodeInterfaceMappingCreateRequest> nodeInterfaceMappings = DefaultSdkAutoConstructList.getInstance();

        private String requestId;

        private String role;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNodeRequest model) {
            super(model);
            clusterId(model.clusterId);
            name(model.name);
            nodeInterfaceMappings(model.nodeInterfaceMappings);
            requestId(model.requestId);
            role(model.role);
            tags(model.tags);
        }

        public final String getClusterId() {
            return clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<NodeInterfaceMappingCreateRequest.Builder> getNodeInterfaceMappings() {
            List<NodeInterfaceMappingCreateRequest.Builder> result = ___listOfNodeInterfaceMappingCreateRequestCopier
                    .copyToBuilder(this.nodeInterfaceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNodeInterfaceMappings(Collection<NodeInterfaceMappingCreateRequest.BuilderImpl> nodeInterfaceMappings) {
            this.nodeInterfaceMappings = ___listOfNodeInterfaceMappingCreateRequestCopier.copyFromBuilder(nodeInterfaceMappings);
        }

        @Override
        public final Builder nodeInterfaceMappings(Collection<NodeInterfaceMappingCreateRequest> nodeInterfaceMappings) {
            this.nodeInterfaceMappings = ___listOfNodeInterfaceMappingCreateRequestCopier.copy(nodeInterfaceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeInterfaceMappings(NodeInterfaceMappingCreateRequest... nodeInterfaceMappings) {
            nodeInterfaceMappings(Arrays.asList(nodeInterfaceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeInterfaceMappings(Consumer<NodeInterfaceMappingCreateRequest.Builder>... nodeInterfaceMappings) {
            nodeInterfaceMappings(Stream.of(nodeInterfaceMappings)
                    .map(c -> NodeInterfaceMappingCreateRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(NodeRole role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNodeRequest build() {
            return new CreateNodeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
