/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for DescribeChannelPlacementGroupRequest
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeChannelPlacementGroupRequest extends MediaLiveRequest implements
        ToCopyableBuilder<DescribeChannelPlacementGroupRequest.Builder, DescribeChannelPlacementGroupRequest> {
    private static final SdkField<String> CHANNEL_PLACEMENT_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelPlacementGroupId").getter(getter(DescribeChannelPlacementGroupRequest::channelPlacementGroupId))
            .setter(setter(Builder::channelPlacementGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelPlacementGroupId").build())
            .build();

    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterId").getter(getter(DescribeChannelPlacementGroupRequest::clusterId))
            .setter(setter(Builder::clusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("clusterId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CHANNEL_PLACEMENT_GROUP_ID_FIELD, CLUSTER_ID_FIELD));

    private final String channelPlacementGroupId;

    private final String clusterId;

    private DescribeChannelPlacementGroupRequest(BuilderImpl builder) {
        super(builder);
        this.channelPlacementGroupId = builder.channelPlacementGroupId;
        this.clusterId = builder.clusterId;
    }

    /**
     * The ID of the channel placement group.
     * 
     * @return The ID of the channel placement group.
     */
    public final String channelPlacementGroupId() {
        return channelPlacementGroupId;
    }

    /**
     * The ID of the cluster.
     * 
     * @return The ID of the cluster.
     */
    public final String clusterId() {
        return clusterId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelPlacementGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(clusterId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeChannelPlacementGroupRequest)) {
            return false;
        }
        DescribeChannelPlacementGroupRequest other = (DescribeChannelPlacementGroupRequest) obj;
        return Objects.equals(channelPlacementGroupId(), other.channelPlacementGroupId())
                && Objects.equals(clusterId(), other.clusterId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeChannelPlacementGroupRequest").add("ChannelPlacementGroupId", channelPlacementGroupId())
                .add("ClusterId", clusterId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelPlacementGroupId":
            return Optional.ofNullable(clazz.cast(channelPlacementGroupId()));
        case "ClusterId":
            return Optional.ofNullable(clazz.cast(clusterId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeChannelPlacementGroupRequest, T> g) {
        return obj -> g.apply((DescribeChannelPlacementGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeChannelPlacementGroupRequest> {
        /**
         * The ID of the channel placement group.
         * 
         * @param channelPlacementGroupId
         *        The ID of the channel placement group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelPlacementGroupId(String channelPlacementGroupId);

        /**
         * The ID of the cluster.
         * 
         * @param clusterId
         *        The ID of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaLiveRequest.BuilderImpl implements Builder {
        private String channelPlacementGroupId;

        private String clusterId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeChannelPlacementGroupRequest model) {
            super(model);
            channelPlacementGroupId(model.channelPlacementGroupId);
            clusterId(model.clusterId);
        }

        public final String getChannelPlacementGroupId() {
            return channelPlacementGroupId;
        }

        public final void setChannelPlacementGroupId(String channelPlacementGroupId) {
            this.channelPlacementGroupId = channelPlacementGroupId;
        }

        @Override
        public final Builder channelPlacementGroupId(String channelPlacementGroupId) {
            this.channelPlacementGroupId = channelPlacementGroupId;
            return this;
        }

        public final String getClusterId() {
            return clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeChannelPlacementGroupRequest build() {
            return new DescribeChannelPlacementGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
