/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for DescribeClusterResponse
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeClusterResponse extends MediaLiveResponse implements
        ToCopyableBuilder<DescribeClusterResponse.Builder, DescribeClusterResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DescribeClusterResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<List<String>> CHANNEL_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ChannelIds")
            .getter(getter(DescribeClusterResponse::channelIds))
            .setter(setter(Builder::channelIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLUSTER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterType").getter(getter(DescribeClusterResponse::clusterTypeAsString))
            .setter(setter(Builder::clusterType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterType").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(DescribeClusterResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> INSTANCE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceRoleArn").getter(getter(DescribeClusterResponse::instanceRoleArn))
            .setter(setter(Builder::instanceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceRoleArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeClusterResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<ClusterNetworkSettings> NETWORK_SETTINGS_FIELD = SdkField
            .<ClusterNetworkSettings> builder(MarshallingType.SDK_POJO).memberName("NetworkSettings")
            .getter(getter(DescribeClusterResponse::networkSettings)).setter(setter(Builder::networkSettings))
            .constructor(ClusterNetworkSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkSettings").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(DescribeClusterResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CHANNEL_IDS_FIELD,
            CLUSTER_TYPE_FIELD, ID_FIELD, INSTANCE_ROLE_ARN_FIELD, NAME_FIELD, NETWORK_SETTINGS_FIELD, STATE_FIELD));

    private final String arn;

    private final List<String> channelIds;

    private final String clusterType;

    private final String id;

    private final String instanceRoleArn;

    private final String name;

    private final ClusterNetworkSettings networkSettings;

    private final String state;

    private DescribeClusterResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.channelIds = builder.channelIds;
        this.clusterType = builder.clusterType;
        this.id = builder.id;
        this.instanceRoleArn = builder.instanceRoleArn;
        this.name = builder.name;
        this.networkSettings = builder.networkSettings;
        this.state = builder.state;
    }

    /**
     * The ARN of this Cluster. It is automatically assigned when the Cluster is created.
     * 
     * @return The ARN of this Cluster. It is automatically assigned when the Cluster is created.
     */
    public final String arn() {
        return arn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChannelIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasChannelIds() {
        return channelIds != null && !(channelIds instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the ChannelIds property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChannelIds} method.
     * </p>
     * 
     * @return The value of the ChannelIds property for this object.
     */
    public final List<String> channelIds() {
        return channelIds;
    }

    /**
     * The hardware type for the Cluster
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clusterType} will
     * return {@link ClusterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clusterTypeAsString}.
     * </p>
     * 
     * @return The hardware type for the Cluster
     * @see ClusterType
     */
    public final ClusterType clusterType() {
        return ClusterType.fromValue(clusterType);
    }

    /**
     * The hardware type for the Cluster
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clusterType} will
     * return {@link ClusterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clusterTypeAsString}.
     * </p>
     * 
     * @return The hardware type for the Cluster
     * @see ClusterType
     */
    public final String clusterTypeAsString() {
        return clusterType;
    }

    /**
     * The ID of the Cluster. Unique in the AWS account. The ID is the resource-id portion of the ARN.
     * 
     * @return The ID of the Cluster. Unique in the AWS account. The ID is the resource-id portion of the ARN.
     */
    public final String id() {
        return id;
    }

    /**
     * The ARN of the IAM role for the Node in this Cluster. Any Nodes that are associated with this Cluster assume this
     * role. The role gives permissions to the operations that you expect these Node to perform.
     * 
     * @return The ARN of the IAM role for the Node in this Cluster. Any Nodes that are associated with this Cluster
     *         assume this role. The role gives permissions to the operations that you expect these Node to perform.
     */
    public final String instanceRoleArn() {
        return instanceRoleArn;
    }

    /**
     * The name that you specified for the Cluster.
     * 
     * @return The name that you specified for the Cluster.
     */
    public final String name() {
        return name;
    }

    /**
     * Network settings that connect the Nodes in the Cluster to one or more of the Networks that the Cluster is
     * associated with.
     * 
     * @return Network settings that connect the Nodes in the Cluster to one or more of the Networks that the Cluster is
     *         associated with.
     */
    public final ClusterNetworkSettings networkSettings() {
        return networkSettings;
    }

    /**
     * The current state of the Cluster.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ClusterState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the Cluster.
     * @see ClusterState
     */
    public final ClusterState state() {
        return ClusterState.fromValue(state);
    }

    /**
     * The current state of the Cluster.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ClusterState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the Cluster.
     * @see ClusterState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(hasChannelIds() ? channelIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clusterTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(instanceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(networkSettings());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterResponse)) {
            return false;
        }
        DescribeClusterResponse other = (DescribeClusterResponse) obj;
        return Objects.equals(arn(), other.arn()) && hasChannelIds() == other.hasChannelIds()
                && Objects.equals(channelIds(), other.channelIds())
                && Objects.equals(clusterTypeAsString(), other.clusterTypeAsString()) && Objects.equals(id(), other.id())
                && Objects.equals(instanceRoleArn(), other.instanceRoleArn()) && Objects.equals(name(), other.name())
                && Objects.equals(networkSettings(), other.networkSettings())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeClusterResponse").add("Arn", arn())
                .add("ChannelIds", hasChannelIds() ? channelIds() : null).add("ClusterType", clusterTypeAsString())
                .add("Id", id()).add("InstanceRoleArn", instanceRoleArn()).add("Name", name())
                .add("NetworkSettings", networkSettings()).add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ChannelIds":
            return Optional.ofNullable(clazz.cast(channelIds()));
        case "ClusterType":
            return Optional.ofNullable(clazz.cast(clusterTypeAsString()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "InstanceRoleArn":
            return Optional.ofNullable(clazz.cast(instanceRoleArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "NetworkSettings":
            return Optional.ofNullable(clazz.cast(networkSettings()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClusterResponse, T> g) {
        return obj -> g.apply((DescribeClusterResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeClusterResponse> {
        /**
         * The ARN of this Cluster. It is automatically assigned when the Cluster is created.
         * 
         * @param arn
         *        The ARN of this Cluster. It is automatically assigned when the Cluster is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * Sets the value of the ChannelIds property for this object.
         *
         * @param channelIds
         *        The new value for the ChannelIds property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelIds(Collection<String> channelIds);

        /**
         * Sets the value of the ChannelIds property for this object.
         *
         * @param channelIds
         *        The new value for the ChannelIds property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelIds(String... channelIds);

        /**
         * The hardware type for the Cluster
         * 
         * @param clusterType
         *        The hardware type for the Cluster
         * @see ClusterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterType
         */
        Builder clusterType(String clusterType);

        /**
         * The hardware type for the Cluster
         * 
         * @param clusterType
         *        The hardware type for the Cluster
         * @see ClusterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterType
         */
        Builder clusterType(ClusterType clusterType);

        /**
         * The ID of the Cluster. Unique in the AWS account. The ID is the resource-id portion of the ARN.
         * 
         * @param id
         *        The ID of the Cluster. Unique in the AWS account. The ID is the resource-id portion of the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * The ARN of the IAM role for the Node in this Cluster. Any Nodes that are associated with this Cluster assume
         * this role. The role gives permissions to the operations that you expect these Node to perform.
         * 
         * @param instanceRoleArn
         *        The ARN of the IAM role for the Node in this Cluster. Any Nodes that are associated with this Cluster
         *        assume this role. The role gives permissions to the operations that you expect these Node to perform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceRoleArn(String instanceRoleArn);

        /**
         * The name that you specified for the Cluster.
         * 
         * @param name
         *        The name that you specified for the Cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Network settings that connect the Nodes in the Cluster to one or more of the Networks that the Cluster is
         * associated with.
         * 
         * @param networkSettings
         *        Network settings that connect the Nodes in the Cluster to one or more of the Networks that the Cluster
         *        is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkSettings(ClusterNetworkSettings networkSettings);

        /**
         * Network settings that connect the Nodes in the Cluster to one or more of the Networks that the Cluster is
         * associated with. This is a convenience method that creates an instance of the
         * {@link ClusterNetworkSettings.Builder} avoiding the need to create one manually via
         * {@link ClusterNetworkSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClusterNetworkSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #networkSettings(ClusterNetworkSettings)}.
         * 
         * @param networkSettings
         *        a consumer that will call methods on {@link ClusterNetworkSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkSettings(ClusterNetworkSettings)
         */
        default Builder networkSettings(Consumer<ClusterNetworkSettings.Builder> networkSettings) {
            return networkSettings(ClusterNetworkSettings.builder().applyMutation(networkSettings).build());
        }

        /**
         * The current state of the Cluster.
         * 
         * @param state
         *        The current state of the Cluster.
         * @see ClusterState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterState
         */
        Builder state(String state);

        /**
         * The current state of the Cluster.
         * 
         * @param state
         *        The current state of the Cluster.
         * @see ClusterState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterState
         */
        Builder state(ClusterState state);
    }

    static final class BuilderImpl extends MediaLiveResponse.BuilderImpl implements Builder {
        private String arn;

        private List<String> channelIds = DefaultSdkAutoConstructList.getInstance();

        private String clusterType;

        private String id;

        private String instanceRoleArn;

        private String name;

        private ClusterNetworkSettings networkSettings;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterResponse model) {
            super(model);
            arn(model.arn);
            channelIds(model.channelIds);
            clusterType(model.clusterType);
            id(model.id);
            instanceRoleArn(model.instanceRoleArn);
            name(model.name);
            networkSettings(model.networkSettings);
            state(model.state);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Collection<String> getChannelIds() {
            if (channelIds instanceof SdkAutoConstructList) {
                return null;
            }
            return channelIds;
        }

        public final void setChannelIds(Collection<String> channelIds) {
            this.channelIds = ___listOf__stringCopier.copy(channelIds);
        }

        @Override
        public final Builder channelIds(Collection<String> channelIds) {
            this.channelIds = ___listOf__stringCopier.copy(channelIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelIds(String... channelIds) {
            channelIds(Arrays.asList(channelIds));
            return this;
        }

        public final String getClusterType() {
            return clusterType;
        }

        public final void setClusterType(String clusterType) {
            this.clusterType = clusterType;
        }

        @Override
        public final Builder clusterType(String clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        @Override
        public final Builder clusterType(ClusterType clusterType) {
            this.clusterType(clusterType == null ? null : clusterType.toString());
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getInstanceRoleArn() {
            return instanceRoleArn;
        }

        public final void setInstanceRoleArn(String instanceRoleArn) {
            this.instanceRoleArn = instanceRoleArn;
        }

        @Override
        public final Builder instanceRoleArn(String instanceRoleArn) {
            this.instanceRoleArn = instanceRoleArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ClusterNetworkSettings.Builder getNetworkSettings() {
            return networkSettings != null ? networkSettings.toBuilder() : null;
        }

        public final void setNetworkSettings(ClusterNetworkSettings.BuilderImpl networkSettings) {
            this.networkSettings = networkSettings != null ? networkSettings.build() : null;
        }

        @Override
        public final Builder networkSettings(ClusterNetworkSettings networkSettings) {
            this.networkSettings = networkSettings;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ClusterState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public DescribeClusterResponse build() {
            return new DescribeClusterResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
