/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for DescribeNodeResponse
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeNodeResponse extends MediaLiveResponse implements
        ToCopyableBuilder<DescribeNodeResponse.Builder, DescribeNodeResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DescribeNodeResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<List<String>> CHANNEL_PLACEMENT_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ChannelPlacementGroups")
            .getter(getter(DescribeNodeResponse::channelPlacementGroups))
            .setter(setter(Builder::channelPlacementGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelPlacementGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterId").getter(getter(DescribeNodeResponse::clusterId)).setter(setter(Builder::clusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterId").build()).build();

    private static final SdkField<String> CONNECTION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionState").getter(getter(DescribeNodeResponse::connectionStateAsString))
            .setter(setter(Builder::connectionState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionState").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(DescribeNodeResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceArn").getter(getter(DescribeNodeResponse::instanceArn)).setter(setter(Builder::instanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeNodeResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<NodeInterfaceMapping>> NODE_INTERFACE_MAPPINGS_FIELD = SdkField
            .<List<NodeInterfaceMapping>> builder(MarshallingType.LIST)
            .memberName("NodeInterfaceMappings")
            .getter(getter(DescribeNodeResponse::nodeInterfaceMappings))
            .setter(setter(Builder::nodeInterfaceMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeInterfaceMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NodeInterfaceMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(NodeInterfaceMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(DescribeNodeResponse::roleAsString)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("role").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(DescribeNodeResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CHANNEL_PLACEMENT_GROUPS_FIELD, CLUSTER_ID_FIELD, CONNECTION_STATE_FIELD, ID_FIELD, INSTANCE_ARN_FIELD, NAME_FIELD,
            NODE_INTERFACE_MAPPINGS_FIELD, ROLE_FIELD, STATE_FIELD));

    private final String arn;

    private final List<String> channelPlacementGroups;

    private final String clusterId;

    private final String connectionState;

    private final String id;

    private final String instanceArn;

    private final String name;

    private final List<NodeInterfaceMapping> nodeInterfaceMappings;

    private final String role;

    private final String state;

    private DescribeNodeResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.channelPlacementGroups = builder.channelPlacementGroups;
        this.clusterId = builder.clusterId;
        this.connectionState = builder.connectionState;
        this.id = builder.id;
        this.instanceArn = builder.instanceArn;
        this.name = builder.name;
        this.nodeInterfaceMappings = builder.nodeInterfaceMappings;
        this.role = builder.role;
        this.state = builder.state;
    }

    /**
     * The ARN of the Node. It is automatically assigned when the Node is created.
     * 
     * @return The ARN of the Node. It is automatically assigned when the Node is created.
     */
    public final String arn() {
        return arn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChannelPlacementGroups property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasChannelPlacementGroups() {
        return channelPlacementGroups != null && !(channelPlacementGroups instanceof SdkAutoConstructList);
    }

    /**
     * An array of IDs. Each ID is one ChannelPlacementGroup that is associated with this Node. Empty if the Node is not
     * yet associated with any groups.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChannelPlacementGroups} method.
     * </p>
     * 
     * @return An array of IDs. Each ID is one ChannelPlacementGroup that is associated with this Node. Empty if the
     *         Node is not yet associated with any groups.
     */
    public final List<String> channelPlacementGroups() {
        return channelPlacementGroups;
    }

    /**
     * The ID of the Cluster that the Node belongs to.
     * 
     * @return The ID of the Cluster that the Node belongs to.
     */
    public final String clusterId() {
        return clusterId;
    }

    /**
     * The current connection state of the Node.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionState}
     * will return {@link NodeConnectionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #connectionStateAsString}.
     * </p>
     * 
     * @return The current connection state of the Node.
     * @see NodeConnectionState
     */
    public final NodeConnectionState connectionState() {
        return NodeConnectionState.fromValue(connectionState);
    }

    /**
     * The current connection state of the Node.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionState}
     * will return {@link NodeConnectionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #connectionStateAsString}.
     * </p>
     * 
     * @return The current connection state of the Node.
     * @see NodeConnectionState
     */
    public final String connectionStateAsString() {
        return connectionState;
    }

    /**
     * The unique ID of the Node. Unique in the Cluster. The ID is the resource-id portion of the ARN.
     * 
     * @return The unique ID of the Node. Unique in the Cluster. The ID is the resource-id portion of the ARN.
     */
    public final String id() {
        return id;
    }

    /**
     * The ARN of the EC2 instance hosting the Node.
     * 
     * @return The ARN of the EC2 instance hosting the Node.
     */
    public final String instanceArn() {
        return instanceArn;
    }

    /**
     * The name that you specified for the Node.
     * 
     * @return The name that you specified for the Node.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the NodeInterfaceMappings property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasNodeInterfaceMappings() {
        return nodeInterfaceMappings != null && !(nodeInterfaceMappings instanceof SdkAutoConstructList);
    }

    /**
     * Documentation update needed
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNodeInterfaceMappings} method.
     * </p>
     * 
     * @return Documentation update needed
     */
    public final List<NodeInterfaceMapping> nodeInterfaceMappings() {
        return nodeInterfaceMappings;
    }

    /**
     * The initial role current role of the Node in the Cluster. ACTIVE means the Node is available for encoding. BACKUP
     * means the Node is a redundant Node and might get used if an ACTIVE Node fails.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link NodeRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The initial role current role of the Node in the Cluster. ACTIVE means the Node is available for
     *         encoding. BACKUP means the Node is a redundant Node and might get used if an ACTIVE Node fails.
     * @see NodeRole
     */
    public final NodeRole role() {
        return NodeRole.fromValue(role);
    }

    /**
     * The initial role current role of the Node in the Cluster. ACTIVE means the Node is available for encoding. BACKUP
     * means the Node is a redundant Node and might get used if an ACTIVE Node fails.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link NodeRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The initial role current role of the Node in the Cluster. ACTIVE means the Node is available for
     *         encoding. BACKUP means the Node is a redundant Node and might get used if an ACTIVE Node fails.
     * @see NodeRole
     */
    public final String roleAsString() {
        return role;
    }

    /**
     * The current state of the Node.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link NodeState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the Node.
     * @see NodeState
     */
    public final NodeState state() {
        return NodeState.fromValue(state);
    }

    /**
     * The current state of the Node.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link NodeState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the Node.
     * @see NodeState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(hasChannelPlacementGroups() ? channelPlacementGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(connectionStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasNodeInterfaceMappings() ? nodeInterfaceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(roleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNodeResponse)) {
            return false;
        }
        DescribeNodeResponse other = (DescribeNodeResponse) obj;
        return Objects.equals(arn(), other.arn()) && hasChannelPlacementGroups() == other.hasChannelPlacementGroups()
                && Objects.equals(channelPlacementGroups(), other.channelPlacementGroups())
                && Objects.equals(clusterId(), other.clusterId())
                && Objects.equals(connectionStateAsString(), other.connectionStateAsString()) && Objects.equals(id(), other.id())
                && Objects.equals(instanceArn(), other.instanceArn()) && Objects.equals(name(), other.name())
                && hasNodeInterfaceMappings() == other.hasNodeInterfaceMappings()
                && Objects.equals(nodeInterfaceMappings(), other.nodeInterfaceMappings())
                && Objects.equals(roleAsString(), other.roleAsString()) && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeNodeResponse").add("Arn", arn())
                .add("ChannelPlacementGroups", hasChannelPlacementGroups() ? channelPlacementGroups() : null)
                .add("ClusterId", clusterId()).add("ConnectionState", connectionStateAsString()).add("Id", id())
                .add("InstanceArn", instanceArn()).add("Name", name())
                .add("NodeInterfaceMappings", hasNodeInterfaceMappings() ? nodeInterfaceMappings() : null)
                .add("Role", roleAsString()).add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ChannelPlacementGroups":
            return Optional.ofNullable(clazz.cast(channelPlacementGroups()));
        case "ClusterId":
            return Optional.ofNullable(clazz.cast(clusterId()));
        case "ConnectionState":
            return Optional.ofNullable(clazz.cast(connectionStateAsString()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "InstanceArn":
            return Optional.ofNullable(clazz.cast(instanceArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "NodeInterfaceMappings":
            return Optional.ofNullable(clazz.cast(nodeInterfaceMappings()));
        case "Role":
            return Optional.ofNullable(clazz.cast(roleAsString()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNodeResponse, T> g) {
        return obj -> g.apply((DescribeNodeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeNodeResponse> {
        /**
         * The ARN of the Node. It is automatically assigned when the Node is created.
         * 
         * @param arn
         *        The ARN of the Node. It is automatically assigned when the Node is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * An array of IDs. Each ID is one ChannelPlacementGroup that is associated with this Node. Empty if the Node is
         * not yet associated with any groups.
         * 
         * @param channelPlacementGroups
         *        An array of IDs. Each ID is one ChannelPlacementGroup that is associated with this Node. Empty if the
         *        Node is not yet associated with any groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelPlacementGroups(Collection<String> channelPlacementGroups);

        /**
         * An array of IDs. Each ID is one ChannelPlacementGroup that is associated with this Node. Empty if the Node is
         * not yet associated with any groups.
         * 
         * @param channelPlacementGroups
         *        An array of IDs. Each ID is one ChannelPlacementGroup that is associated with this Node. Empty if the
         *        Node is not yet associated with any groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelPlacementGroups(String... channelPlacementGroups);

        /**
         * The ID of the Cluster that the Node belongs to.
         * 
         * @param clusterId
         *        The ID of the Cluster that the Node belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        /**
         * The current connection state of the Node.
         * 
         * @param connectionState
         *        The current connection state of the Node.
         * @see NodeConnectionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeConnectionState
         */
        Builder connectionState(String connectionState);

        /**
         * The current connection state of the Node.
         * 
         * @param connectionState
         *        The current connection state of the Node.
         * @see NodeConnectionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeConnectionState
         */
        Builder connectionState(NodeConnectionState connectionState);

        /**
         * The unique ID of the Node. Unique in the Cluster. The ID is the resource-id portion of the ARN.
         * 
         * @param id
         *        The unique ID of the Node. Unique in the Cluster. The ID is the resource-id portion of the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * The ARN of the EC2 instance hosting the Node.
         * 
         * @param instanceArn
         *        The ARN of the EC2 instance hosting the Node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceArn(String instanceArn);

        /**
         * The name that you specified for the Node.
         * 
         * @param name
         *        The name that you specified for the Node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Documentation update needed
         * 
         * @param nodeInterfaceMappings
         *        Documentation update needed
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeInterfaceMappings(Collection<NodeInterfaceMapping> nodeInterfaceMappings);

        /**
         * Documentation update needed
         * 
         * @param nodeInterfaceMappings
         *        Documentation update needed
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeInterfaceMappings(NodeInterfaceMapping... nodeInterfaceMappings);

        /**
         * Documentation update needed This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.medialive.model.NodeInterfaceMapping.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.medialive.model.NodeInterfaceMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.NodeInterfaceMapping.Builder#build()} is called
         * immediately and its result is passed to {@link #nodeInterfaceMappings(List<NodeInterfaceMapping>)}.
         * 
         * @param nodeInterfaceMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.NodeInterfaceMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeInterfaceMappings(java.util.Collection<NodeInterfaceMapping>)
         */
        Builder nodeInterfaceMappings(Consumer<NodeInterfaceMapping.Builder>... nodeInterfaceMappings);

        /**
         * The initial role current role of the Node in the Cluster. ACTIVE means the Node is available for encoding.
         * BACKUP means the Node is a redundant Node and might get used if an ACTIVE Node fails.
         * 
         * @param role
         *        The initial role current role of the Node in the Cluster. ACTIVE means the Node is available for
         *        encoding. BACKUP means the Node is a redundant Node and might get used if an ACTIVE Node fails.
         * @see NodeRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeRole
         */
        Builder role(String role);

        /**
         * The initial role current role of the Node in the Cluster. ACTIVE means the Node is available for encoding.
         * BACKUP means the Node is a redundant Node and might get used if an ACTIVE Node fails.
         * 
         * @param role
         *        The initial role current role of the Node in the Cluster. ACTIVE means the Node is available for
         *        encoding. BACKUP means the Node is a redundant Node and might get used if an ACTIVE Node fails.
         * @see NodeRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeRole
         */
        Builder role(NodeRole role);

        /**
         * The current state of the Node.
         * 
         * @param state
         *        The current state of the Node.
         * @see NodeState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeState
         */
        Builder state(String state);

        /**
         * The current state of the Node.
         * 
         * @param state
         *        The current state of the Node.
         * @see NodeState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeState
         */
        Builder state(NodeState state);
    }

    static final class BuilderImpl extends MediaLiveResponse.BuilderImpl implements Builder {
        private String arn;

        private List<String> channelPlacementGroups = DefaultSdkAutoConstructList.getInstance();

        private String clusterId;

        private String connectionState;

        private String id;

        private String instanceArn;

        private String name;

        private List<NodeInterfaceMapping> nodeInterfaceMappings = DefaultSdkAutoConstructList.getInstance();

        private String role;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNodeResponse model) {
            super(model);
            arn(model.arn);
            channelPlacementGroups(model.channelPlacementGroups);
            clusterId(model.clusterId);
            connectionState(model.connectionState);
            id(model.id);
            instanceArn(model.instanceArn);
            name(model.name);
            nodeInterfaceMappings(model.nodeInterfaceMappings);
            role(model.role);
            state(model.state);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Collection<String> getChannelPlacementGroups() {
            if (channelPlacementGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return channelPlacementGroups;
        }

        public final void setChannelPlacementGroups(Collection<String> channelPlacementGroups) {
            this.channelPlacementGroups = ___listOf__stringCopier.copy(channelPlacementGroups);
        }

        @Override
        public final Builder channelPlacementGroups(Collection<String> channelPlacementGroups) {
            this.channelPlacementGroups = ___listOf__stringCopier.copy(channelPlacementGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelPlacementGroups(String... channelPlacementGroups) {
            channelPlacementGroups(Arrays.asList(channelPlacementGroups));
            return this;
        }

        public final String getClusterId() {
            return clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final String getConnectionState() {
            return connectionState;
        }

        public final void setConnectionState(String connectionState) {
            this.connectionState = connectionState;
        }

        @Override
        public final Builder connectionState(String connectionState) {
            this.connectionState = connectionState;
            return this;
        }

        @Override
        public final Builder connectionState(NodeConnectionState connectionState) {
            this.connectionState(connectionState == null ? null : connectionState.toString());
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getInstanceArn() {
            return instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<NodeInterfaceMapping.Builder> getNodeInterfaceMappings() {
            List<NodeInterfaceMapping.Builder> result = ___listOfNodeInterfaceMappingCopier
                    .copyToBuilder(this.nodeInterfaceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNodeInterfaceMappings(Collection<NodeInterfaceMapping.BuilderImpl> nodeInterfaceMappings) {
            this.nodeInterfaceMappings = ___listOfNodeInterfaceMappingCopier.copyFromBuilder(nodeInterfaceMappings);
        }

        @Override
        public final Builder nodeInterfaceMappings(Collection<NodeInterfaceMapping> nodeInterfaceMappings) {
            this.nodeInterfaceMappings = ___listOfNodeInterfaceMappingCopier.copy(nodeInterfaceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeInterfaceMappings(NodeInterfaceMapping... nodeInterfaceMappings) {
            nodeInterfaceMappings(Arrays.asList(nodeInterfaceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeInterfaceMappings(Consumer<NodeInterfaceMapping.Builder>... nodeInterfaceMappings) {
            nodeInterfaceMappings(Stream.of(nodeInterfaceMappings)
                    .map(c -> NodeInterfaceMapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(NodeRole role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(NodeState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public DescribeNodeResponse build() {
            return new DescribeNodeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
