/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Endpoint settings for a PUSH type input.
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputDestinationRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<InputDestinationRequest.Builder, InputDestinationRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamName").getter(getter(InputDestinationRequest::streamName)).setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamName").build()).build();

    private static final SdkField<String> NETWORK_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Network")
            .getter(getter(InputDestinationRequest::network)).setter(setter(Builder::network))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("network").build()).build();

    private static final SdkField<List<InputRequestDestinationRoute>> NETWORK_ROUTES_FIELD = SdkField
            .<List<InputRequestDestinationRoute>> builder(MarshallingType.LIST)
            .memberName("NetworkRoutes")
            .getter(getter(InputDestinationRequest::networkRoutes))
            .setter(setter(Builder::networkRoutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkRoutes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputRequestDestinationRoute> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputRequestDestinationRoute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATIC_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StaticIpAddress").getter(getter(InputDestinationRequest::staticIpAddress))
            .setter(setter(Builder::staticIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("staticIpAddress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD,
            NETWORK_FIELD, NETWORK_ROUTES_FIELD, STATIC_IP_ADDRESS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String streamName;

    private final String network;

    private final List<InputRequestDestinationRoute> networkRoutes;

    private final String staticIpAddress;

    private InputDestinationRequest(BuilderImpl builder) {
        this.streamName = builder.streamName;
        this.network = builder.network;
        this.networkRoutes = builder.networkRoutes;
        this.staticIpAddress = builder.staticIpAddress;
    }

    /**
     * A unique name for the location the RTMP stream is being pushed to.
     * 
     * @return A unique name for the location the RTMP stream is being pushed to.
     */
    public final String streamName() {
        return streamName;
    }

    /**
     * If the push input has an input location of ON-PREM, ID the ID of the attached network.
     * 
     * @return If the push input has an input location of ON-PREM, ID the ID of the attached network.
     */
    public final String network() {
        return network;
    }

    /**
     * For responses, this returns true if the service returned a value for the NetworkRoutes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNetworkRoutes() {
        return networkRoutes != null && !(networkRoutes instanceof SdkAutoConstructList);
    }

    /**
     * If the push input has an input location of ON-PREM it's a requirement to specify what the route of the input is
     * going to be on the customer local network.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworkRoutes} method.
     * </p>
     * 
     * @return If the push input has an input location of ON-PREM it's a requirement to specify what the route of the
     *         input is going to be on the customer local network.
     */
    public final List<InputRequestDestinationRoute> networkRoutes() {
        return networkRoutes;
    }

    /**
     * If the push input has an input location of ON-PREM it's optional to specify what the ip address of the input is
     * going to be on the customer local network.
     * 
     * @return If the push input has an input location of ON-PREM it's optional to specify what the ip address of the
     *         input is going to be on the customer local network.
     */
    public final String staticIpAddress() {
        return staticIpAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(network());
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkRoutes() ? networkRoutes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(staticIpAddress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDestinationRequest)) {
            return false;
        }
        InputDestinationRequest other = (InputDestinationRequest) obj;
        return Objects.equals(streamName(), other.streamName()) && Objects.equals(network(), other.network())
                && hasNetworkRoutes() == other.hasNetworkRoutes() && Objects.equals(networkRoutes(), other.networkRoutes())
                && Objects.equals(staticIpAddress(), other.staticIpAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputDestinationRequest").add("StreamName", streamName()).add("Network", network())
                .add("NetworkRoutes", hasNetworkRoutes() ? networkRoutes() : null).add("StaticIpAddress", staticIpAddress())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        case "Network":
            return Optional.ofNullable(clazz.cast(network()));
        case "NetworkRoutes":
            return Optional.ofNullable(clazz.cast(networkRoutes()));
        case "StaticIpAddress":
            return Optional.ofNullable(clazz.cast(staticIpAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputDestinationRequest, T> g) {
        return obj -> g.apply((InputDestinationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputDestinationRequest> {
        /**
         * A unique name for the location the RTMP stream is being pushed to.
         * 
         * @param streamName
         *        A unique name for the location the RTMP stream is being pushed to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * If the push input has an input location of ON-PREM, ID the ID of the attached network.
         * 
         * @param network
         *        If the push input has an input location of ON-PREM, ID the ID of the attached network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder network(String network);

        /**
         * If the push input has an input location of ON-PREM it's a requirement to specify what the route of the input
         * is going to be on the customer local network.
         * 
         * @param networkRoutes
         *        If the push input has an input location of ON-PREM it's a requirement to specify what the route of the
         *        input is going to be on the customer local network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkRoutes(Collection<InputRequestDestinationRoute> networkRoutes);

        /**
         * If the push input has an input location of ON-PREM it's a requirement to specify what the route of the input
         * is going to be on the customer local network.
         * 
         * @param networkRoutes
         *        If the push input has an input location of ON-PREM it's a requirement to specify what the route of the
         *        input is going to be on the customer local network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkRoutes(InputRequestDestinationRoute... networkRoutes);

        /**
         * If the push input has an input location of ON-PREM it's a requirement to specify what the route of the input
         * is going to be on the customer local network. This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.medialive.model.InputRequestDestinationRoute.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.medialive.model.InputRequestDestinationRoute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.InputRequestDestinationRoute.Builder#build()} is
         * called immediately and its result is passed to {@link #networkRoutes(List<InputRequestDestinationRoute>)}.
         * 
         * @param networkRoutes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.InputRequestDestinationRoute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkRoutes(java.util.Collection<InputRequestDestinationRoute>)
         */
        Builder networkRoutes(Consumer<InputRequestDestinationRoute.Builder>... networkRoutes);

        /**
         * If the push input has an input location of ON-PREM it's optional to specify what the ip address of the input
         * is going to be on the customer local network.
         * 
         * @param staticIpAddress
         *        If the push input has an input location of ON-PREM it's optional to specify what the ip address of the
         *        input is going to be on the customer local network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticIpAddress(String staticIpAddress);
    }

    static final class BuilderImpl implements Builder {
        private String streamName;

        private String network;

        private List<InputRequestDestinationRoute> networkRoutes = DefaultSdkAutoConstructList.getInstance();

        private String staticIpAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(InputDestinationRequest model) {
            streamName(model.streamName);
            network(model.network);
            networkRoutes(model.networkRoutes);
            staticIpAddress(model.staticIpAddress);
        }

        public final String getStreamName() {
            return streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final String getNetwork() {
            return network;
        }

        public final void setNetwork(String network) {
            this.network = network;
        }

        @Override
        public final Builder network(String network) {
            this.network = network;
            return this;
        }

        public final List<InputRequestDestinationRoute.Builder> getNetworkRoutes() {
            List<InputRequestDestinationRoute.Builder> result = ___listOfInputRequestDestinationRouteCopier
                    .copyToBuilder(this.networkRoutes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkRoutes(Collection<InputRequestDestinationRoute.BuilderImpl> networkRoutes) {
            this.networkRoutes = ___listOfInputRequestDestinationRouteCopier.copyFromBuilder(networkRoutes);
        }

        @Override
        public final Builder networkRoutes(Collection<InputRequestDestinationRoute> networkRoutes) {
            this.networkRoutes = ___listOfInputRequestDestinationRouteCopier.copy(networkRoutes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkRoutes(InputRequestDestinationRoute... networkRoutes) {
            networkRoutes(Arrays.asList(networkRoutes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkRoutes(Consumer<InputRequestDestinationRoute.Builder>... networkRoutes) {
            networkRoutes(Stream.of(networkRoutes).map(c -> InputRequestDestinationRoute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getStaticIpAddress() {
            return staticIpAddress;
        }

        public final void setStaticIpAddress(String staticIpAddress) {
            this.staticIpAddress = staticIpAddress;
        }

        @Override
        public final Builder staticIpAddress(String staticIpAddress) {
            this.staticIpAddress = staticIpAddress;
            return this;
        }

        @Override
        public InputDestinationRequest build() {
            return new InputDestinationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
