/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for InterfaceMappingUpdateRequest
 */
@Generated("software.amazon.awssdk:codegen")
public final class InterfaceMappingUpdateRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<InterfaceMappingUpdateRequest.Builder, InterfaceMappingUpdateRequest> {
    private static final SdkField<String> LOGICAL_INTERFACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogicalInterfaceName").getter(getter(InterfaceMappingUpdateRequest::logicalInterfaceName))
            .setter(setter(Builder::logicalInterfaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logicalInterfaceName").build())
            .build();

    private static final SdkField<String> NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkId").getter(getter(InterfaceMappingUpdateRequest::networkId)).setter(setter(Builder::networkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGICAL_INTERFACE_NAME_FIELD,
            NETWORK_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String logicalInterfaceName;

    private final String networkId;

    private InterfaceMappingUpdateRequest(BuilderImpl builder) {
        this.logicalInterfaceName = builder.logicalInterfaceName;
        this.networkId = builder.networkId;
    }

    /**
     * The logical name for one interface (on every Node) that handles a specific type of traffic. We recommend that the
     * name hints at the physical interface it applies to. For example, it could refer to the traffic that the physical
     * interface handles. For example, my-Inputs-Interface.
     * 
     * @return The logical name for one interface (on every Node) that handles a specific type of traffic. We recommend
     *         that the name hints at the physical interface it applies to. For example, it could refer to the traffic
     *         that the physical interface handles. For example, my-Inputs-Interface.
     */
    public final String logicalInterfaceName() {
        return logicalInterfaceName;
    }

    /**
     * The ID of the network that you want to connect to the specified logicalInterfaceName. You can use the
     * ListNetworks operation to discover all the IDs.
     * 
     * @return The ID of the network that you want to connect to the specified logicalInterfaceName. You can use the
     *         ListNetworks operation to discover all the IDs.
     */
    public final String networkId() {
        return networkId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logicalInterfaceName());
        hashCode = 31 * hashCode + Objects.hashCode(networkId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InterfaceMappingUpdateRequest)) {
            return false;
        }
        InterfaceMappingUpdateRequest other = (InterfaceMappingUpdateRequest) obj;
        return Objects.equals(logicalInterfaceName(), other.logicalInterfaceName())
                && Objects.equals(networkId(), other.networkId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InterfaceMappingUpdateRequest").add("LogicalInterfaceName", logicalInterfaceName())
                .add("NetworkId", networkId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LogicalInterfaceName":
            return Optional.ofNullable(clazz.cast(logicalInterfaceName()));
        case "NetworkId":
            return Optional.ofNullable(clazz.cast(networkId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InterfaceMappingUpdateRequest, T> g) {
        return obj -> g.apply((InterfaceMappingUpdateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InterfaceMappingUpdateRequest> {
        /**
         * The logical name for one interface (on every Node) that handles a specific type of traffic. We recommend that
         * the name hints at the physical interface it applies to. For example, it could refer to the traffic that the
         * physical interface handles. For example, my-Inputs-Interface.
         * 
         * @param logicalInterfaceName
         *        The logical name for one interface (on every Node) that handles a specific type of traffic. We
         *        recommend that the name hints at the physical interface it applies to. For example, it could refer to
         *        the traffic that the physical interface handles. For example, my-Inputs-Interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicalInterfaceName(String logicalInterfaceName);

        /**
         * The ID of the network that you want to connect to the specified logicalInterfaceName. You can use the
         * ListNetworks operation to discover all the IDs.
         * 
         * @param networkId
         *        The ID of the network that you want to connect to the specified logicalInterfaceName. You can use the
         *        ListNetworks operation to discover all the IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkId(String networkId);
    }

    static final class BuilderImpl implements Builder {
        private String logicalInterfaceName;

        private String networkId;

        private BuilderImpl() {
        }

        private BuilderImpl(InterfaceMappingUpdateRequest model) {
            logicalInterfaceName(model.logicalInterfaceName);
            networkId(model.networkId);
        }

        public final String getLogicalInterfaceName() {
            return logicalInterfaceName;
        }

        public final void setLogicalInterfaceName(String logicalInterfaceName) {
            this.logicalInterfaceName = logicalInterfaceName;
        }

        @Override
        public final Builder logicalInterfaceName(String logicalInterfaceName) {
            this.logicalInterfaceName = logicalInterfaceName;
            return this;
        }

        public final String getNetworkId() {
            return networkId;
        }

        public final void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        @Override
        public final Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        @Override
        public InterfaceMappingUpdateRequest build() {
            return new InterfaceMappingUpdateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
