/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for ListEventBridgeRuleTemplateGroupsResponse
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEventBridgeRuleTemplateGroupsResponse extends MediaLiveResponse implements
        ToCopyableBuilder<ListEventBridgeRuleTemplateGroupsResponse.Builder, ListEventBridgeRuleTemplateGroupsResponse> {
    private static final SdkField<List<EventBridgeRuleTemplateGroupSummary>> EVENT_BRIDGE_RULE_TEMPLATE_GROUPS_FIELD = SdkField
            .<List<EventBridgeRuleTemplateGroupSummary>> builder(MarshallingType.LIST)
            .memberName("EventBridgeRuleTemplateGroups")
            .getter(getter(ListEventBridgeRuleTemplateGroupsResponse::eventBridgeRuleTemplateGroups))
            .setter(setter(Builder::eventBridgeRuleTemplateGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventBridgeRuleTemplateGroups")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventBridgeRuleTemplateGroupSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventBridgeRuleTemplateGroupSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListEventBridgeRuleTemplateGroupsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EVENT_BRIDGE_RULE_TEMPLATE_GROUPS_FIELD, NEXT_TOKEN_FIELD));

    private final List<EventBridgeRuleTemplateGroupSummary> eventBridgeRuleTemplateGroups;

    private final String nextToken;

    private ListEventBridgeRuleTemplateGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.eventBridgeRuleTemplateGroups = builder.eventBridgeRuleTemplateGroups;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventBridgeRuleTemplateGroups property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEventBridgeRuleTemplateGroups() {
        return eventBridgeRuleTemplateGroups != null && !(eventBridgeRuleTemplateGroups instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the EventBridgeRuleTemplateGroups property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventBridgeRuleTemplateGroups} method.
     * </p>
     * 
     * @return The value of the EventBridgeRuleTemplateGroups property for this object.
     */
    public final List<EventBridgeRuleTemplateGroupSummary> eventBridgeRuleTemplateGroups() {
        return eventBridgeRuleTemplateGroups;
    }

    /**
     * A token used to retrieve the next set of results in paginated list responses.
     * 
     * @return A token used to retrieve the next set of results in paginated list responses.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEventBridgeRuleTemplateGroups() ? eventBridgeRuleTemplateGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEventBridgeRuleTemplateGroupsResponse)) {
            return false;
        }
        ListEventBridgeRuleTemplateGroupsResponse other = (ListEventBridgeRuleTemplateGroupsResponse) obj;
        return hasEventBridgeRuleTemplateGroups() == other.hasEventBridgeRuleTemplateGroups()
                && Objects.equals(eventBridgeRuleTemplateGroups(), other.eventBridgeRuleTemplateGroups())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListEventBridgeRuleTemplateGroupsResponse")
                .add("EventBridgeRuleTemplateGroups", hasEventBridgeRuleTemplateGroups() ? eventBridgeRuleTemplateGroups() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventBridgeRuleTemplateGroups":
            return Optional.ofNullable(clazz.cast(eventBridgeRuleTemplateGroups()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEventBridgeRuleTemplateGroupsResponse, T> g) {
        return obj -> g.apply((ListEventBridgeRuleTemplateGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListEventBridgeRuleTemplateGroupsResponse> {
        /**
         * Sets the value of the EventBridgeRuleTemplateGroups property for this object.
         *
         * @param eventBridgeRuleTemplateGroups
         *        The new value for the EventBridgeRuleTemplateGroups property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventBridgeRuleTemplateGroups(Collection<EventBridgeRuleTemplateGroupSummary> eventBridgeRuleTemplateGroups);

        /**
         * Sets the value of the EventBridgeRuleTemplateGroups property for this object.
         *
         * @param eventBridgeRuleTemplateGroups
         *        The new value for the EventBridgeRuleTemplateGroups property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventBridgeRuleTemplateGroups(EventBridgeRuleTemplateGroupSummary... eventBridgeRuleTemplateGroups);

        /**
         * Sets the value of the EventBridgeRuleTemplateGroups property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.medialive.model.EventBridgeRuleTemplateGroupSummary.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.medialive.model.EventBridgeRuleTemplateGroupSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.EventBridgeRuleTemplateGroupSummary.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #eventBridgeRuleTemplateGroups(List<EventBridgeRuleTemplateGroupSummary>)}.
         * 
         * @param eventBridgeRuleTemplateGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.EventBridgeRuleTemplateGroupSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventBridgeRuleTemplateGroups(java.util.Collection<EventBridgeRuleTemplateGroupSummary>)
         */
        Builder eventBridgeRuleTemplateGroups(
                Consumer<EventBridgeRuleTemplateGroupSummary.Builder>... eventBridgeRuleTemplateGroups);

        /**
         * A token used to retrieve the next set of results in paginated list responses.
         * 
         * @param nextToken
         *        A token used to retrieve the next set of results in paginated list responses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MediaLiveResponse.BuilderImpl implements Builder {
        private List<EventBridgeRuleTemplateGroupSummary> eventBridgeRuleTemplateGroups = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEventBridgeRuleTemplateGroupsResponse model) {
            super(model);
            eventBridgeRuleTemplateGroups(model.eventBridgeRuleTemplateGroups);
            nextToken(model.nextToken);
        }

        public final List<EventBridgeRuleTemplateGroupSummary.Builder> getEventBridgeRuleTemplateGroups() {
            List<EventBridgeRuleTemplateGroupSummary.Builder> result = ___listOfEventBridgeRuleTemplateGroupSummaryCopier
                    .copyToBuilder(this.eventBridgeRuleTemplateGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventBridgeRuleTemplateGroups(
                Collection<EventBridgeRuleTemplateGroupSummary.BuilderImpl> eventBridgeRuleTemplateGroups) {
            this.eventBridgeRuleTemplateGroups = ___listOfEventBridgeRuleTemplateGroupSummaryCopier
                    .copyFromBuilder(eventBridgeRuleTemplateGroups);
        }

        @Override
        public final Builder eventBridgeRuleTemplateGroups(
                Collection<EventBridgeRuleTemplateGroupSummary> eventBridgeRuleTemplateGroups) {
            this.eventBridgeRuleTemplateGroups = ___listOfEventBridgeRuleTemplateGroupSummaryCopier
                    .copy(eventBridgeRuleTemplateGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventBridgeRuleTemplateGroups(EventBridgeRuleTemplateGroupSummary... eventBridgeRuleTemplateGroups) {
            eventBridgeRuleTemplateGroups(Arrays.asList(eventBridgeRuleTemplateGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventBridgeRuleTemplateGroups(
                Consumer<EventBridgeRuleTemplateGroupSummary.Builder>... eventBridgeRuleTemplateGroups) {
            eventBridgeRuleTemplateGroups(Stream.of(eventBridgeRuleTemplateGroups)
                    .map(c -> EventBridgeRuleTemplateGroupSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEventBridgeRuleTemplateGroupsResponse build() {
            return new ListEventBridgeRuleTemplateGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
