/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for ListNetworksResponse
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListNetworksResponse extends MediaLiveResponse implements
        ToCopyableBuilder<ListNetworksResponse.Builder, ListNetworksResponse> {
    private static final SdkField<List<DescribeNetworkSummary>> NETWORKS_FIELD = SdkField
            .<List<DescribeNetworkSummary>> builder(MarshallingType.LIST)
            .memberName("Networks")
            .getter(getter(ListNetworksResponse::networks))
            .setter(setter(Builder::networks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DescribeNetworkSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(DescribeNetworkSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListNetworksResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORKS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<DescribeNetworkSummary> networks;

    private final String nextToken;

    private ListNetworksResponse(BuilderImpl builder) {
        super(builder);
        this.networks = builder.networks;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Networks property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNetworks() {
        return networks != null && !(networks instanceof SdkAutoConstructList);
    }

    /**
     * An array of networks that you have created.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworks} method.
     * </p>
     * 
     * @return An array of networks that you have created.
     */
    public final List<DescribeNetworkSummary> networks() {
        return networks;
    }

    /**
     * Token for the next ListNetworks request.
     * 
     * @return Token for the next ListNetworks request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworks() ? networks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNetworksResponse)) {
            return false;
        }
        ListNetworksResponse other = (ListNetworksResponse) obj;
        return hasNetworks() == other.hasNetworks() && Objects.equals(networks(), other.networks())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListNetworksResponse").add("Networks", hasNetworks() ? networks() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Networks":
            return Optional.ofNullable(clazz.cast(networks()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListNetworksResponse, T> g) {
        return obj -> g.apply((ListNetworksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListNetworksResponse> {
        /**
         * An array of networks that you have created.
         * 
         * @param networks
         *        An array of networks that you have created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networks(Collection<DescribeNetworkSummary> networks);

        /**
         * An array of networks that you have created.
         * 
         * @param networks
         *        An array of networks that you have created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networks(DescribeNetworkSummary... networks);

        /**
         * An array of networks that you have created. This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.medialive.model.DescribeNetworkSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.medialive.model.DescribeNetworkSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.DescribeNetworkSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #networks(List<DescribeNetworkSummary>)}.
         * 
         * @param networks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.DescribeNetworkSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networks(java.util.Collection<DescribeNetworkSummary>)
         */
        Builder networks(Consumer<DescribeNetworkSummary.Builder>... networks);

        /**
         * Token for the next ListNetworks request.
         * 
         * @param nextToken
         *        Token for the next ListNetworks request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MediaLiveResponse.BuilderImpl implements Builder {
        private List<DescribeNetworkSummary> networks = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNetworksResponse model) {
            super(model);
            networks(model.networks);
            nextToken(model.nextToken);
        }

        public final List<DescribeNetworkSummary.Builder> getNetworks() {
            List<DescribeNetworkSummary.Builder> result = ___listOfDescribeNetworkSummaryCopier.copyToBuilder(this.networks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworks(Collection<DescribeNetworkSummary.BuilderImpl> networks) {
            this.networks = ___listOfDescribeNetworkSummaryCopier.copyFromBuilder(networks);
        }

        @Override
        public final Builder networks(Collection<DescribeNetworkSummary> networks) {
            this.networks = ___listOfDescribeNetworkSummaryCopier.copy(networks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networks(DescribeNetworkSummary... networks) {
            networks(Arrays.asList(networks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networks(Consumer<DescribeNetworkSummary.Builder>... networks) {
            networks(Stream.of(networks).map(c -> DescribeNetworkSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListNetworksResponse build() {
            return new ListNetworksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
