/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings for a Multicast input. Contains a list of multicast Urls and optional source ip addresses.
 */
@Generated("software.amazon.awssdk:codegen")
public final class MulticastSettingsUpdateRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<MulticastSettingsUpdateRequest.Builder, MulticastSettingsUpdateRequest> {
    private static final SdkField<List<MulticastSourceUpdateRequest>> SOURCES_FIELD = SdkField
            .<List<MulticastSourceUpdateRequest>> builder(MarshallingType.LIST)
            .memberName("Sources")
            .getter(getter(MulticastSettingsUpdateRequest::sources))
            .setter(setter(Builder::sources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MulticastSourceUpdateRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(MulticastSourceUpdateRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<MulticastSourceUpdateRequest> sources;

    private MulticastSettingsUpdateRequest(BuilderImpl builder) {
        this.sources = builder.sources;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSources() {
        return sources != null && !(sources instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Sources property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSources} method.
     * </p>
     * 
     * @return The value of the Sources property for this object.
     */
    public final List<MulticastSourceUpdateRequest> sources() {
        return sources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSources() ? sources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MulticastSettingsUpdateRequest)) {
            return false;
        }
        MulticastSettingsUpdateRequest other = (MulticastSettingsUpdateRequest) obj;
        return hasSources() == other.hasSources() && Objects.equals(sources(), other.sources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MulticastSettingsUpdateRequest").add("Sources", hasSources() ? sources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Sources":
            return Optional.ofNullable(clazz.cast(sources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MulticastSettingsUpdateRequest, T> g) {
        return obj -> g.apply((MulticastSettingsUpdateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MulticastSettingsUpdateRequest> {
        /**
         * Sets the value of the Sources property for this object.
         *
         * @param sources
         *        The new value for the Sources property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Collection<MulticastSourceUpdateRequest> sources);

        /**
         * Sets the value of the Sources property for this object.
         *
         * @param sources
         *        The new value for the Sources property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(MulticastSourceUpdateRequest... sources);

        /**
         * Sets the value of the Sources property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.medialive.model.MulticastSourceUpdateRequest.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.medialive.model.MulticastSourceUpdateRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.MulticastSourceUpdateRequest.Builder#build()} is
         * called immediately and its result is passed to {@link #sources(List<MulticastSourceUpdateRequest>)}.
         * 
         * @param sources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.MulticastSourceUpdateRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sources(java.util.Collection<MulticastSourceUpdateRequest>)
         */
        Builder sources(Consumer<MulticastSourceUpdateRequest.Builder>... sources);
    }

    static final class BuilderImpl implements Builder {
        private List<MulticastSourceUpdateRequest> sources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MulticastSettingsUpdateRequest model) {
            sources(model.sources);
        }

        public final List<MulticastSourceUpdateRequest.Builder> getSources() {
            List<MulticastSourceUpdateRequest.Builder> result = ___listOfMulticastSourceUpdateRequestCopier
                    .copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<MulticastSourceUpdateRequest.BuilderImpl> sources) {
            this.sources = ___listOfMulticastSourceUpdateRequestCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<MulticastSourceUpdateRequest> sources) {
            this.sources = ___listOfMulticastSourceUpdateRequestCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(MulticastSourceUpdateRequest... sources) {
            sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<MulticastSourceUpdateRequest.Builder>... sources) {
            sources(Stream.of(sources).map(c -> MulticastSourceUpdateRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public MulticastSettingsUpdateRequest build() {
            return new MulticastSettingsUpdateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
