/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Pair of multicast url and source ip address (optional) that make up a multicast source.
 */
@Generated("software.amazon.awssdk:codegen")
public final class MulticastSourceUpdateRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<MulticastSourceUpdateRequest.Builder, MulticastSourceUpdateRequest> {
    private static final SdkField<String> SOURCE_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceIp").getter(getter(MulticastSourceUpdateRequest::sourceIp)).setter(setter(Builder::sourceIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceIp").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Url")
            .getter(getter(MulticastSourceUpdateRequest::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_IP_FIELD, URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sourceIp;

    private final String url;

    private MulticastSourceUpdateRequest(BuilderImpl builder) {
        this.sourceIp = builder.sourceIp;
        this.url = builder.url;
    }

    /**
     * This represents the ip address of the device sending the multicast stream.
     * 
     * @return This represents the ip address of the device sending the multicast stream.
     */
    public final String sourceIp() {
        return sourceIp;
    }

    /**
     * This represents the customer's source URL where multicast stream is pulled from.
     * 
     * @return This represents the customer's source URL where multicast stream is pulled from.
     */
    public final String url() {
        return url;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceIp());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MulticastSourceUpdateRequest)) {
            return false;
        }
        MulticastSourceUpdateRequest other = (MulticastSourceUpdateRequest) obj;
        return Objects.equals(sourceIp(), other.sourceIp()) && Objects.equals(url(), other.url());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MulticastSourceUpdateRequest").add("SourceIp", sourceIp()).add("Url", url()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceIp":
            return Optional.ofNullable(clazz.cast(sourceIp()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MulticastSourceUpdateRequest, T> g) {
        return obj -> g.apply((MulticastSourceUpdateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MulticastSourceUpdateRequest> {
        /**
         * This represents the ip address of the device sending the multicast stream.
         * 
         * @param sourceIp
         *        This represents the ip address of the device sending the multicast stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceIp(String sourceIp);

        /**
         * This represents the customer's source URL where multicast stream is pulled from.
         * 
         * @param url
         *        This represents the customer's source URL where multicast stream is pulled from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);
    }

    static final class BuilderImpl implements Builder {
        private String sourceIp;

        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(MulticastSourceUpdateRequest model) {
            sourceIp(model.sourceIp);
            url(model.url);
        }

        public final String getSourceIp() {
            return sourceIp;
        }

        public final void setSourceIp(String sourceIp) {
            this.sourceIp = sourceIp;
        }

        @Override
        public final Builder sourceIp(String sourceIp) {
            this.sourceIp = sourceIp;
            return this;
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        @Override
        public MulticastSourceUpdateRequest build() {
            return new MulticastSourceUpdateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
